/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tx.ec.provider;

import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.idemponent.helper.IdempotentServiceHelper;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.invoke.CommonDtxResponse;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class BaseEcService
extends EventualConsistencyService {
    private static Log logger = LogFactory.getLog(BaseEcService.class);

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        if (this instanceof IdempotentService) {
            IdempotentProperties idemProp = ((IdempotentService)this).getIdempotentProperties(param, lastReturn);
            boolean isConcurrent = IdempotentServiceHelper.idempotent((IdempotentProperties)idemProp);
            if (isConcurrent) {
                return (DtxResponse)IdempotentServiceHelper.getConcurrentResult((IdempotentProperties)idemProp, CommonDtxResponse.class);
            }
            Throwable throwable = null;
            try (TXHandle h = TX.required();){
                DtxResponse dtxResponse = this.doExecute(param, lastReturn);
                String result = JsonUtils.getParasStr((Object)dtxResponse);
                IdempotentServiceHelper.executeCompleted((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey(), (ConcurrentPolicyEnum)idemProp.getConcurrentPolicy(), (String)result);
                DtxResponse dtxResponse2 = dtxResponse;
                return dtxResponse2;
            }
            catch (Exception e) {
                try {
                    h.markRollback();
                    logger.error("\u670d\u52a1\u8c03\u7528\u5f02\u5e38:", (Throwable)e);
                    IdempotentServiceHelper.executeException((StorageStrategyEnum)idemProp.getStorageStrategy(), (DBRoute)idemProp.getDbRoute(), (String)idemProp.getIdempotentKey());
                    throw e;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return this.doExecute(param, lastReturn);
    }

    protected abstract DtxResponse doExecute(Object var1, Object var2) throws Exception;
}

