/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.es.api.EsBatchValue;
import kd.bos.ext.hr.es.api.EsDataType;
import kd.bos.ext.hr.es.api.EsPropertyValue;
import kd.bos.ext.hr.es.me.common.EncryptionBusinessDataServiceHelper;
import kd.bos.ext.hr.es.me.dao.AISearchEsConfigService;
import kd.bos.ext.hr.es.me.dao.HrBusinessEncryptDataDao;
import kd.bos.ext.hr.es.me.utils.QFilterUtilHR;
import kd.bos.ext.hr.es.me.vo.JoinEntityDO;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class AIQEsStrageBaseHelper {
    public static List<EsBatchValue> buildAIQBatchValue(QueryEntity queryEntity, DynamicObject[] dynamicObjects, Object multiEntityId) {
        return AIQEsStrageBaseHelper.buildAIQBatchBaseValue(queryEntity.getKey(), queryEntity, dynamicObjects, multiEntityId);
    }

    public static List<EsBatchValue> buildAIQBatchBaseValue(String builderEntityName, QueryEntity queryEntity, DynamicObject[] mainArray) {
        return AIQEsStrageBaseHelper.buildAIQBatchBaseValue(builderEntityName, queryEntity, mainArray, null);
    }

    public static String transferBaseData(MainEntityType entityType, String property, boolean isMapping) {
        String propertyName;
        IDataEntityProperty joinProperty = AIQEsStrageBaseHelper.findProperty(entityType, property);
        if (joinProperty instanceof IComplexProperty && !property.startsWith((propertyName = joinProperty.getName()) + ".")) {
            property = propertyName + (isMapping ? ".id" : "_id");
        }
        return property;
    }

    public static IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        DynamicProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.getProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    public static List<String> filterPropertys(Set<String> nestPropertys, String entityName) {
        ArrayList<String> joinSelectListNew = new ArrayList<String>();
        List joinSelectList = nestPropertys.stream().filter(property -> property.contains(entityName)).collect(Collectors.toList());
        if (joinSelectList.size() <= 0) {
            return joinSelectListNew;
        }
        for (String joinSelect : joinSelectList) {
            joinSelectListNew.add(joinSelect.replace(entityName + ".", ""));
        }
        return joinSelectListNew;
    }

    private static void addOnAndJoinFilter(List<QFilter> listJoinFilter, QueryEntity queryEntity, String entityName) {
        if (queryEntity == null || StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        if (listJoinFilter == null) {
            listJoinFilter = new ArrayList<QFilter>();
        }
        for (QuerySourceJoinRelation relation : queryEntity.getJoinRelations()) {
            List listQSConditionRow = relation.getCondition();
            if (!entityName.equals(relation.getRelEntityNumber())) continue;
            for (QSConditionRow qSConditionRow : listQSConditionRow) {
                String compareOp;
                QSExpr objLeftItem = qSConditionRow.getLeftItem();
                QSExpr objRightItem = qSConditionRow.getRightItem();
                if (objLeftItem == null || objRightItem == null || !(objLeftItem instanceof QSIdentifierExpr) || !(objRightItem instanceof QSIdentifierExpr)) continue;
                QSIdentifierExpr leftItem = (QSIdentifierExpr)objLeftItem;
                QSIdentifierExpr rightItem = (QSIdentifierExpr)objRightItem;
                String leftItemName = leftItem.getExpr();
                String rightItemName = rightItem.getExpr();
                if (StringUtils.isEmpty((CharSequence)rightItemName) || StringUtils.isEmpty((CharSequence)leftItemName) || rightItemName.startsWith(entityName + ".") || StringUtils.isEmpty((CharSequence)(compareOp = qSConditionRow.getCompareOp())) || !"=".equals(compareOp)) continue;
                if (rightItemName.startsWith("'") && rightItemName.endsWith("'")) {
                    rightItemName = rightItemName.substring(1, rightItemName.length() - 1);
                }
                QFilter qFilter = new QFilter(leftItemName, compareOp, (Object)rightItemName);
                listJoinFilter.add(qFilter);
            }
            return;
        }
    }

    private static void parseSelectField(QueryEntity queryEntity, Set<String> mainPropertys, Set<String> nestPropertys) {
        for (QuerySelectField selectField : queryEntity.getSelectFields()) {
            MainEntityType relationEntityType;
            String fieldName = selectField.getAlias();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            boolean mainFlags = false;
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, queryEntity);
            if (entityName == null) {
                entityName = queryEntity.getEntityName();
                mainFlags = true;
            }
            try {
                relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            }
            catch (Exception ex) {
                throw new KDBizException("Read entity meta data from cache error! entity name: " + entityName);
            }
            IDataEntityProperty joinProperty = AIQEsStrageBaseHelper.transBaseDataToId(relationEntityType, fieldName);
            if (joinProperty instanceof BasedataProp) {
                fieldName = fieldName + ".id";
            }
            if (mainFlags) {
                mainPropertys.add(fieldName);
                continue;
            }
            if (!fieldName.contains(entityName)) {
                fieldName = entityName + "." + fieldName;
            }
            nestPropertys.add(fieldName);
        }
        mainPropertys.remove(null);
        nestPropertys.remove(null);
        mainPropertys.add("id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            String fieldName = AIQEsStrageBaseHelper.transferBaseData(mainEntityType, joinEntity.getFKProperty(), true);
            mainPropertys.add(fieldName);
            nestPropertys.add(joinEntity.getEntityName() + ".id");
        }
    }

    private static IDataEntityProperty transBaseDataToId(MainEntityType entityType, String property) {
        String[] split;
        String propertyStrCopy = property;
        String entityTypeName = entityType.getName();
        if (propertyStrCopy.startsWith(entityTypeName + ".")) {
            propertyStrCopy = propertyStrCopy.replace(entityTypeName + ".", "");
        }
        if (1 > (split = propertyStrCopy.split("\\.")).length || split.length > 4) {
            return null;
        }
        if (split.length == 1) {
            return entityType.getProperty(split[0]);
        }
        DynamicProperty bdProp = entityType.getProperty(split[0]);
        if (bdProp instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)bdProp;
            String newProp = propertyStrCopy.replace(split[0] + ".", "");
            return AIQEsStrageBaseHelper.transBaseDataToId(EntityMetadataCache.getDataEntityType((String)basedataProp.getBaseEntityId()), newProp);
        }
        return bdProp;
    }

    public static JoinEntityDO queryJoinDynamicObjects(MainEntityType mainEntityType, QueryEntity queryEntity, DynamicObject[] mainArray, String builderEntityName, Set<String> nestPropertys, Object multiEntityId) {
        HashMap<String, Map<String, List<DynamicObject>>> joinEntityDataMap = new HashMap<String, Map<String, List<DynamicObject>>>();
        HashMap<String, Map<String, String>> joinEntityPropertyMap = new HashMap<String, Map<String, String>>();
        Set<String> multiEntitys = AISearchEsConfigService.getOneToManyEntity(builderEntityName);
        Map<String, String> arrayDisplayProp = AISearchEsConfigService.getArrayDisplayProp(builderEntityName);
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            boolean isMultiEntity;
            String joinEntityName = joinEntity.getEntityName();
            HashSet<Object> fKPropertyValS = new HashSet<Object>();
            String fKProperty = AIQEsStrageBaseHelper.transferBaseData(mainEntityType, joinEntity.getFKProperty(), Boolean.FALSE);
            for (DynamicObject object : mainArray) {
                Object objectJoin = object.get(fKProperty);
                fKPropertyValS.add(objectJoin);
            }
            List<String> joinSelectListNew = AIQEsStrageBaseHelper.filterPropertys(nestPropertys, joinEntityName);
            if (joinSelectListNew.size() <= 0) continue;
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)joinEntityName);
            String joinPropertys = AIQEsStrageBaseHelper.transferBaseData(relationEntityType, joinEntity.getProperty(), Boolean.FALSE);
            ArrayList<QFilter> listJoinFilter = new ArrayList<QFilter>();
            QFilter joinFilter = new QFilter(joinPropertys, "in", fKPropertyValS);
            listJoinFilter.add(joinFilter);
            joinSelectListNew.add(joinPropertys);
            boolean bl = isMultiEntity = multiEntitys.contains(joinEntityName) || arrayDisplayProp.containsKey(joinEntityName);
            if (isMultiEntity && multiEntityId != null) {
                QFilter multiEntityIdFilter = new QFilter(joinEntityName + ".id", "=", multiEntityId);
                listJoinFilter.add(multiEntityIdFilter);
            }
            AIQEsStrageBaseHelper.addOnAndJoinFilter(listJoinFilter, queryEntity, joinEntityName);
            QFilter[] joinFilters = listJoinFilter.toArray(new QFilter[0]);
            Object[] joinEntityArray = BusinessDataServiceHelper.load((String)joinEntityName, (String)StringUtils.join(joinSelectListNew, (char)','), (QFilter[])joinFilters);
            if (ArrayUtils.isEmpty((Object[])joinEntityArray)) continue;
            ArrayList<String> pkValueList = new ArrayList<String>();
            DynamicObjectType joinDynamicObjectType = null;
            HashMap<String, ArrayList<Object>> dynamicObjectDataMap = new HashMap<String, ArrayList<Object>>();
            for (Object dynamicObject : joinEntityArray) {
                Object objectJoinValue = dynamicObject.get(joinPropertys);
                String strJoinValue = null;
                if (objectJoinValue != null) {
                    strJoinValue = String.valueOf(objectJoinValue);
                }
                if (StringUtils.isNotEmpty(strJoinValue)) {
                    ArrayList<Object> dataList = (ArrayList<Object>)dynamicObjectDataMap.get(strJoinValue);
                    if (CollectionUtils.isEmpty((Collection)dataList)) {
                        dataList = new ArrayList<Object>();
                    }
                    dataList.add(dynamicObject);
                    dynamicObjectDataMap.put(strJoinValue, dataList);
                    if (joinDynamicObjectType == null) {
                        joinDynamicObjectType = (DynamicObjectType)dynamicObject.getDataEntityType();
                    }
                }
                String pkValue = String.valueOf(dynamicObject.getPkValue());
                pkValueList.add(pkValue);
            }
            Map<String, Map<String, String>> mapEncryptData = null;
            if (!CollectionUtils.isEmpty(pkValueList) && joinDynamicObjectType != null) {
                mapEncryptData = HrBusinessEncryptDataDao.getEncryptData(joinDynamicObjectType, pkValueList.toArray(new Object[0]));
            }
            if (!CollectionUtils.isEmpty(mapEncryptData)) {
                EncryptionBusinessDataServiceHelper.processEncryptData(mapEncryptData, joinDynamicObjectType, (DynamicObject[])joinEntityArray);
            }
            joinEntityDataMap.put(joinEntityName, dynamicObjectDataMap);
            HashMap<String, String> pkPropertyMap = new HashMap<String, String>();
            pkPropertyMap.put(fKProperty, joinPropertys);
            joinEntityPropertyMap.put(joinEntityName, pkPropertyMap);
        }
        JoinEntityDO joinEntityDO = new JoinEntityDO();
        joinEntityDO.setJoinEntityDataMap(joinEntityDataMap);
        joinEntityDO.setJoinEntityPropertyMap(joinEntityPropertyMap);
        return joinEntityDO;
    }

    public static List<EsBatchValue> buildAIQBatchBaseValue(String builderEntityName, QueryEntity queryEntity, DynamicObject[] mainArray, Object multiEntityId) {
        HashSet<String> mainPropertys = new HashSet<String>();
        HashSet<String> nestPropertys = new HashSet<String>();
        AIQEsStrageBaseHelper.parseSelectField(queryEntity, mainPropertys, nestPropertys);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        DynamicObject esConfig = AISearchEsConfigService.queryAISearchEsConfig(builderEntityName);
        Set<String> multiEntitys = AISearchEsConfigService.getOneToManyEntity(esConfig);
        Map<String, String> arrayDisplayProp = AISearchEsConfigService.getArrayDisplayProp(esConfig);
        JoinEntityDO joinEntityDO = AIQEsStrageBaseHelper.queryJoinDynamicObjects(mainEntityType, queryEntity, mainArray, builderEntityName, nestPropertys, multiEntityId);
        ArrayList<EsBatchValue> batchValues = new ArrayList<EsBatchValue>();
        HashSet<String> privacyEnpPropCache = new HashSet<String>();
        for (DynamicObject object : mainArray) {
            ArrayList<EsPropertyValue> properyValues = new ArrayList<EsPropertyValue>();
            AIQEsStrageBaseHelper.readPropValueNew(object, properyValues, mainPropertys, privacyEnpPropCache);
            AIQEsStrageBaseHelper.buildPropertyValue(object, multiEntitys, properyValues, nestPropertys, joinEntityDO, arrayDisplayProp);
            EsBatchValue batchValue = new EsBatchValue(object.get("id"), properyValues.toArray(new EsPropertyValue[0]));
            batchValues.add(batchValue);
        }
        return batchValues;
    }

    private static void readPropValueNew(DynamicObject dyo, List<EsPropertyValue> properyValues, Set<String> propertys, Set<String> privacyEnpPropCache) {
        DynamicObjectType dynamicObjectType = dyo.getDynamicObjectType();
        for (String field : propertys) {
            AIQEsStrageBaseHelper.fillEsPropVal(dyo, properyValues, dynamicObjectType, field, field, privacyEnpPropCache);
        }
    }

    private static void fillEsPropVal(DynamicObject dyo, List<EsPropertyValue> properyValues, DynamicObjectType dynamicObjectType, String fullFieldName, String field, Set<String> privacyEnpPropCache) {
        String[] split = field.split("\\.");
        if (split.length == 1) {
            IDataEntityProperty fieldProperty = AIQEsStrageBaseHelper.getFieldProperty(dynamicObjectType, fullFieldName);
            String propStr = fieldProperty.getParent().getName() + "_" + fieldProperty.getName();
            if (fieldProperty instanceof ISimpleProperty && (privacyEnpPropCache.contains(propStr) || PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)fieldProperty))) {
                privacyEnpPropCache.add(propStr);
                return;
            }
            Object objVal = dyo.get(field);
            if (null == objVal) {
                return;
            }
            if (fieldProperty instanceof ILocaleProperty) {
                OrmLocaleValue dy = (OrmLocaleValue)objVal;
                for (String key : dy.keySet()) {
                    properyValues.add(new EsPropertyValue(fullFieldName + "_l." + key, (Object)dy.get((Object)key)));
                }
                properyValues.add(new EsPropertyValue(fullFieldName, (Object)dy.getLocaleValue()));
            } else if (fieldProperty instanceof DynamicSimpleProperty) {
                DynamicSimpleProperty dynamicSimpleProperty = (DynamicSimpleProperty)fieldProperty;
                boolean isEncrypt = dynamicSimpleProperty.isEncrypt();
                if (isEncrypt) {
                    properyValues.add(new EsPropertyValue(fullFieldName, null));
                    properyValues.add(new EsPropertyValue(fullFieldName + "_enp", dyo.get(field + "_enp")));
                } else {
                    properyValues.add(new EsPropertyValue(fullFieldName, objVal));
                }
            }
        } else if (split.length == 2 || split.length == 3) {
            DynamicObject refDataEntity = dyo.getDynamicObject(split[0]);
            if (null == refDataEntity) {
                return;
            }
            String realField = field.replace(split[0] + ".", "");
            AIQEsStrageBaseHelper.fillEsPropVal(refDataEntity, properyValues, dynamicObjectType, fullFieldName, realField, privacyEnpPropCache);
        }
    }

    public static void buildPropertyValue(DynamicObject object, Set<String> multiEntitys, List<EsPropertyValue> properyValues, Set<String> nestPropertys, JoinEntityDO joinEntityDO, Map<String, String> arrayDisplayProp) {
        Map<String, Map<String, List<DynamicObject>>> mapJoinEntityData = joinEntityDO.getJoinEntityDataMap();
        if (mapJoinEntityData == null) {
            return;
        }
        HashSet<String> privacyEnpPropCache = new HashSet<String>();
        for (Map.Entry<String, Map<String, List<DynamicObject>>> entry : mapJoinEntityData.entrySet()) {
            Map<String, List<DynamicObject>> dynamicObjectMap;
            List<DynamicObject> joinObjectList;
            EsPropertyValue properyValue = new EsPropertyValue(entry.getKey(), EsDataType.NESTED, null);
            Map<String, String> pkPropertyMap = joinEntityDO.getJoinEntityPropertyMap().get(entry.getKey());
            Object objectMain = null;
            Iterator<Map.Entry<String, String>> iterator = pkPropertyMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> pkProperty = iterator.next();
                objectMain = object.get(pkProperty.getKey());
            }
            if (null == objectMain || CollectionUtils.isEmpty(joinObjectList = (dynamicObjectMap = entry.getValue()).get(String.valueOf(objectMain)))) continue;
            boolean isMultiEntity = multiEntitys.contains(entry.getKey());
            boolean isArray = arrayDisplayProp.containsKey(entry.getKey());
            HashSet<String> onPrexProps = new HashSet<String>(AIQEsStrageBaseHelper.filterPropertys(nestPropertys, entry.getKey()));
            for (DynamicObject joinObject : joinObjectList) {
                ArrayList<EsPropertyValue> nestProperyValues = new ArrayList<EsPropertyValue>();
                if (isMultiEntity) {
                    AIQEsStrageBaseHelper.readPropValueNew(joinObject, nestProperyValues, onPrexProps, privacyEnpPropCache);
                    properyValue.nests.add(nestProperyValues);
                    continue;
                }
                if (isArray) {
                    String arrProp = arrayDisplayProp.get(entry.getKey());
                    HashSet<String> arrayProp = new HashSet<String>();
                    arrayProp.add("id");
                    arrayProp.add(arrProp);
                    String[] split = arrProp.split("\\.");
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entry.getKey());
                    IDataEntityProperty simpleProperty = AIQEsStrageBaseHelper.getFieldProperty((DynamicObjectType)dataEntityType, arrProp);
                    if (split.length > 1 && simpleProperty != null) {
                        ISimpleProperty primaryKey = simpleProperty.getParent().getPrimaryKey();
                        StringBuilder primaryKeyStr = new StringBuilder();
                        for (int i = 0; i < split.length - 1; ++i) {
                            primaryKeyStr.append(split[i]);
                            primaryKeyStr.append(".");
                        }
                        primaryKeyStr.append(primaryKey.getName());
                        arrayProp.add(primaryKeyStr.toString());
                    }
                    AIQEsStrageBaseHelper.readPropValueNew(joinObject, nestProperyValues, arrayProp, privacyEnpPropCache);
                    properyValue.nests.add(nestProperyValues);
                    continue;
                }
                AIQEsStrageBaseHelper.readPropValueNew(joinObject, nestProperyValues, onPrexProps, privacyEnpPropCache);
                properyValue.nests.addAll(nestProperyValues);
                break;
            }
            properyValues.add(properyValue);
        }
    }

    private static IDataEntityProperty getFieldProperty(DynamicObjectType relationEntityType, String propertyName) {
        String[] nameKeys = propertyName.split("\\.");
        if (nameKeys.length == 1) {
            return relationEntityType.getProperty(nameKeys[0]);
        }
        if (nameKeys.length > 1) {
            BasedataProp bdProp = (BasedataProp)relationEntityType.getProperty(nameKeys[0]);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdProp.getBaseEntityId());
            return AIQEsStrageBaseHelper.getFieldProperty((DynamicObjectType)dataEntityType, propertyName.replace(nameKeys[0] + ".", ""));
        }
        return null;
    }
}

