/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.common;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.ext.hr.es.me.dao.HrBusinessEncryptDataDao;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class EncryptionBusinessDataServiceHelper {
    private static final Log logger = LogFactory.getLog(EncryptionBusinessDataServiceHelper.class);

    public static DynamicObject[] loadDynamicObjectsByPks(Object[] pkArray, DynamicObjectType dt) {
        DynamicObjectType dtCopy = null;
        try {
            dtCopy = (DynamicObjectType)dt.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("clone  DynamicObjectType object error!");
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)dtCopy);
        Map<String, Map<String, String>> mapResult = HrBusinessEncryptDataDao.getEncryptData(dtCopy, pkArray);
        if (CollectionUtils.isEmpty(mapResult)) {
            return dynamicObjects;
        }
        EncryptionBusinessDataServiceHelper.processEncryptData(mapResult, dtCopy, dynamicObjects);
        return dynamicObjects;
    }

    public static void processEncryptData(Map<String, Map<String, String>> map, DynamicObjectType dt, DynamicObject[] dynamicObjects) {
        DynamicObject[] dynamicObjectArray = map.values().iterator();
        if (dynamicObjectArray.hasNext()) {
            Map<String, String> mapNest = dynamicObjectArray.next();
            for (String filedName : mapNest.keySet()) {
                dt.registerProperty(filedName + "_enp", String.class, null, false);
            }
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            String pkValue = String.valueOf(dynamicObject.getPkValue());
            if (!StringUtils.isNotEmpty((CharSequence)pkValue)) continue;
            Map<String, String> mapValue = map.get(pkValue);
            for (Map.Entry<String, String> entry : mapValue.entrySet()) {
                String key = entry.getKey();
                key = key + "_enp";
                dynamicObject.set(entry.getKey(), null);
                dynamicObject.set(key, (Object)entry.getValue());
            }
        }
    }
}

