/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ILocaleProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.entity.mulentities.expr.QSIdentifierExpr;
import kd.bos.ext.hr.es.api.EsBatchValue;
import kd.bos.ext.hr.es.api.EsDataType;
import kd.bos.ext.hr.es.api.EsPropertyValue;
import kd.bos.ext.hr.es.api.storage.EsFilterField;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.api.storage.EsStorageFactory;
import kd.bos.ext.hr.es.me.common.EncryptionBusinessDataServiceHelper;
import kd.bos.ext.hr.es.me.dao.EntityEsConfigService;
import kd.bos.ext.hr.es.me.dao.HrBusinessEncryptDataDao;
import kd.bos.ext.hr.es.me.utils.QFilterUtilHR;
import kd.bos.ext.hr.es.me.vo.JoinEntityDO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class EsStrageBaseHelper {
    public static String IDS_SEPARATOR = "-";
    private static final Log logger = LogFactory.getLog(EsStrageBaseHelper.class);

    public static void optEndLog(String opt, long startTime) {
        long ms = System.currentTimeMillis() - startTime;
        String msg = "----optEndLog----" + opt + "------" + ms + "ms----\r\n";
        logger.info(msg);
    }

    public static QueryEntity getQueryEntity(String entityName) {
        String queryFormId = MetadataDao.getIdByNumber((String)entityName, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isEmpty((CharSequence)queryFormId)) {
            return null;
        }
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readMeta((String)queryFormId, (MetaCategory)MetaCategory.Entity);
        return (QueryEntity)entityMeta.getRootEntity();
    }

    public static IDataEntityProperty findProperty(MainEntityType relationEntityType, String propertyName) {
        DynamicProperty dataEntityProperty = null;
        String[] nameKeys = propertyName.split("\\.");
        for (int i = 0; i < nameKeys.length && null == (dataEntityProperty = relationEntityType.getProperty(nameKeys[i])); ++i) {
        }
        return dataEntityProperty;
    }

    public static List<EsBatchValue> buildBatchBaseValue(String builderEntityName, QueryEntity queryEntity, DynamicObject[] mainArray, Set<String> mainPropertys, Set<String> nestPropertys) {
        return EsStrageBaseHelper.buildBatchBaseValue(builderEntityName, queryEntity, mainArray, mainPropertys, nestPropertys, null);
    }

    public static JoinEntityDO queryJoinDynamicObjects(MainEntityType mainEntityType, QueryEntity queryEntity, DynamicObject[] mainArray, String builderEntityName, Set<String> nestPropertys, Object multiEntityId) {
        HashMap<String, Map<String, List<DynamicObject>>> joinEntityDataMap = new HashMap<String, Map<String, List<DynamicObject>>>();
        HashMap<String, Map<String, String>> joinEntityPropertyMap = new HashMap<String, Map<String, String>>();
        List<String> multiEntitys = EntityEsConfigService.getOneToManyEntity(builderEntityName);
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            String entityName = joinEntity.getEntityName();
            HashSet<Object> fKPropertys = new HashSet<Object>();
            String fKProperty = EsStrageBaseHelper.transferBaseData(mainEntityType, joinEntity.getFKProperty(), Boolean.FALSE);
            for (DynamicObject object : mainArray) {
                Object objectJoin = object.get(fKProperty);
                fKPropertys.add(objectJoin);
            }
            boolean isMultiEntity = multiEntitys.contains(entityName);
            List<String> joinSelectListNew = EsStrageBaseHelper.filterPropertys(nestPropertys, entityName);
            if (null == joinSelectListNew || joinSelectListNew.size() <= 0) continue;
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            String joinPropertys = EsStrageBaseHelper.transferBaseData(relationEntityType, joinEntity.getProperty(), Boolean.FALSE);
            ArrayList<QFilter> listJoinFilter = new ArrayList<QFilter>();
            QFilter joinFilter = new QFilter(joinPropertys, "in", fKPropertys);
            listJoinFilter.add(joinFilter);
            joinSelectListNew.add(joinPropertys);
            if (isMultiEntity && multiEntityId != null) {
                QFilter multiEntityIdFilter = new QFilter(entityName + ".id", "=", multiEntityId);
                listJoinFilter.add(multiEntityIdFilter);
            }
            EsStrageBaseHelper.addOnAndJoinFilter(listJoinFilter, queryEntity, entityName);
            QFilter[] joinFilters = new QFilter[listJoinFilter.size()];
            joinFilters = listJoinFilter.toArray(joinFilters);
            Object[] joinEntityArray = BusinessDataServiceHelper.load((String)entityName, (String)StringUtils.join(joinSelectListNew, (char)','), (QFilter[])joinFilters);
            if (ArrayUtils.isEmpty((Object[])joinEntityArray)) continue;
            ArrayList<String> pkValueList = new ArrayList<String>();
            DynamicObjectType joinDynamicObjectType = null;
            HashMap<String, ArrayList<Object>> dynamicObjectDataMap = new HashMap<String, ArrayList<Object>>();
            for (Object dynamicObject : joinEntityArray) {
                Object objectJoinValue = dynamicObject.get(joinPropertys);
                String strJoinValue = null;
                if (objectJoinValue != null) {
                    strJoinValue = String.valueOf(objectJoinValue);
                }
                if (StringUtils.isNotEmpty(strJoinValue)) {
                    ArrayList<Object> dataList = (ArrayList<Object>)dynamicObjectDataMap.get(strJoinValue);
                    if (CollectionUtils.isEmpty((Collection)dataList)) {
                        dataList = new ArrayList<Object>();
                        dynamicObjectDataMap.put(strJoinValue, dataList);
                    }
                    if (joinDynamicObjectType == null) {
                        joinDynamicObjectType = (DynamicObjectType)dynamicObject.getDataEntityType();
                    }
                    dataList.add(dynamicObject);
                }
                String pkValue = String.valueOf(dynamicObject.getPkValue());
                pkValueList.add(pkValue);
            }
            Map<String, Map<String, String>> mapEncryptData = null;
            if (!CollectionUtils.isEmpty(pkValueList) && joinDynamicObjectType != null) {
                mapEncryptData = HrBusinessEncryptDataDao.getEncryptData(joinDynamicObjectType, pkValueList.toArray(new Object[pkValueList.size()]));
            }
            if (!CollectionUtils.isEmpty(mapEncryptData)) {
                EncryptionBusinessDataServiceHelper.processEncryptData(mapEncryptData, joinDynamicObjectType, (DynamicObject[])joinEntityArray);
            }
            joinEntityDataMap.put(entityName, dynamicObjectDataMap);
            HashMap<String, String> pkPropertyMap = new HashMap<String, String>();
            pkPropertyMap.put(fKProperty, joinPropertys);
            joinEntityPropertyMap.put(entityName, pkPropertyMap);
        }
        JoinEntityDO joinEntityDO = new JoinEntityDO();
        joinEntityDO.setJoinEntityDataMap(joinEntityDataMap);
        joinEntityDO.setJoinEntityPropertyMap(joinEntityPropertyMap);
        return joinEntityDO;
    }

    public static List<EsBatchValue> buildBatchBaseValue(String builderEntityName, QueryEntity queryEntity, DynamicObject[] mainArray, Set<String> mainPropertys, Set<String> nestPropertys, Object multiEntityId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        List<String> multiEntitys = EntityEsConfigService.getOneToManyEntity(builderEntityName);
        JoinEntityDO joinEntityDO = EsStrageBaseHelper.queryJoinDynamicObjects(mainEntityType, queryEntity, mainArray, builderEntityName, nestPropertys, multiEntityId);
        ArrayList<EsBatchValue> batchValues = new ArrayList<EsBatchValue>();
        HashSet<String> privacyEnpPropCache = new HashSet<String>();
        for (DynamicObject object : mainArray) {
            ArrayList<EsPropertyValue> properyValues = new ArrayList<EsPropertyValue>();
            EsStrageBaseHelper.readPropValue(object, properyValues, mainPropertys, privacyEnpPropCache);
            Map<Object, EsPropertyValue> multiNests = EsStrageBaseHelper.buildPropertyValue(object, multiEntitys, properyValues, nestPropertys, joinEntityDO);
            if (multiNests.size() > 0) {
                for (Map.Entry<Object, EsPropertyValue> multiNest : multiNests.entrySet()) {
                    properyValues.add(multiNest.getValue());
                    EsBatchValue batchValue = new EsBatchValue(object.get("id") + IDS_SEPARATOR + multiNest.getKey(), properyValues.toArray(new EsPropertyValue[properyValues.size()]));
                    batchValues.add(batchValue);
                }
                continue;
            }
            EsBatchValue batchValue = new EsBatchValue(object.get("id"), properyValues.toArray(new EsPropertyValue[properyValues.size()]));
            batchValues.add(batchValue);
        }
        return batchValues;
    }

    public static Map<Object, EsPropertyValue> buildPropertyValue(DynamicObject object, List<String> multiEntitys, List<EsPropertyValue> properyValues, Set<String> nestPropertys, JoinEntityDO joinEntityDO) {
        HashMap<Object, EsPropertyValue> multiNests = new HashMap<Object, EsPropertyValue>();
        Map<String, Map<String, List<DynamicObject>>> mapJoinEntityData = joinEntityDO.getJoinEntityDataMap();
        if (mapJoinEntityData == null) {
            return null;
        }
        HashSet<String> privacyEnpPropCache = new HashSet<String>();
        for (Map.Entry<String, Map<String, List<DynamicObject>>> entry : mapJoinEntityData.entrySet()) {
            Map<String, List<DynamicObject>> dynamicObjectMap;
            List<DynamicObject> joinObjectList;
            boolean isMultiEntity = multiEntitys.contains(entry.getKey());
            EsPropertyValue properyValue = new EsPropertyValue(entry.getKey(), EsDataType.NESTED, null);
            Map<String, String> pkPropertyMap = joinEntityDO.getJoinEntityPropertyMap().get(entry.getKey());
            Object objectMain = null;
            Iterator<Map.Entry<String, String>> iterator = pkPropertyMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, String> pkProperty = iterator.next();
                objectMain = object.get(pkProperty.getKey());
            }
            if (null == objectMain || CollectionUtils.isEmpty(joinObjectList = (dynamicObjectMap = entry.getValue()).get(String.valueOf(objectMain)))) continue;
            for (DynamicObject joinObject : joinObjectList) {
                ArrayList<EsPropertyValue> nestProperyValues = new ArrayList<EsPropertyValue>();
                EsStrageBaseHelper.readPropValue(joinObject, nestProperyValues, nestPropertys, privacyEnpPropCache);
                if (isMultiEntity) {
                    properyValue = new EsPropertyValue(entry.getKey(), EsDataType.NESTED, null);
                    properyValue.nests.add(nestProperyValues);
                    multiNests.put(joinObject.get("id"), properyValue);
                    continue;
                }
                properyValue.nests.add(nestProperyValues);
                break;
            }
            if (isMultiEntity) continue;
            properyValues.add(properyValue);
        }
        return multiNests;
    }

    private static void addOnAndJoinFilter(List<QFilter> listJoinFilter, QueryEntity queryEntity, String entityName) {
        if (queryEntity == null || StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        if (listJoinFilter == null) {
            listJoinFilter = new ArrayList<QFilter>();
        }
        for (QuerySourceJoinRelation relation : queryEntity.getJoinRelations()) {
            List listQSConditionRow = relation.getCondition();
            if (!entityName.equals(relation.getRelEntityNumber())) continue;
            for (QSConditionRow qSConditionRow : listQSConditionRow) {
                String compareOp;
                QSExpr objLeftItem = qSConditionRow.getLeftItem();
                QSExpr objRightItem = qSConditionRow.getRightItem();
                if (objLeftItem == null || objRightItem == null || !(objLeftItem instanceof QSIdentifierExpr) || !(objRightItem instanceof QSIdentifierExpr)) continue;
                QSIdentifierExpr leftItem = (QSIdentifierExpr)objLeftItem;
                QSIdentifierExpr rightItem = (QSIdentifierExpr)objRightItem;
                String leftItemName = leftItem.getExpr();
                String rightItemName = rightItem.getExpr();
                if (StringUtils.isEmpty((CharSequence)rightItemName) || StringUtils.isEmpty((CharSequence)leftItemName) || rightItemName.startsWith(entityName + ".") || StringUtils.isEmpty((CharSequence)(compareOp = qSConditionRow.getCompareOp())) || !"=".equals(compareOp)) continue;
                if (rightItemName.startsWith("'") && rightItemName.endsWith("'")) {
                    rightItemName = rightItemName.substring(1, rightItemName.length() - 1);
                }
                QFilter qFilter = new QFilter(leftItemName, compareOp, (Object)rightItemName);
                listJoinFilter.add(qFilter);
            }
            return;
        }
    }

    public static void parseSelectField(QueryEntity queryEntity, Set<String> mainPropertys, Set<String> nestPropertys, boolean isMapping) {
        for (QuerySelectField selectField : queryEntity.getSelectFields()) {
            String fieldName = selectField.getAlias();
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            boolean mainFlags = Boolean.FALSE;
            String entityName = QFilterUtilHR.getSubEntityName(fieldName, queryEntity);
            if (entityName == null) {
                entityName = queryEntity.getEntityName();
                mainFlags = Boolean.TRUE;
            }
            MainEntityType relationEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            fieldName = EsStrageBaseHelper.transferBaseData(relationEntityType, fieldName, isMapping);
            if (mainFlags) {
                mainPropertys.add(fieldName);
                continue;
            }
            if (!fieldName.contains(entityName)) {
                fieldName = entityName + "." + fieldName;
            }
            nestPropertys.add(fieldName);
        }
        mainPropertys.add("id");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)queryEntity.getEntityName());
        for (JoinEntity joinEntity : queryEntity.getJoinEntitys()) {
            String fieldName = EsStrageBaseHelper.transferBaseData(mainEntityType, joinEntity.getFKProperty(), isMapping);
            mainPropertys.add(fieldName);
            nestPropertys.add(joinEntity.getEntityName() + ".id");
        }
    }

    public static List<String> filterPropertys(Set<String> nestPropertys, String entityName) {
        ArrayList<String> joinSelectListNew = new ArrayList<String>();
        List joinSelectList = nestPropertys.stream().filter(property -> property.contains(entityName)).collect(Collectors.toList());
        if (null == joinSelectList || joinSelectList.size() <= 0) {
            return joinSelectListNew;
        }
        for (String joinSelect : joinSelectList) {
            joinSelectListNew.add(joinSelect.replace(entityName + ".", ""));
        }
        return joinSelectListNew;
    }

    public static String transferBaseData(MainEntityType entityType, String property, boolean isMapping) {
        String propertyName;
        IDataEntityProperty joinProperty = EsStrageBaseHelper.findProperty(entityType, property);
        if (joinProperty instanceof IComplexProperty && !property.startsWith((propertyName = joinProperty.getName()) + ".")) {
            property = propertyName + (isMapping ? ".id" : "_id");
        }
        return property;
    }

    public static void readPropValue(DynamicObject dataEntity, List<EsPropertyValue> properyValues, Set<String> propertys, Set<String> privacyEnpPropCache) {
        IDataEntityType dType = dataEntity.getDataEntityType();
        for (IDataEntityProperty property : dType.getProperties()) {
            String propStr = property.getParent().getName() + "_" + property.getName();
            if (property instanceof ISimpleProperty && (privacyEnpPropCache.contains(propStr) || PrivacyCenterServiceHelper.isEncryptField((IDataEntityProperty)property))) {
                privacyEnpPropCache.add(propStr);
                continue;
            }
            Object object = dataEntity.get(property);
            if (null == object) continue;
            String propertyName = property.getName();
            if (!propertys.contains(dType.getName() + "." + propertyName) && !propertys.contains(propertyName)) continue;
            if (propertyName.contains("_")) {
                propertyName = propertyName.replace("_", ".");
            }
            if (property instanceof ICollectionProperty) {
                DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(property);
                if (null == rows) continue;
                for (DynamicObject row : rows) {
                    EsStrageBaseHelper.readPropValue(row, properyValues, propertys, privacyEnpPropCache);
                }
                continue;
            }
            if (property instanceof IComplexProperty) {
                DynamicObject refDataEntity = dataEntity.getDynamicObject(property);
                if (null != refDataEntity) continue;
                continue;
            }
            if (property instanceof ILocaleProperty) {
                OrmLocaleValue dy = (OrmLocaleValue)object;
                for (String key : dy.keySet()) {
                    properyValues.add(new EsPropertyValue(propertyName + "_l." + key, (Object)dy.get((Object)key)));
                }
                properyValues.add(new EsPropertyValue(propertyName, (Object)dy.getLocaleValue()));
                continue;
            }
            if (!(property instanceof DynamicSimpleProperty)) continue;
            DynamicSimpleProperty dynamicSimpleProperty = (DynamicSimpleProperty)property;
            boolean isEncrypt = dynamicSimpleProperty.isEncrypt();
            if (isEncrypt) {
                properyValues.add(new EsPropertyValue(propertyName, null));
                properyValues.add(new EsPropertyValue(propertyName + "_enp", dataEntity.get(propertyName + "_enp")));
                continue;
            }
            properyValues.add(new EsPropertyValue(propertyName, object));
        }
    }

    public static List<EsBatchValue> buildBatchValue(QueryEntity queryEntity, DynamicObject[] dynamicObjects) {
        return EsStrageBaseHelper.buildBatchValue(queryEntity, dynamicObjects, null);
    }

    public static List<EsBatchValue> buildBatchValue(QueryEntity queryEntity, DynamicObject[] dynamicObjects, Object multiEntityId) {
        HashSet<String> mainPropertys = new HashSet<String>();
        HashSet<String> nestPropertys = new HashSet<String>();
        EsStrageBaseHelper.parseSelectField(queryEntity, mainPropertys, nestPropertys, Boolean.FALSE);
        return EsStrageBaseHelper.buildBatchBaseValue(queryEntity.getKey(), queryEntity, dynamicObjects, mainPropertys, nestPropertys, multiEntityId);
    }

    public static void deleteEsDataById(EsStorage storage, String indexName, String type, String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        storage.delete(indexName, type, id);
    }

    public static void deleteEsDataByIds(EsStorage storage, String indexName, String type, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>();
        EsFilterField esFilterField = new EsFilterField(null, "_id", "in", ids.toArray());
        listEsFilterField.add(esFilterField);
        storage.deleteByQuery(indexName, type, listEsFilterField);
    }

    public static void deleteEsDataByMainEntityId(EsStorage storage, String indexName, String type, String mainEntityId) {
        if (StringUtils.isEmpty((CharSequence)mainEntityId)) {
            return;
        }
        ArrayList<EsFilterField> listEsFilterField = new ArrayList<EsFilterField>();
        EsFilterField esFilterField = new EsFilterField(null, "id", "=", mainEntityId);
        listEsFilterField.add(esFilterField);
        storage.deleteByQuery(indexName, type, listEsFilterField);
    }

    public static EsStorage init() {
        return EsStorageFactory.getStorage("hr");
    }
}

