/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.me.utils;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class DbServiceHelper {
    private String entityName;

    public DbServiceHelper(String entityName) {
        this.entityName = entityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entryEntity) {
        return this.generateEmptyEntryDynamicObject(this.getEntityName(), entryEntity);
    }

    public DynamicObject generateEmptyEntryDynamicObject(String entityName, String entryEntity) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        return (DynamicObject)type.createInstance();
    }

    public DynamicObjectCollection generateEmptyEntryCollection(DynamicObject dy, String entryEntity) {
        MainEntityType mainType = (MainEntityType)dy.getDataEntityType();
        EntityType type = (EntityType)mainType.getAllEntities().get(entryEntity);
        DynamicObjectCollection dyColl = new DynamicObjectCollection((DynamicObjectType)type, (Object)dy);
        dy.set(entryEntity, (Object)dyColl);
        return dyColl;
    }

    public DynamicObject generateEmptyDynamicObject() {
        return this.generateEmptyDynamicObject(this.getEntityName());
    }

    public DynamicObject generateEmptyDynamicObject(String entityName) {
        return BusinessDataServiceHelper.newDynamicObject((String)entityName);
    }

    public DynamicObject generateDynamicObject(Object pk, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), pk, selectProperties);
    }

    public DynamicObject generateDynamicObject(DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(this.getEntityName(), dobj, selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, DynamicObject dobj, String selectProperties) {
        return this.generateDynamicObject(entityName, dobj.getPkValue(), selectProperties);
    }

    public DynamicObject generateDynamicObject(String entityName, Object pk, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName, (String)selectProperties);
    }

    public Object updateOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object[] update(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public DynamicObject queryOne(Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityName());
    }

    public DynamicObject queryOne(String selectProperties, Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        return this.queryOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOne(String selectProperties, QFilter filter) {
        return this.queryOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOne(QFilter[] filters) {
        DynamicObject[] dobjs = this.load(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOne(String selectProperties, QFilter[] filters, String order) {
        DynamicObject[] dobjs = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters, (String)order);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject queryOriginalOne(String selectProperties, Object pk) {
        QFilter filter = new QFilter("id", "=", pk);
        return this.queryOriginalOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalOne(String selectProperties, QFilter filter) {
        return this.queryOriginalOne(selectProperties, new QFilter[]{filter});
    }

    public DynamicObject queryOriginalOne(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryOne((String)this.getEntityName(), (String)selectFields, (QFilter[])filters);
    }

    public DynamicObject queryOriginalOne(String selectFields, QFilter[] filters, String orderBys) {
        DynamicObjectCollection collection = QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
        if (collection.size() > 0) {
            return (DynamicObject)collection.get(0);
        }
        return null;
    }

    public DynamicObjectCollection queryOriginalCollection(String selectFields, QFilter[] filters) {
        return QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters);
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters) {
        DynamicObjectCollection dyColl = this.queryOriginalCollection(selectFields, filters);
        DynamicObject[] dys = new DynamicObject[dyColl.size()];
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            dys[i] = (DynamicObject)dyColl.get(i);
        }
        return dys;
    }

    public DynamicObject[] queryOriginalArray(String selectFields, QFilter[] filters, String orderBys) {
        DynamicObjectCollection dyColl = this.queryOriginalCollection(selectFields, filters, orderBys);
        DynamicObject[] dys = new DynamicObject[dyColl.size()];
        int size = dyColl.size();
        for (int i = 0; i < size; ++i) {
            dys[i] = (DynamicObject)dyColl.get(i);
        }
        return dys;
    }

    public DynamicObjectCollection queryOriginalCollection(String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.query((String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public DynamicObject[] query(QFilter[] filters) {
        return this.load(this.getEntityName(), filters);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)this.getEntityName(), (String)selectProperties, (QFilter[])filters);
    }

    public DynamicObject[] query(QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), filters, orderBys);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderBys) {
        return this.load(this.getEntityName(), selectProperties, filters, orderBys);
    }

    public DynamicObject[] query(String selectProperties, QFilter[] filters, String orderby, int top) {
        return this.load(this.getEntityName(), selectProperties, filters, orderby, top);
    }

    public DataSet queryDataSet(String algoKey, String selectFields) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, null, (String)orderBys);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, null);
    }

    public DataSet queryDataSet(String algoKey, String selectFields, QFilter[] filters, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)this.getEntityName(), (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    public boolean isExists(Object pk) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (Object)pk);
    }

    public boolean isExists(QFilter filter) {
        return this.isExists(new QFilter[]{filter});
    }

    public boolean isExists(QFilter[] filters) {
        return QueryServiceHelper.exists((String)this.getEntityName(), (QFilter[])filters);
    }

    public void deleteOne(Object pk) {
        this.delete(this.getEntityName(), pk);
    }

    public void delete(Object[] pks) {
        this.delete(this.getEntityName(), pks);
    }

    public int deleteByFilter(QFilter[] filters) {
        return this.delete(this.getEntityName(), filters);
    }

    public Object saveOne(DynamicObject dobj) {
        Object[] pks = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dobj});
        return pks[0];
    }

    public Object[] save(DynamicObject[] dobjs) {
        return SaveServiceHelper.save((DynamicObject[])dobjs);
    }

    public Object[] save(DynamicObjectCollection dobjColl) {
        int size;
        Object[] result = null;
        if (dobjColl != null && (size = dobjColl.size()) > 0) {
            DynamicObject[] dobjs = new DynamicObject[size];
            for (int i = 0; i < size; ++i) {
                dobjs[i] = (DynamicObject)dobjColl.get(i);
            }
            result = SaveServiceHelper.save((DynamicObject[])dobjs);
        }
        return result;
    }

    public int count(String entityName, QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count("QueryServiceHelper." + entityName, entityName, filters);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters) {
        return BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filters);
    }

    private DynamicObject[] load(String entityName, QFilter[] filters, String orderBys) {
        return BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])filters, (String)orderBys);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderBys) {
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderBys);
    }

    private DynamicObject[] load(String entityName, String selectProperties, QFilter[] filters, String orderby, int top) {
        return BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filters, (String)orderby, (int)top);
    }

    private void delete(String entityName, Object pk) {
        Object[] pks = new Object[]{pk};
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private void delete(String entityName, Object[] pks) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityName);
        DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
    }

    private int delete(String entityName, QFilter[] filters) {
        return DeleteServiceHelper.delete((String)entityName, (QFilter[])filters);
    }

    public DynamicObject[] loadDynamicObjectArray(QFilter[] filters) {
        return this.loadDynamicObjectArray(this.getEntityName(), filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] loadDynamicObjectArray(String entityName, QFilter[] filters) {
        ArrayList listIds = new ArrayList();
        try (DataSet ds = null;){
            ds = QueryServiceHelper.queryDataSet((String)"BusinessDataServiceHelper.LoadFromCache", (String)entityName, (String)"id", (QFilter[])filters, null);
            ds.forEach(row -> listIds.add(row.get(0)));
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.load((Object[])listIds.toArray(new Object[listIds.size()]), (DynamicObjectType)type);
    }

    public DynamicObject loadDynamicObject(QFilter filter) {
        return this.loadDynamicObject(new QFilter[]{filter});
    }

    public DynamicObject loadDynamicObject(QFilter[] filters) {
        DynamicObject[] dobjs = this.loadDynamicObjectArray(this.getEntityName(), filters);
        if (dobjs.length > 0) {
            return dobjs[0];
        }
        return null;
    }

    public DynamicObject loadSingle(Object pk) {
        return this.loadSingle(this.getEntityName(), pk);
    }

    public DynamicObject loadSingle(String entityName, Object pk) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)type);
    }

    public DynamicObject[] loadDynamicObjectArray(Object[] pkArray) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.getEntityName());
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }

    public DynamicObject[] loadDynamicObjectArray(String entityName, Object[] pkArray) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }

    public static <T> T query(DBRoute dbRoute, String sql, Object[] params, ResultSetHandler<T> rh) {
        return (T)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rh);
    }
}

