/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.prop;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.ext.hr.metadata.prop.IQueryProp;
import kd.bos.ext.hr.metadata.prop.QueryLocalCacheMgr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.DesignEntityMeta;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.servicehelper.QueryServiceHelper;

@DataEntityTypeAttribute(name="kd.bos.ext.hr.metadata.prop.QueryProp")
public class QueryProp
extends BasedataProp
implements IQueryProp {
    private static final Log LOGGER = LogFactory.getLog(QueryProp.class);
    private static final long serialVersionUID = -477548326973244564L;
    private String billFormId;

    public QueryProp() {
        this.setDbIgnore(true);
    }

    public void setComplexType(IDataEntityType dynamicObjectType) {
        try {
            RefEntityType refEntityType;
            try {
                refEntityType = (RefEntityType)dynamicObjectType.clone();
            }
            catch (CloneNotSupportedException e) {
                LOGGER.error("RefEntityType clone error!");
                refEntityType = (RefEntityType)dynamicObjectType;
            }
            if (refEntityType.getPrimaryKey() == null) {
                String parentName = null != this.getParent() ? this.getParent().getName() : "null";
                String traceId = RequestContext.get().getTraceId();
                String lockKey = "qp_" + traceId + "_" + refEntityType.getName();
                String lockValue = (String)QueryLocalCacheMgr.getCache(lockKey);
                int count = StringUtils.isEmpty((CharSequence)lockValue) ? 0 : Integer.parseInt(lockValue);
                LOGGER.info("parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                if (count < 3) {
                    QueryLocalCacheMgr.putCache(lockKey, String.valueOf(++count));
                    QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)refEntityType.getName());
                    QueryLocalCacheMgr.putCache(lockKey, String.valueOf(--count));
                    this.addProperty((DynamicObjectType)refEntityType, queryEntityType);
                    LOGGER.info("add all property,parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                    if (StringUtils.isEmpty((CharSequence)refEntityType.getAlias())) {
                        refEntityType.setAlias(queryEntityType.getAlias());
                        refEntityType.setDBRouteKey(queryEntityType.getDBRouteKey());
                    }
                    refEntityType.setNameProperty(this.getNameKey((IDataEntityType)queryEntityType, this.getDisplayProp()));
                    refEntityType.setNumberProperty(this.getNumberKey((IDataEntityType)queryEntityType, this.getDisplayProp()));
                } else {
                    LongProp idProp = new LongProp();
                    idProp.setName("id");
                    this.addProperty((IDataEntityType)refEntityType, (DynamicProperty)idProp);
                    MetadataReader reader = new MetadataReader(false);
                    String entityId = reader.loadIdByNumber(refEntityType.getName(), MetaCategory.Entity);
                    EntityMetadata entityMetadata = (EntityMetadata)reader.readMeta(entityId, OrmUtils.getDataEntityType(DesignEntityMeta.class), true);
                    QueryEntity queryEntity = (QueryEntity)entityMetadata.getRootEntity();
                    refEntityType.setAlias(this.getTableName(queryEntity.getEntityAlias()));
                    refEntityType.setDBRouteKey(queryEntity.getdbRoute());
                    refEntityType.setNameProperty(this.getDisplayProp());
                    refEntityType.setNumberProperty(this.getEditSearchProp() != null ? this.getEditSearchProp() : this.getDisplayProp());
                    LOGGER.info("only add id,parentName:{},propName:{},refEntityType.getName:{},traceId:{},count:{}", new Object[]{parentName, this.getName(), refEntityType.getName(), traceId, count});
                }
            }
            super.setComplexType((IDataEntityType)refEntityType);
        }
        catch (Exception e) {
            LOGGER.info("setComplexType:", (Object)e);
        }
    }

    private String getTableName(String queryEntityNumber) {
        DynamicObject dy = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"tablename", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryEntityNumber)});
        if (null != dy) {
            return dy.getString("tablename");
        }
        return "";
    }

    @Override
    public synchronized void addProperty(IDataEntityType dynamicObjectType, DynamicProperty dynamicProperty) {
        if (dynamicObjectType == null || dynamicObjectType.getProperties() == null || dynamicProperty == null) {
            return;
        }
        if (dynamicObjectType.getProperties().get((Object)dynamicProperty.getName()) == null) {
            dynamicObjectType.getProperties().add((Object)dynamicProperty);
        }
    }

    public Object getBindingBasedataValue(Object val, String displayProp) {
        IDataEntityProperty p2;
        Object[] arr = new Object[]{"", "", ""};
        if (StringUtils.isEmpty((CharSequence)displayProp)) {
            return arr;
        }
        if (!(val instanceof DynamicObject)) {
            return arr;
        }
        DynamicObject value = (DynamicObject)val;
        BasedataEntityType dt = value.getDataEntityType() instanceof BasedataEntityType ? (BasedataEntityType)value.getDataEntityType() : (BasedataEntityType)this.getComplexType();
        String nameKey = this.getNameKey((IDataEntityType)dt, displayProp);
        String numberKey = this.getNumberKey((IDataEntityType)dt, displayProp);
        IDataEntityProperty p1 = dt.findProperty(numberKey);
        if (p1 != null) {
            arr[0] = p1.getValueFast(val);
            if (arr[0] == null) {
                arr[0] = "";
            }
        } else {
            arr[0] = value.get(numberKey);
        }
        arr[1] = (p2 = dt.findProperty(nameKey)) != null ? p2.getValueFast(val) : value.get(nameKey);
        if (arr[1] instanceof ILocaleString) {
            arr[1] = arr[1].toString();
        }
        if (arr[1] == null) {
            arr[1] = "";
        }
        if (employees.contains(this.getBaseEntityId()) || depEmps.contains(this.getBaseEntityId())) {
            this.setEditSearchProp(numberKey);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getEditSearchProp())) {
            String number = StringUtils.isBlank((Object)arr[0]) ? "" : arr[0].toString();
            String name = StringUtils.isBlank((Object)arr[1]) ? "" : arr[1].toString();
            arr[2] = StringUtils.replaceEach((String)this.getEditSearchProp(), (String[])new String[]{numberKey, nameKey}, (String[])new String[]{number, name});
        } else {
            arr[2] = arr[0];
        }
        return arr;
    }

    public String getNameKey(String displayProp) {
        return this.getNameKey(null, displayProp);
    }

    public String getNumberKey(String displayProp) {
        return this.getNumberKey(null, displayProp);
    }

    @KSMethod
    @SimplePropertyAttribute
    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    public String getDisplayValue(Object basedataObj) {
        if (basedataObj == null) {
            return null;
        }
        if (this.getDisplayProp().contains(".")) {
            return ((DynamicObject)basedataObj).getString(this.getDisplayProp());
        }
        return super.getDisplayValue(basedataObj);
    }
}

