/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.plugin;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetDimensionNumberPlugin
extends AbstractFuncParamPlugIn
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(GetDimensionNumberPlugin.class);

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"currentbillid"});
    }

    public String getSetting() {
        String index = this.getModel().getDataEntity().getString("index");
        LOGGER.info("GetDimensionNumberPlugin #########getSetting() ### index : {}", (Object)index);
        String setting = String.format("%s(%s, '%s')", this.getFuncId(), "entryentity.id", index);
        LOGGER.info("GetDimensionNumberPlugin #########getSetting() ### setting : {}", (Object)setting);
        return setting;
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject one = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getEntityNumber())});
        LOGGER.info("GetDimensionNumberPlugin #########afterCreateNewData() ### currententityname : {}", one == null ? null : one.get("id"));
        this.getModel().setValue("currententityname", one == null ? null : one.get("id"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dimensionEidt = (BasedataEdit)this.getView().getControl("dimension");
        dimensionEidt.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        long costStruId = this.getModel().getDataEntity().getLong("coststru.id");
        LOGGER.info("GetDimensionNumberPlugin #########checkSetting() ### costStruId : {}", (Object)costStruId);
        if (costStruId == 0L) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\u7ec4\u5408\uff01", (String)"GetDimensionNumberPlugin_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            return false;
        }
        long dimensionId = this.getModel().getDataEntity().getLong("dimension.id");
        LOGGER.info("GetDimensionNumberPlugin #########checkSetting() ### dimensionId : {}", (Object)dimensionId);
        if (dimensionId == 0L) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ef4\u5ea6\uff01", (String)"GetDimensionNumberPlugin_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        long costStruId = this.getModel().getDataEntity().getLong("coststru.id");
        LOGGER.info("GetDimensionNumberPlugin #########beforeF7Select() ### costStruId : {}", (Object)costStruId);
        if (costStruId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ef4\u5ea6\u7ec4\u5408\uff01", (String)"GetDimensionNumberPlugin_2", (String)"bos-ext-hr", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if ("dimension".equals(propertyName)) {
            QFilter idFilter = new QFilter("id", "=", (Object)costStruId);
            DynamicObject costStruObj = BusinessDataServiceHelper.loadSingle((String)"lcs_coststru", (String)"costdimension,storageset", (QFilter[])new QFilter[]{idFilter});
            DynamicObjectCollection costDimensionColl = costStruObj.getDynamicObjectCollection("dimensionentry");
            int costDimensionCollSize = costDimensionColl.size();
            ArrayList<Long> costDimensionidList = new ArrayList<Long>(costDimensionCollSize);
            HashMap<String, String> costDimensionIdRefIndexMap = new HashMap<String, String>(costDimensionCollSize);
            for (DynamicObject costDimension : costDimensionColl) {
                long costDimensionId = costDimension.getLong("costdimension.id");
                costDimensionIdRefIndexMap.put(String.valueOf(costDimensionId), costDimension.getString("storageset.number"));
                costDimensionidList.add(costDimensionId);
            }
            LOGGER.info("GetDimensionNumberPlugin #########beforeF7Select() ### costDimensionIdRefIndexMap : {}", (Object)JSON.toJSONString(costDimensionIdRefIndexMap));
            this.getView().getPageCache().put(costDimensionIdRefIndexMap);
            LOGGER.info("GetDimensionNumberPlugin #########beforeF7Select() ### costDimensionidList : {}", (Object)JSON.toJSONString(costDimensionidList));
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", costDimensionidList);
            param.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if ("dimension".equals(fieldKey)) {
            String dimensionId = this.getModel().getDataEntity().getString("dimension.id");
            LOGGER.info("GetDimensionNumberPlugin #########propertyChanged() ### dimensionId : {}", (Object)this.getView().getPageCache().get(dimensionId));
            this.getModel().setValue("index", (Object)this.getView().getPageCache().get(dimensionId));
        }
    }
}

