/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.controls;

import com.google.common.collect.Maps;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.controls.RuleControl;
import kd.bos.ext.hr.ruleengine.infos.DecisionTableInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.BindingContext;
import kd.bos.script.annotations.KSObject;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.ruleengine.controls.DecisionTable")
public class DecisionTable
extends RuleControl {
    private String tableHead;
    private String tableBody;

    @Override
    public RuleValidateInfo validate() {
        RuleValidateInfo info = RuleValidateUtil.validDecisionTableHead(this.getTableHead());
        RuleValidateInfo info2 = RuleValidateUtil.validDecisionTableBody(this.getTableBody());
        info.addMsgs(info2.getMsgList());
        return null;
    }

    @Override
    public void bindData(BindingContext object) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        data.put("tableHead", this.getTableHead());
        data.put("tableBody", this.getTableBody());
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        String pageStatus = this.getView().getPageCache().get("pageStatus");
        if ("view".equals(pageStatus)) {
            data.put("pageState", "VIEW");
        } else {
            String pageState;
            String string = pageState = operationStatus == OperationStatus.ADDNEW ? "NEW" : operationStatus.name();
            if (this.getLock() != null && this.getLock().contains(pageState.toLowerCase())) {
                data.put("pageState", "VIEW");
            }
        }
        this.updateControlDataOnInit(data);
        this.setInited(Boolean.TRUE);
    }

    public String getTableHead() {
        return this.get(this.tableHead);
    }

    public void setTableHead(String tableHead) {
        this.tableHead = tableHead;
        this.set(tableHead);
        DecisionTableInfo info = StringUtils.isNotEmpty((CharSequence)this.getValue()) ? (DecisionTableInfo)SerializationUtils.fromJsonString((String)this.getValue(), DecisionTableInfo.class) : new DecisionTableInfo();
        info.setTableHeadString(tableHead);
        super.setValue(SerializationUtils.toJsonString((Object)info));
    }

    public void setTableHeadAndUpdateControl(String tableHead) {
        this.setTableHead(tableHead);
        this.updateControlData("tableHead", tableHead);
    }

    public String getTableBody() {
        return this.get(this.tableBody);
    }

    public void setTableBody(String tableBody) {
        this.tableBody = tableBody;
        this.set(tableBody);
        DecisionTableInfo info = StringUtils.isNotEmpty((CharSequence)this.getValue()) ? (DecisionTableInfo)SerializationUtils.fromJsonString((String)this.getValue(), DecisionTableInfo.class) : new DecisionTableInfo();
        info.setTableBodyString(tableBody);
        super.setValue(SerializationUtils.toJsonString((Object)info));
    }

    public void setTableBodyAndUpdateControl(String tableBody) {
        this.setTableBody(tableBody);
        this.updateControlData("tableBody", tableBody);
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        DecisionTableInfo info = StringUtils.isNotEmpty((CharSequence)value) ? (DecisionTableInfo)SerializationUtils.fromJsonString((String)value, DecisionTableInfo.class) : new DecisionTableInfo();
        this.setTableHead(SerializationUtils.toJsonString((Object)info.getTableHead()));
        this.setTableBody(SerializationUtils.toJsonString(info.getTableBody()));
    }

    public void addRow(int number) {
        if (number < 1) {
            number = 1;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("addRow", Boolean.TRUE);
        data.put("number", number);
        this.updateControlData(this.key, data);
    }

    public void insertRow(int index) {
        if (index == 0) {
            return;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("insertRow", Boolean.TRUE);
        data.put("priority", index);
        this.updateControlData(this.key, data);
    }

    public void deleteRow(int[] index) {
        if (null == index || index.length == 0) {
            return;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("deleteRow", Boolean.TRUE);
        data.put("priority", index);
        this.updateControlData(this.key, data);
    }
}

