/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.ruleengine.utils;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.DecisionConditionParamInfo;
import kd.bos.ext.hr.ruleengine.infos.DecisionParamInfo;
import kd.bos.ext.hr.ruleengine.infos.DecisionTableBodyInfo;
import kd.bos.ext.hr.ruleengine.infos.DecisionTableHeadInfo;
import kd.bos.ext.hr.ruleengine.infos.DecisionTableInfo;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RosterInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleRosterConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;

public class RuleValidateUtil {
    private static final String[] patterns = new String[]{"^.+d$", "^.+w$", "^.+m$", "^.+q$", "^.+y$", "is_null", "is_not_null"};
    private static final String DECISION_TABLE_CONDITION = "decisionTableCondition";
    private static final String DECISION_TABLE_RESULT = "decisionTableResult";
    private static final String ROSTER_RESULT = "rosterResult";
    private static final String RULE_RESULT = "ruleResult";
    private static final String DEFAULT_RESULT = "defaultResult";
    private static final String TARGET_RESULT = "targetResult";
    private static final String TARGET_ELSE = "targetElse";
    private static final String RULE_CONDITION = "ruleCondition";
    private static final String RULE_TEST = "ruleTest";

    public static RuleValidateInfo validDecisionTable(String decisionTableJson) {
        DecisionTableInfo decisionTableInfo = (DecisionTableInfo)SerializationUtils.fromJsonString((String)decisionTableJson, DecisionTableInfo.class);
        return RuleValidateUtil.validDecisionTable(decisionTableInfo);
    }

    public static RuleValidateInfo validDecisionTable(DecisionTableInfo decisionTableInfo) {
        RuleValidateInfo info = RuleValidateUtil.validDecisionTableHead(decisionTableInfo.getTableHead());
        RuleValidateInfo info2 = RuleValidateUtil.validDecisionTableBody(decisionTableInfo.getTableBody());
        info.addMsgs(info2.getMsgList());
        return info;
    }

    public static RuleValidateInfo validDecisionTableHead(String decisionTableHeadJson) {
        DecisionTableHeadInfo decisionTableHeadInfo = (DecisionTableHeadInfo)SerializationUtils.fromJsonString((String)decisionTableHeadJson, DecisionTableHeadInfo.class);
        return RuleValidateUtil.validDecisionTableHead(decisionTableHeadInfo);
    }

    public static RuleValidateInfo validDecisionTableHead(DecisionTableHeadInfo decisionTableHeadInfo) {
        RuleValidateInfo info = RuleValidateUtil.validDecisionTableConditionParams(decisionTableHeadInfo.getConditionParams());
        RuleValidateInfo info2 = RuleValidateUtil.validDecisionTableResultParams(decisionTableHeadInfo.getResultParams());
        info.addMsgs(info2.getMsgList());
        return info;
    }

    public static RuleValidateInfo validDecisionTableConditionParams(String conditionParamsJson) {
        List conditionParams = SerializationUtils.fromJsonStringToList((String)conditionParamsJson, DecisionConditionParamInfo.class);
        return RuleValidateUtil.validDecisionTableConditionParams(conditionParams);
    }

    public static RuleValidateInfo validDecisionTableConditionParams(List<DecisionConditionParamInfo> conditionParams) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (conditionParams == null || conditionParams.isEmpty()) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u53c2\u6570", (String)"RuleValidateUtil_decisionTable_headCondition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else {
            for (int i = 0; i < conditionParams.size(); ++i) {
                DecisionConditionParamInfo conditionParamInfo = conditionParams.get(i);
                if (StringUtils.isEmpty((CharSequence)conditionParamInfo.getName())) {
                    info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u6761\u4ef6\u53c2\u6570\u540d\u79f0", (String)"RuleValidateUtil_decisionTable_headCondition_1", (String)"bos-ext-hr", (Object[])new Object[0]), conditionParamInfo.getIndex()));
                }
                if (null != conditionParamInfo.getOpt() && !StringUtils.isEmpty((CharSequence)conditionParamInfo.getOpt().get("value"))) continue;
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u6761\u4ef6\u53c2\u6570\u6bd4\u8f83\u7b26", (String)"RuleValidateUtil_decisionTable_headCondition_2", (String)"bos-ext-hr", (Object[])new Object[0]), conditionParamInfo.getIndex()));
            }
        }
        return info;
    }

    public static RuleValidateInfo validDecisionTableResultParams(String resultParamsJson) {
        List resultParams = SerializationUtils.fromJsonStringToList((String)resultParamsJson, DecisionParamInfo.class);
        return RuleValidateUtil.validDecisionTableResultParams(resultParams);
    }

    public static RuleValidateInfo validDecisionTableResultParams(List<DecisionParamInfo> resultParams) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (resultParams == null || resultParams.isEmpty()) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u7ed3\u679c", (String)"RuleValidateUtil_decisionTable_headResult_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else {
            for (int i = 0; i < resultParams.size(); ++i) {
                DecisionParamInfo resultParamInfo = resultParams.get(i);
                if (!StringUtils.isEmpty((CharSequence)resultParamInfo.getName())) continue;
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u6761\u4ef6\u7ed3\u679c\u540d\u79f0", (String)"RuleValidateUtil_decisionTable_headResult_1", (String)"bos-ext-hr", (Object[])new Object[0]), resultParamInfo.getIndex()));
            }
        }
        return info;
    }

    public static RuleValidateInfo validDecisionTableBody(String decisionTableBodyJson) {
        List decisionTableBodyList = SerializationUtils.fromJsonStringToList((String)decisionTableBodyJson, DecisionTableBodyInfo.class);
        return RuleValidateUtil.validDecisionTableBody(decisionTableBodyList);
    }

    public static RuleValidateInfo validDecisionTableBody(List<DecisionTableBodyInfo> decisionTableBodyList) {
        RuleValidateInfo info = new RuleValidateInfo();
        for (int i = 0; i < decisionTableBodyList.size(); ++i) {
            boolean hasCondition = false;
            boolean hasResult = false;
            Map<String, Map<String, String>> conditionValue = decisionTableBodyList.get(i).getConditionValue();
            if (conditionValue == null || conditionValue.isEmpty()) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u89c4\u5219\u7684\u6761\u4ef6", (String)"RuleValidateUtil_decisionTable_bodyCondition_0", (String)"bos-ext-hr", (Object[])new Object[0]), i + 1));
            } else {
                for (Map<String, String> value : conditionValue.values()) {
                    String valueStr = RuleValidateUtil.trim(value.get("value"));
                    if (Boolean.parseBoolean(value.get("isMinOrgFirst")) && StringUtils.isEmpty((CharSequence)valueStr)) {
                        info.addMsg(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u6761\u4ef6(%2$s)\u4e0d\u80fd\u4e3a\u7a7a", (String)"RuleValidateUtil_decisionTable_bodyCondition_4", (String)"bos-ext-hr", (Object[])new Object[0]), i + 1, value.get("displayCondition")));
                        hasCondition = true;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
                        hasCondition = true;
                        if (!ParamTypeEnum.NUMBER.getValue().equals(value.get("type"))) continue;
                        RuleValidateUtil.validNumber(info, valueStr, DECISION_TABLE_CONDITION, i + 1, value.get("displayCondition"));
                        continue;
                    }
                    if (hasCondition) continue;
                    hasCondition = !RuleValidateUtil.isNeedValue(value.get("opt"));
                }
                if (!hasCondition) {
                    info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u89c4\u5219\u7684\u6761\u4ef6", (String)"RuleValidateUtil_decisionTable_bodyCondition_0", (String)"bos-ext-hr", (Object[])new Object[0]), i + 1));
                }
            }
            Map resultValue = decisionTableBodyList.get(i).getResultValue();
            if (resultValue == null || resultValue.isEmpty()) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u89c4\u5219\u7684\u7ed3\u679c", (String)"RuleValidateUtil_decisionTable_bodyResult_0", (String)"bos-ext-hr", (Object[])new Object[0]), i + 1));
                continue;
            }
            for (Map value : resultValue.values()) {
                String valueStr = RuleValidateUtil.trim((String)value.get("value"));
                if (!StringUtils.isNotEmpty((CharSequence)valueStr)) continue;
                hasResult = true;
                if (!ParamTypeEnum.NUMBER.getValue().equals(value.get("type"))) continue;
                RuleValidateUtil.validNumber(info, valueStr, DECISION_TABLE_RESULT, i + 1, (String)value.get("displayCondition"));
            }
            if (hasResult) continue;
            info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u4e2a\u89c4\u5219\u7684\u7ed3\u679c", (String)"RuleValidateUtil_decisionTable_bodyResult_0", (String)"bos-ext-hr", (Object[])new Object[0]), i + 1));
        }
        return info;
    }

    public static RuleValidateInfo validRosterCondition(String conditionJson) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (StringUtils.isEmpty((CharSequence)conditionJson)) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7279\u6b8a\u540d\u5355\u6761\u4ef6", (String)"RuleValidateUtil_roster_condition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            return info;
        }
        RuleRosterConditionInfo ruleConditionInfo = (RuleRosterConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleRosterConditionInfo.class);
        List<RosterInfo> conditionList = ruleConditionInfo.getRosterList();
        if (conditionList.isEmpty()) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7279\u6b8a\u540d\u5355\u6761\u4ef6", (String)"RuleValidateUtil_roster_condition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else {
            for (RosterInfo conditionInfo : conditionList) {
                if (StringUtils.isEmpty((CharSequence)conditionInfo.getParam())) {
                    info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7279\u6b8a\u540d\u5355\u7b2c%s\u4e2a\u6761\u4ef6\u7684\u53c2\u6570", (String)"RuleValidateUtil_roster_condition_1", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getIndex() + 1));
                }
                if (!StringUtils.isEmpty((CharSequence)RuleValidateUtil.trim(conditionInfo.getValue()))) continue;
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7279\u6b8a\u540d\u5355\u7b2c%s\u4e2a\u6761\u4ef6\u7684\u503c", (String)"RuleValidateUtil_roster_condition_2", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getIndex() + 1));
            }
        }
        return info;
    }

    public static RuleValidateInfo validRuleResult(String resultJson) {
        return RuleValidateUtil.validResult(resultJson, RULE_RESULT);
    }

    public static RuleValidateInfo validDefaultResult(String resultJson) {
        return RuleValidateUtil.validResult(resultJson, DEFAULT_RESULT);
    }

    public static RuleValidateInfo validRosterResult(String resultJson) {
        return RuleValidateUtil.validResult(resultJson, ROSTER_RESULT);
    }

    public static RuleValidateInfo validResult(String resultJson, String key) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (StringUtils.isEmpty((CharSequence)resultJson)) {
            info.addMsg(RuleValidateUtil.getResultMsg(key));
        } else {
            RuleResultInfo ruleResultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)resultJson, RuleResultInfo.class);
            List<ResultInfo> resultList = ruleResultInfo.getResultList();
            if (resultList.isEmpty()) {
                info.addMsg(RuleValidateUtil.getResultMsg(key));
            }
            int length = resultList.size();
            ArrayList paramList = Lists.newArrayListWithCapacity((int)length);
            for (int i = 0; i < length; ++i) {
                ResultInfo resultInfo = resultList.get(i);
                String param = resultInfo.getParam();
                if (StringUtils.isEmpty((CharSequence)param)) {
                    info.addMsg(String.format(RuleValidateUtil.getResultParamMsg(key), i + 1));
                }
                if (paramList.contains(param)) {
                    info.addMsg(String.format(RuleValidateUtil.getResultParamRepeatMsg(key), i + 1));
                } else {
                    paramList.add(param);
                }
                String value = RuleValidateUtil.trim(resultInfo.getValue());
                if (StringUtils.isEmpty((CharSequence)value)) {
                    info.addMsg(String.format(RuleValidateUtil.getResultValueMsg(key), i + 1));
                    continue;
                }
                if (!"2".equals(resultInfo.getValueType()) || !ParamTypeEnum.NUMBER.getValue().equals(resultInfo.getParamType())) continue;
                RuleValidateUtil.validNumber(info, value, key, i + 1, null);
            }
        }
        return info;
    }

    public static RuleValidateInfo validTarget(String conditionJson, String returnType, String resultJson, String elseJson) {
        RuleValidateInfo info = RuleValidateUtil.validCondition(conditionJson);
        info.addMsgs(RuleValidateUtil.validTargetResult(returnType, resultJson).getMsgList());
        info.addMsgs(RuleValidateUtil.validTargetElse(returnType, elseJson).getMsgList());
        return info;
    }

    public static RuleValidateInfo validTargetResult(String returnType, String resultJson) {
        RuleValidateInfo info = new RuleValidateInfo();
        String value = RuleValidateUtil.trim(resultJson);
        if (StringUtils.isEmpty((CharSequence)value)) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7ed3\u679c\u90e8\u5206", (String)"RuleValidateUtil_target_result_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else if (ParamTypeEnum.NUMBER.getValue().equals(returnType)) {
            RuleValidateUtil.validNumber(info, value, TARGET_RESULT, 0, null);
        }
        return info;
    }

    public static RuleValidateInfo validTargetElse(String returnType, String elseJson) {
        RuleValidateInfo info = new RuleValidateInfo();
        String value = RuleValidateUtil.trim(elseJson);
        if (StringUtils.isEmpty((CharSequence)value)) {
            info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5426\u5219\u90e8\u5206", (String)"RuleValidateUtil_target_else_0", (String)"bos-ext-hr", (Object[])new Object[0]));
        } else if (ParamTypeEnum.NUMBER.getValue().equals(returnType)) {
            RuleValidateUtil.validNumber(info, value, TARGET_ELSE, 0, null);
        }
        return info;
    }

    public static RuleValidateInfo validCondition(String conditionJson) {
        return RuleValidateUtil.validCondition(conditionJson, false);
    }

    public static RuleValidateInfo validCondition(String conditionJson, boolean ignoreEmpty) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (RuleValidateUtil.isDecisionSetConditionEmpty(conditionJson)) {
            if (!ignoreEmpty) {
                info.addMsg(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u90e8\u5206", (String)"RuleValidateUtil_condition_0", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
            return info;
        }
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditionJson, RuleConditionInfo.class);
        List<ConditionInfo> conditionList = ruleConditionInfo.getConditionList();
        for (ConditionInfo conditionInfo : conditionList) {
            String value;
            String operators;
            if (StringUtils.isEmpty((CharSequence)conditionInfo.getParam())) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u53c2\u6570", (String)"RuleValidateUtil_condition_1", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (StringUtils.isEmpty((CharSequence)(operators = conditionInfo.getOperators()))) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u6bd4\u8f83\u7b26", (String)"RuleValidateUtil_condition_2", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (!RuleValidateUtil.isNeedValue(operators)) continue;
            if (StringUtils.isEmpty((CharSequence)conditionInfo.getValueType()) || "0".equals(conditionInfo.getValueType())) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u503c\u7c7b\u578b", (String)"RuleValidateUtil_condition_3", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getName()));
            }
            if (StringUtils.isEmpty((CharSequence)(value = RuleValidateUtil.trim(conditionInfo.getValue())))) {
                info.addMsg(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u503c", (String)"RuleValidateUtil_condition_4", (String)"bos-ext-hr", (Object[])new Object[0]), conditionInfo.getName()));
                continue;
            }
            if (!"2".equals(conditionInfo.getValueType()) || !ParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getParamType())) continue;
            RuleValidateUtil.validNumber(info, value, RULE_CONDITION, 0, conditionInfo.getName());
        }
        RuleValidateUtil.validExpression(ruleConditionInfo, info);
        return info;
    }

    public static RuleValidateInfo validRuleTestCondition(String conditionJson) {
        RuleValidateInfo info = new RuleValidateInfo();
        List paramList = SerializationUtils.fromJsonStringToList((String)conditionJson, Map.class);
        for (int i = 0; i < paramList.size(); ++i) {
            Map map = (Map)paramList.get(i);
            if (!ParamTypeEnum.NUMBER.getValue().equals(map.get("type")) || null == map.get("value") || !StringUtils.isNotEmpty((CharSequence)map.get("value").toString())) continue;
            RuleValidateUtil.validNumber(info, map.get("value").toString(), RULE_TEST, i + 1, "");
        }
        return info;
    }

    protected static void validExpression(RuleConditionInfo ruleConditionInfo, RuleValidateInfo info) {
        List<ConditionExpressInfo> expressList = ruleConditionInfo.getConditionExpressList();
        Set expressNameList = expressList.stream().map(ConditionExpressInfo::getName).collect(Collectors.toSet());
        String pattern = "^\\(*T[0-9]+\\)*((and|or)\\(*T[0-9]+\\)*)*$";
        String expressStr = ruleConditionInfo.getConditionExpressStr();
        if (!Pattern.matches(pattern, expressStr.replaceAll(" ", ""))) {
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef", (String)"RuleValidateUtil_condition_7", (String)"bos-ext-hr", (Object[])new Object[0]));
        }
        String[] str = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        for (String s : str) {
            if (StringUtils.isEmpty((CharSequence)s) || "and".equals(s) || "or".equals(s)) continue;
            if ("(".equals(s)) {
                ++leftBracket;
                continue;
            }
            if (")".equals(s)) {
                ++rightBracket;
                continue;
            }
            if (Pattern.matches("^T\\d{2,}$", s)) {
                if (expressNameList.contains(s)) continue;
                info.addMsg(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6761\u4ef6%s\u5931\u8d25\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u65b0\u914d\u7f6e", (String)"RuleValidateUtil_condition_8", (String)"bos-ext-hr", (Object[])new Object[0]), s));
                continue;
            }
            info.addMsg(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u4e2d\u5b58\u5728\u65e0\u6548\u5b57\u7b26%s", (String)"RuleValidateUtil_condition_9", (String)"bos-ext-hr", (Object[])new Object[0]), s));
        }
        if (leftBracket != rightBracket) {
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u7684\u62ec\u53f7\u4e2a\u6570\u4e0d\u5339\u914d", (String)"RuleValidateUtil_condition_10", (String)"bos-ext-hr", (Object[])new Object[0]));
        }
    }

    public static boolean isNumeric(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static void validNumber(RuleValidateInfo info, String number, String key, int index, String title) {
        String numberTypeMsg = RuleValidateUtil.getNumberTypeMsg(key, index, title);
        if (!RuleValidateUtil.isNumeric(number)) {
            info.addMsg(numberTypeMsg);
            return;
        }
        String numberDecimalPlacesMsg = RuleValidateUtil.getNumberDecimalPlacesMsg(key, index, title);
        if (number.contains(".") && number.length() - number.indexOf(46) > 11) {
            info.addMsg(numberDecimalPlacesMsg);
        }
        String numberScopeMsg = RuleValidateUtil.getNumberScopeMsg(key, index, title);
        BigDecimal num = new BigDecimal(number);
        if (num.compareTo(new BigDecimal(Long.MIN_VALUE)) <= 0 || num.compareTo(new BigDecimal(Long.MAX_VALUE)) >= 0) {
            info.addMsg(numberScopeMsg);
        }
    }

    private static String getNumberTypeMsg(String key, int index, String title) {
        switch (key) {
            case "decisionTableCondition": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u6761\u4ef6(%2$s)\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_decisionTable_bodyCondition_1", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "decisionTableResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u7ed3\u679c(%2$s)\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_decisionTable_bodyResult_1", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "rosterResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_rosterResult_4", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "ruleResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_ruleResult_4", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "defaultResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_defaultResult_4", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "targetResult": {
                return ResManager.loadKDString((String)"\u7ed3\u679c\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_target_result_1", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "targetElse": {
                return ResManager.loadKDString((String)"\u5426\u5219\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_target_else_1", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "ruleCondition": {
                return String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_condition_5", (String)"bos-ext-hr", (Object[])new Object[0]), title);
            }
            case "ruleTest": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u89c4\u5219\u6761\u4ef6\u7684\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_ruleTest_1", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
        }
        return ResManager.loadKDString((String)"\u503c\u5fc5\u987b\u662f\u6570\u5b57", (String)"RuleValidateUtil_number_0", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getNumberDecimalPlacesMsg(String key, int index, String title) {
        switch (key) {
            case "decisionTableCondition": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u6761\u4ef6(%2$s)\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_decisionTable_bodyCondition_2", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "decisionTableResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u7ed3\u679c(%2$s)\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_decisionTable_bodyResult_2", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "rosterResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_rosterResult_5", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "ruleResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_ruleResult_5", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "defaultResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_defaultResult_5", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "targetResult": {
                return ResManager.loadKDString((String)"\u7ed3\u679c\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_target_result_2", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "targetElse": {
                return ResManager.loadKDString((String)"\u5426\u5219\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_target_else_2", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "ruleCondition": {
                return String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_condition_6", (String)"bos-ext-hr", (Object[])new Object[0]), title);
            }
            case "ruleTest": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u89c4\u5219\u6761\u4ef6\u7684\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_ruleTest_3", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
        }
        return ResManager.loadKDString((String)"\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u6700\u591a10\u4f4d", (String)"RuleValidateUtil_decimalPlaces_0", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getNumberScopeMsg(String key, int index, String title) {
        switch (key) {
            case "decisionTableCondition": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u6761\u4ef6(%2$s)\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_decisionTable_bodyCondition_3", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "decisionTableResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u4e2a\u89c4\u5219\u7ed3\u679c(%2$s)\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_decisionTable_bodyResult_3", (String)"bos-ext-hr", (Object[])new Object[0]), index, title);
            }
            case "rosterResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_rosterResult_6", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "ruleResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_ruleResult_6", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "defaultResult": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_defaultResult_6", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
            case "targetResult": {
                return ResManager.loadKDString((String)"\u7ed3\u679c\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_target_result_3", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "targetElse": {
                return ResManager.loadKDString((String)"\u5426\u5219\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_target_else_3", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "ruleCondition": {
                return String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_condition_11", (String)"bos-ext-hr", (Object[])new Object[0]), title);
            }
            case "ruleTest": {
                return String.format(ResManager.loadKDString((String)"\u7b2c%s\u4e2a\u89c4\u5219\u6761\u4ef6\u7684\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_ruleTest_2", (String)"bos-ext-hr", (Object[])new Object[0]), index);
            }
        }
        return ResManager.loadKDString((String)"\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808 ~ 9223372036854775807\u4e4b\u95f4", (String)"RuleValidateUtil_numberScope_0", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getResultMsg(String key) {
        switch (key) {
            case "ruleResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u89c4\u5219\u7ed3\u679c", (String)"RuleValidateUtil_ruleResult_0", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "defaultResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u9ed8\u8ba4\u7ed3\u679c", (String)"RuleValidateUtil_defaultResult_0", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "rosterResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7279\u6b8a\u540d\u5355\u7ed3\u679c", (String)"RuleValidateUtil_rosterResult_0", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7ed3\u679c", (String)"RuleValidateUtil_result_0", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getResultParamMsg(String key) {
        switch (key) {
            case "ruleResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u53c2\u6570", (String)"RuleValidateUtil_ruleResult_1", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "defaultResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u53c2\u6570", (String)"RuleValidateUtil_defaultResult_1", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "rosterResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u53c2\u6570", (String)"RuleValidateUtil_rosterResult_1", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u7ed3\u679c\u7684\u53c2\u6570", (String)"RuleValidateUtil_result_1", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getResultParamRepeatMsg(String key) {
        switch (key) {
            case "ruleResult": {
                return ResManager.loadKDString((String)"\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u53c2\u6570\u91cd\u590d", (String)"RuleValidateUtil_ruleResult_2", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "defaultResult": {
                return ResManager.loadKDString((String)"\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u53c2\u6570\u91cd\u590d", (String)"RuleValidateUtil_defaultResult_2", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "rosterResult": {
                return ResManager.loadKDString((String)"\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u53c2\u6570\u91cd\u590d", (String)"RuleValidateUtil_rosterResult_2", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u7b2c%s\u6761\u7ed3\u679c\u7684\u53c2\u6570\u91cd\u590d", (String)"RuleValidateUtil_result_2", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    private static String getResultValueMsg(String key) {
        switch (key) {
            case "ruleResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u89c4\u5219\u7ed3\u679c\u7684\u503c", (String)"RuleValidateUtil_ruleResult_3", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "defaultResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u9ed8\u8ba4\u7ed3\u679c\u7684\u503c", (String)"RuleValidateUtil_defaultResult_3", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
            case "rosterResult": {
                return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u7279\u6b8a\u540d\u5355\u7ed3\u679c\u7684\u503c", (String)"RuleValidateUtil_rosterResult_3", (String)"bos-ext-hr", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u7b2c%s\u6761\u7ed3\u679c\u7684\u503c", (String)"RuleValidateUtil_result_3", (String)"bos-ext-hr", (Object[])new Object[0]);
    }

    protected static String trim(String str) {
        return StringUtils.isNotEmpty((CharSequence)str) ? str.trim() : str;
    }

    public static boolean isNeedValue(String opt) {
        for (String pattern : patterns) {
            if (!StringUtils.isNotEmpty((CharSequence)opt) || !Pattern.matches(pattern, opt)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDecisionSetConditionEmpty(String condition) {
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return true;
        }
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)condition, RuleConditionInfo.class);
        return ruleConditionInfo.getConditionList().isEmpty();
    }
}

