/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.util.query;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateTimeUtils {
    private static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String BOS_EXT_HR = "bos-ext-hr";
    private static final String HR_DATE_TIME_UTILS_0 = "HRDateTimeUtils_0";
    private static final String HR_DATE_TIME_UTILS_1 = "HRDateTimeUtils_1";
    private static final String YEARS = "years";
    private static final String MONTHS = "months";
    private static final String DAYS = "days";
    private static TimeZone gmt = new SimpleTimeZone(0, "GMT");
    private static final Log LOGGER = LogFactory.getLog(DateTimeUtils.class);
    private static final String EX_GMT_TO_DATE = "gmtToDate: invalid gmt date string!";
    private static final String EX_GET_MONTH_NAME = "getMonthName : month value must be between 1 and 12!";
    private static final String EX_GET_ELAPSED_TIME = "getElapsedTime : begin date must be inferior to end date !";
    private static final String EX_GET_DAY_NAME = "getDayName: day value must be between 1 and 7!";
    private static final String EX_FORMAT_MONTH = "Invalid month name";
    private static final String EX_DATE_TO_GMT = "dateToGmt: unknown RFC format";

    public static String format(Date date, String fmt) {
        return DateTimeUtils.format(date, fmt, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone) {
        return DateTimeUtils.format(date, fmt, timezone, null);
    }

    public static String format(Date date, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = YYYY_MM_DD_HH_MM_SS;
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(date);
    }

    public static String format(Date date) {
        return DateTimeUtils.format(date, null, null);
    }

    public static String format(Date date, TimeZone timezone) {
        return DateTimeUtils.format(date, null, timezone);
    }

    public static String formatDate(Date date, TimeZone timezone) {
        return DateTimeUtils.format(date, YYYY_MM_DD, timezone);
    }

    public static String formatDate(Date date) {
        return DateTimeUtils.formatDate(date, null);
    }

    public static String formatTime(Date date, TimeZone timezone) {
        return DateTimeUtils.format(date, "HH:mm:ss", timezone);
    }

    public static String formatTime(Date date) {
        return DateTimeUtils.formatTime(date, null);
    }

    public static String defaultDateString(Date date) {
        return DateTimeUtils.defaultDateString(date, null);
    }

    public static String defaultDateString(Date date, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long rawOffset = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(date, timezone));
        if (rawOffset > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            rawOffset = -rawOffset;
        }
        temp.append(DateTimeUtils.format(new Date(rawOffset), "HH:mm", gmt));
        return temp.toString();
    }

    public static Date parseDate(String str) throws ParseException {
        try {
            return DateTimeUtils.parseDate(str, YYYY_MM_DD_HH_MM_SS);
        }
        catch (ParseException e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parseDate info:" + str + ",fmt:" + YYYY_MM_DD_HH_MM_SS);
            }
            try {
                return DateTimeUtils.parseDate(str, YYYY_MM_DD);
            }
            catch (ParseException e2) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("parseDate info:" + str + ",fmt:" + YYYY_MM_DD);
                }
                try {
                    return DateTimeUtils.parseDate(str, "MM/dd/yyyy HH:mm:ss");
                }
                catch (ParseException e3) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("parseDate info:" + str + ",fmt:MM/dd/yyyy HH:mm:ss");
                    }
                    try {
                        return DateTimeUtils.parseDate(str, "MM/dd/yyyy");
                    }
                    catch (ParseException e4) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("parseDate info:" + str + ",fmt:MM/dd/yyyy");
                        }
                        try {
                            return DateTimeUtils.parseDate(str, "HH:mm:ss");
                        }
                        catch (ParseException e5) {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info("parseDate info:" + str + ",fmt:HH:mm:ss");
                            }
                            throw new ParseException("can not understand your format", -1);
                        }
                    }
                }
            }
        }
    }

    public static Date parseDate(String str, String fmt) throws ParseException {
        return DateTimeUtils.parseDate(str, fmt, null);
    }

    public static Date parseDate(String str, String fmt, TimeZone timezone) throws ParseException {
        return DateTimeUtils.parseDate(str, fmt, timezone, null);
    }

    public static Date parseDate(String str, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(str);
    }

    public static Date parseDefaultDate(String str) throws ParseException {
        int index = str.lastIndexOf(32);
        char charAt = str.charAt(index + 1);
        long time = DateTimeUtils.parseDate(str.substring(index + 2), "HH:mm", gmt).getTime();
        if (charAt == '-') {
            time = -time;
        }
        return DateTimeUtils.parseDate(str.substring(0, index), YYYY_MM_DD_HH_MM_SS, new SimpleTimeZone((int)time, "XXX"));
    }

    public static String emailDate(Date date) {
        return DateTimeUtils.emailDate(date, null);
    }

    public static String emailDate(Date date, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long rawOffset = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(date, "E, d MMM yyyy HH:mm:ss", timezone, Locale.UK));
        if (rawOffset > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            rawOffset = -rawOffset;
        }
        temp.append(DateTimeUtils.format(new Date(rawOffset), "HHmm", gmt));
        return temp.toString();
    }

    public static Date parseEmailDate(String str) throws ParseException {
        try {
            int lastIndexOf = str.lastIndexOf(32);
            char charAt = str.charAt(lastIndexOf + 1);
            long time = DateTimeUtils.parseDate(str.substring(lastIndexOf + 2), "HHmm", gmt).getTime();
            if (charAt == '-') {
                time = -time;
            }
            return DateTimeUtils.parseDate(str.substring(0, lastIndexOf), "E, d MMM yyyy HH:mm:ss", new SimpleTimeZone((int)time, "XXX"), Locale.UK);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return DateTimeUtils.parseDate(str, "E, d MMM yyyy HH:mm:ss z", gmt, Locale.UK);
        }
    }

    public static boolean dayBefore(Date dt, Date dt1) {
        return dt.before(dt1);
    }

    public static boolean dayAfter(Date dt, Date dt1) {
        return dt.after(dt1);
    }

    public static boolean dayEquals(Date dt, Date dt1) {
        return dt.equals(dt1);
    }

    public static int getQuarter(Date date) {
        int quarter = 0;
        int month = DateTimeUtils.getMonth(date);
        if (month >= 1 && month <= 3) {
            quarter = 1;
        } else if (month >= 4 && month <= 6) {
            quarter = 2;
        } else if (month >= 7 && month <= 9) {
            quarter = 3;
        } else if (month >= 10 && month <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static int daysOfMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (DateTimeUtils.isLeap(year)) {
                    return 29;
                }
                return 28;
            }
        }
        return 0;
    }

    public static Date addDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long add = date1Ms + date2Ms;
        return new Date(add);
    }

    public static Date addDay(Date dDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth) {
        Date result = dDate;
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay) {
        Date result = dDate;
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour) {
        Date result = dDate;
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute) {
        Date result = dDate;
        result = DateTimeUtils.addMinute(result, iNbMinute);
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute, int iNbSecond) {
        Date result = dDate;
        result = DateTimeUtils.addSecond(result, iNbSecond);
        result = DateTimeUtils.addMinute(result, iNbMinute);
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addHour(Date dDate, long iNbHour) {
        long datems = dDate.getTime();
        long hourMs = iNbHour * 60L * 60L * 1000L;
        long newDateMs = datems + hourMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMinute(Date dDate, long iNbMinute) {
        long datems = dDate.getTime();
        long minuteMs = iNbMinute * 60L * 1000L;
        long newDateMs = datems + minuteMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMonth(Date dDate, int iNbMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        return cal.getTime();
    }

    public static Date addSecond(Date dDate, long iNbSecond) {
        long datems = dDate.getTime();
        long secondms = iNbSecond * 1000L;
        long newDateMs = datems + secondms;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addYear(Date dDate, int iNbYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int oldYear = cal.get(1);
        cal.set(1, iNbYear + oldYear);
        return cal.getTime();
    }

    public static long dateDiff(String interval, Date dDate1, Date dDate2) {
        int field;
        Date date2;
        Date date1;
        int desiredField = 0;
        int coef = 1;
        if (dDate1.getTime() > dDate2.getTime()) {
            coef = -1;
            date1 = dDate2;
            date2 = dDate1;
        } else {
            date1 = dDate1;
            date2 = dDate2;
        }
        if (interval.equals("yyyy")) {
            field = 1;
        } else if (interval.equals("m")) {
            field = 2;
        } else if (interval.equals("d")) {
            field = 5;
        } else if (interval.equals("y")) {
            field = 5;
        } else if (interval.equals("w")) {
            field = 4;
        } else if (interval.equals("ww")) {
            field = 3;
        } else if (interval.equals("h")) {
            field = 5;
            desiredField = 11;
        } else if (interval.equals("n")) {
            field = 5;
            desiredField = 12;
        } else if (interval.equals("s")) {
            field = 5;
            desiredField = 13;
        } else {
            return -1L;
        }
        Calendar calTmp = Calendar.getInstance();
        calTmp.setTime(date1);
        long nbOccurence = 0L;
        calTmp.add(field, 1);
        Date dateTemp = calTmp.getTime();
        while (dateTemp.getTime() <= date2.getTime()) {
            calTmp.add(field, 1);
            dateTemp = calTmp.getTime();
            ++nbOccurence;
        }
        nbOccurence = DateTimeUtils.getNbOccurence(desiredField, date1, date2, field, calTmp, nbOccurence);
        return nbOccurence * (long)coef;
    }

    private static long getNbOccurence(int desiredField, Date date1, Date date2, int field, Calendar calTmp, long nbOccurence) {
        if (desiredField == 11 || desiredField == 12 || desiredField == 13) {
            calTmp.setTime(date1);
            calTmp.add(field, (int)nbOccurence);
            Date dateTemp = calTmp.getTime();
            switch (desiredField) {
                case 11: {
                    nbOccurence *= 24L;
                    break;
                }
                case 12: {
                    nbOccurence = nbOccurence * 24L * 60L;
                    break;
                }
                case 13: {
                    nbOccurence = nbOccurence * 24L * 60L * 60L;
                    break;
                }
            }
            calTmp.add(desiredField, 1);
            dateTemp = calTmp.getTime();
            while (dateTemp.getTime() <= date2.getTime()) {
                calTmp.add(desiredField, 1);
                dateTemp = calTmp.getTime();
                ++nbOccurence;
            }
        }
        return nbOccurence;
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static String dateToGMT(Date vDate, String sFormat) throws KDBizException {
        String resultString = "";
        Calendar cal = Calendar.getInstance();
        cal.setTime(vDate);
        int iDay = cal.get(7);
        int iMonth = cal.get(2);
        String subWeekDay = "";
        String subMonth = "";
        String pattern = "";
        subWeekDay = DateTimeUtils.getWeekDay(iDay, subWeekDay);
        subMonth = DateTimeUtils.getMonthDay(iMonth, subMonth);
        if (sFormat.equals("RFC822") || sFormat.equals("RFC1123")) {
            pattern = "'" + subWeekDay.substring(0, 3) + "', dd '" + subMonth + "' yyyy HH:mm:ss 'GMT'";
            resultString = DateTimeUtils.format(vDate, pattern);
        } else if (sFormat.equals("RFC850") || sFormat.equals("RFC1036")) {
            pattern = "'" + subWeekDay + "', dd-'" + subMonth + "'-yy HH:mm:ss 'GMT'";
            resultString = DateTimeUtils.format(vDate, pattern);
        } else if (sFormat.equals("ASCTIME")) {
            pattern = "'" + subWeekDay.substring(0, 3) + " " + subMonth + "' d HH:mm:ss yyyy";
            resultString = DateTimeUtils.format(vDate, pattern);
        } else {
            throw new KDBizException(EX_DATE_TO_GMT);
        }
        return resultString;
    }

    private static String getMonthDay(int iMonth, String subMonth) {
        switch (iMonth) {
            case 0: {
                subMonth = "Jan";
                break;
            }
            case 1: {
                subMonth = "Feb";
                break;
            }
            case 2: {
                subMonth = "Mar";
                break;
            }
            case 3: {
                subMonth = "Apr";
                break;
            }
            case 4: {
                subMonth = "May";
                break;
            }
            case 5: {
                subMonth = "Jun";
                break;
            }
            case 6: {
                subMonth = "Jul";
                break;
            }
            case 7: {
                subMonth = "Aug";
                break;
            }
            case 8: {
                subMonth = "Sep";
                break;
            }
            case 9: {
                subMonth = "Oct";
                break;
            }
            case 10: {
                subMonth = "Nov";
                break;
            }
            case 11: {
                subMonth = "Dec";
                break;
            }
        }
        return subMonth;
    }

    private static String getWeekDay(int iDay, String subWeekDay) {
        switch (iDay) {
            case 1: {
                subWeekDay = "Sunday";
                break;
            }
            case 2: {
                subWeekDay = "Monday";
                break;
            }
            case 3: {
                subWeekDay = "Tuesday";
                break;
            }
            case 4: {
                subWeekDay = "Wednesday";
                break;
            }
            case 5: {
                subWeekDay = "Thursday";
                break;
            }
            case 6: {
                subWeekDay = "Friday";
                break;
            }
            case 7: {
                subWeekDay = "Saturday";
                break;
            }
        }
        return subWeekDay;
    }

    public static String dateToSQL(Date vDate) {
        String sqlDate = "#" + DateTimeUtils.format(vDate, "M/d/yyyy H:m:s") + "#";
        return sqlDate;
    }

    private static int formatMonth(String sMonth) throws KDBizException {
        if (sMonth.equalsIgnoreCase("jan")) {
            return 0;
        }
        if (sMonth.equalsIgnoreCase("feb")) {
            return 1;
        }
        if (sMonth.equalsIgnoreCase("mar")) {
            return 2;
        }
        if (sMonth.equalsIgnoreCase("apr")) {
            return 3;
        }
        if (sMonth.equalsIgnoreCase("may")) {
            return 4;
        }
        if (sMonth.equalsIgnoreCase("jun")) {
            return 5;
        }
        if (sMonth.equalsIgnoreCase("jul")) {
            return 6;
        }
        if (sMonth.equalsIgnoreCase("aug")) {
            return 7;
        }
        if (sMonth.equalsIgnoreCase("sep")) {
            return 8;
        }
        if (sMonth.equalsIgnoreCase("oct")) {
            return 9;
        }
        if (sMonth.equalsIgnoreCase("nov")) {
            return 10;
        }
        if (sMonth.equalsIgnoreCase("dec")) {
            return 11;
        }
        throw new KDBizException(EX_FORMAT_MONTH);
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String getDayName(int iNDay) throws KDBizException {
        if (iNDay >= 1 && iNDay <= 7) {
            Calendar cal = Calendar.getInstance();
            cal.set(7, iNDay);
            return DateTimeUtils.format(cal.getTime(), "EEEE");
        }
        throw new KDBizException(EX_GET_DAY_NAME);
    }

    public static String getDayName(Date vDate) {
        return DateTimeUtils.format(vDate, "EEEE");
    }

    public static int getElapsedTime(Date vDateBegin, Date vDateEnd, Date vDate) throws KDBizException {
        long begin = vDateBegin.getTime();
        long end = vDateEnd.getTime();
        long current = vDate.getTime();
        if (begin > end) {
            throw new KDBizException(EX_GET_ELAPSED_TIME);
        }
        if (current <= begin) {
            return 0;
        }
        if (current >= end) {
            return 100;
        }
        long result = 100L * DateTimeUtils.dateDiff(vDateBegin, vDate) / DateTimeUtils.dateDiff(vDateBegin, vDateEnd);
        return (int)result;
    }

    public static Date getGMTDate() {
        Date now = new Date();
        long nowMs = now.getTime();
        long gmtOffetsMs = Long.parseLong(String.valueOf(DateTimeUtils.getServerGMTOffset())) * 60L * 1000L;
        Date nowGMT = new Date(nowMs - gmtOffetsMs);
        return nowGMT;
    }

    public static int getGMTHour() {
        Date nowGMT = DateTimeUtils.getGMTDate();
        int gmtHour = Integer.parseInt(DateTimeUtils.format(nowGMT, "H"));
        return gmtHour;
    }

    public static long getGMTOffset(Date vDate) {
        Date nowGMT = DateTimeUtils.getGMTDate();
        long nowGMTMs = nowGMT.getTime();
        long vDateMs = vDate.getTime();
        BigDecimal nowGMTMsBig = new BigDecimal(nowGMTMs);
        BigDecimal vDateMsBig = new BigDecimal(vDateMs);
        BigDecimal diffMsBig = vDateMsBig.subtract(nowGMTMsBig);
        BigDecimal diffSecBig = diffMsBig.divide(new BigDecimal("1000"), 2);
        BigDecimal result = diffSecBig.divide(new BigDecimal("60"), 2);
        return result.longValue();
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String getMonthName(int iMonth) throws KDBizException {
        if (--iMonth >= 0 && iMonth <= 11) {
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(2, iMonth);
            return DateTimeUtils.format(cal.getTime(), "MMMM");
        }
        throw new KDBizException(EX_GET_MONTH_NAME);
    }

    public static String getMonthName(Date vDate) {
        return DateTimeUtils.format(vDate, "MMMM");
    }

    public static Map<String, Integer> getRemainTime(Date vDate) {
        Date now = new Date();
        long iNbMilisecSeconds = vDate.getTime() - now.getTime();
        int mIYears = 0;
        int mIMonths = 0;
        int mIDays = 0;
        int mIHours = 0;
        int mIMinutes = 0;
        int mISeconds = 0;
        int coef = DateTimeUtils.getCoef(iNbMilisecSeconds);
        iNbMilisecSeconds = Math.abs(iNbMilisecSeconds);
        Date mDate = new Date(now.getTime() + iNbMilisecSeconds);
        mIYears = (int)DateTimeUtils.dateDiff("yyyy", now, mDate);
        if ((DateTimeUtils.dateDiff("m", now, mDate = DateTimeUtils.addYear(mDate, -mIYears)) < 0L || DateTimeUtils.dateDiff("d", now, mDate) < 0L || DateTimeUtils.dateDiff("h", now, mDate) < 0L || DateTimeUtils.dateDiff("n", now, mDate) < 0L || DateTimeUtils.dateDiff("s", now, mDate) < 0L) && mIYears != 0) {
            --mIYears;
            mDate = DateTimeUtils.addYear(mDate, 1);
        }
        if ((DateTimeUtils.dateDiff("d", now, mDate = DateTimeUtils.addMonth(mDate, -(mIMonths = (int)DateTimeUtils.dateDiff("m", now, mDate)))) < 0L || DateTimeUtils.dateDiff("h", now, mDate) < 0L || DateTimeUtils.dateDiff("n", now, mDate) < 0L || DateTimeUtils.dateDiff("s", now, mDate) < 0L) && mIMonths != 0) {
            --mIMonths;
            mDate = DateTimeUtils.addMonth(mDate, 1);
        }
        if ((DateTimeUtils.dateDiff("h", now, mDate = DateTimeUtils.addDay(mDate, -(mIDays = (int)DateTimeUtils.dateDiff("d", now, mDate)))) < 0L || DateTimeUtils.dateDiff("n", now, mDate) < 0L || DateTimeUtils.dateDiff("s", now, mDate) < 0L) && mIDays != 0) {
            --mIDays;
            mDate = DateTimeUtils.addDay(mDate, 1L);
        }
        if ((DateTimeUtils.dateDiff("n", now, mDate = DateTimeUtils.addHour(mDate, -(mIHours = (int)DateTimeUtils.dateDiff("h", now, mDate)))) < 0L || DateTimeUtils.dateDiff("s", now, mDate) < 0L) && mIHours != 0) {
            --mIHours;
            mDate = DateTimeUtils.addHour(mDate, 1L);
        }
        mIMinutes = (int)DateTimeUtils.dateDiff("n", now, mDate);
        mDate = DateTimeUtils.addMinute(mDate, -mIMinutes);
        if (mIMinutes != 0 && DateTimeUtils.dateDiff("s", now, mDate) < 0L) {
            --mIMinutes;
            mDate = DateTimeUtils.addMinute(mDate, 1L);
        }
        mISeconds = DateTimeUtils.getMiSeconds(now, mDate);
        return DateTimeUtils.getStringIntegerConcurrentMap(mIYears, mIMonths, mIDays, mIHours, mIMinutes, mISeconds, coef);
    }

    private static int getCoef(long iNbMilisecSeconds) {
        if (iNbMilisecSeconds < 0L) {
            return -1;
        }
        return 1;
    }

    private static ConcurrentMap<String, Integer> getStringIntegerConcurrentMap(int mIYears, int mIMonths, int mIDays, int mIHours, int mIMinutes, int mISeconds, int coef) {
        ConcurrentMap numbers = Maps.newConcurrentMap();
        numbers.put("year", mIYears * coef);
        numbers.put("month", mIMonths * coef);
        numbers.put("day", mIDays * coef);
        numbers.put("hour", mIHours * coef);
        numbers.put("minute", mIMinutes * coef);
        numbers.put("second", mISeconds * coef);
        return numbers;
    }

    private static int getMiSeconds(Date now, Date mDate) {
        int mISeconds = (int)DateTimeUtils.dateDiff("s", now, mDate);
        int mIMillisec = (int)((mDate = DateTimeUtils.addSecond(mDate, -mISeconds)).getTime() - now.getTime());
        if (mIMillisec < 0 && mISeconds != 0) {
            --mISeconds;
        }
        return mISeconds;
    }

    public static int getServerGMTOffset() {
        Calendar now = Calendar.getInstance();
        int era = now.get(0);
        int year = now.get(1);
        int month = now.get(2);
        int day = now.get(5);
        int dayofweek = now.get(7);
        int milliseconds = now.get(14);
        int resultMs = Calendar.getInstance().getTimeZone().getOffset(era, year, month, day, dayofweek, milliseconds);
        return resultMs / 1000 / 60;
    }

    public static String getServerTimeZone() {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        return tz.getID();
    }

    public static int getWeek(Date vDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(vDate);
        int week = cal.get(3);
        return week;
    }

    public static int getWeekDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        int era = cal.get(0);
        if (era == 0) {
            return -1 * year;
        }
        return year;
    }

    public static Date gmtToDate(String sDate) throws KDBizException {
        int totalNbSpace = 0;
        for (int i = 0; i < sDate.length(); ++i) {
            if (sDate.charAt(i) != ' ') continue;
            ++totalNbSpace;
        }
        if (totalNbSpace == 5) {
            return DateTimeUtils.gmtToDateRFC822(sDate);
        }
        if (totalNbSpace == 3) {
            return DateTimeUtils.gmtToDateRFC850(sDate);
        }
        if (totalNbSpace == 4) {
            return DateTimeUtils.gmtToDateAscTime(sDate);
        }
        throw new KDBizException(EX_GMT_TO_DATE);
    }

    private static Date gmtToDateRFC822(String sDate) {
        int beginSpace = 1 + sDate.indexOf(32);
        int endSpace = sDate.indexOf(32, beginSpace);
        int iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        String month = sDate.substring(beginSpace, endSpace);
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        int year = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        int seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        return DateTimeUtils.getDateByFields(iDay, month, year, hours, minutes, seconds);
    }

    private static Date gmtToDateRFC850(String sDate) {
        int beginSpace = 1 + sDate.indexOf(32);
        int endSpace = sDate.indexOf(45, beginSpace);
        int iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(45, beginSpace);
        String month = sDate.substring(beginSpace, endSpace);
        beginSpace = 1 + endSpace;
        int year = Integer.parseInt(sDate.substring(beginSpace, endSpace = sDate.indexOf(32, beginSpace)));
        year = year < 70 ? (year += 2000) : (year += 1900);
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        int seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        return DateTimeUtils.getDateByFields(iDay, month, year, hours, minutes, seconds);
    }

    private static Date gmtToDateAscTime(String sDate) {
        int beginSpace = 1 + sDate.indexOf(32);
        int endSpace = sDate.indexOf(32, beginSpace);
        String month = sDate.substring(beginSpace, endSpace);
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        int iDay = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int hours = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(58, beginSpace);
        int minutes = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.indexOf(32, beginSpace);
        int seconds = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        beginSpace = 1 + endSpace;
        endSpace = sDate.length();
        int year = Integer.parseInt(sDate.substring(beginSpace, endSpace));
        return DateTimeUtils.getDateByFields(iDay, month, year, hours, minutes, seconds);
    }

    private static Date getDateByFields(int iDay, String month, int year, int hours, int minutes, int seconds) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, DateTimeUtils.formatMonth(month));
        cal.set(5, iDay);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        return cal.getTime();
    }

    public static boolean isLeap(int year) {
        boolean div4 = year % 4 == 0;
        boolean div100 = year % 100 == 0;
        boolean div400 = year % 400 == 0;
        return div4 && (!div100 || div400);
    }

    public static Date secondsTo(long lNbSeconds) {
        return new Date(lNbSeconds * 1000L);
    }

    public static Date subDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long diff = date1Ms - date2Ms;
        return new Date(diff);
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static String getTrancateDateFromTimestamp(Timestamp time) {
        if (time == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YYYY_MM_DD);
        Date date = new Date(time.getTime());
        return simpleDateFormat.format(date);
    }

    public static String getTrancateDateFromDate(Date date) {
        if (date == null) {
            return null;
        }
        return DateTimeUtils.format(date, YYYY_MM_DD);
    }

    public static List<String> getDateScope(int day, Calendar calendar, int days, int dateType) {
        SimpleDateFormat sdf = new SimpleDateFormat(YYYY_MM_DD);
        ArrayList<String> date = new ArrayList<String>();
        int dayVar = calendar.get(dateType) == 1 ? 0 : 1 - calendar.get(dateType);
        calendar.add(dateType, dayVar);
        String dtstartdate = sdf.format(calendar.getTime());
        calendar.add(dateType, days - 1);
        String dtenddate = sdf.format(calendar.getTime());
        date.add(dtstartdate);
        date.add(dtenddate);
        return date;
    }

    public static int getCurrentMonthDays() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.roll(5, -1);
        int maxDate = cal.get(5);
        return maxDate;
    }

    public static int getCurrentYearDays() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        int days = 0;
        int year = Integer.parseInt(sdf.format(new Date()));
        days = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 366 : 365;
        return days;
    }

    public static List<String> getCurrentQuarterDate() {
        String startDate = null;
        String endDate = null;
        ArrayList<String> quarterDate = new ArrayList<String>();
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        SimpleDateFormat yearSdf = new SimpleDateFormat("yyyy");
        String year = yearSdf.format(new Date());
        String now = sdf.format(new Date());
        try {
            Date nowDate = sdf.parse(now);
            if (nowDate.compareTo(sdf.parse("01-01")) >= 0 && nowDate.compareTo(sdf.parse("03-31")) <= 0) {
                startDate = year + "-01-01";
                endDate = year + "-03-31";
            } else if (nowDate.compareTo(sdf.parse("04-01")) >= 0 && nowDate.compareTo(sdf.parse("06-30")) <= 0) {
                startDate = year + "-04-01";
                endDate = year + "-06-30";
            } else if (nowDate.compareTo(sdf.parse("07-01")) >= 0 && nowDate.compareTo(sdf.parse("09-30")) <= 0) {
                startDate = year + "-07-01";
                endDate = year + "-09-30";
            } else if (nowDate.compareTo(sdf.parse("10-01")) >= 0 && nowDate.compareTo(sdf.parse("12-31")) <= 0) {
                startDate = year + "-10-01";
                endDate = year + "-12-31";
            }
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
        quarterDate.add(startDate);
        quarterDate.add(endDate);
        return quarterDate;
    }

    public static String getDateStrWithoutMin(Date date) {
        return DateTimeUtils.format(date, YYYY_MM_DD);
    }

    public static String getDateStrWithoutMinTs(Date date) {
        String dateString = DateTimeUtils.getDateStrWithoutMin(date);
        return " {ts'" + dateString + "'} ";
    }

    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getNextDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    private static String formatDuration(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.get(YEARS) != null) {
            sb.append(map.get(YEARS));
            sb.append(ResManager.loadKDString((String)"\u5e74", (String)"DateTimeUtils_2", (String)BOS_EXT_HR, (Object[])new Object[0]));
        }
        if (map != null && map.get(MONTHS) != null) {
            sb.append(map.get(MONTHS));
            sb.append(ResManager.loadKDString((String)"\u6708", (String)"DateTimeUtils_3", (String)BOS_EXT_HR, (Object[])new Object[0]));
        }
        if (map != null && map.get(DAYS) != null) {
            sb.append(map.get(DAYS));
            sb.append(ResManager.loadKDString((String)"\u5929", (String)"DateTimeUtils_4", (String)BOS_EXT_HR, (Object[])new Object[0]));
        }
        return sb.toString();
    }

    public static Date getSysMaxDate() {
        Date maxDate = null;
        LocalDate localDate = LocalDate.of(2999, 12, 31);
        maxDate = DateTimeUtils.localDate2Date(localDate);
        return maxDate;
    }

    public static Date localDate2Date(LocalDate localDate) {
        if (null == localDate) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        if (null == localDateTime) {
            return null;
        }
        ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }
}

