/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.context.RequestContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.ext.hr.web.dto.LoginConfigDTO;
import kd.bos.ext.hr.web.dto.LoginOpDTO;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.ext.hr.web.util.HrGuestUrlUtil;
import kd.bos.ext.hr.web.util.HrUserCacheUtil;
import kd.bos.ext.hr.web.vo.HrUserSessionVO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.lang.LoginLangUtils;
import kd.bos.login.utils.LoginUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.util.RevProxyUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import org.apache.poi.ss.usermodel.DateUtil;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;

public class HrLoginFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(HrLoginFilter.class);
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String HR_USER_COOKIE = "KHRSESSIONID";
    private static final String HR_COMMONLOGIN_FORMID = "hbss_commonlogin";
    private static final int MIN_2_SECOND = 60;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURI = HrFilterUtil.getURI(servletRequest);
        try {
            Map<String, String> queryMap;
            if (requestURI.contains("hr") && requestURI.contains("/auth/login.do")) {
                String kdGlobalSessionId = HrFilterUtil.getKDGlobalSessionId(request);
                String bizUserId = HrFilterUtil.xssEncode(request.getParameter("bizUserId"));
                if (kdGlobalSessionId == null) {
                    response.getWriter().write("invalidSession,refuse request");
                    response.getWriter().flush();
                    return;
                }
                try {
                    HrFilterUtil.createGuestRequestContext(request, kdGlobalSessionId);
                    LOGGER.info("hrGusetUser create requestContext success,bizUserId={}", (Object)bizUserId);
                    this.handleHrUserLogin(request, response);
                }
                catch (Exception ex) {
                    LOGGER.error("HrGuestLoginError.", (Throwable)ex);
                }
                return;
            }
            Cookie mobileToIndexCookie = HrFilterUtil.getCookieByName(request, "mobiletoindex");
            boolean isBatchInvokeAction = requestURI.equals("/form/batchInvokeAction.do");
            if (isBatchInvokeAction && mobileToIndexCookie != null) {
                String indexUrl2 = mobileToIndexCookie.getValue();
                HrFilterUtil.removeClientCookie(request, response, "mobiletoindex");
                String responseBody = "[{\"p\":[{\"openStyle\":\"0\",\"url\":\"" + indexUrl2 + "\"}],\"a\":\"openUrl\"}]";
                response.getWriter().write(responseBody);
                response.getWriter().flush();
                return;
            }
            boolean isGetConfigDo = requestURI.equals("/form/getConfig.do");
            if (isGetConfigDo && (queryMap = this.getRefererQueryParamMap(request)) != null && queryMap.containsKey("timeout")) {
                Request jettyRequest = Request.getBaseRequest((ServletRequest)request);
                MultiMap queryParameterMap = jettyRequest.getQueryParameters();
                String params = HrFilterUtil.crlfFilter(request.getParameter("params"));
                JSONObject jsonObject = JSON.parseObject((String)params);
                jsonObject.put("formId", (Object)HrFilterUtil.getClientUrlExpiryFormId(request, queryMap.get("loginConfigNumber")));
                String newParams = JSON.toJSONString((Object)jsonObject);
                jettyRequest.resetParameters();
                queryParameterMap.remove((Object)"params");
                queryParameterMap.put("params", (Object)newParams);
                jettyRequest.setQueryParameters(queryParameterMap);
                String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
                String hrUserSessionCookieName = this.getHrUserSessionCookieName(tenantAlias);
                HrFilterUtil.removeClientCookie(request, response, hrUserSessionCookieName);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            Cookie hrUserCookie = HrFilterUtil.getHrUserCookie(request);
            Map<String, String> queryMap2 = this.getRefererQueryParamMap(request);
            if (hrUserCookie == null) {
                if (queryMap2 == null || !queryMap2.containsKey("loginConfigNumber")) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                String referer = request.getHeader("Referer");
                URL refererUrl = new URL(referer);
                String refererPath = refererUrl.getPath();
                if (isGetConfigDo && queryMap2.containsKey(HrFilterUtil.getRequestFormKey(request, refererPath)) && queryMap2.get(HrFilterUtil.getRequestFormKey(request, refererPath)).equals(HrFilterUtil.getRequestCommonLoginFormId(request, refererPath))) {
                    Request jettyRequest = Request.getBaseRequest((ServletRequest)request);
                    jettyRequest.getParameterMap();
                    MultiMap queryParameterMap = jettyRequest.getQueryParameters();
                    String params = HrFilterUtil.crlfFilter(request.getParameter("params"));
                    JSONObject jsonObject = JSON.parseObject((String)params);
                    String originFormId = jsonObject.getString("formId");
                    if (!jsonObject.containsKey((Object)"bizFormId")) {
                        jsonObject.put("bizFormId", (Object)originFormId);
                    }
                    jsonObject.put("formId", (Object)HrFilterUtil.getClientCommonLoginFormId(request, queryMap2.get("loginConfigNumber")));
                    String newParams = JSON.toJSONString((Object)jsonObject);
                    jettyRequest.resetParameters();
                    queryParameterMap.remove((Object)"params");
                    queryParameterMap.put("params", (Object)newParams);
                    jettyRequest.setQueryParameters(queryParameterMap);
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                if (queryMap2.containsKey(HrFilterUtil.getRequestFormKey(request, refererPath)) && !queryMap2.get(HrFilterUtil.getRequestFormKey(request, refererPath)).equals(HrFilterUtil.getRequestCommonLoginFormId(request, refererPath))) {
                    LOGGER.info("Get config missing with loginConfigNumber: {}.", (Object)queryMap2.get("loginConfigNumber"));
                    String url2 = HrFilterUtil.handleSessionTimeout(request, response, filterChain, null, queryMap2.get("loginConfigNumber"));
                    String responseBody = "[{\"p\":[{\"openStyle\":\"0\",\"url\":\"" + url2 + "\"}],\"a\":\"openUrl\"}]";
                    response.getWriter().write(responseBody);
                    response.getWriter().flush();
                    return;
                }
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String cookieValue = hrUserCookie.getValue();
            String accountId = LoginUtils.getAccountIdFromSession((String)HrFilterUtil.getKDGlobalSessionId(request));
            HrUserSessionVO hrUserSessionVO = HrUserCacheUtil.getCacheHrUserVO(accountId, cookieValue);
            if (hrUserSessionVO == null) {
                LOGGER.info(" Hr user session is missing with loginConfigNumber: {}.", (Object)queryMap2.get("loginConfigNumber"));
                String url = HrFilterUtil.handleSessionTimeout(request, response, filterChain, hrUserCookie, queryMap2.get("loginConfigNumber"));
                if (StringUtils.isNotEmpty((String)url)) {
                    String responseBody = "[{\"p\":[{\"openStyle\":\"0\",\"url\":\"" + url + "\"}],\"a\":\"openUrl\"}]";
                    response.getWriter().write(responseBody);
                    response.getWriter().flush();
                }
            } else {
                this.updateSessionTimeout(request, cookieValue, hrUserSessionVO);
                filterChain.doFilter(servletRequest, servletResponse);
            }
        }
        catch (Exception ex) {
            LOGGER.error("HrLoginFilterError:", (Throwable)ex);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01\n", (String)"LoginFilter_3", (String)"bos-login", (Object[])new Object[0]) + ex.getMessage()});
            String resp = LoginUtils.getLoginResponse((String)String.valueOf(kd.getErrorCode().getCode()), (String)kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception var52) {
                throw ex;
            }
        }
    }

    private Map<String, String> getRefererQueryParamMap(HttpServletRequest request) throws MalformedURLException {
        Map<String, String> queryMap = null;
        String referer = request.getHeader("Referer");
        if (StringUtils.isEmpty((String)referer)) {
            return queryMap;
        }
        URL refererUrl = new URL(referer);
        String query = refererUrl.getQuery();
        if (StringUtils.isNotEmpty((String)query) && query.contains("=")) {
            try {
                queryMap = HrFilterUtil.split("&", "=", query);
            }
            catch (Exception ex) {
                LOGGER.error("resolveReferQueryError:{}", (Object)ex.getMessage());
            }
        }
        return queryMap;
    }

    private void updateSessionTimeout(HttpServletRequest request, String hrSessionId, HrUserSessionVO hrUserSessionVO) throws IOException {
        if (!this.isWithinMinute(hrUserSessionVO.getLastUpdateTime())) {
            hrUserSessionVO.setTimeout(this.getHrSessionTimeout(request));
            hrUserSessionVO.setLastUpdateTime(System.currentTimeMillis());
            String sessionValue = JSON.toJSONString((Object)hrUserSessionVO);
            HrUserCacheUtil.set(hrUserSessionVO.getAccountId(), hrSessionId, sessionValue);
        }
    }

    private void handleHrUserLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String accountId = RequestContext.get().getAccountId();
        String realBizUserId = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("realBizUserId")));
        String bizUserId = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("bizUserId")));
        String randomTag = HrFilterUtil.xssEncode(request.getParameter("randomTag"));
        String authInfoEncrypt = HrUserCacheUtil.get(accountId, "auth_" + randomTag);
        try {
            HrUserCacheUtil.remove(accountId, "auth_" + randomTag);
        }
        catch (Exception ex) {
            LOGGER.error("removeHrAuthCacheError,key={}", (Object)("auth_" + randomTag));
        }
        String authInfo = Encrypters.decode((String)authInfoEncrypt);
        String[] authInfoArrays = authInfo.split("#");
        String loginType = authInfoArrays[0];
        String value1 = authInfoArrays[1];
        String hideValue1 = authInfoArrays[2];
        LOGGER.info("userId: {},phone or email ={} is logining", (Object)bizUserId, (Object)hideValue1);
        String verifyCode = authInfoArrays[3];
        if (StringUtils.isNotEmpty((String)hideValue1) && StringUtils.isNotEmpty((String)verifyCode)) {
            boolean isLogin = true;
            if ("1".equals(loginType) || "2".equals(loginType)) {
                isLogin = (Boolean)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"isHrLogin", (Object[])new Object[]{authInfoEncrypt});
            }
            LOGGER.info("userId={},phone or email ={} isLogin:{}", new Object[]{bizUserId, hideValue1, isLogin});
            if (!isLogin) {
                return;
            }
            String hrSessionId = this.getHrSessionId(RequestContext.get().getAccountId());
            String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
            String hrUserSessionCookieName = this.getHrUserSessionCookieName(tenantAlias);
            SessionManager.writeCookieData((HttpServletRequest)request, (HttpServletResponse)response, (String)hrUserSessionCookieName, (String)hrSessionId);
            String formId = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("form")));
            String loginConfigNumber = HrFilterUtil.xssEncode(HrFilterUtil.crlfFilter(request.getParameter("loginConfigNumber")));
            String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizUserId=" + bizUserId;
            String bizCustomParam = request.getParameter("bizCustomParam");
            if (StringUtils.isNotEmpty((String)bizCustomParam)) {
                bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
                queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
            }
            HrUserSessionVO hrUserSessionVO = new HrUserSessionVO();
            hrUserSessionVO.setBizUserId(bizUserId);
            hrUserSessionVO.setRealBizUserId(realBizUserId);
            hrUserSessionVO.setLoginType(loginType);
            if ("1".equals(loginType)) {
                hrUserSessionVO.setPhone(value1);
            } else if ("2".equals(loginType)) {
                hrUserSessionVO.setEmail(value1);
            } else if ("3".equals(loginType)) {
                hrUserSessionVO.setUserName(value1);
            }
            String htmlUriParam = this.getLoginPageUriParam(request);
            hrUserSessionVO.setLoginPageUriParam(htmlUriParam);
            hrUserSessionVO.setLoginClientType(HrFilterUtil.getClientType(request, loginConfigNumber));
            hrUserSessionVO.setTenantId(tenantAlias);
            hrUserSessionVO.setAccountId(accountId);
            hrUserSessionVO.setLoginConfigNumber(loginConfigNumber);
            hrUserSessionVO.setBizFormId(formId);
            hrUserSessionVO.setClientIP(HrFilterUtil.getClientIP(request));
            hrUserSessionVO.setTimeout(this.getHrSessionTimeout(request));
            hrUserSessionVO.setLastUpdateTime(System.currentTimeMillis());
            String sessionValue = JSON.toJSONString((Object)hrUserSessionVO);
            HrUserCacheUtil.set(hrUserSessionVO.getAccountId(), hrSessionId, sessionValue);
            LoginOpDTO loginOpDTO = new LoginOpDTO(HrGuestUrlUtil.transFromUserID(realBizUserId, loginType), "login", "login", HrFilterUtil.getClientType(request, loginConfigNumber));
            DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"insertLoginOpLog", (Object[])new Object[]{loginOpDTO});
            String url = HrFilterUtil.getFormUrlByGuest(request, accountId, formId, loginConfigNumber) + queryParam + "&language=" + RequestContext.get().getLang().toString();
            response.sendRedirect(url);
        }
    }

    private String getLoginPageUriParam(HttpServletRequest request) throws MalformedURLException {
        String referer = request.getHeader("Referer");
        URL refererUrl = new URL(referer);
        String refererPath = refererUrl.getPath();
        String query = refererUrl.getQuery();
        Map<String, String> queryMap = null;
        if (StringUtils.isNotEmpty((String)query) && query.contains("=")) {
            try {
                queryMap = HrFilterUtil.split("&", "=", query);
            }
            catch (Exception ex) {
                LOGGER.error("resolveReferQueryError:{}", (Object)ex.getMessage());
            }
        }
        if (null == queryMap) {
            LOGGER.error("HrLoginFilter: QueryMap is null.");
            throw new KDException("HrLoginFilter: QueryMap is null.");
        }
        String loginConfigNumber = (String)queryMap.get("loginConfigNumber");
        LoginConfigDTO loginConfigDTO = (LoginConfigDTO)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSLoginService", (String)"getHrLoginConfig", (Object[])new Object[]{loginConfigNumber});
        String accountId = queryMap.get("accountId");
        String formKey = HrFilterUtil.getRequestFormKey(request, refererPath);
        String loginFormId = HrFilterUtil.getRequestCommonLoginFormId(request, refererPath);
        String bizUserId = queryMap.get("bizUserId");
        String redirectFormId = loginFormId.equals("hbss_commonloginpc") ? loginConfigDTO.getPcRedirectFormId() : loginConfigDTO.getRedirectFormId();
        String queryParam = "&loginConfigNumber=" + loginConfigNumber + "&bizFormId=" + redirectFormId + "&bizUserId=" + bizUserId;
        String bizCustomParam = queryMap.get("bizCustomParam");
        if (StringUtils.isNotEmpty((String)bizCustomParam)) {
            bizCustomParam = HrFilterUtil.crlfFilter(bizCustomParam);
            queryParam = queryParam + "&bizCustomParam=" + bizCustomParam;
        }
        String langCode = loginConfigDTO.getLangCode();
        String language = HrFilterUtil.xssEncode(request.getParameter("language"));
        if (StringUtils.isNotEmpty((String)language)) {
            langCode = LoginLangUtils.getLoginLanguage((HttpServletRequest)request).toString();
        }
        return HrFilterUtil.getRequestHtmlPath(request, refererPath) + "?" + this.getFormUriParamByGuest(accountId, formKey, loginFormId) + queryParam + "&language=" + langCode;
    }

    private String getFormUriParamByGuest(String accountId, String formKey, String formId) {
        StringBuilder sb = new StringBuilder();
        sb.append("userId=Guest&needReset=true").append("&accountId=").append(accountId).append("&").append(formKey).append("=").append(formId);
        return sb.toString();
    }

    private boolean isWithinMinute(long time) {
        long currentTime = System.currentTimeMillis();
        int betweenSecond = (int)((currentTime - time) / 1000L);
        int second = 60 - betweenSecond;
        return second > 0;
    }

    private long getHrSessionTimeout(HttpServletRequest request) {
        String tenantAlias = RevProxyUtil.getTenantCode((HttpServletRequest)request);
        String sessionTimeout = SystemPropertyUtils.getProptyByTenant((String)"kd.hr.session.timeout", (String)tenantAlias);
        if (StringUtils.isEmpty((String)sessionTimeout)) {
            sessionTimeout = "1800";
        }
        return System.currentTimeMillis() + Long.parseLong(sessionTimeout) * 1000L;
    }

    private String getHrUserSessionCookieName(String tenantAlias) {
        return HR_USER_COOKIE + tenantAlias;
    }

    private String getHrSessionId(String accountId) {
        return accountId + "_" + StringUtils.randomWord((int)100);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(DateUtil.class.getName());
            Field field = clazz.getDeclaredField("lastCachedResult");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(null, ThreadLocal.withInitial(() -> Boolean.FALSE));
        }
        catch (Exception e) {
            LOGGER.error("reflectUpdate lastCachedResult error", (Object)e.getMessage());
        }
    }

    public void destroy() {
    }
}

