/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.util;

import com.alibaba.fastjson.JSON;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.ext.hr.web.vo.HrUserSessionVO;
import kd.bos.util.StringUtils;

public class HrUserCacheUtil {
    private static final String HRUSER_CACHE_KEY = "hruser_";
    private static final int TIMEOUT_SECONDS = 1800;
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hrcs", true);

    public static HrUserSessionVO getCacheHrUserVO(String accountId, String hrUserSessionId) {
        String sessionCacheValue = HrUserCacheUtil.get(accountId, hrUserSessionId);
        if (StringUtils.isEmpty((String)sessionCacheValue)) {
            return null;
        }
        return (HrUserSessionVO)JSON.parseObject((String)sessionCacheValue, HrUserSessionVO.class);
    }

    public static void set(String accountId, String key, String value) {
        CACHE.put(HrUserCacheUtil.doGetKey(accountId, key), (Object)value, 1800);
    }

    public static String get(String accountId, String key) {
        return (String)CACHE.get(HrUserCacheUtil.doGetKey(accountId, key));
    }

    public static void remove(String accountId, String key) {
        CACHE.remove(HrUserCacheUtil.doGetKey(accountId, key));
    }

    private static String doGetKey(String accountId, String key) {
        return HRUSER_CACHE_KEY + accountId + "_" + key;
    }
}

