/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.RandomStringUtils;

public class SafeUriUtil {
    private static final Log LOGGER = LogFactory.getLog(SafeUriUtil.class);
    private static SecureRandom SECURE_RANDOM;

    public static String getSafeUri() {
        String fixLengthString = SafeUriUtil.getFixLengthString();
        String randomString = SafeUriUtil.getRandomString();
        return fixLengthString + randomString;
    }

    public static boolean isSafeUri(String uri) {
        String fixLengthString = uri.substring(4, 12);
        int total = 0;
        for (int i = 0; i < fixLengthString.length(); ++i) {
            char c = fixLengthString.charAt(i);
            if (c < '0' || c > '9') continue;
            int temp = Integer.parseInt(fixLengthString.charAt(i) + "");
            total += temp;
        }
        return total % 5 == 0;
    }

    private static String getFixLengthString() {
        String randomString;
        int total;
        do {
            randomString = RandomStringUtils.randomAlphanumeric((int)8);
            total = 0;
            for (int i = 0; i < randomString.length(); ++i) {
                char c = randomString.charAt(i);
                if (c < '0' || c > '9') continue;
                int temp = Integer.parseInt(randomString.charAt(i) + "");
                total += temp;
            }
        } while (total % 5 != 0);
        return randomString;
    }

    private static String getRandomString() {
        int randomInt = 2;
        if (SECURE_RANDOM != null) {
            randomInt = SECURE_RANDOM.nextInt(3) + 2;
        }
        return RandomStringUtils.randomAlphanumeric((int)randomInt);
    }

    static {
        try {
            SECURE_RANDOM = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error(e.getMessage());
        }
    }
}

