/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.wf.plugin.activity;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.AgentTask;
import kd.bos.workflow.engine.extitf.ITaskPlugin;
import kd.bos.workflow.engine.task.TaskInfo;

public class ActivityTransferHandlePlugin
implements ITaskPlugin {
    private static final Log LOGGER = LogFactory.getLog(ActivityTransferHandlePlugin.class);
    private static final String ENTITY_NAME = "hrcs_activityins";
    private static final String EVENT_NAME_TRANSFER = "transfer";
    private static final String WF_TASK_ID = "wfcurtaskid";
    private static final String GLOBAL_TASK_ID = "globaltaskid";
    private static final String COMMA = ",";
    private static final String NEW_HANDLER_KEY = "transferUserId";
    private static final String OPINION_KEY = "opinion";

    public void handleTask(AgentTask agentTask, String eventName, Map<String, Object> params) {
        LOGGER.info("Got event name:{} and params:{}.", (Object)eventName, params);
        try {
            if (EVENT_NAME_TRANSFER.equalsIgnoreCase(eventName)) {
                Long globalTaskId = agentTask.getId();
                DynamicObject activityIns = QueryServiceHelper.queryOne((String)ENTITY_NAME, (String)WF_TASK_ID, (QFilter[])new QFilter[]{new QFilter(GLOBAL_TASK_ID, "=", (Object)globalTaskId)});
                LOGGER.info("Got activity instance:{} with global task id:{}.", (Object)activityIns, (Object)globalTaskId);
                if (null != activityIns) {
                    Long wfTaskId = activityIns.getLong(WF_TASK_ID);
                    if (params.containsKey(NEW_HANDLER_KEY)) {
                        long handlerId = (Long)params.get(NEW_HANDLER_KEY);
                        Object opinion = params.get(OPINION_KEY);
                        LocaleString transferOpinion = new LocaleString("-");
                        if (opinion instanceof LocaleString) {
                            transferOpinion = (LocaleString)params.get(OPINION_KEY);
                        } else if (opinion instanceof OrmLocaleValue) {
                            transferOpinion = LocaleString.fromMap((Map)((OrmLocaleValue)opinion));
                        } else {
                            LOGGER.info("Can not got opinion from {}.", opinion);
                        }
                        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                        LOGGER.info("Got taskInfo: {} with wfTaskId:{}.", (Object)taskInfo, (Object)wfTaskId);
                        if (null != taskInfo) {
                            WorkflowServiceHelper.taskTransfer((Long)wfTaskId, (Long)handlerId, (ILocaleString)transferOpinion, (Boolean)Boolean.TRUE);
                        }
                    } else {
                        List destHandlerIdList = (List)params.get("partitionIds");
                        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
                        LOGGER.info("Got taskInfo: {} with wfTaskId:{}.", (Object)taskInfo, (Object)wfTaskId);
                        if (null != taskInfo) {
                            WorkflowServiceHelper.updateTaskInfoAndParticipant((TaskInfo)WorkflowServiceHelper.findTaskById((Long)wfTaskId), (List)destHandlerIdList);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.info("Got exception.", (Object)exception);
            throw exception;
        }
    }
}

