package kd.bos.ext.imc.operation.bizrule;

import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.imc.operation.contant.InvoiceOpParamContant;
import kd.bos.ext.imc.operation.exception.ImcRimInvoiceBizException;
import kd.bos.ext.imc.operation.util.CoverUtils;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;

/**
 * 	点击操作按钮之后，发票状态随之更新
 * @Description: 保存服务执行插件 
 * @author 何雨秋
 * @date 2022-4-8
 */
public class SaveInvoiceAction extends AbstractOpBizRuleAction {

	private static Log logger = LogFactory.getLog(SaveInvoiceAction.class);
	
	private static final String ATTACH_NO_PRE = "invoice_";
	
	@Override
	public void onPreparePropertys(PreparePropertysEventArgs e) {
		//列表操作字段准备
		String param = this.getBizRule().getParameter();
		JSONObject config = JSONObject.parseObject(param);
		Map<String, String> paraMapKey = config.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
		List<String> paramKey = Lists.newArrayList(InvoiceOpParamContant.BILLNO ,InvoiceOpParamContant.BILLID
				,InvoiceOpParamContant.ORGID ,InvoiceOpParamContant.BILLUSER,InvoiceOpParamContant.BILLIMAGENO,InvoiceOpParamContant.BILLCOMPANY);
		List<String> fieldKeys = e.getFieldKeys();
		
		//单头
		fieldKeys.addAll(paramKey.stream().map(v -> config.getString(paraMapKey.get(v))).filter(v -> v != null).collect(Collectors.toList()));		
		//分录
		String invoiceentry = config.getString(InvoiceOpParamContant.INVOICEENTRY);
		if(StringUtils.isNotBlank(invoiceentry)) {
            int index = invoiceentry.lastIndexOf("_");
            if(index != -1){
                invoiceentry = invoiceentry.substring(0,index);
            }
			JSONArray entryentity = config.getJSONArray(InvoiceOpParamContant.ENTRYENTITY);
			if(entryentity != null && !entryentity.isEmpty()) {
				for (Object object : entryentity) {
					JSONObject entry = (JSONObject)object;
					fieldKeys.add(invoiceentry+"."+entry.getString(InvoiceOpParamContant.ENTRYKEY));
				}
			}
		}
	}
	
	@Override
	public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
		DynamicObject[] dataEntities = e.getDataEntities();
		//先保存影像编码
		JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
		Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
		String templateFormId = param.getString(InvoiceOpParamContant.PRINT);
		if(StringUtils.isNotBlank(templateFormId)) {
			List<String> imgNoList = Lists.newArrayList();
			for (DynamicObject dataEntity : dataEntities) {
				Map<String, Object> configMap = initConfigParam(param, dataEntity, paraMapKey, false);
				boolean needCreate = needCreatePdf(param, dataEntity, configMap);
				if(needCreate) {
					long billid = (long)dataEntity.getPkValue();
					if(billid == 0L) {
						billid = ORM.create().genLongId(dataEntity.getDataEntityType());
						dataEntity.set("id", billid);
					}
					//没有创建的要先创建
					String imageNumber = getImageNumber(dataEntity.getDynamicObjectType().getName(), (long)dataEntity.getPkValue());
					String imgNo = createImageNumber(e.getOperationKey(),dataEntity, param);
					//如果查询为空，则说明是新创建的
					if(StringUtils.isBlank(imageNumber)) {
						imgNoList.add(imgNo);
					}
				}
			}
			if(!imgNoList.isEmpty()) {
				param.put("newImgNo", imgNoList);
				this.getBizRule().setParameter(param.toJSONString());
			}
		}
	}
	
	@Override
	public void beginOperationTransaction(BeginOperationTransactionArgs e) {
		DynamicObject[] dataEntities = e.getDataEntities();
		//列表提交走resultInfo，因为平台机制问题，需要分两个地方执行
		//表单页面提交时，提示失败又提示成功
		if(dataEntities.length > 1) {
			JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
			Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
			List<DynamicObject> successList = Lists.newArrayListWithExpectedSize(dataEntities.length);
			for (DynamicObject dataEntity : dataEntities) {
				try {
					excuteService(param, dataEntity, paraMapKey);
					successList.add(dataEntity);
				}catch(ImcRimInvoiceBizException e1) {
					showInView(dataEntity, e.getOperationKey(), e1, ResManager.loadKDString("发票云", "SaveInvoiceAction", "bos-ext-imc"));
				}catch (Exception e2) {
					showInView(dataEntity, e.getOperationKey(), e2, ResManager.loadKDString("内部程序错误", "SaveInvoiceAction", "bos-ext-imc"));
				}
			}
			e.setDataEntities(successList.toArray(new DynamicObject[successList.size()]));
		}
	}
	
	@Override
	public void endOperationTransaction(EndOperationTransactionArgs e) {
		DynamicObject[] dataEntities = e.getDataEntities();
		//单据提交走中断，因为平台机制问题，需要分两个地方执行
		if(dataEntities.length == 1) {
			JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
			Map<String, String> paraMapKey = param.keySet().stream().collect(Collectors.toMap(v -> exChange(v), v -> v));
			for (DynamicObject dataEntity : dataEntities) {
				try {
					excuteService(param, dataEntity, paraMapKey);
				}catch(ImcRimInvoiceBizException e1) {
					showKDBizException(e.getOperationKey(), e1);
				}catch (Exception e2) {
					showKDBizException(e.getOperationKey(), e2);
				}
			}
		}
	}
	
	@Override
	public void rollbackOperation(RollbackOperationArgs e) {
		JSONObject param = JSONObject.parseObject(this.getBizRule().getParameter());
		JSONArray imgNoList = param.getJSONArray("newImgNo");
		if(imgNoList != null) {
			for (int i = 0; i < imgNoList.size(); i++) {
				String imgNo = imgNoList.getString(i);
				delImgNo(imgNo);
			}
			param.remove("newImgNo");
			this.getBizRule().setParameter(param.toJSONString());
		}
	}
	
	/**
	 * 	包装错误信息
	 * @author rd_yuqiu_he 
	 * @date 2022-4-8 
	 * @param dataEntity
	 * @param errorInfoStr
	 * @param title
	 */
	protected void showInView(DynamicObject dataEntity, String opKey, Exception e, String title) {
		String errorInfoFormat = ResManager.loadKDString("执行%s失败，原因：%s", "SaveInvoiceAction_1", "bos-ext-imc");
		String errorInfoStr = String.format(errorInfoFormat, getServiceName(opKey), e.getMessage());
		logger.error("【发票云服务】保存服务，错误日志：", e);
		OperationResult operationResult = this.getOperationResult();
		OperateErrorInfo errorInfo = new OperateErrorInfo(title, ErrorLevel.Error, dataEntity.getPkValue());
		errorInfo.setMessage(errorInfoStr);
		errorInfo.setTitle(title);
		operationResult.addErrorInfo(errorInfo);
	}
	
	/**
	 * 	获取当前操作的多语言文字
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param opKey
	 * @return
	 */
	private String getServiceName(String opKey){
		String serviceName = opKey;
		if(this.operateMeta.get("name") != null && this.operateMeta.get("name") instanceof Map) {
			serviceName = LocaleString.fromMap((Map)this.operateMeta.get("name")).getLocaleValue();
		}
		return serviceName;
	}
	
	/**
	 * 	包装KDEX的错误信息
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param opKey
	 * @param e
	 */
	private void showKDBizException(String opKey, Exception e) {
		logger.error("【发票云服务】保存服务，错误日志：", e);
		String errorInfoFormat = ResManager.loadKDString("执行%s失败，原因：%s", "SaveInvoiceAction_2", "bos-ext-imc");
		String errorInfo = String.format(errorInfoFormat, getServiceName(opKey), e.getMessage());
		throw new KDBizException(e, new ErrorCode("SaveInvoiceAction,afterExecuteOperationTransaction", errorInfo));
	}
	
	/**
	 * 	执行保存发票服务
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param param
	 * @param dataEntity
	 * @param paraMapKey
	 * @throws ImcRimInvoiceBizException
	 * @throws Exception
	 */
	private void excuteService(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey) throws ImcRimInvoiceBizException,Exception{
		//将页面配置构造成参数
		Map<String, Object> configMap = initConfigParam(param, dataEntity, paraMapKey, true);
		logger.info("【发票云服务】保存服务，转换后的参数：{}",configMap);
		//调用发票云的保存服务
		saveInvoiceAndBill(configMap);
	}
	
	/**
	 * 	操作传递进来的参数或单据页面获取对应的构造保存发票服务的参数
	 * 	优先使用调用操作传递进来的参数
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param param
	 * @param dataEntity
	 * @param paraMapKey
	 * @return
	 */
	private Map<String, Object> initConfigParam(JSONObject param, DynamicObject dataEntity, Map<String, String> paraMapKey, boolean createPdf) {
		//获取初始化参数信息
		Map<String, Object> configParam = Maps.newHashMapWithExpectedSize(8);

		//首先检查是否在操作中传递参数
 		Map<String, String> opVariables = this.getOption().getVariables();
		logger.info("【发票云服务】保存服务，传入参数：{}",opVariables);
		logger.info("【发票云服务】保存服务，配置参数：{}",param.toJSONString());
		//挑选出参数中未传递的数据
		List<String> noneParam = Lists.newArrayListWithExpectedSize(getCustomConfigParam().size());
		for (String key : getCustomConfigParam()) {
			String value = opVariables.get(key);
			if(value != null) {
				configParam.put(key, value);
			}else {
				noneParam.add(key);
			}
		}
		
		//根据配置补全参数
		for (String noneKey : noneParam) {
			String configValue = param.getString(paraMapKey.get(noneKey));
			if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLID)) {
				if(StringUtils.equals(configValue, "id")) {
					//获取单据id
					configParam.put(noneKey, dataEntity.getPkValue().toString());
				}else {
					if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
						configParam.put(noneKey, dataEntity.get(configValue));
					}
				}
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLNO)) {
				//判断字段是否存在于当前页面
				if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
					configParam.put(noneKey, dataEntity.get(configValue));
				}
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.BILLTYPE)) {
				if (StringUtils.isNotBlank(configValue)) {
					DynamicObject billTypeDobj= BusinessDataServiceHelper.loadSingle(configValue, InvoiceOpParamContant.RIM_EXPENSE_TYPE, "number");
					configValue = billTypeDobj.getString("number");
				}
				//单据类型是基础资料
				configParam.put(noneKey, configValue);
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.ORGID)
					|| StringUtils.equals(noneKey, InvoiceOpParamContant.BILLUSER)){ 
				if(dataEntity.getDynamicObjectType().getProperty(configValue) != null) {
					configParam.put(noneKey, getDynamicObjectLongValue(dataEntity.getDynamicObject(configValue)));
				}
			}else if(StringUtils.equals(noneKey, InvoiceOpParamContant.INVOICEDATA)) {
				String invoiceentry = param.getString(InvoiceOpParamContant.INVOICEENTRY);
				if(StringUtils.isNotBlank(invoiceentry)) {
					int index = invoiceentry.lastIndexOf("_");
					if(index != -1){
						invoiceentry = invoiceentry.substring(0,index);
					}
				}
				//打印日志输出获取到的发票分录标识
				logger.info("【发票云服务】保存服务，发票分录参数：{}",invoiceentry);
				JSONArray entryentity = param.getJSONArray(InvoiceOpParamContant.ENTRYENTITY);
				//发票分录
				if(dataEntity.getDynamicObjectType().getProperty(invoiceentry) != null
						&& entryentity != null && !entryentity.isEmpty()) {
					DynamicObjectCollection invoiceInfos = dataEntity.getDynamicObjectCollection(invoiceentry);
					//调用接口的参数
					List<Map<String, Object>> invoiceData = Lists.newArrayListWithExpectedSize(invoiceInfos.size());
					//获取需要在发票分录的
					for (DynamicObject invoiceInfo : invoiceInfos) {
						Map<String, Object> invoice = Maps.newHashMapWithExpectedSize(entryentity.size());
						for (Object object : entryentity) {
							JSONObject entry = (JSONObject)object;
							String key = entry.getString(InvoiceOpParamContant.INVOICEKEY);
							Object value = invoiceInfo.get(entry.getString(InvoiceOpParamContant.ENTRYKEY));
							invoice.put(key, value);
						}
						if(invoiceInfo.getPkValue() != null && StringUtils.isNotBlank(invoiceInfo.getPkValue())) {
							invoice.put(InvoiceOpParamContant.ENTRYID, invoiceInfo.getPkValue().toString());
						}
						invoiceData.add(invoice);
					}
					configParam.put(InvoiceOpParamContant.INVOICEDATA, invoiceData);
				}
			}else if(configValue != null) {
				configParam.put(noneKey, configValue);
			}
		}
		
		if(noneParam.contains(InvoiceOpParamContant.COVERDATA) && createPdf) {
			createPdf(param, dataEntity, configParam);
		}
		//是否自动获取附件信息
		String updateAttach = param.getString(InvoiceOpParamContant.UPDATEATTACHRELATION);
		if(StringUtils.equals(updateAttach, "1") && configParam.get(InvoiceOpParamContant.ATTACHDATA) == null && createPdf) {
			updateAttachRelation(param, dataEntity, configParam);
		}
		return configParam;
	}
	
	private void updateAttachRelation(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam) {
		JSONArray updateAttachInfos = new JSONArray();
		//获取附件面板标识
		String attachpanelkey = param.getString(InvoiceOpParamContant.ATTACHPANELKEY);
		if(StringUtils.isBlank(attachpanelkey)) {
			logger.info("【发票云服务】保存服务，附件面板标识为空，不进行同步删除附件操作");
			param.remove(InvoiceOpParamContant.UPDATEATTACHRELATION);
			return;
		}
		//附件缓存
		String tempAttach = this.getOption().getVariables().get("attachmentpanel");
		if(StringUtils.isNotBlank(tempAttach)) {
			JSONObject AttachmentInfo = JSONObject.parseObject(tempAttach).getJSONObject("AttachmentInfo");
			JSONArray tempAttachArr = AttachmentInfo.getJSONArray(attachpanelkey);
			for (int i = 0; i < tempAttachArr.size(); i++) {
				JSONObject tempAttachInfo = tempAttachArr.getJSONObject(i);
				String attachNo = tempAttachInfo.getString("uid");
				if(StringUtils.isNotBlank(attachNo) && attachNo.contains(ATTACH_NO_PRE)) {
					JSONObject updateAttachInfo = new JSONObject();
					updateAttachInfos.add(updateAttachInfo);
					updateAttachInfo.put("attachNo", attachNo.replace(ATTACH_NO_PRE, ""));
				}
			}
		}
		//附件表
		List<Map<String, Object>> attachments = AttachmentServiceHelper.getAttachments(dataEntity.getDynamicObjectType().getName(), dataEntity.getPkValue(), attachpanelkey, true);
		for (Map<String, Object> attachment : attachments) {
			String attachNo = (String)attachment.get("uid");
			if(StringUtils.isNotBlank(attachNo) && attachNo.contains(ATTACH_NO_PRE)) {
				JSONObject updateAttachInfo = new JSONObject();
				updateAttachInfos.add(updateAttachInfo);
				updateAttachInfo.put("attachNo", attachNo.replace(ATTACH_NO_PRE, ""));
			}
		}
		//设置附件信息
		configParam.put(InvoiceOpParamContant.ATTACHDATA, updateAttachInfos);
	}
	
	private void createPdf(JSONObject param, DynamicObject dataEntity,Map<String, Object> configParam) {
		//判断是否需要生成封面
		if(!needCreatePdf(param, dataEntity, configParam)) {
			logger.info("【发票云服务】保存服务，无需生成封面");
			return;
		}
		//获取影像封面，暂不支持自定义的封面模板
		String templateFormId = param.getString(InvoiceOpParamContant.PRINT);
		if(StringUtils.isNotBlank(templateFormId)) {
			String formId = dataEntity.getDynamicObjectType().getName();
			String imageNumber = getImageNumber(formId, (long)dataEntity.getPkValue());
			//先判断是否创建影像编号
			if(StringUtils.isNotBlank(imageNumber)){
				//String fakePageId = "fake-" + UUID.randomUUID().toString().replace("-", "");
				//byte[] imagePdf = createSinglePdf("", templateFormId, formId, dataEntity.getPkValue());
				byte[] imagePdf = CoverUtils.createSinglePdf("", templateFormId, formId, dataEntity.getPkValue());
				if(imagePdf != null && imagePdf.length > 0) {
					JSONObject coverData = new JSONObject();
					String base64Str = new String( Base64.getEncoder().encode(imagePdf));
					coverData.put("base64", base64Str);
					coverData.put("coveType", "pdf");
					coverData.put("coveNo", imageNumber);
					configParam.put(InvoiceOpParamContant.COVERDATA, coverData);
					logger.info("【发票云服务】保存服务，封面数据：" + coverData.toJSONString());
				} else {
					logger.info("【发票云服务】保存服务，未获取到pdf文件流");
				}
			}else{
				logger.info("【发票云服务】保存服务，未获取到影像编号");
			}
		}
	}
	
	private boolean needCreatePdf(JSONObject param, DynamicObject dataEntity, Map<String, Object> configParam) {
		String onlyPrint = param.getString(InvoiceOpParamContant.ONLY_PRINT);
		boolean needCreate = true;
		//无发票附件同步封面为关闭
		if(StringUtils.equals(onlyPrint, "0")) {
			//首先判断单据上是否存在发票或附件
			List invoice = (List)configParam.get(InvoiceOpParamContant.INVOICEDATA);
			List attach = (List)configParam.get(InvoiceOpParamContant.ATTACHDATA);
			if((invoice != null && !invoice.isEmpty())||(attach != null && !attach.isEmpty())){
				return needCreate;
			}
			Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(2);
			Long billid = (Long)dataEntity.getPkValue();
			//单据id为空，未保存或未打开过发票助手
			if(billid != null && billid != 0L) {
				paramMap.put("billId", configParam.get(InvoiceOpParamContant.BILLID));
				paramMap.put("entityId", configParam.get(InvoiceOpParamContant.ENTITYID));
				Map<String, Object> result = DispatchServiceHelper.invokeBizService("imc", "rim", "FpzsService", "queryInvoiceAndFile", new Object[]{paramMap});
				JSONObject resultJson = JSONObject.parseObject(JSONObject.toJSONString(result));
				logger.info("获取到的发票信息：{}" ,result);
				if(StringUtils.equals(resultJson.getString("errcode"), "0000")) {
					JSONObject data = resultJson.getJSONObject("data");
					JSONArray invoiceData = null;
					JSONArray attachment = null;
					if(data != null){
						invoiceData = data.getJSONArray("invoiceData");
						attachment = data.getJSONArray("attachment");
					}else{
						invoiceData = resultJson.getJSONArray("invoiceData");
						attachment = resultJson.getJSONArray("attachment");
					}
					if((invoiceData == null || invoiceData.isEmpty())
							&& (attachment == null || attachment.isEmpty())) {
						logger.info("【发票云服务】保存服务，未查询到发票或附件信息，不生成封面");
						needCreate = false;
					}
				}
			}
		}
		return needCreate;
	}
	
	/**
	 * 	执行保存发票服务
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param configMap
	 * @throws ImcRimInvoiceBizException
	 * @throws Exception
	 */
	private void saveInvoiceAndBill(Map<String, Object> configMap) throws ImcRimInvoiceBizException,Exception {
		Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(14);
		
		paramMap.put(InvoiceOpParamContant.BILLTYPE, configMap.get(InvoiceOpParamContant.BILLTYPE));
		paramMap.put(InvoiceOpParamContant.BILLNO, configMap.get(InvoiceOpParamContant.BILLNO));
		paramMap.put(InvoiceOpParamContant.BILLID, configMap.get(InvoiceOpParamContant.BILLID));
		paramMap.put(InvoiceOpParamContant.ENTITYID, configMap.get(InvoiceOpParamContant.ENTITYID));
		paramMap.put(InvoiceOpParamContant.ORGID, configMap.get(InvoiceOpParamContant.ORGID));
		paramMap.put(InvoiceOpParamContant.BILLUSER, configMap.get(InvoiceOpParamContant.BILLUSER));
		paramMap.put(InvoiceOpParamContant.VERIFYFLAG, configMap.get(InvoiceOpParamContant.VERIFYFLAG));
		paramMap.put(InvoiceOpParamContant.STATUS, configMap.get(InvoiceOpParamContant.STATUS));
		
		if(configMap.get(InvoiceOpParamContant.RESOURCE) == null) {
			paramMap.put(InvoiceOpParamContant.RESOURCE, "4");
		}else {
			paramMap.put(InvoiceOpParamContant.RESOURCE, configMap.get(InvoiceOpParamContant.RESOURCE));
		}
		
		if(configMap.get(InvoiceOpParamContant.VIEWPAGE) == null) {
			paramMap.put(InvoiceOpParamContant.VIEWPAGE, configMap.get(InvoiceOpParamContant.ENTITYID));
		}else {
			paramMap.put(InvoiceOpParamContant.VIEWPAGE, InvoiceOpParamContant.VIEWPAGE);
		}
		
		if(configMap.get(InvoiceOpParamContant.APPID) == null) {
			paramMap.put(InvoiceOpParamContant.APPID, this.billEntityType.getAppId());
		}else{
			paramMap.put(InvoiceOpParamContant.APPID, configMap.get(InvoiceOpParamContant.APPID));
		}
		
		if(configMap.get(InvoiceOpParamContant.INVOICEDATA) == null) {
			paramMap.put(InvoiceOpParamContant.INVOICEDATA, new JSONArray());
		}else {
			paramMap.put(InvoiceOpParamContant.INVOICEDATA, configMap.get(InvoiceOpParamContant.INVOICEDATA));
		}
		
		//判断是否有传封面
		if(configMap.get(InvoiceOpParamContant.COVERDATA) != null) {
			paramMap.put(InvoiceOpParamContant.COVERDATA, configMap.get(InvoiceOpParamContant.COVERDATA));
		}
		
		//传入附件信息
		if(configMap.get(InvoiceOpParamContant.UPDATEATTACHRELATION) != null) {
			paramMap.put(InvoiceOpParamContant.UPDATEATTACHRELATION, configMap.get(InvoiceOpParamContant.UPDATEATTACHRELATION));
		}
		if(configMap.get(InvoiceOpParamContant.ATTACHDATA) != null) {
			paramMap.put(InvoiceOpParamContant.ATTACHDATA, configMap.get(InvoiceOpParamContant.ATTACHDATA));
		}
		
		logger.info("【发票云服务】保存服务，更新发票云状态，请求参数：{}", JSON.toJSONString(paramMap));
		Map<String, Object> rawResult = DispatchServiceHelper.invokeBizService("imc", "rim", "FpzsService", "save", new Object[]{paramMap});
		logger.info("【发票云服务】保存服务，更新发票云状态， 返回结果：{}", JSON.toJSONString(rawResult));
		if(!StringUtils.equals((String)rawResult.get("errcode"), "0000")) {
			throw new ImcRimInvoiceBizException("保存发票关系失败，"+rawResult.get("description")+"，请联系管理员");
		}
	}

	/**
	 * 获取单据对应的影像编码
	 */
	private String getImageNumber(String entityName, Long billId) {
		ImageInfo imageInfo = new ImageInfo();
		imageInfo.setBillId(String.valueOf(billId));
		imageInfo.setBilltype(entityName);
		
		logger.info("getImageNumber param: " + entityName + ", " + billId);
		ImageInfo result = kd.bos.servicehelper.image.ImageServiceHelper.getImageInfoInside(imageInfo);
		if(result == null) {
			logger.info("【发票云服务】保存服务，影像编码未查询到");
			return "";
		}
		logger.info("【发票云服务】保存服务，影像编码: {}", result.getImageNo());
		return result.getImageNo();
	}
	
	private String createImageNumber(String opKey, DynamicObject dataEntity, JSONObject param) {
		String imageNum = "";
		try {
			ImageInfo imageInfo = new ImageInfo();
			imageInfo.setBillId(dataEntity.getPkValue().toString());//单据id
			imageInfo.setBillNo(dataEntity.getString(param.getString("bill_no")));//单据编码
			imageInfo.setCreator(""+getDynamicObjectLongValue(dataEntity.getDynamicObject(param.getString("bill_user"))));//提单人id
			imageInfo.setBilltype(dataEntity.getDynamicObjectType().getName());//表单标识
			imageInfo.setOrgId(""+getDynamicObjectLongValue(dataEntity.getDynamicObject(param.getString("bill_company"))));//提单人所在组织
			imageNum = ImageServiceHelper.createImageInfo(imageInfo);
			logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码成功：{}", imageNum);
		}catch (Exception e){
			showKDBizException(opKey, e);
			logger.info("【发票云服务】保存服务，推送发票影像数据前创建影像编码失败,异常类型：{}", e);
		}
		if(StringUtils.isNotBlank(param.getString("bill_imageno")) && dataEntity.getDynamicObjectType().getProperty(param.getString("bill_imageno")) != null) {
			dataEntity.set(param.getString("bill_imageno"), imageNum);
		}
		return imageNum;
	}
	
	private void delImgNo(String imageNo) {
		try (TXHandle h = TX.requiresNew()) {
			try {
				String userName = RequestContext.get().getUserName();
				ImageServiceHelper.deleteImage(imageNo, userName, null);
			} catch (Throwable e) {
				h.markRollback();
				throw e;
			}
		}
	}
	
	/**
	 * 	获取接口参数
	 * @author rd_yuqiu_he 
	 * @date 2022-4-8 
	 * @return
	 */
	private List<String> getCustomConfigParam() {
		return Lists.newArrayList(InvoiceOpParamContant.BILLTYPE,InvoiceOpParamContant.BILLNO,InvoiceOpParamContant.BILLID
				,InvoiceOpParamContant.ENTITYID,InvoiceOpParamContant.ORGID,InvoiceOpParamContant.BILLUSER
				,InvoiceOpParamContant.VERIFYFLAG,InvoiceOpParamContant.STATUS,InvoiceOpParamContant.RESOURCE
				,InvoiceOpParamContant.VIEWPAGE,InvoiceOpParamContant.APPID,InvoiceOpParamContant.COMPANYINFO
				,InvoiceOpParamContant.INVOICEDATA,InvoiceOpParamContant.COVERDATA,InvoiceOpParamContant.UPDATEATTACHRELATION
				,InvoiceOpParamContant.ATTACHDATA);
	}
	
	/**
	 * 	因页面无法写成大写，则在多单词之间增加下划线_，在此进行转换
	 * 	例：bill_id = billId
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param key
	 * @return
	 */
	private String exChange(String key) {
		String[] strArr = key.split("_");
		StringBuilder sb = new StringBuilder();
		sb.append(strArr[0]);
		for (int i = 1; i < strArr.length; i++) {
			String start = strArr[i].substring(0,1);
			String end = strArr[i].substring(1);
			start = start.toUpperCase();
			strArr[i] = start+end;
			sb.append(strArr[i]);
		}
		return sb.toString();
	}
	
	/**
	 * 	获取基础资料主键id
	 * @author 何雨秋 
	 * @date 2022-4-11 
	 * @param value
	 * @return
	 */
	private long getDynamicObjectLongValue(Object value) {
		try {
			if (value instanceof DynamicObject) {
				return Long.parseLong(((DynamicObject) value).getPkValue().toString());
			} else {
				return Long.parseLong(value.toString());
			}
		} catch (Exception e) {
			return 0L;
		}
	}
}
