package kd.bos.ext.imc.operation.util;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.util.CollectionUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

/**
 * @ClassName CoverUtils
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/25 16:56
 * @Version 1.0
 */
public class CoverUtils {
    private static Log logger = LogFactory.getLog(CoverUtils.class);

    public static byte[] createSinglePdf(String pageId, String templateFormId, String formId, Object pkId) {
        // 暂时：用 MetadataDao 旧 api 判断新旧模板，从元数据判断，新打印是没有数据的。等平台出新 api 再调整
        String tplId = MetadataDao.getIdByNumber(templateFormId, MetaCategory.Form);
        logger.info(String.format("【发票云服务】保存服务，创建单据封面pdf, pageId : %s, formId: %s, templateFormId: %s, tplId: %s", pageId, formId, templateFormId, tplId));
        byte[] result = null;
        if (!StringUtils.isBlank(tplId)) { // 旧模板
            logger.info("【发票云服务】保存服务，创建单据封面的pdf，旧模板id：{}" , tplId);
            result = PrintServiceHelper.createSinglePdf(pageId, formId, templateFormId, pkId);
        } else { // 新模板
            PrintWork printWork = new PrintWork();
            printWork.setPrintLang(ResManager.getLanguage()); //ResManager
            // 导出类型： 1.pdf 2.xls
            printWork.setExpType("1");
            printWork.setPageId(pageId);
            PrintTask printTask = new PrintTask();
            tplId = BosPrintServiceHelper.getTplIdByNum(templateFormId);
            logger.info("【发票云服务】保存服务，创建单据封面的pdf，新模板id：{}" , tplId);
            printTask.setTplId(tplId);
            printTask.setPkIds(Collections.singletonList(pkId));
            printWork.setTaskList(Collections.singletonList(printTask));
            //增加一个参数控制
            InputStream inputStream = null;
            String createCoverModel = ImcConfigUtil.getValue("imc_config","create_cover_model");
            if(StringUtils.equals(createCoverModel, "old")){
                inputStream = getPdfOld(printWork);
            }else{
                inputStream = getPdfNew(printWork);
            }
            if(inputStream !=null){
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                int nRead;
                byte[] data = new byte[16384];
                try {
                    while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                        buffer.write(data, 0, nRead);
                    }
                } catch (IOException e) {
                    logger.error(e);
                }
                result = buffer.toByteArray();
            }else{
                logger.info("生成pdf封面失败");
            }
        }
        return result == null ? new byte[0] : result;
    }



    /**
     * 5.0.011有紧急补丁，5.0.019标准补丁发布
     * @param printWork
     * @return
     */
    private static InputStream getPdfNew(PrintWork printWork){
        PrtAttach attach = BosPrintServiceHelper.execPrint(printWork);
        List<PrtAttach.AttachDetail> attachDetails = attach.getAttachDetail();
        if (!CollectionUtils.isEmpty(attachDetails)) {
            String tempUrl = attachDetails.get(0).getFilePath();
            logger.info("【发票云服务】保存服务，创建单据封面的pdf，doPrint 返回附件详情数据：{}，拼接后的下载地址：{}" , JSON.toJSONString(attachDetails), tempUrl);
            return BosPrintServiceHelper.getFileInputStream(tempUrl);
        }
        return null;
    }

    /**
     * 旧版本逻辑，存在客户版本低，保留
     * @param printWork
     * @return
     */
    private static InputStream getPdfOld(PrintWork printWork){
        PrtAttach attach = BosPrintServiceHelper.doPrint(printWork);
        List<PrtAttach.AttachDetail> attachDetails = attach.getAttachDetail();
        if (!CollectionUtils.isEmpty(attachDetails)) {
            logger.info("【发票云服务】保存服务，创建单据封面的pdf，doPrint 返回附件详情数据：{}" , JSON.toJSONString(attachDetails));
            return FileServiceFactory.getAttachmentFileService().getInputStream(attachDetails.get(0).getFilePath());
        }
        return null;
    }
}
