package kd.bos.ext.imc.operation.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName ImcConfigUtil
 * @Description TODO
 * @Author yuqiu_he
 * @Date 2023/9/25 17:01
 * @Version 1.0
 */
public class ImcConfigUtil {

    private static final String CONFIG_FIELD_TYPE = "config_type";
    private static final String CONFIG_FIELD_KEY = "config_key";
    private static final String CONFIG_FIELD_VALUE = "config_value";
    private static final String CONFIG_FIELDS = "config_type,config_key,config_value";
    private static Log logger = LogFactory.getLog(ImcConfigUtil.class);

    /**
     * 清除缓存
     *
     * @param configType
     */
    public static void removeCache(String configType) {
        CacheHelper.remove(configType);
    }

    public static Map<String, String> getValue(String configType) {
        String configCache = CacheHelper.get(configType);
        if (StringUtils.isNotEmpty(configCache)) {
            Map<String, String> map = new HashMap<>();
            map = SerializationUtils.fromJsonString(configCache, map.getClass());
            if (logger.isInfoEnabled()) {
                logger.info(String.format("读取ImcConfig缓存：%s, 内容：%s", configType, configCache));
            }
            return map;
        }
        return putCache(configType);
    }

    public static String getValue(String configType, String configKey) {
        Map<String, String> map = getValue(configType);
        String val = map.get(configKey);
        if (val != null) {
            return val;
        }
        return map.get(configType + "_" + configKey);
    }

    public static Map<String, String> putCache(String configType) {
        QFilter filter = new QFilter(CONFIG_FIELD_TYPE, QFilter.equals, configType);
        DynamicObject[] collection = BusinessDataServiceHelper.load("invsm_param_configuration",
                CONFIG_FIELDS, new QFilter[] { filter });
        Map<String, String> map = new HashMap<>(collection.length);
        String start = configType + "_";
        for (DynamicObject obj : collection) {
            String type = obj.getString(CONFIG_FIELD_KEY);
            if (type.startsWith(start)) {
                map.put(type.replace(start, ""), obj.getString(CONFIG_FIELD_VALUE));
            } else {
                map.put(type, obj.getString(CONFIG_FIELD_VALUE));
            }
        }
        if (!map.isEmpty()) {
            String cacheStr = SerializationUtils.toJsonString(map);
            CacheHelper.put(configType, cacheStr, 60 * 60 * 24);
        }
        return map;
    }

    public static int getSizeFromConfig(int defaultSize, String configType, String configKey) {
        String sizeStr = getValue(configType, configKey);
        if (StringUtils.isNotEmpty(sizeStr)) {
            try {
                defaultSize = Integer.parseInt(sizeStr.trim());
            } catch (NumberFormatException e) {

            }
        }
        return defaultSize;
    }
}
