package kd.bos.ext.taxc.writeback;

import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.AbstractDapWriteBackImpl;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.ext.fi.ai.VoucherOperation;

import java.util.Map;

/**
 * @ClassName: DapVoucherWriteBackTcvat
 * @Description: 增值税进项转出凭证回调接口
 * @Author: rd_liu_scott
 * @Date: 2020/12/9 10:01
 * ..
 */
public class DapVoucherWriteBackTcvat extends AbstractDapWriteBackImpl {
	public DapVoucherWriteBackTcvat() {
	}

	public void writeBack(VoucherOperation operation, String billEntityNumber, Map<Long, Voucher> billToVch) {
		MainEntityType mt = EntityMetadataCache.getDataEntityType(billEntityNumber);
		if (mt.findProperty("billno") != null) {
			if (VoucherOperation.Create.equals(operation)) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisvoucher = '1'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}

			if (VoucherOperation.Delete.equals(operation)) {
				DB.execute(this.getDBRoute(), "update " + mt.getAlias() + " set fisvoucher = '0'  where fid in (" + StringUtils.join(billToVch.keySet().toArray(), ',') + ")", new Object[0]);
			}
		}
	}

	protected String getVchStatusField() {
		return "fisvoucher";
	}

	protected Object getVchEnableStatus() {
		return true;
	}

	protected Object getVchDisableStatus() {
		return false;
	}

	protected DBRoute getDBRoute() {
		return DBRoute.of("taxc");
	}
}
