/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.dao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.FilterBaseCondition;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.FilterItem;
import kd.bsc.bea.common.model.Mapping;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.util.FieldTypeUtil;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.util.QueryConditionUtils;

public class MappingBizDataQueryHelper {
    private static final Log log = LogFactory.getLog(MappingBizDataQueryHelper.class);

    private MappingBizDataQueryHelper() {
        throw new IllegalStateException("util static class cannot be init");
    }

    public static DynamicObject getBizMappingById(Object id) {
        String selectProperties = MappingBizDataQueryHelper.beaMappingSelectProp();
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"bea_mapping", (String)selectProperties);
    }

    public static DynamicObject[] queryByMapping(Object id, Date startTime) {
        DynamicObject mappingObj = MappingBizDataQueryHelper.getBizMappingById(id);
        Mapping mapping = BizMappingHelper.dynamicObjectToMapping(mappingObj);
        return MappingBizDataQueryHelper.queryByMapping(Boolean.TRUE, mapping, startTime);
    }

    public static DynamicObject[] queryByMappingAndBillNo(Object mappingId, String billNoNumber, String billNo) {
        DynamicObject mappingObj = MappingBizDataQueryHelper.getBizMappingById(mappingId);
        Mapping mapping = BizMappingHelper.dynamicObjectToMapping(mappingObj);
        Map<String, BizModelField> bizModelFieldMap = BizMappingHelper.getBizModelFieldMap(mapping.getBizModel(), 0);
        QFilter billFilter = new QFilter(billNoNumber, "=", (Object)billNo);
        QFilter mappingFilter = MappingBizDataQueryHelper.constructQFilter(mapping.getFilterEntries(), null, bizModelFieldMap);
        QFilter filter = null == mappingFilter ? billFilter : mappingFilter.and(billFilter);
        String selectProp = MappingBizDataQueryHelper.constructSelectProp(mapping.getMappingEntries());
        return BusinessDataServiceHelper.load((String)mapping.getBizModel(), (String)selectProp, (QFilter[])filter.toArray(), (String)MappingBizDataQueryHelper.constructOrderBys());
    }

    public static DynamicObject[] queryByMapping(Boolean includeFilter, Mapping mapping, Date startTime) {
        Map<String, BizModelField> bizModelFieldMap = BizMappingHelper.getBizModelFieldMap(mapping.getBizModel(), 0);
        QFilter filter = MappingBizDataQueryHelper.constructQFilter(mapping.getFilterEntries(), startTime, bizModelFieldMap);
        String selectProp = MappingBizDataQueryHelper.constructSelectProp(mapping.getMappingEntries());
        QFilter[] qFilters = null == filter ? null : filter.toArray();
        return BusinessDataServiceHelper.load((String)mapping.getBizModel(), (String)selectProp, (QFilter[])(includeFilter != false ? qFilters : null), (String)MappingBizDataQueryHelper.constructOrderBys());
    }

    public static String constructSelectProp(List<MappingEntry> mappingEntries) {
        List fieldNames = mappingEntries.stream().map(e -> Arrays.asList(e.getBizName().split(","))).flatMap(Collection::stream).filter(e -> StringUtils.isNotEmpty((CharSequence)e) && !"\u9644\u4ef6".equals(e)).collect(Collectors.toList());
        List extraFieldNames = fieldNames.stream().map(MappingBizDataQueryHelper::extraEntrySelectProp).filter(Objects::nonNull).collect(Collectors.toList());
        return Stream.of(Stream.of("billno"), fieldNames.stream(), extraFieldNames.stream()).flatMap(i -> i).map(MappingBizDataQueryHelper::transformEntryFieldName).distinct().collect(Collectors.joining(","));
    }

    private static String transformEntryFieldName(String name) {
        return name.replaceAll("[\\[\\] ]", "");
    }

    public static QFilter constructQFilter(List<FilterEntry> filterEntries, Date modifyTime, Map<String, BizModelField> bizModelFieldMap) {
        Deque<FilterItem> items = MappingBizDataQueryHelper.breakdownSourceCondition(filterEntries, bizModelFieldMap);
        QFilter filter = MappingBizDataQueryHelper.itemsToFilter(items);
        if (modifyTime != null) {
            filter = Objects.nonNull(filter) ? filter.and("modifytime", ">=", (Object)modifyTime) : new QFilter("modifytime", ">=", (Object)modifyTime);
        }
        return filter;
    }

    private static QFilter itemsToFilter(Deque<FilterItem> items) {
        FilterItem.Type link = null;
        QFilter preFilter = null;
        while (!items.isEmpty()) {
            FilterItem item = items.pop();
            if (FilterItem.LEFT_BRACKET.equals(item)) {
                QFilter filter = MappingBizDataQueryHelper.itemsToFilter(items);
                preFilter = MappingBizDataQueryHelper.linkQFilter(filter, preFilter, link);
            }
            if (FilterItem.Type.CONDITION == item.getType()) {
                FilterBaseCondition condition = item.getData();
                QFilter filter = new QFilter(condition.getFilterField(), condition.getCompareMethod(), condition.getCompareValue(), condition.isExpressValue());
                preFilter = MappingBizDataQueryHelper.linkQFilter(filter, preFilter, link);
            }
            if (FilterItem.RIGHT_BRACKET.equals(item)) {
                return preFilter;
            }
            if (!FilterItem.AND_LINK.equals(item) && !FilterItem.OR_LINK.equals(item)) continue;
            link = item.getType();
        }
        return preFilter;
    }

    private static Deque<FilterItem> breakdownSourceCondition(List<FilterEntry> filterEntries, Map<String, BizModelField> bizModelFieldMap) {
        LinkedList<FilterItem> items = new LinkedList<FilterItem>();
        for (FilterEntry entry : filterEntries) {
            FilterBaseCondition baseCondition;
            if (StringUtils.isNotEmpty((CharSequence)entry.getLeftBracketValue())) {
                for (int i = 0; i < entry.getLeftBracketValue().length(); ++i) {
                    items.addLast(FilterItem.LEFT_BRACKET);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)entry.getConstVar())) {
                Object constVar = entry.getConstVar();
                BizModelField field = bizModelFieldMap.get(entry.getFilterName());
                if (null != field && FieldTypeUtil.isInteger((int)field.getFieldType())) {
                    constVar = Long.valueOf(entry.getConstVar());
                }
                baseCondition = new FilterBaseCondition(entry.getFilterName(), entry.getOption(), constVar, false);
            } else {
                baseCondition = new FilterBaseCondition(entry.getFilterName(), entry.getOption(), (Object)entry.getRefVar(), true);
            }
            items.addLast(new FilterItem(baseCondition));
            if (StringUtils.isNotEmpty((CharSequence)entry.getRightBracketValue())) {
                for (int i = 0; i < entry.getRightBracketValue().length(); ++i) {
                    items.addLast(FilterItem.RIGHT_BRACKET);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)entry.getLogicalSymbol())) continue;
            FilterItem logicalItem = "&&".equals(entry.getLogicalSymbol()) ? FilterItem.AND_LINK : FilterItem.OR_LINK;
            items.addLast(logicalItem);
        }
        return items;
    }

    private static QFilter linkQFilter(QFilter current, QFilter pre, FilterItem.Type link) {
        if (pre == null) {
            return current;
        }
        return FilterItem.Type.AND_LINK == link ? pre.and(current) : pre.or(current);
    }

    private static String constructOrderBys() {
        return "modifytime desc";
    }

    private static String beaMappingSelectProp() {
        String mappingEntryProp = QueryConditionUtils.entryCondition("mapping_entry", "bizname", "biztype", "bizdesc", "conv_rule", "aggr_fun", "aggr_fun_param", "fixed_value", "required_flag", "datatype_name", "datatype_type", "datatype_desc");
        String filterEntrySelectProp = QueryConditionUtils.entryCondition("filter_entry", "left_bracket", "filter_name", "option", "ref_var", "const", "right_bracket", "link_symbol", "filter_desc");
        return QueryConditionUtils.propJoin("bizmodel", "bduid_type", "org_bduid", "user_bduid", "stcc_custom_param", "field_mapping_param", "service_center", "datatype", mappingEntryProp, filterEntrySelectProp);
    }

    private static String extraEntrySelectProp(String fieldName) {
        String[] nameSlices = fieldName.split("\\.");
        int index = -1;
        for (int i = 0; i < nameSlices.length; ++i) {
            if (!nameSlices[i].contains("[") || !nameSlices[i].contains("]")) continue;
            index = i;
            break;
        }
        if (index > -1) {
            CharSequence[] elements = Arrays.copyOf(nameSlices, index + 2);
            return String.join((CharSequence)".", elements);
        }
        return null;
    }
}

