/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.helper;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bsc.bea.common.model.AggregationFunRow;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.plugin.AggregationFunPopForm;
import org.apache.commons.io.IOUtils;

public class AggregationFunHelper {
    private static List<AggregationFunRow> funRows;
    private static Map<String, AggregationFunRow> funRowMap;
    private static final Log log;

    private AggregationFunHelper() {
    }

    public static List<AggregationFunRow> getFunRows() {
        return funRows;
    }

    public static Map<String, AggregationFunRow> getFunRowMap() {
        return funRowMap;
    }

    static {
        log = LogFactory.getLog(AggregationFunHelper.class);
        ClassLoader classLoader = AggregationFunPopForm.class.getClassLoader();
        if (classLoader != null) {
            try (InputStream input = classLoader.getResourceAsStream("prop/AggrFunRows.json");
                 StringWriter writer = new StringWriter();){
                if (null == input) {
                    throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u6307\u5b9a\u8def\u5f84\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                String rowsString = writer.toString();
                funRows = JsonUtil.parseToList((String)rowsString, AggregationFunRow.class);
                funRowMap = Collections.unmodifiableMap(funRows.stream().collect(Collectors.toMap(AggregationFunRow::getNumber, e -> e)));
            }
            catch (Exception e2) {
                log.error("\u521d\u59cb\u5316\u805a\u5408\u51fd\u6570\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)e2.getMessage());
            }
        }
    }
}

