/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.common.util.FunctionUtil;
import kd.bsc.bea.common.util.MerkleTrees;
import kd.bsc.bea.exception.BeaErrorCode;
import org.apache.commons.io.IOUtils;

public class AttachmentHelper {
    public static final String IDENTIFY_ATTACHMENT_PANEL = "bos_attachment";
    public static final String KEY_INTER_ID = "finterid";
    public static final String KEY_FILE_PATH = "ffileid";
    public static final String KEY_ATTACHMENT_NAME = "fattachmentname";
    public static final String KEY_ALIAS_FILE_NAME = "faliasfilename";
    public static final String KEY_EXT_NAME = "fextname";
    public static final String KEY_ATTACHMENT_SIZE = "fattachmentsize";
    public static final String KEY_DESCRIPTION = "fdescription";
    public static final String KEY_CREATETIME = "fcreatetime";
    public static final String KEY_ATTACHMENT_PANEL = "fattachmentpanel";
    private static final Log log = LogFactory.getLog(AttachmentHelper.class);

    public static DynamicObject[] getAttachments(Object billPkId, List<String> panels) {
        QFilter filter = new QFilter(KEY_INTER_ID, "=", (Object)String.valueOf(billPkId));
        QFilter attachmentFilter = new QFilter(KEY_ATTACHMENT_PANEL, "in", panels);
        QFilter[] filters = new QFilter[]{filter.and(attachmentFilter)};
        return BusinessDataServiceHelper.load((String)IDENTIFY_ATTACHMENT_PANEL, (String)AttachmentHelper.getSelectProps(), (QFilter[])filters, (String)KEY_CREATETIME);
    }

    public static List<String> getAttachmentsHashList(String attachEncode, Object billPkId, List<String> panels) {
        LinkedList<String> hashList = new LinkedList<String>();
        DynamicObject[] attachments = AttachmentHelper.getAttachments(billPkId, panels);
        for (int i = 0; i < attachments.length; ++i) {
            String attachmentHash;
            DynamicObject attachment = attachments[i];
            String path = attachment.getString(KEY_FILE_PATH);
            if ("Base16".equals(attachEncode)) {
                attachmentHash = AttachmentHelper.getAttachmentHashBase16(path);
                hashList.add(attachmentHash);
                continue;
            }
            if (!"Base64".equals(attachEncode)) continue;
            attachmentHash = AttachmentHelper.getAttachmentHashBase64(path);
            hashList.add(attachmentHash);
        }
        return hashList;
    }

    public static String getMerkleTreeHash(List<String> list) {
        if (!list.isEmpty()) {
            AttachmentHelper.sortAscending(list);
            MerkleTrees merkleTrees = new MerkleTrees(list);
            merkleTrees.merkleTree();
            return merkleTrees.getRoot();
        }
        return "";
    }

    public static void sortAscending(List<String> list) {
        Collections.sort(list);
    }

    public static InputStream getAttachmentStream(String path) {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        return fs.getInputStream(path);
    }

    public static String getAttachmentHashBase16(String path) {
        byte[] bytes = new byte[]{};
        InputStream is = null;
        try {
            is = AttachmentHelper.getAttachmentStream(path);
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new KDException(BeaErrorCode.UNKNOWN_EXCEPTION, new Object[0]);
        }
        finally {
            if (is != null) {
                AttachmentHelper.safeClose(is);
            }
        }
        return FunctionUtil.sha256Base16((byte[])bytes);
    }

    public static String getAttachmentHashBase64(String path) {
        byte[] bytes = new byte[]{};
        InputStream is = null;
        try {
            is = AttachmentHelper.getAttachmentStream(path);
            bytes = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new KDException(BeaErrorCode.UNKNOWN_EXCEPTION, new Object[0]);
        }
        finally {
            if (is != null) {
                AttachmentHelper.safeClose(is);
            }
        }
        return FunctionUtil.sha256Base64((byte[])bytes);
    }

    private static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error("\u8f93\u5165\u6d41\u5173\u95ed\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            }
        }
    }

    private static String getSelectProps() {
        List<String> args = Arrays.asList(KEY_INTER_ID, KEY_FILE_PATH, KEY_ATTACHMENT_NAME, KEY_ALIAS_FILE_NAME, KEY_EXT_NAME, KEY_ATTACHMENT_SIZE, KEY_ATTACHMENT_PANEL, KEY_DESCRIPTION, KEY_CREATETIME);
        return String.join((CharSequence)",", args);
    }
}

