/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bcc.common.dao.ServiceCenterDao;
import kd.bsc.bcc.common.model.ServiceCenter;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.common.model.Entry;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.exception.BeaErrorCode;
import kd.bsc.bea.model.SchemeInitDataOwnerParam;
import kd.bsc.bea.servicehelper.StcTaskServiceHelper;
import kd.bsc.bea.util.ExceptionUtil;
import kd.bsc.bea.util.ParseSchemaUtil;

public class BeaSchemeHelper {
    private static final Log log = LogFactory.getLog(BeaSchemeHelper.class);
    private static final String NULL_ARRAY = "[]";

    public static void initScheme(String schemeNumber) {
        DynamicObject scheme = BeaSchemeHelper.getScheme(schemeNumber);
        SchemeInitDataOwnerParam dataOwnerParam = BeaSchemeHelper.getDataOwnerParam(scheme);
        Object stcDate = BeaSchemeHelper.getStcDate(scheme);
        DynamicObjectCollection schemeDataTypes = scheme.getDynamicObjectCollection("datatype");
        DynamicObjectCollection schemeMappings = scheme.getDynamicObjectCollection("mapping");
        DynamicObjectCollection schemeTasks = scheme.getDynamicObjectCollection("task");
        if (BeaSchemeHelper.initDataType(dataOwnerParam, schemeDataTypes).booleanValue() && BeaSchemeHelper.initMappings(dataOwnerParam, schemeMappings).booleanValue() && BeaSchemeHelper.initTasks(stcDate, schemeTasks).booleanValue()) {
            DynamicObject saveScheme = BusinessDataServiceHelper.loadSingle((Object)scheme.getPkValue(), (String)"bea_scheme");
            saveScheme.set("status", (Object)"C");
            SaveServiceHelper.update((DynamicObject)saveScheme);
        }
    }

    public static void startTasks(String schemeNumber) {
        DynamicObject scheme = BeaSchemeHelper.getScheme(schemeNumber);
        DynamicObjectCollection schemeTasks = scheme.getDynamicObjectCollection("task");
        List taskNumbers = schemeTasks.stream().map(k -> k.getString("task_no")).collect(Collectors.toList());
        QFilter taskFilter = new QFilter("billno", "in", taskNumbers);
        DynamicObject[] tasks = BusinessDataServiceHelper.load((String)"bea_task", (String)"name", (QFilter[])taskFilter.toArray());
        List taskPkIds = Arrays.stream(tasks).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List pkIds = taskPkIds.stream().map(i -> (Long)i).collect(Collectors.toList());
        List startTaskResults = StcTaskServiceHelper.startTasks(pkIds);
        List errorBillNos = startTaskResults.stream().map(m -> (String)m.get("taskBillNo")).collect(Collectors.toList());
        if (!errorBillNos.isEmpty()) {
            throw new KDBizException(BeaErrorCode.TASK_START_FAIL_EXCEPTION, new Object[]{String.join((CharSequence)",", errorBillNos)});
        }
    }

    private static DynamicObject getScheme(String schemeNumber) {
        QFilter filter = new QFilter("number", "=", (Object)schemeNumber);
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)"bea_scheme", (String)BeaSchemeHelper.getSelectProps(), (QFilter[])filter.toArray());
        if (scheme == null) {
            throw new KDBizException(BeaErrorCode.ERROR_SCHEME_NUMBER_EXCEPTION, new Object[0]);
        }
        return scheme;
    }

    private static String getSelectProps() {
        List<String> args = Arrays.asList("bduid_source", "bduid_type", "service_center", "org_bduid", "user_bduid", "openaccessid", "openaccesstoken", "chainname", "stcdate_source", "stcdate", "stcdate_offset", "datatype.datatype_no", "datatype.datatype_name", "datatype.schema_tag", "mapping.mapping_no", "mapping.mapping_name", "mapping.mapping_datatype_no", "mapping.mapping_bizmodel_no", "mapping.bizappid", "mapping.data_owner_param", "mapping.field_mapping_param", "mapping.stcc_custom_param", "mapping.mapping_entry_tag", "mapping.filter_entry_tag", "task.task_no", "task.task_name", "task.task_type", "task.task_cron", "task.task_stcdate", "task.task_mapping_ids");
        return String.join((CharSequence)",", args);
    }

    private static SchemeInitDataOwnerParam getDataOwnerParam(DynamicObject scheme) {
        String bduIdSource;
        switch (bduIdSource = scheme.getString("bduid_source")) {
            case "default": {
                return BeaSchemeHelper.getDataOwnerParamByDefault();
            }
            case "assign": {
                return BeaSchemeHelper.getDataOwnerParamByAssign(scheme);
            }
            case "mservice": {
                return BeaSchemeHelper.getDataOwnerParamByMservice(scheme);
            }
        }
        log.error("\u5b58\u8bc1\u65b9\u6848-\u65e0\u6cd5\u8bc6\u522b\u7684\u6570\u636e\u6240\u6709\u6743\u6765\u6e90\u53c2\u6570\uff1a{}", (Object)bduIdSource);
        throw new KDBizException(BeaErrorCode.BLOCK_CHAIN_ERROR_EXCEPTION, new Object[0]);
    }

    private static SchemeInitDataOwnerParam getDataOwnerParamByDefault() {
        ServiceCenter serviceCenter = ServiceCenterDao.getDefaultServiceCenter();
        if (null == serviceCenter) {
            throw new KDBizException(BeaErrorCode.NULL_DEFAULT_SERVICE_CENTER_EXCEPTION, new Object[0]);
        }
        return new SchemeInitDataOwnerParam(serviceCenter, "service_center");
    }

    private static SchemeInitDataOwnerParam getDataOwnerParamByAssign(DynamicObject scheme) {
        DynamicObject serviceCenterObj = scheme.getDynamicObject("service_center");
        if (null == serviceCenterObj) {
            throw new KDBizException(BeaErrorCode.NULL_SERVICE_CENTER_EXCEPTION, new Object[0]);
        }
        ServiceCenter serviceCenter = ServiceCenterDao.prepareServiceCenter((DynamicObject)serviceCenterObj);
        String bduIdType = scheme.getString("bduid_type");
        DynamicObject bduIdObj = BeaSchemeHelper.getBduId(bduIdType, scheme);
        if (null == bduIdObj && !bduIdType.equals("service_center")) {
            throw new KDBizException(BeaErrorCode.NULL_BDUID_EXCEPTION, new Object[0]);
        }
        return new SchemeInitDataOwnerParam(serviceCenter, bduIdType, bduIdObj);
    }

    private static SchemeInitDataOwnerParam getDataOwnerParamByMservice(DynamicObject scheme) {
        String openAccessId = scheme.getString("openaccessid");
        String openAccessToken = scheme.getString("openaccesstoken");
        String chainName = scheme.getString("chainname");
        Map serviceCenterMap = (Map)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bcc", (String)"ServiceCenterService", (String)"getServiceCenter", (Object[])new Object[]{openAccessId, openAccessToken, chainName});
        ServiceCenter serviceCenter = (ServiceCenter)JsonUtil.parse((String)JsonUtil.stringify((Object)serviceCenterMap), ServiceCenter.class);
        return new SchemeInitDataOwnerParam(serviceCenter, "service_center");
    }

    private static DynamicObject getBduId(String bduIdType, DynamicObject scheme) {
        switch (bduIdType) {
            case "org": {
                return scheme.getDynamicObject("org_bduid");
            }
            case "user": {
                return scheme.getDynamicObject("user_bduid");
            }
        }
        return null;
    }

    private static Object getStcDate(DynamicObject scheme) {
        String stcDateSource;
        switch (stcDateSource = scheme.getString("stcdate_source")) {
            case "assign": {
                return scheme.get("stcdate");
            }
            case "relative": {
                return BeaSchemeHelper.getRelativeDate(scheme.getString("stcdate_offset"));
            }
        }
        return null;
    }

    private static Object getRelativeDate(String relative) {
        Calendar calendar = Calendar.getInstance();
        switch (relative) {
            case "that_day": {
                calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                break;
            }
            case "that_month": {
                calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
                break;
            }
            case "that_year": {
                calendar.set(calendar.get(1), 0, 1, 0, 0, 0);
                break;
            }
            case "one_recent_month": {
                int month = calendar.get(2) - 1 < 0 ? 11 : calendar.get(2) - 1;
                int year = month == 11 ? calendar.get(1) - 1 : calendar.get(1);
                calendar.set(year, month, calendar.get(5), 0, 0, 0);
                break;
            }
            case "one_recent_year": {
                calendar.set(calendar.get(1) - 1, calendar.get(2), calendar.get(5), 0, 0, 0);
                break;
            }
        }
        return calendar.getTime();
    }

    private static Boolean initDataType(SchemeInitDataOwnerParam param, DynamicObjectCollection schemeDataTypes) {
        List dataTypeNumbers = schemeDataTypes.stream().map(m -> m.getString("datatype_no")).collect(Collectors.toList());
        QFilter existedFilter = new QFilter("number", "in", dataTypeNumbers);
        DynamicObject[] existedDataTypes = BusinessDataServiceHelper.load((String)"bea_datatype", (String)"number,structure_tag", (QFilter[])existedFilter.toArray(), (String)"number DESC");
        List existedNumbers = Arrays.stream(existedDataTypes).map(m -> m.getString("number")).collect(Collectors.toList());
        List newSchemeDataTypes = schemeDataTypes.stream().filter(d -> !existedNumbers.contains(d.getString("datatype_no"))).collect(Collectors.toList());
        ServiceCenter serviceCenter = param.getServiceCenter();
        String clientId = serviceCenter.getClientId();
        String clientSecret = serviceCenter.getClientSecret();
        String chainName = serviceCenter.getChainName();
        String bduId = serviceCenter.getBduid();
        ArrayList<DynamicObject> dataTypeList = new ArrayList<DynamicObject>(10);
        schemeDataTypes.removeAll(newSchemeDataTypes);
        if (!BeaSchemeHelper.judgeSameSchema(existedDataTypes, schemeDataTypes).booleanValue()) {
            throw new KDBizException(BeaErrorCode.CONFLICT_DATA_TYPE_EXCEPTION, new Object[0]);
        }
        for (DynamicObject schemeDataType : newSchemeDataTypes) {
            ChainDataType chainDataType;
            String token;
            String dataTypeNumber = schemeDataType.getString("datatype_no");
            String dateTypeName = schemeDataType.getString("datatype_name");
            String schema = schemeDataType.getString("schema_tag");
            try {
                token = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
                chainDataType = KedasClient.querySchemaByName((String)chainName, (String)token, (String)bduId, (String)dateTypeName);
            }
            catch (KDException e) {
                throw new KDBizException(ExceptionUtil.commonHandleException(e, log), new Object[0]);
            }
            if (chainDataType == null) {
                try {
                    token = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
                    chainDataType = KedasClient.createSchema((String)chainName, (String)token, (String)bduId, (String)bduId, (String)dateTypeName, (String)schema);
                }
                catch (KDException e) {
                    throw new KDBizException(ExceptionUtil.commonHandleException(e, log), new Object[0]);
                }
            }
            dataTypeList.add(BeaSchemeHelper.getDataType(dataTypeNumber, dateTypeName, schema, serviceCenter.getPkId(), chainDataType));
        }
        if (!BeaSchemeHelper.saveDynamicObjects(dataTypeList).booleanValue()) {
            throw new KDBizException(BeaErrorCode.SCHEME_DATA_TYPE_INIT_FAIL_EXCEPTION, new Object[0]);
        }
        return Boolean.TRUE;
    }

    private static Boolean initMappings(SchemeInitDataOwnerParam param, DynamicObjectCollection schemeMappings) {
        List mappingNumbers = schemeMappings.stream().map(m -> m.getString("mapping_no")).collect(Collectors.toList());
        QFilter existedFilter = new QFilter("number", "in", mappingNumbers);
        DynamicObject[] existedMappings = BusinessDataServiceHelper.load((String)"bea_mapping", (String)"number", (QFilter[])existedFilter.toArray());
        List existedNumbers = Arrays.stream(existedMappings).map(m -> m.getString("number")).collect(Collectors.toList());
        List newSchemeMappings = schemeMappings.stream().filter(d -> !existedNumbers.contains(d.getString("mapping_no"))).collect(Collectors.toList());
        Long serviceCenterPkId = param.getServiceCenter().getPkId();
        ArrayList<DynamicObject> mappingList = new ArrayList<DynamicObject>(10);
        for (DynamicObject schemeMapping : newSchemeMappings) {
            DynamicObject mapping = BusinessDataServiceHelper.newDynamicObject((String)"bea_mapping");
            mapping.set("number", schemeMapping.get("mapping_no"));
            mapping.set("name", schemeMapping.get("mapping_name"));
            mapping.set("bizmodel_id", schemeMapping.get("mapping_bizmodel_no"));
            mapping.set("bduid_type", (Object)param.getBduIdType());
            mapping.set("service_center_id", (Object)serviceCenterPkId);
            if ("org".equals(param.getBduIdType())) {
                mapping.set("org_bduid", (Object)param.getBduIdObj());
            }
            if ("user".equals(param.getBduIdType())) {
                mapping.set("user_bduid", (Object)param.getBduIdObj());
            }
            mapping.set("data_owner_param", schemeMapping.get("data_owner_param"));
            mapping.set("field_mapping_param", schemeMapping.get("field_mapping_param"));
            mapping.set("stcc_custom_param", schemeMapping.get("stcc_custom_param"));
            mapping.set("bizappid", schemeMapping.get("bizappid"));
            mapping.set("status", (Object)"C");
            mapping.set("enable", (Object)1);
            mapping.set("creator", (Object)RequestContext.get().getCurrUserId());
            QFilter filter = new QFilter("number", "=", schemeMapping.get("mapping_datatype_no"));
            DynamicObject dataType = BusinessDataServiceHelper.loadSingle((String)"bea_datatype", (String)"*", (QFilter[])filter.toArray());
            mapping.set("datatype_id", dataType.getPkValue());
            String mappingEntryParam = schemeMapping.getString("mapping_entry_tag");
            DynamicObjectCollection mappingEntryCollection = mapping.getDynamicObjectCollection("mapping_entry");
            if (!ObjectUtils.isEmpty((Object)mappingEntryParam) && !NULL_ARRAY.equals(mappingEntryParam)) {
                BeaSchemeHelper.prepareMappingEntry(mappingEntryParam, mappingEntryCollection);
            }
            String filterEntryParam = schemeMapping.getString("filter_entry_tag");
            DynamicObjectCollection filterEntryCollection = mapping.getDynamicObjectCollection("filter_entry");
            if (!ObjectUtils.isEmpty((Object)filterEntryParam) && !NULL_ARRAY.equals(filterEntryParam)) {
                BeaSchemeHelper.prepareFilterEntry(filterEntryParam, filterEntryCollection);
            }
            mappingList.add(mapping);
        }
        if (!BeaSchemeHelper.saveDynamicObjects(mappingList).booleanValue()) {
            throw new KDBizException(BeaErrorCode.SCHEME_MAPPING_INIT_FAIL_EXCEPTION, new Object[0]);
        }
        return Boolean.TRUE;
    }

    private static Boolean initTasks(Object stcDate, DynamicObjectCollection schemeTasks) {
        List taskBillNos = schemeTasks.stream().map(m -> m.getString("task_no")).collect(Collectors.toList());
        QFilter existedFilter = new QFilter("billno", "in", taskBillNos);
        DynamicObject[] existedTasks = BusinessDataServiceHelper.load((String)"bea_task", (String)"billno", (QFilter[])existedFilter.toArray());
        List existedBillNos = Arrays.stream(existedTasks).map(m -> m.getString("billno")).collect(Collectors.toList());
        List newSchemeTasks = schemeTasks.stream().filter(d -> !existedBillNos.contains(d.getString("task_no"))).collect(Collectors.toList());
        ArrayList<DynamicObject> taskList = new ArrayList<DynamicObject>(10);
        for (DynamicObject schemeTask : newSchemeTasks) {
            DynamicObject task = BusinessDataServiceHelper.newDynamicObject((String)"bea_task");
            task.set("type", schemeTask.get("task_type"));
            task.set("billno", schemeTask.get("task_no"));
            task.set("name", schemeTask.get("task_name"));
            task.set("cron", schemeTask.get("task_cron"));
            task.set("billstatus", (Object)"A");
            task.set("creator", (Object)RequestContext.get().getCurrUserId());
            if (null != stcDate) {
                task.set("stcdate", stcDate);
            } else {
                task.set("stcdate", schemeTask.get("task_stcdate"));
            }
            String mappingId = schemeTask.getString("task_mapping_ids");
            String[] mappingIds = mappingId.split(",");
            QFilter filter = new QFilter("number", "in", (Object)mappingIds);
            DynamicObject[] mappings = BusinessDataServiceHelper.load((String)"bea_mapping", (String)"*", (QFilter[])filter.toArray());
            DynamicObjectCollection mappingCollection = task.getDynamicObjectCollection("mappings");
            DynamicObjectType dynamicObjectType = mappingCollection.getDynamicObjectType();
            BasedataProp basedataProp = (BasedataProp)dynamicObjectType.getProperties().get((Object)"fbasedataid");
            for (DynamicObject mapping : mappings) {
                DynamicObject newMapping = new DynamicObject(dynamicObjectType);
                mappingCollection.add((Object)newMapping);
                basedataProp.setValue((Object)newMapping, (Object)mapping);
            }
            taskList.add(task);
        }
        if (!BeaSchemeHelper.saveDynamicObjects(taskList).booleanValue()) {
            throw new KDBizException(BeaErrorCode.SCHEME_TASK_INIT_FAIL_EXCEPTION, new Object[0]);
        }
        return Boolean.TRUE;
    }

    private static Boolean judgeSameSchema(DynamicObject[] existedDataTypes, DynamicObjectCollection schemeDataTypes) {
        schemeDataTypes.sort(Comparator.comparing(o -> o.getString("datatype_no"), Comparator.reverseOrder()));
        for (int i = 0; i < existedDataTypes.length; ++i) {
            String existedNumber = existedDataTypes[i].getString("number");
            String schemeNumber = ((DynamicObject)schemeDataTypes.get(i)).getString("datatype_no");
            String existedSchema = existedDataTypes[i].getString("structure_tag");
            String schemeSchema = ((DynamicObject)schemeDataTypes.get(i)).getString("schema_tag");
            if (!existedNumber.equals(schemeNumber) || existedSchema.equals(schemeSchema)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean saveDynamicObjects(List<DynamicObject> dynamicObjects) {
        DynamicObject[] saveObjects;
        Object[] saveResult;
        if (dynamicObjects.size() > 0 && (saveResult = SaveServiceHelper.save((DynamicObject[])(saveObjects = dynamicObjects.toArray(new DynamicObject[0])))).length != dynamicObjects.size()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static DynamicObject getDataType(String dataTypeNumber, String dateTypeName, String schema, Long serviceCenterPkId, ChainDataType chainDataType) {
        DynamicObject dataType = BusinessDataServiceHelper.newDynamicObject((String)"bea_datatype");
        dataType.set("number", (Object)dataTypeNumber);
        dataType.set("name", (Object)dateTypeName);
        dataType.set("structure_tag", (Object)schema);
        dataType.set("service_center_id", (Object)serviceCenterPkId);
        dataType.set("datatypeid", (Object)chainDataType.getSchemaId());
        dataType.set("datatypestatus", (Object)"associated");
        dataType.set("status", (Object)"C");
        dataType.set("enable", (Object)"1");
        dataType.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObjectCollection entryEntities = dataType.getDynamicObjectCollection("entryentity");
        List<Entry> entries = ParseSchemaUtil.parseJsonSchema(schema);
        for (Entry entry : entries) {
            DynamicObject entryEntity = entryEntities.addNew();
            entryEntity.set("entryname", (Object)entry.getName());
            entryEntity.set("entryrequired", (Object)entry.getRequired());
            entryEntity.set("entrytype", (Object)entry.getType());
            entryEntity.set("entrydesc", (Object)entry.getDescription());
        }
        return dataType;
    }

    private static void prepareMappingEntry(String mappingEntryParam, DynamicObjectCollection mappingEntryCollection) {
        List mappingEntryList = JsonUtil.parseToList((String)mappingEntryParam, MappingEntry.class);
        for (MappingEntry mappingEntry : mappingEntryList) {
            DynamicObject entry = mappingEntryCollection.addNew();
            entry.set("datatype_name", (Object)mappingEntry.getDataTypeName());
            entry.set("datatype_type", (Object)mappingEntry.getDataTypeType());
            entry.set("datatype_desc", (Object)mappingEntry.getDataTypeDesc());
            entry.set("required_flag", (Object)mappingEntry.getRequired());
            entry.set("fixed_value", (Object)mappingEntry.getFixedValue());
            entry.set("bizname", (Object)mappingEntry.getBizName());
            entry.set("biztype", (Object)mappingEntry.getBizType());
            entry.set("bizdesc", (Object)mappingEntry.getBizDesc());
            entry.set("aggr_fun", (Object)mappingEntry.getAggFunc());
            entry.set("aggr_fun_param", (Object)mappingEntry.getAggFuncParam());
            entry.set("conv_rule", (Object)mappingEntry.getConvRule());
        }
    }

    private static void prepareFilterEntry(String filterEntryParam, DynamicObjectCollection filterEntryCollection) {
        List filterEntryList = JsonUtil.parseToList((String)filterEntryParam, FilterEntry.class);
        for (FilterEntry filterEntry : filterEntryList) {
            DynamicObject entry = filterEntryCollection.addNew();
            entry.set("left_bracket", (Object)filterEntry.getLeftBracketValue());
            entry.set("filter_name", (Object)filterEntry.getFilterName());
            entry.set("filter_desc", (Object)filterEntry.getFilterDesc());
            entry.set("option", (Object)filterEntry.getOption());
            entry.set("ref_var", (Object)filterEntry.getRefVar());
            entry.set("const", (Object)filterEntry.getConstVar());
            entry.set("right_bracket", (Object)filterEntry.getRightBracketValue());
            entry.set("link_symbol", (Object)filterEntry.getLogicalSymbol());
        }
    }
}

