/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.FilterEntryVerifyDepend;
import kd.bsc.bea.common.model.Mapping;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.model.MappingEntryVerifyDepend;
import kd.bsc.bea.common.util.MetaDataUtils;
import kd.bsc.bea.dao.MappingBizDataQueryHelper;
import kd.bsc.bea.util.MappingUtil;
import kd.bsc.bea.verifier.FilterEntryVerifierExecutors;
import kd.bsc.bea.verifier.MappingEntryVerifierExecutors;
import kd.bsc.bea.verifier.MappingMainVerifyExecutor;
import kd.bsc.bea.verifier.Prompt;

public class BizMappingHelper {
    private static final Log log = LogFactory.getLog(MappingBizDataQueryHelper.class);
    private static final String MAPPING_QUERY_CALLBACK_PREFIX = "mapping_query";
    private static final Set<String> UNSELECTED_DATATYPE_FIELD_TYPE = Stream.of("object", "object[]").collect(Collectors.toSet());

    private BizMappingHelper() {
        throw new IllegalStateException("util static class cannot be init");
    }

    public static void openBizModelList(IFormView view, IFormPlugin plugin, String number, QFilter[] filters) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(number);
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u5217\u8868", (String)"BizMappingHelper_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        ListFilterParameter filterParameter = new ListFilterParameter();
        if (null != filters) {
            filterParameter.setQFilters(Arrays.asList(filters));
        }
        listShowParameter.setListFilterParameter(filterParameter);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1230");
        styleCss.setHeight("690");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack(plugin, MAPPING_QUERY_CALLBACK_PREFIX + number));
        view.showForm((FormShowParameter)listShowParameter);
    }

    public static void openModelEditWindow(IFormView view, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bea_mapping_pop");
        showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u4e1a\u52a1\u5173\u8054", (String)"BizMappingHelper_1", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "bea_mapping_pop_close"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    private static void openAddWindow(IFormView view, IFormPlugin plugin, Map<String, Object> initData) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("bea_mapping");
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5173\u8054", (String)"BizMappingHelper_2", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCustomParams(initData);
        billShowParameter.setCloseCallBack(new CloseCallBack(plugin, "bea_mapping"));
        view.showForm((FormShowParameter)billShowParameter);
    }

    public static void mappingPopCloseCallBack(IFormView view, IFormPlugin plugin, String actionId, Object returnData) {
        if (null != returnData && StringUtils.equals((CharSequence)actionId, (CharSequence)"bea_mapping_pop_close")) {
            HashMap returnDataMap = (HashMap)returnData;
            BizMappingHelper.openAddWindow(view, plugin, returnDataMap);
        }
    }

    public static List<Prompt> checkMappingAndTransform(Mapping mapping) {
        List<Prompt> preCheck = BizMappingHelper.checkMapping(mapping);
        if (preCheck.isEmpty() && StringUtils.isBlank((CharSequence)mapping.getStcConditionCustomParam()) && StringUtils.isBlank((CharSequence)mapping.getFieldMappingCustomParam())) {
            Prompt dataCheck = BizMappingHelper.checkBizDataTransform(mapping);
            return null == dataCheck ? Collections.emptyList() : Collections.singletonList(dataCheck);
        }
        return preCheck;
    }

    public static List<Prompt> checkMapping(Mapping mapping) {
        return Stream.of(BizMappingHelper.checkMappingMain(mapping), BizMappingHelper.checkFilterEntries(mapping.getBizModel(), mapping.getFilterEntries()), BizMappingHelper.checkMappingEntries(mapping.getBizModel(), mapping.getMappingEntries())).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<Prompt> checkMappingMain(Mapping mapping) {
        return MappingMainVerifyExecutor.execute(mapping);
    }

    private static List<Prompt> checkFilterEntries(String entityNumber, List<FilterEntry> filterEntries) {
        Map<String, BizModelField> bizModelFieldMap = BizMappingHelper.getBizModelFieldMap(entityNumber, 0);
        FilterEntryVerifyDepend filterEntryVerifyDepend = new FilterEntryVerifyDepend(bizModelFieldMap, filterEntries.size());
        List<Prompt> filterEntryVerifyResult = FilterEntryVerifierExecutors.execute(filterEntries, filterEntryVerifyDepend);
        List<Prompt> filterEntriesVerifyResult = FilterEntryVerifierExecutors.execute(filterEntries, filterEntryVerifyDepend);
        filterEntryVerifyResult.addAll(filterEntriesVerifyResult);
        return filterEntryVerifyResult;
    }

    private static List<Prompt> checkMappingEntries(String entityNumber, List<MappingEntry> mappingEntries) {
        Map<String, BizModelField> bizModelFieldMap = BizMappingHelper.getBizModelFieldMap(entityNumber, 1);
        Map<String, MappingEntry> mappingEntryMap = mappingEntries.stream().collect(Collectors.toMap(MappingEntry::getDataTypeName, m -> m));
        MappingEntryVerifyDepend mappingEntryVerifyDepend = new MappingEntryVerifyDepend(bizModelFieldMap, mappingEntryMap);
        List<Prompt> mappingEntryCheckResult = MappingEntryVerifierExecutors.execute(mappingEntries, mappingEntryVerifyDepend);
        List<Prompt> mappingEntriesCheckResult = MappingEntryVerifierExecutors.execute(mappingEntries, mappingEntryVerifyDepend);
        mappingEntryCheckResult.addAll(mappingEntriesCheckResult);
        return mappingEntryCheckResult;
    }

    private static Prompt checkBizDataTransform(Mapping mapping) {
        DynamicObject[] objCol = MappingBizDataQueryHelper.queryByMapping(Boolean.FALSE, mapping, null);
        if (objCol.length == 0) {
            return Prompt.error(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u4e1a\u52a1\u5bf9\u8c61\u6ca1\u6709\u6570\u636e\uff0c\u53ef\u4ee5\u63d2\u5165\u4e00\u6761\u6570\u636e\u7528\u4e8e\u6821\u9a8c\u6570\u636e\u7ed3\u6784", (String)"BizMappingHelper_3", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        }
        DynamicObject obj = objCol[0];
        LinkedHashMap<String, MappingEntry> map = new LinkedHashMap<String, MappingEntry>(16);
        mapping.getMappingEntries().forEach(mappingEntry -> map.put(mappingEntry.getDataTypeName(), (MappingEntry)mappingEntry));
        try {
            MappingUtil.parseMappingEntry(map, obj, mapping);
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u6309\u94ae\uff1a\u8f6c\u5316\u4e0a\u94fe\u5bf9\u8c61\u5931\u8d25, error msg:{}", (Object)ExceptionMessageProviderFactory.getProvider().getMessage(e));
            return Prompt.interruptError(ResManager.loadKDString((String)"\u8f6c\u6362\u6570\u636e\u7ed3\u6784\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u5b57\u6bb5\u6620\u5c04\u8bbe\u7f6e", (String)"BizMappingHelper_4", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        }
        return null;
    }

    public static List<BizModelField> getBizModelAttachmentPanels(String entityNumber) {
        String id = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List items = formMetadata.getItems();
        return items.stream().filter(i -> i instanceof AttachmentPanelAp).map(i -> (AttachmentPanelAp)i).map(i -> new BizModelField(i.getKey(), "attachmentPanel", i.getName().toString())).collect(Collectors.toList());
    }

    public static Map<String, BizModelField> getBizModelFieldMap(String entityNumber, int maxEntryLevel) {
        return BizMappingHelper.getBizModelFields(entityNumber, maxEntryLevel).stream().collect(Collectors.toMap(BizModelField::getFieldName, e -> e));
    }

    public static List<BizModelField> getBizModelFields(String entityNumber, int maxEntryLevel) {
        List filterFields = MetaDataUtils.getFilterFields((String)entityNumber);
        Stream<BizModelField> stream = filterFields.stream().map(e -> BizMappingHelper.constructBizModelField(entityNumber, e));
        return stream.filter(f -> f.getEntryLevel() <= maxEntryLevel).collect(Collectors.toList());
    }

    public static Map<BizModelField, FilterField> getFilterFieldMap(String entityNumber) {
        List filterFields = MetaDataUtils.getFilterFields((String)entityNumber);
        return filterFields.stream().collect(Collectors.toMap(f -> BizMappingHelper.constructBizModelField(entityNumber, f), f -> f));
    }

    private static BizModelField constructBizModelField(String mainEntityNumber, FilterField filterField) {
        Integer fieldType = filterField.getFieldType();
        String type = filterField.getFilterControlType();
        String fieldCaption = filterField.getFullFieldCaption();
        String entryEntity = filterField.getEntityKey();
        boolean entryField = !StringUtils.equals((CharSequence)filterField.getFieldName(), (CharSequence)filterField.getFullFieldName());
        String fieldName = filterField.getFullFieldName();
        if (entryField) {
            String[] nameElements;
            List fullNameElements = Stream.of(filterField.getFullFieldName().split("\\.")).collect(Collectors.toList());
            for (String name : nameElements = filterField.getFieldName().split("\\.")) {
                fullNameElements.remove(name);
            }
            Iterator iterator = fullNameElements.stream().distinct().iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                fieldName = fieldName.replaceAll(name, name + "[ ]");
            }
        }
        String temp = fieldName.replace("[ ]", "");
        int entryLevel = (fieldName.length() - temp.length()) / 2;
        return new BizModelField(fieldName, type, fieldCaption, fieldType, mainEntityNumber, entryEntity, entryLevel);
    }

    public static Mapping dynamicObjectToMapping(DynamicObject obj) {
        String bizModelNumber = obj.getString("bizmodel_id");
        String bduIdType = obj.getString("bduid_type");
        String stcConditionCustomParam = obj.getString("stcc_custom_param");
        String fieldMappingCustomParam = obj.getString("field_mapping_param");
        DynamicObject org = obj.getDynamicObject("org_bduid");
        DynamicObject user = obj.getDynamicObject("user_bduid");
        DynamicObject serviceCenter = obj.getDynamicObject("service_center");
        DynamicObject dataType = obj.getDynamicObject("datatype");
        DynamicObjectCollection mappingEntryCol = obj.getDynamicObjectCollection("mapping_entry");
        DynamicObjectCollection filterEntryCol = obj.getDynamicObjectCollection("filter_entry");
        Mapping mapping = new Mapping();
        mapping.setBizModel(bizModelNumber);
        mapping.setDataType(dataType);
        mapping.setBduIdType(bduIdType);
        mapping.setOrg(org);
        mapping.setUser(user);
        mapping.setServiceCenter(serviceCenter);
        mapping.setStcConditionCustomParam(stcConditionCustomParam);
        mapping.setFieldMappingCustomParam(fieldMappingCustomParam);
        mapping.setMappingEntries(BizMappingHelper.objColToMappingEntry(mappingEntryCol));
        mapping.setFilterEntries(BizMappingHelper.objColToFilterEntry(filterEntryCol));
        return mapping;
    }

    public static Mapping pageModelToMapping(IDataModel model) {
        String bduIdType = (String)model.getValue("bduid_type");
        DynamicObject org = (DynamicObject)model.getValue("org_bduid");
        DynamicObject user = (DynamicObject)model.getValue("user_bduid");
        DynamicObject serviceCenter = (DynamicObject)model.getValue("service_center");
        String stcConditionCustomParam = (String)model.getValue("stcc_custom_param");
        String fieldMappingCustomParam = (String)model.getValue("field_mapping_param");
        DynamicObject dataType = (DynamicObject)model.getValue("datatype");
        DynamicObjectCollection mappingEntryCol = model.getEntryEntity("mapping_entry");
        DynamicObjectCollection filterEntryCol = model.getEntryEntity("filter_entry");
        Mapping mapping = new Mapping();
        mapping.setBizModel(BizMappingHelper.getBizModelNumber(model));
        mapping.setBduIdType(bduIdType);
        mapping.setOrg(org);
        mapping.setUser(user);
        mapping.setDataType(dataType);
        mapping.setServiceCenter(serviceCenter);
        mapping.setStcConditionCustomParam(stcConditionCustomParam);
        mapping.setFieldMappingCustomParam(fieldMappingCustomParam);
        mapping.setMappingEntries(BizMappingHelper.objColToMappingEntry(mappingEntryCol));
        mapping.setFilterEntries(BizMappingHelper.objColToFilterEntry(filterEntryCol));
        return mapping;
    }

    public static List<MappingEntry> objColToMappingEntry(DynamicObjectCollection mappingEntryCol) {
        ArrayList<MappingEntry> mappingEntries = new ArrayList<MappingEntry>(40);
        for (int i = 0; i < mappingEntryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)mappingEntryCol.get(i);
            MappingEntry mappingEntry = new MappingEntry();
            mappingEntry.setDataTypeName(entry.getString("datatype_name"));
            mappingEntry.setDataTypeType(entry.getString("datatype_type"));
            mappingEntry.setDataTypeDesc(entry.getString("datatype_desc"));
            mappingEntry.setBizName(entry.getString("bizname"));
            mappingEntry.setBizType(entry.getString("biztype"));
            mappingEntry.setBizDesc(entry.getString("bizdesc"));
            mappingEntry.setRequired(Boolean.valueOf(entry.getBoolean("required_flag")));
            mappingEntry.setFixedValue(entry.getString("fixed_value"));
            mappingEntry.setAggFunc(entry.getString("aggr_fun"));
            mappingEntry.setAggFuncParam(entry.getString("aggr_fun_param"));
            mappingEntry.setConvRule(entry.getString("conv_rule"));
            mappingEntry.setSeqNum(Integer.valueOf(i));
            mappingEntries.add(mappingEntry);
        }
        return mappingEntries;
    }

    public static List<FilterEntry> objColToFilterEntry(DynamicObjectCollection filterEntryCol) {
        ArrayList<FilterEntry> filterEntries = new ArrayList<FilterEntry>(10);
        for (int i = 0; i < filterEntryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)filterEntryCol.get(i);
            String leftBracket = entry.getString("left_bracket");
            String rightBracket = entry.getString("right_bracket");
            String logicalSymbol = entry.getString("link_symbol");
            String filterName = entry.getString("filter_name");
            String filterDesc = entry.getString("filter_desc");
            String option = entry.getString("option");
            String constVar = entry.getString("const");
            String refVar = entry.getString("ref_var");
            filterEntries.add(new FilterEntry(Integer.valueOf(i), leftBracket, rightBracket, filterName, filterDesc, option, logicalSymbol, refVar, constVar));
        }
        return filterEntries;
    }

    public static String getBizModelNumber(IDataModel model) {
        MainEntityType mainType = model.getDataEntityType();
        BasedataProp basedataProp = (BasedataProp)mainType.findProperty("bizmodel");
        DynamicObject billObj = model.getDataEntity();
        return (String)basedataProp.getRefIdProp().getValue((Object)billObj);
    }

    public static boolean isCreateMappingEnable(String dataTypeFieldType) {
        return !UNSELECTED_DATATYPE_FIELD_TYPE.contains(dataTypeFieldType.replace(" ", ""));
    }

    public static List<String> getBizFieldEntryNames(MappingEntry entry) {
        return Stream.of(entry.getBizName().split(",")).map(f -> f.split("\\.")).flatMap(Stream::of).filter(s -> s.contains("[") && s.contains("]")).collect(Collectors.toList());
    }
}

