/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.helper;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bsc.bea.common.model.ConvRuleRow;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.converter.DataConverter;
import kd.bsc.bea.plugin.AggregationFunPopForm;
import org.apache.commons.io.IOUtils;

public class ConvRuleHelper {
    private static final Log log = LogFactory.getLog(ConvRuleHelper.class);
    private static List<ConvRuleRow> rows;
    private static Map<String, ConvRuleRow> rowDict;
    private static Map<String, DataConverter<Object, Object>> converterDict;

    private ConvRuleHelper() {
    }

    public static List<ConvRuleRow> getRows() {
        return rows;
    }

    public static Map<String, ConvRuleRow> getRowDict() {
        return rowDict;
    }

    public static Map<String, DataConverter<Object, Object>> getConverterDict() {
        return converterDict;
    }

    public static DataConverter<Object, Object> initConverterClass(String className) {
        return (DataConverter)TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        ClassLoader classLoader = AggregationFunPopForm.class.getClassLoader();
        if (classLoader != null) {
            try (InputStream input = classLoader.getResourceAsStream("prop/ConvRuleRows.json");
                 StringWriter writer = new StringWriter();){
                if (null == input) {
                    throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef\uff0c\u6307\u5b9a\u8def\u5f84\u7684\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
                IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                String rowsString = writer.toString();
                rows = Collections.unmodifiableList(JsonUtil.parseToList((String)rowsString, ConvRuleRow.class));
                rowDict = Collections.unmodifiableMap(rows.stream().collect(Collectors.toMap(ConvRuleRow::getNumber, e -> e)));
                converterDict = Collections.unmodifiableMap(rows.stream().collect(Collectors.toMap(ConvRuleRow::getNumber, e -> ConvRuleHelper.initConverterClass(e.getConverterClassName()))));
            }
            catch (Exception e2) {
                log.error("\u521d\u59cb\u5316\u8f6c\u6362\u89c4\u5219\u5217\u8868\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)e2.getMessage());
            }
        }
    }
}

