/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bsc.bea.common.model.AggregationFunRow;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.helper.AggregationFunHelper;

public class AggregationFunPopForm
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.deleteEntryData("field_list");
        int[] rowIndex = model.batchCreateNewEntryRow("field_list", AggregationFunHelper.getFunRows().size());
        for (int i = 0; i < rowIndex.length; ++i) {
            int index = rowIndex[i];
            AggregationFunRow row = AggregationFunHelper.getFunRows().get(i);
            model.setValue("number", (Object)row.getNumber(), index);
            model.setValue("name", (Object)row.getName(), index);
            model.setValue("desc", (Object)row.getDesc(), index);
            model.setValue("param_desc", (Object)row.getParamDesc(), index);
            model.setValue("param_example", (Object)row.getParamExample(), index);
            model.setValue("param_json_schema", (Object)row.getParamJsonSchema(), index);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.okClickCallBack();
                break;
            }
            case "btncancel": {
                this.cancelClickCallBack();
                break;
            }
        }
    }

    private void okClickCallBack() {
        EntryGrid fieldEntries = (EntryGrid)this.getView().getControl("field_list");
        int[] selectRowNumbers = fieldEntries.getSelectRows();
        if (1 == selectRowNumbers.length) {
            int selectRowNumber = selectRowNumbers[0];
            DynamicObject entryRow = this.getModel().getEntryRowEntity("field_list", selectRowNumber);
            AggregationFunRow funRow = new AggregationFunRow(entryRow.getString("number"), entryRow.getString("name"), entryRow.getString("desc"), entryRow.getString("param_desc"), entryRow.getString("param_example"), entryRow.getString("param_json_schema"));
            String funRowJson = JsonUtil.stringify((Object)funRow);
            Map parentParam = this.getView().getFormShowParameter().getCustomParams();
            parentParam.put("field_list", funRowJson);
            this.getView().returnDataToParent((Object)parentParam);
            this.getView().close();
        } else {
            Map parentParam = this.getView().getFormShowParameter().getCustomParams();
            parentParam.put("field_list", JsonUtil.stringify((Object)AggregationFunRow.EMPTY));
            this.getView().returnDataToParent((Object)parentParam);
            this.getView().close();
        }
    }

    private void cancelClickCallBack() {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }
}

