/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.helper.AggregationFunHelper;
import kd.bsc.bea.helper.ConvRuleHelper;

public class BeaMappingPreviewPopForm
extends AbstractFormPlugin {
    private static final String NULL_ARRAY = "[]";

    public void beforeBindData(EventObject e) {
        String filterEntry;
        super.beforeBindData(e);
        this.initAggrFunComboValue();
        this.initConvRuleComboValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map params = formShowParameter.getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("mapping_no", params.get("mapping_no"));
        model.setValue("mapping_name", params.get("mapping_name"));
        model.setValue("datatype", params.get("mapping_datatype_name"));
        model.setValue("bizmodel", params.get("mapping_bizmodel_name"));
        model.setValue("data_owner_param", params.get("data_owner_param"));
        model.setValue("field_mapping_param", params.get("field_mapping_param"));
        model.setValue("stcc_custom_param", params.get("stcc_custom_param"));
        String mappingEntry = (String)params.get("mapping_entry");
        if (!ObjectUtils.isEmpty((Object)mappingEntry) && !NULL_ARRAY.equals(mappingEntry)) {
            this.prepareMappingEntry(mappingEntry, model);
        }
        if (!ObjectUtils.isEmpty((Object)(filterEntry = (String)params.get("filter_entry"))) && !NULL_ARRAY.equals(filterEntry)) {
            this.prepareFilterEntry(filterEntry, model);
        }
    }

    private void prepareMappingEntry(String param, IDataModel model) {
        List mappingEntries = JsonUtil.parseToList((String)param, MappingEntry.class);
        model.deleteEntryData("mapping_entry");
        int[] rowIndex = model.batchCreateNewEntryRow("mapping_entry", mappingEntries.size());
        mappingEntries.sort(Comparator.comparing(MappingEntry::getSeqNum));
        for (int index : rowIndex) {
            MappingEntry mappingEntry = (MappingEntry)mappingEntries.get(index);
            model.setValue("datatype_name", (Object)mappingEntry.getDataTypeName(), index);
            model.setValue("datatype_type", (Object)mappingEntry.getDataTypeType(), index);
            model.setValue("datatype_desc", (Object)mappingEntry.getDataTypeDesc(), index);
            model.setValue("required_flag", (Object)mappingEntry.getRequired(), index);
            model.setValue("fixed_value", (Object)mappingEntry.getFixedValue(), index);
            model.setValue("bizname", (Object)mappingEntry.getBizName(), index);
            model.setValue("biztype", (Object)mappingEntry.getBizType(), index);
            model.setValue("bizdesc", (Object)mappingEntry.getBizDesc(), index);
            model.setValue("aggr_fun", (Object)mappingEntry.getAggFunc(), index);
            model.setValue("aggr_fun_param", (Object)mappingEntry.getAggFuncParam(), index);
            model.setValue("conv_rule", (Object)mappingEntry.getConvRule(), index);
        }
    }

    private void prepareFilterEntry(String param, IDataModel model) {
        List filterEntries = JsonUtil.parseToList((String)param, FilterEntry.class);
        model.deleteEntryData("filter_entry");
        int[] rowIndex = model.batchCreateNewEntryRow("filter_entry", filterEntries.size());
        filterEntries.sort(Comparator.comparing(FilterEntry::getSeqNum));
        for (int index : rowIndex) {
            FilterEntry filterEntry = (FilterEntry)filterEntries.get(index);
            model.setValue("left_bracket", (Object)filterEntry.getLeftBracketValue(), index);
            model.setValue("filter_name", (Object)filterEntry.getFilterName(), index);
            model.setValue("filter_desc", (Object)filterEntry.getFilterDesc(), index);
            model.setValue("option", (Object)filterEntry.getOption(), index);
            model.setValue("ref_var", (Object)filterEntry.getRefVar(), index);
            model.setValue("const", (Object)filterEntry.getConstVar(), index);
            model.setValue("right_bracket", (Object)filterEntry.getRightBracketValue(), index);
            model.setValue("link_symbol", (Object)filterEntry.getLogicalSymbol(), index);
        }
    }

    private void initAggrFunComboValue() {
        List items = AggregationFunHelper.getFunRows().stream().map(r -> new ComboItem(new LocaleString(r.getName()), r.getNumber())).collect(Collectors.toList());
        ComboEdit aggrFunControl = (ComboEdit)this.getControl("aggr_fun");
        aggrFunControl.setComboItems(items);
    }

    private void initConvRuleComboValue() {
        List items = ConvRuleHelper.getRows().stream().map(r -> new ComboItem(new LocaleString(r.getName()), r.getNumber())).collect(Collectors.toList());
        ComboEdit convRuleControl = (ComboEdit)this.getControl("conv_rule");
        convRuleControl.setComboItems(items);
    }
}

