/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bea.common.model.AggregationFunRow;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.ConvRuleRow;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.Mapping;
import kd.bsc.bea.common.model.MserviceParamProp;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.common.util.MetaDataUtils;
import kd.bsc.bea.dao.MappingBizDataQueryHelper;
import kd.bsc.bea.helper.AggregationFunHelper;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.helper.ConvRuleHelper;
import kd.bsc.bea.verifier.Prompt;

public class BizMappingEdit
extends AbstractBillPlugIn
implements IDataModelChangeListener,
CellClickListener {
    private static final String KEY_DOUBLE_CLICK_FIELD = "$double_click_field";
    private static final String KEY_DOUBLE_CLICK_ROW = "$double_click_row";
    private static final Set<String> BIZ_FILED_POP_ENABLE_CLICK_MAPPING_ENTRY_FIELDS = Stream.of("bizname", "biztype", "bizdesc").collect(Collectors.toSet());
    private static final Set<String> BIZ_FILED_POP_ENABLE_CLICK_FILTER_ENTRY_FIELDS = Stream.of("filter_name", "filter_desc", "ref_var").collect(Collectors.toSet());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"stcc_custom_param"});
        this.addClickListeners(new String[]{"data_owner_param"});
        this.addClickListeners(new String[]{"field_mapping_param"});
        EntryGrid mappingEntries = (EntryGrid)this.getView().getControl("mapping_entry");
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl("filter_entry");
        mappingEntries.addCellClickListener((CellClickListener)this);
        filterEntries.addCellClickListener((CellClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                if (!this.checkEditable(args)) {
                    return;
                }
                if (!this.checkParamAndShowTip(args, false)) break;
                this.setStatusToAudited();
                break;
            }
            case "mapping_query": {
                this.checkParamForMappingQuery(args);
                break;
            }
            case "new": {
                args.setCancel(true);
                BizMappingHelper.openModelEditWindow(this.getView(), (IFormPlugin)this);
                break;
            }
        }
    }

    private boolean checkEditable(BeforeDoOperationEventArgs args) {
        String refrenced = this.getPageCache().get("is_refrenced");
        if (Boolean.parseBoolean(refrenced)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5173\u8054\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BizMappingEdit_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean checkParamAndShowTip(BeforeDoOperationEventArgs args, boolean showSuccessTip) {
        Mapping mapping = BizMappingHelper.pageModelToMapping(this.getModel());
        List<Prompt> paramCheckResults = BizMappingHelper.checkMappingAndTransform(mapping);
        if (!paramCheckResults.isEmpty()) {
            Prompt prompt = paramCheckResults.get(0);
            this.getView().showTipNotification(prompt.getMessage());
            if (prompt.isNeedInterrupt()) {
                if (null != args) {
                    args.setCancel(true);
                }
                return false;
            }
            return true;
        }
        if (showSuccessTip) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u6210\u529f\u3002", (String)"BizMappingEdit_1", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean checkParamForMappingQuery(BeforeDoOperationEventArgs args) {
        Mapping mapping = BizMappingHelper.pageModelToMapping(this.getModel());
        List<Prompt> paramCheckResults = BizMappingHelper.checkMapping(mapping);
        if (!paramCheckResults.isEmpty()) {
            Prompt prompt = paramCheckResults.get(0);
            this.getView().showTipNotification(prompt.getMessage());
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private void mappingQuery() {
        String bizModelNumber = MetaDataUtils.getBaseDataNumber((IDataModel)this.getModel(), (String)"bizmodel");
        DynamicObjectCollection filterEntryCol = this.getModel().getEntryEntity("filter_entry");
        List<FilterEntry> filterEntries = BizMappingHelper.objColToFilterEntry(filterEntryCol);
        QFilter filter = MappingBizDataQueryHelper.constructQFilter(filterEntries, null, BizMappingHelper.getBizModelFieldMap(bizModelNumber, 0));
        BizMappingHelper.openBizModelList(this.getView(), (IFormPlugin)this, bizModelNumber, null == filter ? null : filter.toArray());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "save": {
                this.updateDataTypeStatus(this.getDataTypeId());
                break;
            }
            case "check": {
                this.checkParamAndShowTip(null, true);
                break;
            }
            case "mapping_query": {
                this.mappingQuery();
                break;
            }
        }
    }

    private void fillWithDataTypeToMappingEntry() {
        IDataModel model = this.getModel();
        DynamicObject dataType = (DynamicObject)this.getModel().getValue("datatype");
        if (dataType != null) {
            model.deleteEntryData("mapping_entry");
            DynamicObjectCollection dataTypeEntries = dataType.getDynamicObjectCollection("entryentity");
            int[] rowIndex = model.batchCreateNewEntryRow("mapping_entry", dataTypeEntries.size());
            for (int i = 0; i < rowIndex.length; ++i) {
                int index = rowIndex[i];
                DynamicObject dataTypeEntry = (DynamicObject)dataTypeEntries.get(i);
                model.setValue("datatype_name", (Object)dataTypeEntry.getString("entryname"), index);
                model.setValue("datatype_desc", (Object)dataTypeEntry.getString("entrydesc"), index);
                model.setValue("required_flag", (Object)dataTypeEntry.getString("entryrequired"), index);
                String fieldType = dataTypeEntry.getString("entrytype");
                model.setValue("datatype_type", (Object)fieldType, index);
                if (BizMappingHelper.isCreateMappingEnable(fieldType)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"fixed_value"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"aggr_fun_param"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"conv_rule"});
            }
        }
    }

    private void fillWithHiddenFields(String number) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)number);
        this.getModel().setValue("bizappid", (Object)appId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "bizname": {
                this.bizNameChangedCallBack();
                break;
            }
            case "fixed_value": {
                this.fixedValueChangedCallBack();
                break;
            }
            case "ref_var": {
                this.refVarChangedCallBack();
                break;
            }
            case "const": {
                this.constChangedCallBack();
                break;
            }
            case "bduid_type": {
                this.bduIdTypeChangeCallBack();
                break;
            }
        }
    }

    private void bduIdTypeChangeCallBack() {
        String bduIdType;
        switch (bduIdType = (String)this.getModel().getValue("bduid_type")) {
            case "service_center": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"org_bduid", "user_bduid"});
                this.getModel().setValue("org_bduid", null);
                this.getModel().setValue("user_bduid", null);
                break;
            }
            case "org": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"org_bduid"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"user_bduid"});
                this.getModel().setValue("user_bduid", null);
                break;
            }
            case "user": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"user_bduid"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"org_bduid"});
                this.getModel().setValue("org_bduid", null);
                break;
            }
        }
    }

    private void bizNameChangedCallBack() {
        String bizName = (String)this.getModel().getValue("bizname");
        if (StringUtils.isNotEmpty((CharSequence)bizName)) {
            this.getModel().setValue("fixed_value", null);
        }
    }

    private void fixedValueChangedCallBack() {
        String fixedValue = (String)this.getModel().getValue("fixed_value");
        if (fixedValue != null && !"".equals(fixedValue)) {
            this.getModel().setValue("bizname", null);
            this.getModel().setValue("biztype", null);
            this.getModel().setValue("bizdesc", null);
            this.getModel().setValue("aggr_fun", null);
            this.getModel().setValue("aggr_fun_param", null);
        }
    }

    private void refVarChangedCallBack() {
        String refVar = (String)this.getModel().getValue("ref_var");
        if (refVar != null && !"".equals(refVar)) {
            this.getModel().setValue("const", null);
        }
    }

    private void constChangedCallBack() {
        String constVar = (String)this.getModel().getValue("const");
        if (constVar != null && !"".equals(constVar)) {
            this.getModel().setValue("ref_var", null);
        }
    }

    private Long getDataTypeId() {
        IDataModel model = this.getModel();
        MainEntityType mainType = model.getDataEntityType();
        BasedataProp basedataProp = (BasedataProp)mainType.findProperty("datatype");
        DynamicObject billObj = model.getDataEntity();
        return (Long)basedataProp.getRefIdProp().getValue((Object)billObj);
    }

    private void setStatusToAudited() {
        this.getModel().setValue("status", (Object)"C");
    }

    private void updateDataTypeStatus(Long id) {
        DynamicObject dataType = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bea_datatype");
        String status = dataType.getString("datatypestatus");
        if (!"associated".equals(status)) {
            dataType.set("datatypestatus", (Object)"associated");
            SaveServiceHelper.save((IDataEntityType)dataType.getDataEntityType(), (Object[])new DynamicObject[]{dataType});
        }
    }

    public void beforeBindData(EventObject e) {
        Object bizModel;
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object dataType = customParams.get("datatype");
        if (dataType != null) {
            this.getModel().setValue("datatype", dataType);
            DynamicObject datatypeBasedata = (DynamicObject)this.getModel().getValue("datatype");
            DynamicObject serviceCenter = datatypeBasedata.getDynamicObject("service_center");
            Object serviceCenterPk = serviceCenter.getPkValue();
            this.getModel().setValue("service_center", serviceCenterPk);
            this.fillWithDataTypeToMappingEntry();
        }
        if ((bizModel = customParams.get("bizmodel")) != null) {
            this.getModel().setValue("bizmodel", bizModel);
            this.fillWithHiddenFields((String)bizModel);
        }
        this.setBduIdFilter();
        this.fixStatusToAudited();
        this.initAggrFunComboValue();
        this.initConvRuleComboValue();
    }

    private void initAggrFunComboValue() {
        List items = AggregationFunHelper.getFunRows().stream().map(r -> new ComboItem(new LocaleString(r.getName()), r.getNumber())).collect(Collectors.toList());
        ComboEdit aggrFunControl = (ComboEdit)this.getControl("aggr_fun");
        aggrFunControl.setComboItems(items);
    }

    private void initConvRuleComboValue() {
        List items = ConvRuleHelper.getRows().stream().map(r -> new ComboItem(new LocaleString(r.getName()), r.getNumber())).collect(Collectors.toList());
        ComboEdit convRuleControl = (ComboEdit)this.getControl("conv_rule");
        convRuleControl.setComboItems(items);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bduIdTypeChangeCallBack();
        this.setPageEditable();
    }

    private void setPageEditable() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (null != pkValue && 0L != (Long)pkValue) {
            MainEntityType mainType = this.getModel().getDataEntityType();
            EntityType subEntityType = mainType.getSubEntityType(Arrays.asList("createtime", "enable", "masterid", "modifier", "modifytime", "name", "number"));
            boolean refrenced = BaseDataRefrenceHelper.isRefrenced((BasedataEntityType)((BasedataEntityType)subEntityType), (Object)pkValue);
            this.getPageCache().put("is_refrenced", String.valueOf(refrenced));
            if (refrenced) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel"});
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u88ab\u4e0a\u94fe\u4efb\u52a1\u5f15\u7528\u7684\u4e1a\u52a1\u5173\u8054\u4e0d\u5141\u8bb8\u4fee\u6539", (String)"BizMappingEdit_2", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"conentpanel"});
            this.getPageCache().put("is_refrenced", Boolean.FALSE.toString());
        }
    }

    private void setBduIdFilter() {
        DynamicObject serviceCenter = (DynamicObject)this.getModel().getValue("service_center");
        if (serviceCenter != null) {
            Object serviceCenterPk = serviceCenter.getPkValue();
            BasedataEdit orgBduId = (BasedataEdit)this.getControl("org_bduid");
            BasedataEdit userBduId = (BasedataEdit)this.getControl("user_bduid");
            QFilter userBduIdQfilter = new QFilter("service_center", "=", serviceCenterPk).and("enable_status", "=", (Object)"Usable");
            QFilter orgBduIdQfilter = new QFilter("service_center", "=", serviceCenterPk).and("usage_status", "=", (Object)"Usable");
            orgBduId.setQFilter(orgBduIdQfilter);
            userBduId.setQFilter(userBduIdQfilter);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "stcc_custom_param": {
                this.openMservicePop("stcc_custom_param", ResManager.loadKDString((String)"\u5fc5\u987b\u5b9e\u73b0kd.bsc.bea.mservice.api.BizModelDataQueryService\u63a5\u53e3", (String)"BizMappingEdit_3", (String)"bsc-bea-plugin", (Object[])new Object[0]), "query", "bea_mapping_mservice_close");
                break;
            }
            case "data_owner_param": {
                this.openMservicePop("data_owner_param", ResManager.loadKDString((String)"\u5fc5\u987b\u5b9e\u73b0kd.bsc.bea.mservice.api.OwnershipService\u63a5\u53e3", (String)"BizMappingEdit_4", (String)"bsc-bea-plugin", (Object[])new Object[0]), "getOwnership", "bea_mapping_mservice_bduid_close");
                break;
            }
            case "field_mapping_param": {
                this.openMservicePop("field_mapping_param", ResManager.loadKDString((String)"\u5fc5\u987b\u5b9e\u73b0kd.bsc.bea.mservice.api.BizModelToDataTypeService\u63a5\u53e3", (String)"BizMappingEdit_5", (String)"bsc-bea-plugin", (Object[])new Object[0]), "transform", "bea_mapping_entry_mservice_close");
                break;
            }
        }
    }

    private void openMservicePop(String paramKey, String tip, String fixedMethodName, String closeEventKey) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bea_mservice_param");
        parameter.setCaption(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u53c2\u6570", (String)"BizMappingEdit_6", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        parameter.setCustomParam(paramKey, this.getModel().getValue(paramKey));
        MserviceParamProp serviceNameProp = new MserviceParamProp(true, tip, null);
        parameter.setCustomParam("mservice_servicename_prop", (Object)JsonUtil.stringify((Object)serviceNameProp));
        MserviceParamProp methodNameProp = new MserviceParamProp(false, null, fixedMethodName);
        parameter.setCustomParam("mservice_methodname_prop", (Object)JsonUtil.stringify((Object)methodNameProp));
        parameter.setCustomParam("identify", (Object)paramKey);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeEventKey));
        this.getView().showForm(parameter);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        String dataTypeFieldType = (String)this.getModel().getValue("datatype_type", row);
        String refrencedValue = this.getPageCache().get("is_refrenced");
        boolean refrenced = Boolean.parseBoolean(refrencedValue);
        if (!refrenced) {
            HashMap<String, Object> param;
            if (BIZ_FILED_POP_ENABLE_CLICK_MAPPING_ENTRY_FIELDS.contains(fieldKey) && BizMappingHelper.isCreateMappingEnable(dataTypeFieldType)) {
                this.showBizFieldPopForm(fieldKey, row, "bea_bzimodelfield_pop", 1, true);
            }
            if (BIZ_FILED_POP_ENABLE_CLICK_FILTER_ENTRY_FIELDS.contains(fieldKey)) {
                this.showBizFieldPopForm(fieldKey, row, "bea_bzifield_single_pop", 0, false);
            }
            if ("aggr_fun".equals(fieldKey) && BizMappingHelper.isCreateMappingEnable(dataTypeFieldType)) {
                param = new HashMap<String, Object>();
                param.put(KEY_DOUBLE_CLICK_ROW, row);
                param.put(KEY_DOUBLE_CLICK_FIELD, fieldKey);
                MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u805a\u5408\u51fd\u6570", (String)"BizMappingEdit_7", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)"bea_aggr_fun_pop", (String)"bea_aggr_fun_pop_close", (AbstractFormPlugin)this, param);
            }
            if ("conv_rule".equals(fieldKey) && BizMappingHelper.isCreateMappingEnable(dataTypeFieldType)) {
                param = new HashMap();
                param.put(KEY_DOUBLE_CLICK_ROW, row);
                param.put(KEY_DOUBLE_CLICK_FIELD, fieldKey);
                MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u683c\u5f0f\u8f6c\u6362\u5217\u8868", (String)"BizMappingEdit_8", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)"bea_conv_rule_pop", (String)"bea_conv_rule_pop_close", (AbstractFormPlugin)this, param);
            }
        }
    }

    private void showBizFieldPopForm(String fieldKey, int row, String formId, int bizFieldMaxLevel, boolean identify) {
        String bizModelNumber = MetaDataUtils.getBaseDataNumber((IDataModel)this.getModel(), (String)"bizmodel");
        String bizModelName = MetaDataUtils.getBaseDataName((IDataModel)this.getModel(), (String)"bizmodel");
        List<BizModelField> bizModelFields = BizMappingHelper.getBizModelFields(bizModelNumber, bizFieldMaxLevel);
        List<BizModelField> bizModelAttachmentPanels = BizMappingHelper.getBizModelAttachmentPanels(bizModelNumber);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("field_list", JsonUtil.stringify(bizModelFields));
        if ("bea_bzimodelfield_pop".equals(formId)) {
            param.put("attachmentsPanel", JsonUtil.stringify(bizModelAttachmentPanels));
        }
        param.put("identify", identify);
        if (identify) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("mapping_entry", row);
            param.put("bizname", dynamicObject.getString("bizname"));
        } else {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity("filter_entry", row);
            if (fieldKey.equals("ref_var")) {
                param.put("bizname", dynamicObject.getString("ref_var"));
            } else {
                param.put("bizname", dynamicObject.getString("filter_name"));
            }
        }
        param.put(KEY_DOUBLE_CLICK_ROW, row);
        param.put(KEY_DOUBLE_CLICK_FIELD, fieldKey);
        param.put("bizmodel_id", bizModelNumber);
        param.put("bizmodel_name", bizModelName);
        MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5", (String)"BizMappingEdit_9", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)formId, (String)"bea_bzimodelfield_pop_close", (AbstractFormPlugin)this, param);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (null != event.getReturnData()) {
            Map returnData = (Map)event.getReturnData();
            String doubleClickField = (String)returnData.get(KEY_DOUBLE_CLICK_FIELD);
            Integer doubleClickRow = (Integer)returnData.get(KEY_DOUBLE_CLICK_ROW);
            String selectRowData = (String)returnData.get("field_list");
            String mserviceParam = (String)returnData.get("stcc_custom_param");
            String mserviceBduidParam = (String)returnData.get("data_owner_param");
            String mserviceMappingEntryParam = (String)returnData.get("field_mapping_param");
            switch (event.getActionId()) {
                case "bea_bzimodelfield_pop_close": {
                    this.bizFieldPopCloseCallBack(doubleClickField, doubleClickRow, selectRowData);
                    break;
                }
                case "bea_aggr_fun_pop_close": {
                    this.aggregationFunPopCloseCallBack(doubleClickRow, selectRowData);
                    break;
                }
                case "bea_mapping_mservice_close": {
                    this.mserviceParamPopCloseCallBack("stcc_custom_param", mserviceParam);
                    break;
                }
                case "bea_mapping_mservice_bduid_close": {
                    this.mserviceParamPopCloseCallBack("data_owner_param", mserviceBduidParam);
                    break;
                }
                case "bea_mapping_entry_mservice_close": {
                    this.mserviceParamPopCloseCallBack("field_mapping_param", mserviceMappingEntryParam);
                    break;
                }
                case "bea_conv_rule_pop_close": {
                    this.convertRulePopCloseCallBack(doubleClickRow, selectRowData);
                }
            }
        }
        BizMappingHelper.mappingPopCloseCallBack(this.getView(), (IFormPlugin)this, event.getActionId(), event.getReturnData());
    }

    private void mserviceParamPopCloseCallBack(String key, String paramJson) {
        if (null != paramJson) {
            this.getModel().setValue(key, (Object)paramJson);
        }
    }

    private void aggregationFunPopCloseCallBack(Integer doubleClickRow, String selectedRowData) {
        AggregationFunRow funRow = (AggregationFunRow)JsonUtil.parse((String)selectedRowData, AggregationFunRow.class);
        this.getModel().setValue("aggr_fun", (Object)(StringUtils.isEmpty((CharSequence)funRow.getNumber()) ? null : funRow.getNumber()), doubleClickRow.intValue());
        this.getModel().setValue("aggr_fun_param", (Object)(StringUtils.isEmpty((CharSequence)funRow.getParamExample()) ? null : funRow.getParamExample()), doubleClickRow.intValue());
        this.getModel().setValue("fixed_value", null);
    }

    private void convertRulePopCloseCallBack(Integer doubleClickRow, String selectedRowData) {
        ConvRuleRow row = (ConvRuleRow)JsonUtil.parse((String)selectedRowData, ConvRuleRow.class);
        this.getModel().setValue("conv_rule", (Object)(StringUtils.isEmpty((CharSequence)row.getNumber()) ? null : row.getNumber()), doubleClickRow.intValue());
        this.getModel().setValue("fixed_value", null);
    }

    private void bizFieldPopCloseCallBack(String doubleClickField, Integer doubleClickRow, String selectedRowData) {
        BizModelField field = (BizModelField)JsonUtil.parse((String)selectedRowData, BizModelField.class);
        if (null != field) {
            switch (doubleClickField) {
                case "bizname": 
                case "biztype": 
                case "bizdesc": {
                    this.mappingEntryBizNameClickCallBack(field, doubleClickRow);
                    break;
                }
                case "filter_name": 
                case "filter_desc": {
                    this.filterEntryFilterNameClickCallBack(field, doubleClickRow);
                    break;
                }
                case "ref_var": {
                    this.filterEntryRefVarClickCallBack(field, doubleClickRow);
                    break;
                }
            }
        }
    }

    private void mappingEntryBizNameClickCallBack(BizModelField field, Integer doubleClickRow) {
        this.getModel().setValue("bizname", (Object)(StringUtils.isEmpty((CharSequence)field.getFieldName()) ? null : field.getFieldName()), doubleClickRow.intValue());
        this.getModel().setValue("biztype", (Object)(StringUtils.isEmpty((CharSequence)field.getFilterType()) ? null : field.getFilterType()), doubleClickRow.intValue());
        this.getModel().setValue("bizdesc", (Object)(StringUtils.isEmpty((CharSequence)field.getDisplayName()) ? null : field.getDisplayName()), doubleClickRow.intValue());
        this.getModel().setValue("fixed_value", null, doubleClickRow.intValue());
        if (field.getFilterType().contains("attachmentPanel") || field.getFilterType().contains("attachmentEdits")) {
            this.getModel().setValue("aggr_fun", (Object)"fileHash", doubleClickRow.intValue());
            this.getModel().setValue("aggr_fun_param", (Object)AggregationFunHelper.getFunRowMap().get("fileHash").getParamExample(), doubleClickRow.intValue());
        }
    }

    private void filterEntryFilterNameClickCallBack(BizModelField field, Integer doubleClickRow) {
        this.getModel().setValue("filter_name", (Object)field.getFieldName(), doubleClickRow.intValue());
        this.getModel().setValue("filter_desc", (Object)field.getDisplayName(), doubleClickRow.intValue());
    }

    private void filterEntryRefVarClickCallBack(BizModelField field, Integer doubleClickRow) {
        this.getModel().setValue("ref_var", (Object)field.getFieldName(), doubleClickRow.intValue());
        this.getModel().setValue("const", null, doubleClickRow.intValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    private void fixStatusToAudited() {
        DynamicObject mappingObj = this.getModel().getDataEntity(false);
        String status = mappingObj.getString("status");
        Long pkValue = (Long)mappingObj.getPkValue();
        if (0L != pkValue) {
            switch (status) {
                case "A": {
                    if (!this.checkParamAndShowTip(null, false)) break;
                    mappingObj.set("status", (Object)"C");
                    SaveServiceHelper.update((DynamicObject)mappingObj);
                    break;
                }
                case "B": {
                    mappingObj.set("status", (Object)"C");
                    SaveServiceHelper.update((DynamicObject)mappingObj);
                    break;
                }
            }
        }
    }
}

