/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.common.util.StringUtils;

public class BizMappingFieldPopForm
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
CellClickListener,
F7SelectedListRemoveListener,
PagerClickListener {
    private static final Log log = LogFactory.getLog(BizMappingFieldPopForm.class);
    private static final String KEY_NAME_PARAMS = "names";
    private static final String KEY_PAGER_PARAMS = "pager";
    private static final String KEY_YES_PAGER_CLICK = "yes";
    private static final String KEY_NO_PAGER_CLICK = "no";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_list");
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addPagerClickListener(this::pagerClick);
        if (this.isMulEntry()) {
            F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("f7selectedlistap");
            f7SelectedList.addF7SelectedListRemoveAllListener(this::RemoveClick);
            f7SelectedList.addF7SelectedListRemoveListener(this::RemoveClick);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String bizName = String.valueOf(customParams.get("bizname"));
        this.getPageCache().put(KEY_NAME_PARAMS, bizName);
        this.getPageCache().put(KEY_PAGER_PARAMS, KEY_NO_PAGER_CLICK);
        this.initTree();
    }

    private void initTree() {
        List<BizModelField> fieldList = this.getCommonBizFields();
        String bizModelName = this.getBizModelName();
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        TreeNode root = new TreeNode("", "", bizModelName);
        root.setChildren(new ArrayList());
        treeView.addNode(root);
        treeView.setRootVisible(true);
        treeView.expand("");
        treeView.focusNode(root);
        HashMap<String, TreeNode> nodes = new HashMap<String, TreeNode>(256);
        nodes.put("", root);
        if (fieldList != null) {
            this.constructTreeNodes(fieldList, root, nodes);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5bf9\u8c61\u5143\u6570\u636e\u5931\u8d25", (String)"BizMappingFieldPopForm_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        }
        this.describeTreeWithAttachments(root, nodes);
        this.getPageCache().put("root_node", JsonUtil.stringify(nodes));
        this.refreshEntryList(root);
        this.updateF7Selected();
    }

    private void constructTreeNodes(List<BizModelField> fields, TreeNode root, Map<String, TreeNode> nodes) {
        for (BizModelField field : fields) {
            String[] displayNameSlices;
            String[] fieldNameSlices = field.getFieldName().split("\\.");
            if (fieldNameSlices.length != (displayNameSlices = field.getDisplayName().split("\\.")).length) continue;
            for (int i = 0; i < fieldNameSlices.length; ++i) {
                String fieldName = StringUtils.join((CharSequence)".", (int)(i + 1), (String[])fieldNameSlices);
                if (nodes.containsKey(fieldName)) continue;
                String displayName = fieldNameSlices[i].contains("[") && fieldNameSlices[i].contains("]") ? String.format(ResManager.loadKDString((String)"%s(\u5206\u5f55)", (String)"BizMappingFieldPopForm_1", (String)"bsc-bea-plugin", (Object[])new Object[0]), displayNameSlices[i]) : displayNameSlices[i];
                String parentId = StringUtils.join((CharSequence)".", (int)i, (String[])fieldNameSlices);
                TreeNode node = new TreeNode(parentId, fieldName, displayName);
                TreeNode parentNode = nodes.get(parentId);
                parentNode.addChild(node);
                nodes.put(node.getId(), node);
            }
        }
    }

    private void describeTreeWithAttachments(TreeNode root, Map<String, TreeNode> nodes) {
        if (!this.getAttachmentPanels().isEmpty()) {
            TreeNode panelNode = new TreeNode("", "$attachmentPanel$", ResManager.loadKDString((String)"\u9644\u4ef6\uff1a\u9644\u4ef6\u9762\u677f", (String)"BizMappingFieldPopForm_2", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            root.addChild(panelNode);
            nodes.put(panelNode.getId(), panelNode);
        }
    }

    private void refreshEntryList(TreeNode currentNode) {
        this.getModel().deleteEntryData("field_list");
        String nodeId = currentNode.getId();
        List<BizModelField> fieldList = "$attachmentPanel$".equals(nodeId) ? this.getAttachmentPanels() : this.filterFieldList(nodeId, null == currentNode.getChildren() || currentNode.getChildren().isEmpty());
        int[] selectedArray = this.copyFieldToEntryList(fieldList);
        this.getView().updateView("field_list");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_list");
        entryGrid.selectRows(selectedArray, 0);
    }

    private List<BizModelField> filterFieldList(String fieldName, boolean leafNode) {
        List<BizModelField> fieldList = this.getCommonBizFields();
        if (!"".equals(fieldName)) {
            String filterPrefix = leafNode ? fieldName : fieldName + ".";
            return fieldList.stream().filter(f -> f.getFieldName().startsWith(filterPrefix)).collect(Collectors.toList());
        }
        return fieldList;
    }

    private int[] copyFieldToEntryList(List<BizModelField> fieldList) {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("field_list");
        List<String> selectedNames = this.getSelectedNames();
        LinkedList<Integer> selectedSeq = new LinkedList<Integer>();
        for (BizModelField field : fieldList) {
            DynamicObject row = entry.addNew();
            row.set("name", (Object)field.getFieldName());
            row.set("type", (Object)field.getFilterType());
            row.set("desc", (Object)field.getDisplayName());
            if (!selectedNames.contains(field.getFieldName())) continue;
            selectedSeq.add(entry.size() - 1);
        }
        return selectedSeq.stream().mapToInt(Integer::valueOf).toArray();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Map nodeMap = (Map)JsonUtil.parse((String)this.getPageCache().get("root_node"), (TypeReference)new TypeReference<Map<String, TreeNode>>(){});
        this.refreshEntryList((TreeNode)nodeMap.get((String)evt.getNodeId()));
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.getView().updateView("field_list");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("field_list");
        EntryGrid grid = (EntryGrid)this.getView().getControl("field_list");
        String text = searchEnterEvent.getText();
        if (entryEntity.size() != 0 && !kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)text)) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject o = (DynamicObject)entryEntity.get(i);
                if (!o.getString("desc").contains(text) && !o.getString("name").contains(text)) continue;
                indices.add(i);
            }
            if (indices.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e!", (String)"BizMappingFieldPopForm_3", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            } else {
                int[] rows = indices.stream().mapToInt(Integer::valueOf).toArray();
                grid.setRowBackcolor("#eff3fd", rows);
                grid.focusCell(rows[0], "name");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.okClickCallBack();
                break;
            }
            case "btncancel": {
                this.cancelClickCallBack();
                break;
            }
        }
    }

    private void okClickCallBack() {
        Map map = (Map)JsonUtil.parse((String)this.getPageCache().get("controlstates"), Map.class);
        Map treeView = (Map)map.get("treeviewap");
        Map focus = (Map)treeView.get("focus");
        List<BizModelField> fieldList = "$attachmentPanel$".equals(focus.get("id")) ? this.getAttachmentPanels() : this.getCommonBizFields();
        List<BizModelField> entryRows = this.filterSelectRows(this.getSelectedNames(), fieldList);
        String name = entryRows.stream().map(e -> this.transFormBizFieldProp(e.getFieldName())).collect(Collectors.joining(","));
        String type = entryRows.stream().map(e -> this.transFormBizFieldProp(e.getFilterType())).collect(Collectors.joining(","));
        String desc = entryRows.stream().map(e -> this.transFormBizFieldProp(e.getDisplayName())).collect(Collectors.joining(","));
        String fieldJson = JsonUtil.stringify((Object)new BizModelField(name, type, desc));
        Map parentParam = this.getView().getFormShowParameter().getCustomParams();
        parentParam.put("field_list", fieldJson);
        this.getView().returnDataToParent((Object)parentParam);
        this.getView().close();
    }

    private void cancelClickCallBack() {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }

    private String transFormBizFieldProp(String value) {
        if (null != value) {
            return value.replace(",", "&sbquo;");
        }
        return null;
    }

    private List<BizModelField> filterSelectRows(List<String> selectedNames, List<BizModelField> fieldList) {
        LinkedList<BizModelField> selectedRowList = new LinkedList<BizModelField>();
        for (BizModelField field : fieldList) {
            if (!selectedNames.contains(field.getFieldName())) continue;
            selectedRowList.add(field);
        }
        return selectedRowList;
    }

    private List<BizModelField> getCommonBizFields() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fieldsJson = (String)customParams.get("field_list");
        if (fieldsJson != null) {
            return JsonUtil.parseToList((String)fieldsJson, BizModelField.class).stream().filter(f -> !f.getFieldName().contains(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<BizModelField> getAttachmentPanels() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String attachmentPanelsJson = (String)customParams.get("attachmentsPanel");
        if (attachmentPanelsJson != null) {
            return JsonUtil.parseToList((String)attachmentPanelsJson, BizModelField.class);
        }
        return Collections.emptyList();
    }

    private String getBizModelName() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get("bizmodel_name");
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        Object param = f7SelectedListRemoveEvent.getParam();
        if (ObjectUtils.isEmpty((Object)param)) {
            this.getPageCache().put(KEY_NAME_PARAMS, "");
            this.getView().updateView("field_list");
        } else {
            List<String> selectedNames = this.getSelectedNames();
            selectedNames.remove(param);
            this.getPageCache().put(KEY_NAME_PARAMS, this.stringify(selectedNames));
            int[] selectedArray = this.updateEntrySelected();
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_list");
            int focusRowIndex = selectedArray.length < 1 ? 0 : selectedArray[0];
            entryGrid.selectRows(selectedArray, focusRowIndex);
        }
    }

    private int[] updateEntrySelected() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("field_list");
        List<String> selectedNames = this.getSelectedNames();
        LinkedList<Integer> selectedSeq = new LinkedList<Integer>();
        for (DynamicObject entryRow : entryEntity) {
            if (!selectedNames.contains(entryRow.getString("name"))) continue;
            selectedSeq.add(entryRow.getInt("seq") - 1);
        }
        return selectedSeq.stream().mapToInt(Integer::valueOf).toArray();
    }

    private void updateF7Selected() {
        if (this.isMulEntry()) {
            List<String> selectedNames = this.getSelectedNames();
            ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(10);
            for (String selectedName : selectedNames) {
                valueTextItems.add(new ValueTextItem(selectedName, selectedName));
            }
            F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl("f7selectedlistap");
            f7SelectedList.addItems(valueTextItems);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_list");
        int[] selectRows = entryGrid.getSelectRows();
        Set<Integer> oldSelectedSet = this.updateSelectSeqSet();
        List<String> selectedNames = this.getSelectedNames();
        Set<Integer> newSelectedSet = Arrays.stream(selectRows).boxed().collect(Collectors.toSet());
        if (!this.isMulEntry()) {
            selectedNames.clear();
        } else if (this.judgeDelete(newSelectedSet, oldSelectedSet)) {
            List<String> removeSelectedNamesList = this.getRemoveSelectedNames(oldSelectedSet, newSelectedSet);
            selectedNames.removeAll(removeSelectedNamesList);
        }
        List<String> addSelectedNamesList = this.getAddSelectedNames(this.updateSelectSeqSet(), newSelectedSet);
        selectedNames.addAll(addSelectedNamesList);
        this.getPageCache().put(KEY_NAME_PARAMS, this.stringify(selectedNames));
        this.getPageCache().put(KEY_PAGER_PARAMS, KEY_NO_PAGER_CLICK);
        int[] selectedArray = this.updateEntrySelected();
        entryGrid.selectRows(selectedArray, -1);
        this.updateF7Selected();
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private Set<Integer> updateSelectSeqSet() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("field_list");
        Integer currentPageIndex = entryGrid.getEntryState().getCurrentPageIndex();
        Integer pageRows = entryGrid.getEntryState().getPageRows();
        int[] selectedSeqArray = this.updateEntrySelected();
        HashSet<Integer> selectedSeqSet = new HashSet<Integer>();
        for (int selectedSeq : selectedSeqArray) {
            if (selectedSeq < (currentPageIndex - 1) * pageRows || selectedSeq >= currentPageIndex * pageRows) continue;
            selectedSeqSet.add(selectedSeq);
        }
        return selectedSeqSet;
    }

    private List<String> getSelectedNames() {
        LinkedList<String> selectedNameList = new LinkedList<String>();
        String bizName = this.getPageCache().get(KEY_NAME_PARAMS);
        if (!kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)bizName)) {
            String[] bizNames = bizName.split(",");
            selectedNameList.addAll(Arrays.asList(bizNames));
        }
        return selectedNameList;
    }

    private boolean isMulEntry() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (Boolean)customParams.get("identify");
    }

    private String stringify(List<String> list) {
        return list.stream().map(this::transFormBizFieldProp).collect(Collectors.joining(","));
    }

    public void pagerClick(PagerClickEvent pagerClickEvent) {
        this.getPageCache().put(KEY_PAGER_PARAMS, KEY_YES_PAGER_CLICK);
    }

    private boolean judgeDelete(Set<Integer> newSelectedSet, Set<Integer> oldSelectedSet) {
        if (newSelectedSet.size() == oldSelectedSet.size() - 1 && KEY_NO_PAGER_CLICK.equals(this.getPageCache().get(KEY_PAGER_PARAMS))) {
            return true;
        }
        return newSelectedSet.size() == 0 && oldSelectedSet.size() != 0;
    }

    private List<String> getRemoveSelectedNames(Set<Integer> oldSelectedSet, Set<Integer> newSelectedSet) {
        oldSelectedSet.removeAll(newSelectedSet);
        return oldSelectedSet.stream().map(k -> this.getModel().getEntryRowEntity("field_list", k.intValue())).filter(Objects::nonNull).map(m -> m.getString("name")).collect(Collectors.toList());
    }

    private List<String> getAddSelectedNames(Set<Integer> oldSelectedSet, Set<Integer> newSelectedSet) {
        newSelectedSet.removeAll(oldSelectedSet);
        return newSelectedSet.stream().map(k -> this.getModel().getEntryRowEntity("field_list", k.intValue())).filter(Objects::nonNull).map(m -> m.getString("name")).collect(Collectors.toList());
    }
}

