/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.dao.MappingBizDataQueryHelper;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.verifier.Prompt;

public class BizMappingList
extends StandardTreeListPlugin {
    private static Log log = LogFactory.getLog(BizMappingList.class);

    public void initialize() {
        super.initialize();
        ((ListView)this.getView()).setNeedRefreshTree(false);
    }

    public void initializeTree(EventObject e) {
        this.intiTree();
    }

    private void setBarVisible(boolean enable) {
        this.getView().setVisible(Boolean.valueOf(enable), new String[]{"btnnew", "btnedit", "btndel"});
    }

    private QFilter getModelFilter(String nodeId) {
        QFilter qFilter;
        ORM orm = ORM.create();
        boolean isCloud = orm.exists("bos_devportal_bizcloud", (Object)nodeId);
        if (nodeId.equals("-1")) {
            qFilter = new QFilter("number", "is not null", (Object)"");
        } else if (isCloud) {
            JSONArray units = this.getUnitIdsByCloudId(nodeId);
            qFilter = new QFilter("bizappid", "in", (Object)units);
        } else {
            qFilter = new QFilter("bizappid", "=", (Object)nodeId);
        }
        return qFilter;
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent nodeEvent) {
        super.buildTreeListFilter(nodeEvent);
        String nodeId = nodeEvent.getNodeId().toString();
        nodeEvent.addQFilter(this.getModelFilter(nodeId));
        nodeEvent.setCancel(true);
    }

    private void intiTree() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizMappingList_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setId("-1");
        root.setIsOpened(true);
        List<TreeNode> cloudNodes = this.getAllCloudNodes();
        for (TreeNode treeNode : cloudNodes) {
            List<TreeNode> groupNodes = this.getAppNodesByCloudId(treeNode.getId());
            this.addChildNode(treeNode, groupNodes);
        }
        root.addChildren(cloudNodes);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    private List<TreeNode> getAllCloudNodes() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if ("extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            DynamicObject cloudObject = BizCloudServiceHelp.getBizCloudByAppID((String)refAppId);
            TreeNode node = new TreeNode("-1", cloudObject.getString("id"), cloudObject.getLocaleString("name").getLocaleValue());
            cloudNode.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizCloudServiceHelp.getAllBizClouds();
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                node.setId(dynamicObject.getString("id"));
                node.setText(dynamicObject.getString("name"));
                node.setParentid("-1");
                cloudNode.add(node);
            }
        }
        return cloudNode;
    }

    private List<TreeNode> getAppNodesByCloudId(String cloudId) {
        ArrayList<TreeNode> appNodes = new ArrayList<TreeNode>();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String pageType = (String)formShowParameter.getCustomParam("pagetype");
        if ("extend".equals(pageType)) {
            String refAppId = (String)formShowParameter.getCustomParam("refappid");
            AppMetadata refAppMeta = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)refAppId, (boolean)false);
            String refAppName = refAppMeta.getName().getLocaleValue();
            TreeNode node = new TreeNode(cloudId, refAppId, refAppName);
            appNodes.add(node);
        } else {
            DynamicObjectCollection dynamicObjects = BizAppServiceHelp.getAllBizAppsByCloudID((String)cloudId);
            for (DynamicObject dynamicObject : dynamicObjects) {
                TreeNode node = new TreeNode();
                String nodeId = dynamicObject.getString("id");
                node.setId(nodeId);
                node.setText(dynamicObject.getString("name"));
                node.setParentid(cloudId);
                appNodes.add(node);
            }
        }
        return appNodes;
    }

    private TreeNode addChildNode(TreeNode pnode, List<TreeNode> childNodes) {
        for (int i = 0; i < childNodes.size(); ++i) {
            TreeNode cnode = childNodes.get(i);
            String parentId = cnode.getParentid();
            if (!pnode.getId().equals(parentId)) continue;
            pnode.addChild(this.addChildNode(cnode, childNodes));
        }
        return pnode;
    }

    public void refreshNode(RefreshNodeEvent e) {
        List<TreeNode> childNodes = this.getChildNodes(e.getNodeId());
        e.setChildNodes(childNodes);
    }

    private List<TreeNode> getChildNodes(Object parentId) {
        List<TreeNode> cloudNodes = null;
        if (this.getTreeModel().getRoot().getId().equals(parentId)) {
            cloudNodes = this.getAllCloudNodes();
            for (TreeNode treeNode : cloudNodes) {
                List<TreeNode> groupNodes = this.getAppNodesByCloudId(treeNode.getId());
                this.addChildNode(treeNode, groupNodes);
            }
        } else {
            TreeNode node = this.getTreeModel().getRoot().getTreeNode((String)parentId, 20);
            if (node != null) {
                return node.getChildren();
            }
        }
        return cloudNodes;
    }

    private JSONArray getUnitIdsByCloudId(String bizCloudId) {
        JSONArray unitIds = new JSONArray();
        ORM orm = ORM.create();
        QFilter q = new QFilter("bizcloud", "=", (Object)bizCloudId);
        QFilter[] filters = new QFilter[]{q};
        String selectFields = "id";
        DynamicObjectCollection query = orm.query("bos_devportal_bizapp", selectFields, filters, "sequence asc");
        for (DynamicObject dynamicObject : query) {
            String bizAppId = dynamicObject.getString("id");
            unitIds.add((Object)bizAppId);
        }
        return unitIds;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("new".equals(formOperate.getOperateKey())) {
            args.setCancel(true);
            BizMappingHelper.openModelEditWindow(this.getView(), (IFormPlugin)this);
        } else if ("mapping_query".equals(formOperate.getOperateKey())) {
            this.checkParamForMappingQuery(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("mapping_query".equals(args.getOperateKey())) {
            this.bizModelMappingQuery();
        }
    }

    private void checkParamForMappingQuery(BeforeDoOperationEventArgs args) {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection rows = view.getSelectedRows();
        if (1 != rows.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u67e5\u8be2\u4e0d\u652f\u6301\u591a\u9009\u3002", (String)"BizMappingList_1", (String)"bsc-bea-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            args.setCancel(true);
            return;
        }
        ListSelectedRow row = rows.get(0);
        Long primaryKey = (Long)row.getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)"bea_mapping");
        List<Prompt> paramCheckResults = BizMappingHelper.checkMapping(BizMappingHelper.dynamicObjectToMapping(dynamicObject));
        if (!paramCheckResults.isEmpty()) {
            Prompt prompt = paramCheckResults.get(0);
            this.getView().showTipNotification(prompt.getMessage());
            if (null != args && prompt.isNeedInterrupt()) {
                args.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BizMappingHelper.mappingPopCloseCallBack(this.getView(), (IFormPlugin)this, closedCallBackEvent.getActionId(), closedCallBackEvent.getReturnData());
        ((ListView)this.getView()).refresh();
    }

    public void initTreeToolbar(EventObject e) {
        this.setBarVisible(false);
    }

    private void bizModelMappingQuery() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection rows = view.getSelectedRows();
        ListSelectedRow row = rows.get(0);
        Long primaryKey = (Long)row.getPrimaryKeyValue();
        DynamicObject bizMapping = MappingBizDataQueryHelper.getBizMappingById(primaryKey);
        String bizNumber = bizMapping.getString("bizmodel_id");
        DynamicObjectCollection filterEntryCol = bizMapping.getDynamicObjectCollection("filter_entry");
        List<FilterEntry> filterEntries = BizMappingHelper.objColToFilterEntry(filterEntryCol);
        QFilter filter = MappingBizDataQueryHelper.constructQFilter(filterEntries, null, BizMappingHelper.getBizModelFieldMap(bizNumber, 0));
        BizMappingHelper.openBizModelList(this.getView(), (IFormPlugin)this, bizNumber, null == filter ? null : filter.toArray());
    }
}

