/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bsc.bcc.common.dao.ServiceCenterDao;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;

public class ChainDataTypePopForm
extends AbstractFormPlugin
implements CellClickListener {
    public static final String KEY_SERVICE_CENTER = "service_center";
    public static final String KEY_ENTRYENTITY = "entryentity";
    public static final String KEY_SCHEMAID = "schemaid";
    public static final String KEY_NAME = "name";
    public static final String KEY_PROXY = "proxy";
    public static final String KEY_STRUCTURE = "structure";
    public static final String KEY_CREATETIME = "createtime";
    public static final String KEY_SYNCHRONIZED = "synchronized";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        EntryGrid chainDataTypeEntry = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        chainDataTypeEntry.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject serviceCenterObject = ServiceCenterDao.getDefaultServiceCenterDynamicObject();
        if (null != serviceCenterObject) {
            this.getModel().setValue(KEY_SERVICE_CENTER, serviceCenterObject.getPkValue());
            this.initChainDataTypeList((Long)serviceCenterObject.getPkValue());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject serviceCenter = (DynamicObject)this.getModel().getValue(KEY_SERVICE_CENTER);
        Long pkId = (Long)serviceCenter.getPkValue();
        if (KEY_SERVICE_CENTER.equals(e.getProperty().getName()) && !ObjectUtils.isEmpty((Object)pkId)) {
            this.initChainDataTypeList(pkId);
            this.getModel().setDataChanged(false);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
            entryGrid.setPageIndex(1);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.btnokCallBack();
                break;
            }
            case "btncancel": {
                this.btncancelCallBack();
                break;
            }
        }
    }

    private void initChainDataTypeList(Long pkId) {
        int[] rowIndex;
        IDataModel model = this.getModel();
        Map chainDataTypeList = null;
        try {
            chainDataTypeList = (Map)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"ChainDataTypeService", (String)"querySchemas", (Object[])new Object[]{pkId, 0, 0});
        }
        catch (KDBizException e) {
            model.deleteEntryData(KEY_ENTRYENTITY);
            this.getView().showErrorNotification(ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)e)));
            return;
        }
        model.deleteEntryData(KEY_ENTRYENTITY);
        List chainDataTypes = (List)chainDataTypeList.get("datas");
        if (chainDataTypes.size() < 1) {
            return;
        }
        for (int index : rowIndex = model.batchCreateNewEntryRow(KEY_ENTRYENTITY, chainDataTypes.size())) {
            LinkedHashMap chainDataType = (LinkedHashMap)chainDataTypes.get(index);
            model.setValue(KEY_SCHEMAID, chainDataType.get("schema_id"), index);
            model.setValue(KEY_NAME, chainDataType.get(KEY_NAME), index);
            model.setValue(KEY_PROXY, chainDataType.get(KEY_PROXY), index);
            model.setValue(KEY_STRUCTURE, chainDataType.get(KEY_STRUCTURE), index);
            model.setValue(KEY_CREATETIME, (Object)new Date((Long)chainDataType.get("create_time")), index);
            model.setValue(KEY_SYNCHRONIZED, chainDataType.get(KEY_SYNCHRONIZED), index);
        }
    }

    private void btnokCallBack() {
        EntryGrid fieldEntries = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        int[] selectRowNumbers = fieldEntries.getSelectRows();
        if (1 == selectRowNumbers.length) {
            int selectRowNumber = selectRowNumbers[0];
            DynamicObject entryRow = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, selectRowNumber);
            DynamicObject serviceCenter = (DynamicObject)this.getModel().getValue(KEY_SERVICE_CENTER);
            Long pkId = (Long)serviceCenter.getPkValue();
            String name = entryRow.getString(KEY_NAME);
            String isSynchronized = entryRow.getString(KEY_SYNCHRONIZED);
            if (isSynchronized.equals("true")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u5df2\u540c\u6b65\u3002", (String)"ChainDataTypePopForm_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
                return;
            }
            Map parentParam = this.getView().getFormShowParameter().getCustomParams();
            parentParam.put("pkId", pkId);
            parentParam.put(KEY_NAME, name);
            this.getView().returnDataToParent((Object)parentParam);
        } else {
            this.getView().returnDataToParent(null);
        }
        this.getView().close();
    }

    private void btncancelCallBack() {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        int row = cellClickEvent.getRow();
        String structure = (String)this.getModel().getValue(KEY_STRUCTURE, row);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bea_datatype_schema_pop");
        showParameter.setCaption(ResManager.loadKDString((String)"\u6570\u636e\u7ed3\u6784\u9884\u89c8", (String)"ChainDataTypePopForm_1", (String)"bsc-bea-plugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bea_datatype_schema_pop_close"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put(KEY_STRUCTURE, structure);
        showParameter.setCustomParams(param);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }
}

