/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bsc.bea.common.model.ConvRuleRow;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.helper.ConvRuleHelper;

public class ConvRulePopForm
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.deleteEntryData("field_list");
        int[] rowIndex = model.batchCreateNewEntryRow("field_list", ConvRuleHelper.getRows().size());
        for (int i = 0; i < rowIndex.length; ++i) {
            int index = rowIndex[i];
            ConvRuleRow row = ConvRuleHelper.getRows().get(i);
            model.setValue("rule_number", (Object)row.getNumber(), index);
            model.setValue("rule_name", (Object)row.getName(), index);
            model.setValue("rule_desc", (Object)row.getDesc(), index);
            model.setValue("in_type", (Object)row.getInType(), index);
            model.setValue("out_type", (Object)row.getOutType(), index);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "btnok": {
                this.okClickCallBack();
                break;
            }
            case "btncancel": {
                this.cancelClickCallBack();
                break;
            }
        }
    }

    private void okClickCallBack() {
        EntryGrid fieldEntries = (EntryGrid)this.getView().getControl("field_list");
        int[] selectRowNumbers = fieldEntries.getSelectRows();
        if (1 == selectRowNumbers.length) {
            int selectRowNumber = selectRowNumbers[0];
            DynamicObject entryRow = this.getModel().getEntryRowEntity("field_list", selectRowNumber);
            ConvRuleRow row = new ConvRuleRow();
            row.setNumber(entryRow.getString("rule_number"));
            row.setName(entryRow.getString("rule_name"));
            row.setDesc(entryRow.getString("rule_desc"));
            row.setInType(entryRow.getString("in_type"));
            row.setOutType(entryRow.getString("out_type"));
            String rowJson = JsonUtil.stringify((Object)row);
            Map parentParam = this.getView().getFormShowParameter().getCustomParams();
            parentParam.put("field_list", rowJson);
            this.getView().returnDataToParent((Object)parentParam);
        } else {
            Map parentParam = this.getView().getFormShowParameter().getCustomParams();
            parentParam.put("field_list", JsonUtil.stringify((Object)ConvRuleRow.EMPTY));
            this.getView().returnDataToParent((Object)parentParam);
        }
        this.getView().close();
    }

    private void cancelClickCallBack() {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }
}

