/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bcc.common.dao.ServiceCenterDao;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.constant.ApiErrorCode;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.common.model.Entry;
import kd.bsc.bea.common.util.BeaFeedbackUtils;
import kd.bsc.bea.common.util.JsonSchemaUtil;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.util.ExceptionUtil;
import kd.bsc.bea.util.ParseSchemaUtil;

public class DataTypeEdit
extends AbstractBillPlugIn
implements TabSelectListener {
    private static final Log log = LogFactory.getLog(DataTypeEdit.class);
    public static final String KEY_CODE_EDIT = "codeeditap";
    public static final String KEY_CONTROL_SCHEMA_CREATOR = "control_schema_creator";
    public static final String KEY_TAB = "tabap";
    public static final String KEY_TABPAGE_GRAPH = "tabpage_graph";
    public static final String KEY_TABPAGE_CODE = "tabpage_code";
    public static final String KEY_CUSTOM_CONTROL_TRANS_KEY = "schema";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        Tab tab = (Tab)this.getView().getControl(KEY_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject serviceCenterObject = ServiceCenterDao.getDefaultServiceCenterDynamicObject();
        if (null != serviceCenterObject) {
            this.getModel().setValue("service_center", serviceCenterObject.getPkValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String schema = (String)this.getModel().getValue("structure_tag");
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_CODE_EDIT);
            codeEdit.setText(JsonUtil.toPretty((String)schema));
            CustomControl customControl = (CustomControl)this.getView().getControl(KEY_CONTROL_SCHEMA_CREATOR);
            HashMap<String, String> data = new HashMap<String, String>(4);
            data.put(KEY_CUSTOM_CONTROL_TRANS_KEY, schema);
            customControl.setData(data);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (StringUtils.equals((CharSequence)KEY_CONTROL_SCHEMA_CREATOR, (CharSequence)e.getKey())) {
            Map param = (Map)JsonUtil.parse((String)e.getEventArgs(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String schema = (String)param.get(KEY_CUSTOM_CONTROL_TRANS_KEY);
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_CODE_EDIT);
            codeEdit.setText(JsonUtil.toPretty((String)schema));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey()) || "submit".equalsIgnoreCase(formOperate.getOperateKey())) {
            this.handleBeforeSave(args);
            this.getView().updateView();
            return;
        }
        if ("register".equalsIgnoreCase(formOperate.getOperateKey())) {
            String status = this.getModel().getDataEntity(false).getString("status");
            if ("C".equalsIgnoreCase(status)) {
                this.getView().showTipNotification(BeaFeedbackUtils.getTipDataTypeAllowRegister(), ApiErrorCode.TIP_NOTIFICATION_DURATION);
                args.setCancel(true);
            }
            this.handleBeforeSave(args);
            if (args.isCancel()) {
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            OperationResult operationResult = SaveServiceHelper.saveOperate((String)"bea_datatype", (DynamicObject[])new DynamicObject[]{dataEntity}, (OperateOption)OperateOption.create());
            if (!operationResult.isSuccess()) {
                this.getView().showTipNotification(operationResult.getMessage());
            }
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterEventArgs) {
        super.afterDoOperation(afterEventArgs);
        if ("register".equalsIgnoreCase(afterEventArgs.getOperateKey())) {
            this.register();
            this.getView().updateView();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        CodeEdit codeEdit;
        String schema;
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((CharSequence)tabKey, (CharSequence)KEY_TABPAGE_GRAPH) && StringUtils.isNotEmpty((CharSequence)(schema = (codeEdit = (CodeEdit)this.getView().getControl(KEY_CODE_EDIT)).getText()))) {
            CustomControl customControl = (CustomControl)this.getView().getControl(KEY_CONTROL_SCHEMA_CREATOR);
            HashMap<String, String> data = new HashMap<String, String>(4);
            data.put(KEY_CUSTOM_CONTROL_TRANS_KEY, schema);
            customControl.setData(data);
        }
    }

    private void register() {
        ChainDataType chainDataType;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Object pkId = dataEntity.getPkValue();
        String dataTypeName = dataEntity.getString("name");
        String schema = (String)this.getModel().getValue("structure_tag");
        DynamicObject serviceCenter = dataEntity.getDynamicObject("service_center");
        String clientId = serviceCenter.getString("clientid");
        String clientSecret = serviceCenter.getString("clientsecret");
        String chainName = serviceCenter.getString("chainname");
        String bduid = serviceCenter.getString("bduid");
        try {
            String accessToken = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
            chainDataType = KedasClient.createSchema((String)chainName, (String)accessToken, (String)bduid, (String)bduid, (String)dataTypeName, (String)schema);
        }
        catch (KDException e) {
            KDBizException exception = new KDBizException(ExceptionUtil.commonHandleException(e, log), new Object[0]);
            this.getView().showErrorNotification(ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)exception)));
            return;
        }
        String schemaId = chainDataType.getSchemaId();
        DynamicObject dataType = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bea_datatype");
        dataType.set("datatypeid", (Object)schemaId);
        dataType.set("datatypestatus", (Object)"registered");
        dataType.set("status", (Object)"C");
        dataType.set("enable", (Object)"1");
        SaveServiceHelper.update((DynamicObject)dataType);
        dataEntity.set("datatypeid", (Object)schemaId);
        dataEntity.set("datatypestatus", (Object)"registered");
        dataEntity.set("status", (Object)"C");
        this.getModel().setDataChanged(false);
        this.getView().showSuccessNotification(BeaFeedbackUtils.getTipDataTypeRegister());
    }

    private void handleBeforeSave(BeforeDoOperationEventArgs args) {
        List<Entry> entries;
        Object serviceCenter = this.getModel().getValue("service_center");
        if (null == serviceCenter) {
            this.getView().showTipNotification(BeaFeedbackUtils.getTipParamNull((String)ResManager.loadKDString((String)"\u6240\u5c5e\u670d\u52a1\u4e2d\u5fc3", (String)"DataTypeEdit_0", (String)"bsc-bea-plugin", (Object[])new Object[0])));
            args.setCancel(true);
            return;
        }
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_CODE_EDIT);
        String schema = codeEdit.getText();
        if (StringUtils.isBlank((CharSequence)schema)) {
            this.getView().showTipNotification(BeaFeedbackUtils.getTipDataTypeEmptySchema(), ApiErrorCode.TIP_NOTIFICATION_DURATION);
            args.setCancel(true);
            return;
        }
        String message = JsonSchemaUtil.getSchemaValidateMessage((String)schema);
        if (null != message) {
            this.getView().showErrorNotification(BeaFeedbackUtils.getTipDataTypeSchemaInvalid((String)String.format(ResManager.loadKDString((String)"%s\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DataTypeEdit_1", (String)"bsc-bea-plugin", (Object[])new Object[0]), message)));
            args.setCancel(true);
            return;
        }
        this.getModel().setValue("structure_tag", (Object)JsonUtil.prettyToString((String)schema));
        this.getModel().deleteEntryData("entryentity");
        try {
            entries = ParseSchemaUtil.parseJsonSchema(schema);
        }
        catch (Exception e) {
            args.setCancel(true);
            this.getView().showErrorNotification(ExceptionMessageProviderFactory.getProvider().getMessage(e));
            return;
        }
        int count = entries.size();
        if (!entries.isEmpty()) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("entryentity", count);
            for (int i = 0; i < count; ++i) {
                Entry entry = entries.get(i);
                this.getModel().setValue("entryname", (Object)entry.getName(), rowIndex[i]);
                this.getModel().setValue("entryrequired", (Object)entry.getRequired(), rowIndex[i]);
                this.getModel().setValue("entrytype", (Object)entry.getType(), rowIndex[i]);
                this.getModel().setValue("entrydesc", (Object)entry.getDescription(), rowIndex[i]);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String dataTypeStatus = (String)this.getModel().getValue("datatypestatus");
        if (StringUtils.isEmpty((CharSequence)dataTypeStatus)) {
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KEY_CODE_EDIT);
            String schema = codeEdit.getText();
            String schemaTag = (String)this.getModel().getValue("structure_tag");
            try {
                String prettySchema = JsonUtil.prettyToString((String)schema);
                if (!schemaTag.equals(prettySchema)) {
                    this.getModel().setValue("structure_tag", (Object)schema);
                }
            }
            catch (Exception ex) {
                log.error("\u4ee3\u7801\u6846\u4e2dschema\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a{}", (Object)ex.getMessage());
            }
        }
    }
}

