/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.common.util.BeaFeedbackUtils;
import kd.bsc.bea.util.ExceptionUtil;
import org.apache.commons.collections.CollectionUtils;

public class DataTypeList
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(DataTypeList.class);
    public static final String KEY_SYNCHRONIZED = "synchronize";
    public static final String IDENTIFY_BEA_CHAIN_DATATYPE_POP = "bea_datatype_chain_pop";
    public static final String ACTION_BEA_CHAIN_DATA_TYPE_VIEW_CLOSE = "bea_datatype_chain_pop_close";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (KEY_SYNCHRONIZED.equalsIgnoreCase(evt.getItemKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(IDENTIFY_BEA_CHAIN_DATATYPE_POP);
            showParameter.setCaption(ResManager.loadKDString((String)"\u94fe\u4e0a\u6570\u636e\u7c7b\u578b\u5217\u8868", (String)"DataTypeList_0", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTION_BEA_CHAIN_DATA_TYPE_VIEW_CLOSE));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if ("register".equalsIgnoreCase(evt.getOperateKey())) {
            this.traverseRegister(evt.getOperationResult());
            this.getView().updateView();
        }
    }

    private void traverseRegister(OperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        ArrayList pkIds = new ArrayList();
        CollectionUtils.addAll(pkIds, (Object[])new Object[successPkIds.size()]);
        Collections.copy(pkIds, successPkIds);
        List errorInfos = operationResult.getAllErrorInfo();
        for (int i = 0; i < pkIds.size(); ++i) {
            Object pkId = pkIds.get(i);
            DynamicObject dataType = BusinessDataServiceHelper.loadSingle(pkId, (String)"bea_datatype");
            String number = dataType.getString("number");
            String dataTypeName = dataType.getString("name");
            String schema = dataType.getString("structure_tag");
            DynamicObject serviceCenter = dataType.getDynamicObject("service_center");
            String clientId = serviceCenter.getString("clientid");
            String clientSecret = serviceCenter.getString("clientsecret");
            String chainName = serviceCenter.getString("chainname");
            String bduid = serviceCenter.getString("bduid");
            ChainDataType chainDataType = null;
            try {
                String accessToken = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
                chainDataType = KedasClient.createSchema((String)chainName, (String)accessToken, (String)bduid, (String)bduid, (String)dataTypeName, (String)schema);
            }
            catch (KDException e) {
                String message = e.getMessage();
                String errorCode = e.getErrorCode().getCode();
                if (null != e.getErrorCode()) {
                    log.error("API\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u7801\u4e3a\uff1a{}\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)errorCode, (Object)message);
                } else {
                    log.error("API\u8c03\u7528\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)message);
                }
                successPkIds.remove(pkId);
                KDBizException exception = new KDBizException(ExceptionUtil.commonHandleException(e, log), new Object[0]);
                String langMessage = ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)exception));
                this.notifyErrorMessage(number, langMessage, errorInfos);
                continue;
            }
            dataType.set("datatypeid", (Object)chainDataType.getSchemaId());
            dataType.set("status", (Object)"C");
            dataType.set("datatypestatus", (Object)"registered");
            SaveServiceHelper.update((DynamicObject)dataType);
        }
        operationResult.setSuccessPkIds(successPkIds);
        if (successPkIds.size() != 0 && successPkIds.size() == pkIds.size()) {
            this.getView().showSuccessNotification(BeaFeedbackUtils.getTipDataTypeRegister());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)ACTION_BEA_CHAIN_DATA_TYPE_VIEW_CLOSE) && closedCallBackEvent.getReturnData() != null) {
            Map params = (Map)closedCallBackEvent.getReturnData();
            Long pkId = (Long)params.get("pkId");
            String name = String.valueOf(params.get("name"));
            Map chainDataType = null;
            try {
                chainDataType = (Map)DispatchServiceHelper.invokeBizService((String)"bsc", (String)"bea", (String)"ChainDataTypeService", (String)"saveSchemaByName", (Object[])new Object[]{pkId, name});
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)e)));
                return;
            }
            if (ObjectUtils.isEmpty(chainDataType.get("schema_id"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u94fe\u4e0a\u6570\u636e\u7c7b\u578b\u7f6e\u5165\u5931\u8d25\u3002", (String)"DataTypeList_1", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u94fe\u4e0a\u6570\u636e\u7c7b\u578b\u7f6e\u5165\u6210\u529f\u3002", (String)"DataTypeList_2", (String)"bsc-bea-plugin", (Object[])new Object[0]));
            }
        }
        this.getView().updateView();
    }

    private void notifyErrorMessage(String number, String message, List<OperateErrorInfo> errorInfos) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(number + ": " + message);
        errorInfos.add(errorInfo);
    }
}

