/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.model.SchemeDataType;
import kd.bsc.bea.common.model.SchemeMapping;
import kd.bsc.bea.common.model.SchemeTask;
import kd.bsc.bea.common.model.SchemeTemplate;
import kd.bsc.bea.common.util.BeaFeedbackUtils;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.common.util.MetaDataUtils;
import kd.bsc.bea.helper.BeaSchemeHelper;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.util.LocaleStringUtil;
import kd.bsc.bea.util.ResUtils;

public class SchemeEdit
extends AbstractBillPlugIn
implements CellClickListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final Log log = LogFactory.getLog(SchemeEdit.class);
    private static final String KEY_DOUBLE_CLICK_TASK = "task";
    private static final String KEY_DOUBLE_CLICK_MAPPING = "mapping";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid dataTypeEntry = (EntryGrid)this.getView().getControl("datatype");
        EntryGrid mappingEntry = (EntryGrid)this.getView().getControl(KEY_DOUBLE_CLICK_MAPPING);
        EntryGrid taskEntry = (EntryGrid)this.getView().getControl(KEY_DOUBLE_CLICK_TASK);
        dataTypeEntry.addCellClickListener((CellClickListener)this);
        mappingEntry.addCellClickListener((CellClickListener)this);
        taskEntry.addCellClickListener((CellClickListener)this);
        BasedataEdit serviceCenter = (BasedataEdit)this.getView().getControl("service_center");
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org_bduid");
        BasedataEdit user = (BasedataEdit)this.getView().getControl("user_bduid");
        serviceCenter.addAfterF7SelectListener((AfterF7SelectListener)this);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        user.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initControlVisible();
    }

    private void initControlVisible() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        switch (operationStatus) {
            case VIEW: 
            case EDIT: {
                this.saveAfterCallBack();
                break;
            }
            case ADDNEW: {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_import"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_initialize"});
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.beforeSaveOperation(args);
                break;
            }
            case "initialize": 
            case "initandstart": {
                if (!this.getModel().getDataChanged()) break;
                this.getView().showErrorNotification(ResUtils.loadKDString("\u6570\u636e\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u4fdd\u5b58\u540e\u91cd\u8bd5\u3002", "SchemeEdit_5"));
                args.setCancel(true);
                break;
            }
        }
    }

    public void beforeSaveOperation(BeforeDoOperationEventArgs args) {
        int dataTypesSize = this.getModel().getEntryRowCount("datatype");
        int mappingsSize = this.getModel().getEntryRowCount(KEY_DOUBLE_CLICK_MAPPING);
        int tasksSize = this.getModel().getEntryRowCount(KEY_DOUBLE_CLICK_TASK);
        if (0 == dataTypesSize || 0 == mappingsSize || 0 == tasksSize) {
            args.setCancel(true);
            this.getView().showErrorNotification(BeaFeedbackUtils.getTipNotImportTask());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        try {
            switch (args.getOperateKey()) {
                case "import": {
                    this.importAfterCallBack();
                    break;
                }
                case "save": {
                    this.saveAfterCallBack();
                    break;
                }
                case "initialize": {
                    BeaSchemeHelper.initScheme((String)this.getModel().getValue("number"));
                    this.updateStatus();
                    this.getView().showSuccessNotification(BeaFeedbackUtils.getTipSchemeInitSuccess());
                    break;
                }
                case "initandstart": {
                    BeaSchemeHelper.initScheme((String)this.getModel().getValue("number"));
                    BeaSchemeHelper.startTasks((String)this.getModel().getValue("number"));
                    this.updateStatus();
                    this.getView().showSuccessNotification(BeaFeedbackUtils.getTipSchemeInitAndStartSuccess());
                    break;
                }
            }
        }
        catch (KDBizException e) {
            this.getView().showErrorNotification(ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)e)));
        }
    }

    private void importAfterCallBack() {
        String title = ResUtils.loadKDString("\u4e0a\u94fe\u4efb\u52a1\u5bfc\u5165\u5217\u8868", "SchemeEdit_4");
        MetaDataUtils.openPopForm((String)title, (String)"bea_scheme_pop", (String)"bea_scheme_pop_close", (AbstractFormPlugin)this, null);
    }

    private void saveAfterCallBack() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_import"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"initpanelap"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"bar_initialize"});
    }

    private void updateStatus() {
        this.getModel().setValue("status", (Object)"C");
        this.getModel().setDataChanged(false);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (null != evt.getReturnData()) {
            Map params = (Map)evt.getReturnData();
            switch (evt.getActionId()) {
                case "bea_scheme_pop_close": {
                    this.taskImportCloseCallBack(params);
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject serviceCenter = (DynamicObject)this.getModel().getValue("service_center");
        if (serviceCenter == null) {
            this.getView().showTipNotification(BeaFeedbackUtils.getTipNoSelectServiceCenter());
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter filter = new QFilter("service_center_id", "=", serviceCenter.getPkValue());
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.getListFilterParameter().setFilter(filter);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        String serviceCenterPk;
        ListSelectedRow listSelectedRow = afterF7SelectEvent.getListSelectedRow();
        if (listSelectedRow == null) {
            this.getModel().setValue("org_bduid", null);
            this.getModel().setValue("user_bduid", null);
            return;
        }
        String selectedRowPkId = listSelectedRow.getPrimaryKeyValue().toString();
        if (!selectedRowPkId.equals(serviceCenterPk = this.getView().getPageCache().get("service_center_pk"))) {
            this.getModel().setValue("org_bduid", null);
            this.getModel().setValue("user_bduid", null);
        }
        this.getView().getPageCache().put("service_center_pk", selectedRowPkId);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        int row = cellClickEvent.getRow();
        String fieldKey = cellClickEvent.getFieldKey();
        if ("datatype_no".equals(fieldKey) || "datatype_name".equals(fieldKey)) {
            this.showDataTypePreviewPopForm(row);
            return;
        }
        if (fieldKey.contains(KEY_DOUBLE_CLICK_TASK)) {
            this.showTaskPreviewPopForm(row);
            return;
        }
        if (fieldKey.contains(KEY_DOUBLE_CLICK_MAPPING)) {
            this.showMappingPreviewPopForm(row);
        }
    }

    private void showDataTypePreviewPopForm(int row) {
        HashMap<String, String> param = new HashMap<String, String>(10);
        param.put("structure", this.getModel().getValue("schema_tag", row).toString());
        MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u5b58\u8bc1\u5b9e\u4f53\u6a21\u677f\u9884\u89c8", (String)"SchemeEdit_0", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)"bea_datatype_schema_pop", (String)"bea_datatype_schema_pop_close", (AbstractFormPlugin)this, param);
    }

    private void showMappingPreviewPopForm(int row) {
        DynamicObject mapping = (DynamicObject)this.getModel().getEntryEntity(KEY_DOUBLE_CLICK_MAPPING).get(row);
        HashMap<String, String> param = new HashMap<String, String>(10);
        param.put("mapping_no", mapping.getString("mapping_no"));
        param.put("mapping_name", mapping.getString("mapping_name"));
        param.put("mapping_datatype_name", mapping.getString("mapping_datatype_name"));
        param.put("mapping_bizmodel_name", mapping.getString("mapping_bizmodel_name"));
        param.put("data_owner_param", mapping.getString("data_owner_param"));
        param.put("mapping_entry", mapping.getString("mapping_entry_tag"));
        param.put("field_mapping_param", mapping.getString("field_mapping_param"));
        param.put("filter_entry", mapping.getString("filter_entry_tag"));
        param.put("stcc_custom_param", mapping.getString("stcc_custom_param"));
        MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5173\u8054\u6a21\u677f\u9884\u89c8", (String)"SchemeEdit_1", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)"bea_mapping_preview", (String)"bea_mapping_preview_close", (AbstractFormPlugin)this, param);
    }

    private void showTaskPreviewPopForm(int row) {
        DynamicObject task = (DynamicObject)this.getModel().getEntryEntity(KEY_DOUBLE_CLICK_TASK).get(row);
        HashMap<String, Object> param = new HashMap<String, Object>(10);
        param.put("task_no", task.getString("task_no"));
        param.put("task_name", task.getString("task_name"));
        param.put("task_type", task.getString("task_type"));
        param.put("task_mappings", task.getString("task_mappings"));
        param.put("task_cron", task.getString("task_cron"));
        param.put("task_stcdate", task.get("task_stcdate"));
        MetaDataUtils.openPopForm((String)ResManager.loadKDString((String)"\u4e0a\u94fe\u4efb\u52a1\u6a21\u677f\u9884\u89c8", (String)"SchemeEdit_2", (String)"bsc-bea-plugin", (Object[])new Object[0]), (String)"bea_task_preview", (String)"bea_task_preview_close", (AbstractFormPlugin)this, param);
    }

    private void taskImportCloseCallBack(Map<String, Object> params) {
        List taskPks;
        String taskPksJson = (String)params.get("billlistap");
        if (null != taskPksJson && !(taskPks = JsonUtil.parseToList((String)taskPksJson, Long.class)).isEmpty()) {
            SchemeTemplate template = this.constructSchemeTemplate(taskPks);
            this.fillDataToModel(template);
            this.getView().showSuccessNotification(ResUtils.loadKDString("\u5bfc\u5165\u6210\u529f\u3002", "SchemeEdit_3"));
        }
    }

    private void fillDataToModel(SchemeTemplate template) {
        IDataModel model = this.getModel();
        model.deleteEntryData("datatype");
        List dataTypes = template.getDataTypes();
        int[] dataTypeRowIndex = model.batchCreateNewEntryRow("datatype", dataTypes.size());
        for (int i = 0; i < dataTypeRowIndex.length; ++i) {
            int index = dataTypeRowIndex[i];
            SchemeDataType dataType = (SchemeDataType)dataTypes.get(i);
            model.setValue("datatype_no", (Object)dataType.getNumber(), index);
            model.setValue("datatype_name", (Object)dataType.getName(), index);
            model.setValue("schema_tag", (Object)dataType.getSchema(), index);
        }
        model.deleteEntryData(KEY_DOUBLE_CLICK_MAPPING);
        List mappings = template.getMappings();
        int[] mappingRowIndex = model.batchCreateNewEntryRow(KEY_DOUBLE_CLICK_MAPPING, mappings.size());
        for (int i = 0; i < mappingRowIndex.length; ++i) {
            int index = mappingRowIndex[i];
            SchemeMapping mapping = (SchemeMapping)mappings.get(i);
            model.setValue("mapping_no", (Object)mapping.getMappingNumber(), index);
            model.setValue("mapping_name", (Object)mapping.getMappingName(), index);
            model.setValue("mapping_datatype_no", (Object)mapping.getDataTypeNumber(), index);
            model.setValue("mapping_datatype_name", (Object)mapping.getDataTypeName(), index);
            model.setValue("mapping_bizmodel_no", (Object)mapping.getBizModelNumber(), index);
            model.setValue("mapping_bizmodel_name", (Object)mapping.getBizModelName(), index);
            model.setValue("data_owner_param", (Object)mapping.getDataOwnerCustomParam(), index);
            model.setValue("mapping_entry_tag", (Object)mapping.getMappingEntryJson(), index);
            model.setValue("field_mapping_param", (Object)mapping.getMappingEntryCustomParam(), index);
            model.setValue("filter_entry_tag", (Object)mapping.getFilterEntryJson(), index);
            model.setValue("stcc_custom_param", (Object)mapping.getFilterEntryCustomParam(), index);
            model.setValue("bizappid", (Object)mapping.getBizAppId(), index);
        }
        model.deleteEntryData(KEY_DOUBLE_CLICK_TASK);
        List tasks = template.getTasks();
        int[] taskRowIndex = model.batchCreateNewEntryRow(KEY_DOUBLE_CLICK_TASK, tasks.size());
        for (int i = 0; i < taskRowIndex.length; ++i) {
            int index = taskRowIndex[i];
            SchemeTask task = (SchemeTask)tasks.get(i);
            model.setValue("task_no", (Object)task.getNumber(), index);
            model.setValue("task_name", (Object)task.getName(), index);
            model.setValue("task_type", (Object)task.getType(), index);
            model.setValue("task_cron", (Object)task.getCron(), index);
            model.setValue("task_mappings", (Object)String.join((CharSequence)",", task.getMappingNames().toArray(new String[0])), index);
            model.setValue("task_mapping_ids", (Object)String.join((CharSequence)",", task.getMappingNumbers().toArray(new String[0])), index);
            model.setValue("task_stcdate", (Object)task.getStcDate(), index);
        }
        List<String> bizAppIds = mappings.stream().map(SchemeMapping::getBizAppId).distinct().collect(Collectors.toList());
        this.getModel().setValue("bizapps", (Object)bizAppIds.toArray(new String[0]));
    }

    private SchemeTemplate constructSchemeTemplate(List<Long> taskNumbers) {
        MainEntityType taskType = EntityMetadataCache.getDataEntityType((String)"bea_task");
        DynamicObject[] tasks = BusinessDataServiceHelper.load((Object[])taskNumbers.toArray(new Long[0]), (DynamicObjectType)taskType);
        List<SchemeTask> schemeTasks = Arrays.stream(tasks).map(this::toSchemeTask).collect(Collectors.toList());
        List<Long> mappingPks = this.mergeMappingPks(schemeTasks);
        MainEntityType mappingType = EntityMetadataCache.getDataEntityType((String)"bea_mapping");
        DynamicObject[] mappingObjs = BusinessDataServiceHelper.load((Object[])mappingPks.toArray(new Long[0]), (DynamicObjectType)mappingType);
        this.decorateSchemeTask(schemeTasks, mappingObjs);
        List schemeMappings = Arrays.stream(mappingObjs).map(this::toSchemeMapping).collect(Collectors.toList());
        List<Long> dataTypePks = Arrays.stream(mappingObjs).map(m -> m.getLong("datatype_id")).collect(Collectors.toList());
        MainEntityType dataTypeType = EntityMetadataCache.getDataEntityType((String)"bea_datatype");
        DynamicObject[] dataTypeObjs = BusinessDataServiceHelper.load((Object[])dataTypePks.toArray(new Long[0]), (DynamicObjectType)dataTypeType);
        List schemeDataTypes = Arrays.stream(dataTypeObjs).map(this::toSchemeDataType).collect(Collectors.toList());
        return new SchemeTemplate(schemeDataTypes, schemeMappings, schemeTasks);
    }

    private SchemeDataType toSchemeDataType(DynamicObject dataTypeObj) {
        SchemeDataType schemeDataType = new SchemeDataType();
        schemeDataType.setNumber(dataTypeObj.getString("number"));
        schemeDataType.setName(LocaleStringUtil.getValue(dataTypeObj.getLocaleString("name")));
        schemeDataType.setSchema(dataTypeObj.getString("structure_tag"));
        return schemeDataType;
    }

    private SchemeMapping toSchemeMapping(DynamicObject mappingObj) {
        SchemeMapping schemeMapping = new SchemeMapping();
        schemeMapping.setMappingNumber(mappingObj.getString("number"));
        schemeMapping.setMappingName(LocaleStringUtil.getValue(mappingObj.getLocaleString("name")));
        DynamicObject dataTypeObj = mappingObj.getDynamicObject("datatype");
        schemeMapping.setDataTypeNumber(dataTypeObj.getString("number"));
        schemeMapping.setDataTypeName(LocaleStringUtil.getValue(dataTypeObj.getLocaleString("name")));
        DynamicObject bizModelObj = mappingObj.getDynamicObject("bizmodel");
        schemeMapping.setBizModelNumber(bizModelObj.getString("number"));
        schemeMapping.setBizModelName(bizModelObj.getLocaleString("name").getLocaleValue_zh_CN());
        schemeMapping.setBizAppId(mappingObj.getString("bizappid"));
        String dataOwnerCustomParam = mappingObj.getString("data_owner_param");
        schemeMapping.setDataOwnerCustomParam(StringUtils.isNotEmpty((CharSequence)dataOwnerCustomParam) ? dataOwnerCustomParam : null);
        String mappingEntryCustomParam = mappingObj.getString("field_mapping_param");
        schemeMapping.setMappingEntryCustomParam(StringUtils.isNotEmpty((CharSequence)mappingEntryCustomParam) ? mappingEntryCustomParam : null);
        String filterEntryCustomParam = mappingObj.getString("stcc_custom_param");
        schemeMapping.setFilterEntryCustomParam(StringUtils.isNotEmpty((CharSequence)filterEntryCustomParam) ? filterEntryCustomParam : null);
        List<MappingEntry> mappingEntries = BizMappingHelper.objColToMappingEntry(mappingObj.getDynamicObjectCollection("mapping_entry"));
        schemeMapping.setMappingEntryJson(JsonUtil.stringify(mappingEntries));
        List<FilterEntry> filterEntries = BizMappingHelper.objColToFilterEntry(mappingObj.getDynamicObjectCollection("filter_entry"));
        schemeMapping.setFilterEntryJson(JsonUtil.stringify(filterEntries));
        return schemeMapping;
    }

    private SchemeTask toSchemeTask(DynamicObject taskObj) {
        List mappingPks = taskObj.getDynamicObjectCollection("mappings").stream().map(m -> m.getLong("fbasedataid_id")).collect(Collectors.toList());
        SchemeTask schemeTask = new SchemeTask();
        schemeTask.setMappingPks(mappingPks);
        schemeTask.setNumber(taskObj.getString("billno"));
        schemeTask.setName(taskObj.getString("name"));
        schemeTask.setType(taskObj.getString("type"));
        schemeTask.setCron(taskObj.getString("cron"));
        schemeTask.setStcDate(taskObj.getDate("stcdate"));
        return schemeTask;
    }

    private void decorateSchemeTask(List<SchemeTask> schemeTasks, DynamicObject[] mappingObjs) {
        Map<Long, String> namesDict = Arrays.stream(mappingObjs).collect(Collectors.toMap(m -> (Long)m.getPkValue(), m -> LocaleStringUtil.getValue(m.getLocaleString("name"))));
        Map<Long, String> numbersDict = Arrays.stream(mappingObjs).collect(Collectors.toMap(m -> (Long)m.getPkValue(), m -> m.getString("number")));
        for (SchemeTask task : schemeTasks) {
            List pks = task.getMappingPks();
            List names = pks.stream().map(namesDict::get).filter(Objects::nonNull).collect(Collectors.toList());
            List numbers = pks.stream().map(numbersDict::get).filter(Objects::nonNull).collect(Collectors.toList());
            task.setMappingNames(names);
            task.setMappingNumbers(numbers);
        }
    }

    private List<Long> mergeMappingPks(List<SchemeTask> tasks) {
        return tasks.stream().map(SchemeTask::getMappingPks).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }
}

