/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.nio.charset.StandardCharsets;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.model.ChainData;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.util.ExceptionUtil;

public class StcLogPrintPlugin
extends AbstractPrintPlugin {
    private static Log log = LogFactory.getLog(StcLogPrintPlugin.class);
    private static final String KEY_CUSTOM_FIELD_HASH = "hash";
    private static final String KEY_CUSTOM_FIELD_SIZE = "size";
    private static final String KEY_CUSTOM_FIELD_ID = "id";
    private static final String STRING_ZERO = "0";

    public void loadCustomData(CustomDataLoadEvent evt) {
        ChainData chainData;
        super.loadCustomData(evt);
        List customDataRows = evt.getCustomDataRows();
        CustomDataSource dataSource = evt.getDataSource();
        Object pkId = dataSource.getPkId();
        if (null == pkId || StringUtils.isBlank((CharSequence)String.valueOf(pkId)) || STRING_ZERO.equals(String.valueOf(pkId))) {
            customDataRows.add(this.emptyCustomData());
            return;
        }
        DynamicObject stcLog = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"bea_stc_log");
        if (null == stcLog) {
            customDataRows.add(this.emptyCustomData());
            return;
        }
        String stcNo = stcLog.getString("no");
        String dataTypeNo = stcLog.getString("datatypeno");
        DynamicObject serviceCenter = stcLog.getDynamicObject("service_center");
        QFilter filter = new QFilter("number", "=", (Object)dataTypeNo);
        DynamicObject dataType = BusinessDataServiceHelper.loadSingle((String)"bea_datatype", (String)"datatypeid", (QFilter[])filter.toArray());
        try {
            String chainName = serviceCenter.getString("chainname");
            String proxy = serviceCenter.getString("bduid");
            String clientId = serviceCenter.getString("clientid");
            String clientSecret = serviceCenter.getString("clientsecret");
            String token = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
            if (dataType == null) {
                ChainDataType chainDataType = KedasClient.querySchemaByName((String)chainName, (String)token, (String)proxy, (String)stcLog.getString("datatypename"));
                chainData = KedasClient.queryChainDataByIndexId((String)token, (String)chainName, (String)proxy, (String)proxy, (String)chainDataType.getSchemaId(), (String)stcNo);
            } else {
                chainData = KedasClient.queryChainDataByIndexId((String)token, (String)chainName, (String)proxy, (String)proxy, (String)dataType.getString("datatypeid"), (String)stcNo);
            }
        }
        catch (KDException ex) {
            throw new KDBizException(ExceptionUtil.commonHandleException(ex, log), new Object[0]);
        }
        if (chainData != null) {
            DataRowSet dataRowSet = new DataRowSet();
            byte[] data = chainData.getData().toString().getBytes(StandardCharsets.UTF_8);
            dataRowSet.put(KEY_CUSTOM_FIELD_HASH, (Field)new TextField(chainData.getHash()));
            dataRowSet.put(KEY_CUSTOM_FIELD_SIZE, (Field)new TextField(data.length * 8 + "Bit"));
            dataRowSet.put(KEY_CUSTOM_FIELD_ID, (Field)new TextField(chainData.getDataId()));
            customDataRows.add(dataRowSet);
        }
    }

    private DataRowSet emptyCustomData() {
        DataRowSet dataRowSet = new DataRowSet();
        dataRowSet.put(KEY_CUSTOM_FIELD_HASH, null);
        dataRowSet.put(KEY_CUSTOM_FIELD_SIZE, null);
        dataRowSet.put(KEY_CUSTOM_FIELD_ID, (Field)new TextField("this is a QR code."));
        return dataRowSet;
    }
}

