/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.regex.Pattern;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bsc.bea.common.util.BeaFeedbackUtils;

public class TaskManagementEdit
extends AbstractBillPlugIn
implements IDataModelChangeListener {
    private static final Pattern CRON_PATTERN = Pattern.compile("[,*?/\\-\\s\\d]{6,}");

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if ("type".equals(fieldKey)) {
            this.typeChangeCallBack();
            this.typeChangeEmptyTip();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.typeChangeCallBack();
        this.setPageLock();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey())) {
            DynamicObjectCollection rows;
            DynamicObjectCollection mappings = this.getModel().getDataEntity(true).getDynamicObjectCollection("mappings");
            for (DynamicObject mapping : mappings) {
                Object pkValue = mapping.get("fbasedataid_id");
                boolean exists = QueryServiceHelper.exists((String)"bea_mapping", (Object)pkValue);
                if (exists) continue;
                this.getView().showTipNotification(BeaFeedbackUtils.getTipParamNull((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u5173\u8054\u96c6\u5408", (String)"TaskManagementEdit_0", (String)"bsc-bea-plugin", (Object[])new Object[0])));
                args.setCancel(true);
                this.getView().updateView();
                return;
            }
            String type = (String)this.getModel().getValue("type");
            if ("event_callback".equals(type) && (rows = (DynamicObjectCollection)this.getModel().getValue("mappings")).size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7c7b\u578b\u4e3a\u4e8b\u4ef6\u89e6\u53d1\u65f6\u53ea\u652f\u6301\u5355\u9009\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskManagementEdit_1", (String)"bsc-bea-plugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("schedule_task".equals(type)) {
                String cron = (String)this.getModel().getValue("cron");
                if (StringUtils.isNotBlank((CharSequence)cron) && !CRON_PATTERN.matcher(cron).matches()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408cron\u8868\u8fbe\u5f0f\u89c4\u8303\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TaskManagementEdit_2", (String)"bsc-bea-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                } else if (StringUtils.isBlank((CharSequence)cron)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u542f\u52a8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"TaskManagementEdit_3", (String)"bsc-bea-plugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    private void typeChangeCallBack() {
        String type = (String)this.getModel().getValue("type");
        if ("event_callback".equals(type)) {
            this.getModel().setValue("cron", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{"cron"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cron"});
        }
    }

    private void setPageLock() {
        String status = (String)this.getModel().getValue("billstatus");
        if ("A".equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_del"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"contentpanel"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_del"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanel"});
        }
    }

    private void typeChangeEmptyTip() {
        String type = (String)this.getModel().getValue("type");
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        HashMap mapItem = new HashMap(10);
        HashMap<String, String> mapTip = new HashMap<String, String>(10);
        if ("event_callback".equals(type)) {
            mapTip.put("zh_CN", "\u7c7b\u578b\u4e3a\u4e8b\u4ef6\u89e6\u53d1\u65f6\u53ea\u652f\u6301\u5355\u9009");
            mapTip.put("zh_TW", "\u985e\u578b\u70ba\u4e8b\u4ef6\u89f8\u767c\u6642\u53ea\u652f\u6301\u55ae\u9078");
            mapTip.put("en_US", "Only single choice is supported");
        } else {
            mapTip.put("zh_CN", "\u7c7b\u578b\u4e3a\u5b9a\u65f6\u4efb\u52a1\u65f6\u53ef\u652f\u6301\u591a\u9009");
            mapTip.put("zh_TW", "\u985e\u578b\u70ba\u5b9a\u6642\u4efb\u52d9\u6642\u53ef\u652f\u6301\u591a\u9078");
            mapTip.put("en_US", "Support multiple choice");
        }
        mapItem.put("emptytip", mapTip);
        map.put("id", "mappings");
        map.put("item", mapItem);
        this.getView().updateControlMetadata("mappings", map);
    }
}

