/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.plugin;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bsc.bea.common.dao.TaskManageDao;
import kd.bsc.bea.servicehelper.StcTaskServiceHelper;
import kd.bsc.bea.task.BlockchainTask;
import kd.bsc.bea.task.BlockchainTaskHelper;

public class TaskManagementList
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(BlockchainTask.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("new".equalsIgnoreCase(operate.getOperateKey())) {
            this.openNewTask(args);
        }
        if ("delete".equalsIgnoreCase(operate.getOperateKey())) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            this.traverseDeleteTask(selectedRows);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if ("start".equalsIgnoreCase(evt.getOperateKey())) {
            this.batchSwitchTask(evt.getOperationResult(), true);
            this.getView().updateView();
            return;
        }
        if ("stop".equalsIgnoreCase(evt.getOperateKey())) {
            this.batchSwitchTask(evt.getOperationResult(), false);
            this.getView().updateView();
            return;
        }
        if ("chainlog".equals(evt.getOperateKey())) {
            List pkIds = evt.getOperationResult().getSuccessPkIds();
            QFilter filter = this.getTaskBillnoFilters(pkIds);
            this.openLog(filter);
        }
    }

    private QFilter getTaskBillnoFilters(List<Object> pkIds) {
        if (pkIds.isEmpty()) {
            return null;
        }
        DynamicObject beaTask = BusinessDataServiceHelper.newDynamicObject((String)"bea_task");
        DynamicObject[] taskList = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)beaTask.getDynamicObjectType());
        List taskBillnos = Arrays.stream(taskList).map(task -> task.getString("billno")).collect(Collectors.toList());
        return new QFilter("taskno", "in", taskBillnos);
    }

    private void openNewTask(BeforeDoOperationEventArgs args) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("bea_task");
        StyleCss styleCss = new StyleCss();
        styleCss.setHeight("600");
        styleCss.setWidth("880");
        billShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tblnew"));
        this.getView().showForm((FormShowParameter)billShowParameter);
        args.setCancel(true);
    }

    private void openLog(QFilter filter) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("bea_stc_log");
        if (null != filter) {
            ListFilterParameter filterParameter = new ListFilterParameter();
            filterParameter.setQFilters(Arrays.asList(filter.toArray()));
            listShowParameter.setListFilterParameter(filterParameter);
        }
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void traverseDeleteTask(ListSelectedRowCollection selectedRows) {
        for (ListSelectedRow selectedRow : selectedRows) {
            String billStatus = selectedRow.getBillStatus();
            if (!"D".equalsIgnoreCase(billStatus)) continue;
            String billNo = selectedRow.getBillNo();
            DynamicObject task = TaskManageDao.getTaskManagement((String)billNo);
            String jobId = task.getString("jobid");
            String planId = task.getString("planid");
            boolean deletePlan = BlockchainTaskHelper.deletePlan(planId);
            boolean deleteJob = BlockchainTaskHelper.deleteJob(jobId);
            LOG.info("\u5220\u9664plan\uff1a{} \u7ed3\u679c\uff1a{}\uff0c\u5220\u9664Job\uff1a{} \u7ed3\u679c\uff1a{}", new Object[]{planId, deletePlan, jobId, deleteJob});
        }
    }

    private void batchSwitchTask(OperationResult operationResult, boolean toStart) {
        List successPkIds = operationResult.getSuccessPkIds();
        List pkIds = successPkIds.stream().map(i -> (Long)i).collect(Collectors.toList());
        List errorInfos = operationResult.getAllErrorInfo();
        List startTaskResults = toStart ? StcTaskServiceHelper.startTasks(pkIds) : StcTaskServiceHelper.stopTasks(pkIds);
        for (Map result : startTaskResults) {
            String errorMessage = (String)result.get("errorMessage");
            String taskBillNo = (String)result.get("taskBillNo");
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setLevel(ErrorLevel.Error);
            errorInfo.setMessage(taskBillNo + ": " + errorMessage);
            errorInfos.add(errorInfo);
        }
        List failTaskPkIds = startTaskResults.stream().map(e -> (Long)e.get("taskPkId")).collect(Collectors.toList());
        successPkIds.removeAll(failTaskPkIds);
        operationResult.setSuccessPkIds(successPkIds);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().updateView();
    }
}

