/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.task;

import java.util.Calendar;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.serviceImpl.JobDispatcherImpl;
import kd.bos.schedule.serviceImpl.ScheduleManagerImpl;

public class BlockchainTaskHelper {
    private static final String APP_ID_BEA = "bea";
    private static final String TASK_CLASS_NAME = "kd.bsc.bea.task.BlockchainTask";

    public static String createOnceJob(JobInfo jobInfo) {
        return JobClient.dispatch((JobInfo)jobInfo);
    }

    public static String createJob(JobInfo jobInfo) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.createJob(jobInfo);
    }

    public static String dispatcherJob(JobInfo jobInfo) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.dispatch(jobInfo);
    }

    public static String createPlan(PlanInfo planInfo) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.createPlan(planInfo);
    }

    public static void disableJob(String jobId) {
        ScheduleManagerImpl scheduleManager = new ScheduleManagerImpl();
        scheduleManager.disableJob(jobId);
    }

    public static void enableJod(String jobId) {
        ScheduleManagerImpl scheduleManager = new ScheduleManagerImpl();
        scheduleManager.enableJob(jobId);
    }

    public static boolean deleteJob(String jobId) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.deleteJob(jobId);
    }

    public static boolean deletePlan(String planId) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.deletePlan(planId);
    }

    public static TaskInfo queryTask(String taskId) {
        JobDispatcherImpl jobDispatcher = new JobDispatcherImpl();
        return jobDispatcher.queryTask(taskId);
    }

    public static JobInfo prepareJobInfo(String jobName, Map<String, Object> params) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName("kingdee-block-chain-job:" + jobName);
        jobInfo.setAppId(APP_ID_BEA);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setTaskClassname(TASK_CLASS_NAME);
        jobInfo.setRunConcurrently(false);
        jobInfo.setParams(params);
        RequestContext requestContext = RequestContext.get();
        jobInfo.setRunByLang(requestContext.getLang());
        return jobInfo;
    }

    public static PlanInfo preparePlanInfo(String taskBillNo, String jobId, String planName, String cronExpression) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setNumber("STC-PLAN-" + taskBillNo);
        planInfo.setJobId(jobId);
        planInfo.setName("kingdee-block-chain-plan:" + planName);
        planInfo.setCronExpression(cronExpression);
        Calendar startTime = Calendar.getInstance();
        planInfo.setStartTime(startTime);
        Calendar endTime = Calendar.getInstance();
        endTime.add(1, 30);
        planInfo.setEndTime(endTime);
        return planInfo;
    }
}

