/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.task;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bsc.bcc.common.api.KbdusClient;
import kd.bsc.bea.common.api.KedasClient;
import kd.bsc.bea.common.dao.TaskManageDao;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.ChainData;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.model.MicroServiceParam;
import kd.bsc.bea.common.util.DateUtil;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.dao.MappingOwnershipHelper;
import kd.bsc.bea.servicehelper.BizModelDataQueryServiceHelper;
import kd.bsc.bea.servicehelper.BizModelToDataTypeServiceHelper;
import kd.bsc.bea.task.BlockchainTask;
import kd.bsc.bea.util.MappingUtil;

public class TaskUtil {
    private static final Log log = LogFactory.getLog(BlockchainTask.class);

    public static void toChain(Map<String, Object> params) {
        String[] pkIdArray;
        String taskBillno = params.get("billno").toString();
        String taskName = params.get("name").toString();
        Object STCDateObject = params.get("stcdate");
        Long STCDate = TaskUtil.getLong(STCDateObject);
        DynamicObject taskManagement = TaskManageDao.getTaskManagement((String)taskBillno);
        Object recordDateObject = taskManagement.get("recorddate");
        Long recordDate = TaskUtil.getDate(recordDateObject);
        Long newRecordDate = DateUtil.getCurrentNanos();
        TaskManageDao.updateRecordDate((String)taskBillno, (Long)newRecordDate);
        Object pkIds = params.get("pkIds");
        for (String mappingPkId : pkIdArray = String.valueOf(pkIds).split(",")) {
            DynamicObject mappingObject = BusinessDataServiceHelper.loadSingle((Object)mappingPkId, (String)"bea_mapping");
            List<DynamicObject> bizModelDataRows = TaskUtil.queryBizModelData(mappingObject, STCDate, recordDate);
            TaskUtil.mappingTransformAndUpload(taskBillno, taskName, mappingObject, bizModelDataRows.toArray(new DynamicObject[0]));
        }
    }

    private static List<DynamicObject> queryBizModelData(DynamicObject mappingObj, Long stcDate, Long recordDate) {
        Long mappingPkId = (Long)mappingObj.getPkValue();
        Long lastStcTime = DateUtil.getAfterDate((Long)stcDate, (Long)recordDate);
        String mserviceParamJson = mappingObj.getString("stcc_custom_param");
        Object[] objParams = new Object[]{mappingPkId, lastStcTime, null};
        if (StringUtils.isNotBlank((CharSequence)mserviceParamJson)) {
            MicroServiceParam serviceParam = (MicroServiceParam)JsonUtil.parse((String)mserviceParamJson, MicroServiceParam.class);
            if (StringUtils.isBlank((CharSequence)serviceParam.getCloudNumber())) {
                return (List)DispatchServiceHelper.invokeBOSService((String)serviceParam.getAppNumber(), (String)serviceParam.getServiceName(), (String)serviceParam.getMethodName(), (Object[])objParams);
            }
            return (List)DispatchServiceHelper.invokeBizService((String)serviceParam.getCloudNumber().toLowerCase(), (String)serviceParam.getAppNumber(), (String)serviceParam.getServiceName(), (String)serviceParam.getMethodName(), (Object[])objParams);
        }
        return BizModelDataQueryServiceHelper.query((Long)mappingPkId, (Long)lastStcTime, null);
    }

    private static Map<String, Object> getOwnership(DynamicObject mappingObject) {
        Long mappingPkId = (Long)mappingObject.getPkValue();
        Object[] params = new Object[]{mappingPkId, null};
        String mserviceParamJson = mappingObject.getString("data_owner_param");
        if (StringUtils.isNotBlank((CharSequence)mserviceParamJson)) {
            MicroServiceParam serviceParam = (MicroServiceParam)JsonUtil.parse((String)mserviceParamJson, MicroServiceParam.class);
            if (StringUtils.isBlank((CharSequence)serviceParam.getCloudNumber())) {
                return (Map)DispatchServiceHelper.invokeBOSService((String)serviceParam.getAppNumber(), (String)serviceParam.getServiceName(), (String)serviceParam.getMethodName(), (Object[])params);
            }
            return (Map)DispatchServiceHelper.invokeBizService((String)serviceParam.getCloudNumber().toLowerCase(), (String)serviceParam.getAppNumber(), (String)serviceParam.getServiceName(), (String)serviceParam.getMethodName(), (Object[])params);
        }
        return MappingOwnershipHelper.getOwnership(mappingPkId);
    }

    public static Map<String, Object> parseMappingEntry(DynamicObject mappingObject, DynamicObject bizModelData) {
        Long mappingPkId = (Long)mappingObject.getPkValue();
        String mserviceParamJson = mappingObject.getString("field_mapping_param");
        if (StringUtils.isNotBlank((CharSequence)mserviceParamJson)) {
            Object[] params = new Object[]{mappingPkId, bizModelData};
            MicroServiceParam mappingEntryParam = (MicroServiceParam)JsonUtil.parse((String)mserviceParamJson, MicroServiceParam.class);
            if (StringUtils.isBlank((CharSequence)mappingEntryParam.getCloudNumber())) {
                return (Map)DispatchServiceHelper.invokeBOSService((String)mappingEntryParam.getAppNumber(), (String)mappingEntryParam.getServiceName(), (String)mappingEntryParam.getMethodName(), (Object[])params);
            }
            return (Map)DispatchServiceHelper.invokeBizService((String)mappingEntryParam.getCloudNumber().toLowerCase(), (String)mappingEntryParam.getAppNumber(), (String)mappingEntryParam.getServiceName(), (String)mappingEntryParam.getMethodName(), (Object[])params);
        }
        return BizModelToDataTypeServiceHelper.transform((Long)mappingPkId, (DynamicObject)bizModelData);
    }

    public static void collectionSort(DynamicObjectCollection collection) {
        collection.sort(Comparator.comparing(o -> o.getPkValue().toString()));
    }

    public static void mappingTransformAndUpload(String taskNo, String taskName, DynamicObject mappingObject, DynamicObject[] bizModelDataRows) {
        DynamicObject bizModel = mappingObject.getDynamicObject("bizmodel");
        DynamicObject dataType = mappingObject.getDynamicObject("datatype");
        String dataTypeId = dataType.getString("datatypeid");
        DynamicObjectCollection entries = mappingObject.getDynamicObjectCollection("mapping_entry");
        TaskUtil.collectionSort(entries);
        Map<String, MappingEntry> mappingEntryMap = MappingUtil.getMappingEntryMap(entries);
        for (DynamicObject bizModelDataRow : bizModelDataRows) {
            String indexId = ID.genStringId();
            String bduidType = null;
            Object serviceCenterPkId = null;
            Object bduidPkId = null;
            ChainData chainData = null;
            String bizBillNo = bizModelDataRow.getString("billno");
            Map<String, Object> dataMap = new LinkedHashMap<String, Object>(16);
            try {
                Map<String, Object> ownership = TaskUtil.getOwnership(mappingObject);
                bduidType = (String)ownership.get("type");
                serviceCenterPkId = ownership.get("serviceCenterPkId");
                bduidPkId = ownership.get("bduIdPkId");
                DynamicObject serviceCenter = BusinessDataServiceHelper.loadSingle((Object)serviceCenterPkId, (String)"bcc_service_center");
                String chainName = serviceCenter.getString("chainname");
                String proxy = serviceCenter.getString("bduid");
                String clientId = serviceCenter.getString("clientid");
                String clientSecret = serviceCenter.getString("clientsecret");
                String ownerBduid = MappingOwnershipHelper.getOwnerBduid(bduidType, serviceCenterPkId, bduidPkId);
                dataMap = TaskUtil.parseMappingEntry(mappingObject, bizModelDataRow);
                String accessToken = KbdusClient.getToken((String)clientId, (String)clientSecret).getAccessToken();
                chainData = KedasClient.toChain((String)chainName, (String)accessToken, (String)proxy, (String)ownerBduid, (String)ownerBduid, (String)dataTypeId, (String)indexId, dataMap);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String errorStack = sw.toString();
                String errorMessage = ExceptionMessageProviderFactory.getProvider().getMessage(e);
                log.error("\u4e0a\u94fe\u5931\u8d25\uff0c\u9519\u8bef\u6982\u8981\u4fe1\u606f\u4e3a\uff1a{}\uff0c\u9519\u8bef\u8be6\u7ec6\u4fe1\u606f\u4e3a\uff1a{}", (Object)errorMessage, (Object)errorStack);
                DynamicObject stcLog = TaskUtil.generateSTCLog("B", indexId, bizModel, bizBillNo, taskNo, taskName, chainData, dataType, mappingObject, mappingEntryMap, dataMap, errorMessage, errorStack, bduidType, serviceCenterPkId, bduidPkId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stcLog});
                continue;
            }
            DynamicObject stcLog = TaskUtil.generateSTCLog("A", indexId, bizModel, bizBillNo, taskNo, taskName, chainData, dataType, mappingObject, mappingEntryMap, dataMap, null, null, bduidType, serviceCenterPkId, bduidPkId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stcLog});
        }
    }

    public static Long getDate(Object dateObject) {
        if (null != dateObject) {
            Date date = (Date)dateObject;
            return date.getTime();
        }
        return null;
    }

    public static Long getLong(Object longObject) {
        if (null != longObject) {
            return Long.valueOf(longObject.toString());
        }
        return null;
    }

    public static DynamicObject generateSTCLog(String stcStatus, String indexId, DynamicObject bizModel, String bizBillNo, String taskNo, String taskName, ChainData chainData, DynamicObject dataType, DynamicObject mappingObject, Map<String, MappingEntry> mappingEntryMap, Map<String, Object> dataMap, String errorMessage, String errorStack, String bduidType, Object serviceCenterPkId, Object bduidPkId) {
        DynamicObject stcLog = BusinessDataServiceHelper.newDynamicObject((String)"bea_stc_log");
        stcLog.set("no", (Object)indexId);
        stcLog.set("taskno", (Object)taskNo);
        stcLog.set("taskname", (Object)taskName);
        if (null != chainData) {
            stcLog.set("createtime", (Object)chainData.getCreateTime());
            stcLog.set("txid", (Object)chainData.getTxId());
        } else {
            stcLog.set("createtime", (Object)DateUtil.getCurrentNanos());
        }
        stcLog.set("mappingno", (Object)mappingObject.getString("number"));
        stcLog.set("mappingname", (Object)mappingObject.getString("name"));
        stcLog.set("datatypeno", (Object)dataType.getString("number"));
        stcLog.set("datatypename", (Object)dataType.getString("name"));
        stcLog.set("bizobjno", (Object)bizModel.getString("number"));
        stcLog.set("bizobjname", (Object)bizModel.getString("name"));
        stcLog.set("bizbillno", (Object)bizBillNo);
        stcLog.set("status", (Object)stcStatus);
        stcLog.set("retrytimes", (Object)0);
        if (!ObjectUtils.isEmpty((Object)errorMessage)) {
            stcLog.set("error", TaskUtil.truncateLongValue(errorMessage));
            stcLog.set("error_tag", (Object)errorStack);
        }
        stcLog.set("bduid_type", (Object)bduidType);
        stcLog.set("service_center", serviceCenterPkId);
        if ("service_center".equalsIgnoreCase(bduidType)) {
            stcLog.set("service_center", serviceCenterPkId);
        } else if ("org".equalsIgnoreCase(bduidType)) {
            stcLog.set("org_bduid", bduidPkId);
        } else {
            stcLog.set("user_bduid", bduidPkId);
        }
        DynamicObjectCollection logEntries = (DynamicObjectCollection)stcLog.get("entryentity");
        Set<Map.Entry<String, MappingEntry>> entrySet = mappingEntryMap.entrySet();
        int index = 0;
        for (Map.Entry<String, MappingEntry> entry : entrySet) {
            String dataTypeName = entry.getKey();
            MappingEntry mappingEntry = entry.getValue();
            DynamicObject entryObject = logEntries.addNew();
            entryObject.set("name", (Object)dataTypeName);
            entryObject.set("type", (Object)mappingEntry.getDataTypeType());
            entryObject.set("desc", (Object)mappingEntry.getDataTypeDesc());
            TaskUtil.parseValue(dataMap, mappingEntry, entryObject);
            entryObject.set("seq", (Object)index);
            ++index;
        }
        return stcLog;
    }

    public static void parseValue(Map<String, Object> dataMap, MappingEntry mappingEntry, DynamicObject entryObject) {
        String dataTypeName = mappingEntry.getDataTypeName();
        String dataTypeType = mappingEntry.getDataTypeType();
        if (MappingUtil.isObjectArrayType(dataTypeType) || MappingUtil.isObjectType(dataTypeType)) {
            return;
        }
        if (MappingUtil.isArrayType(dataTypeType)) {
            List<Object> list = TaskUtil.parseBasicEntryType(dataMap, mappingEntry);
            entryObject.set("value", (Object)TaskUtil.truncateList(list));
            entryObject.set("value_tag", (Object)list.toString());
        } else if (MappingUtil.isArrayTypeObjectsInside(dataTypeName)) {
            List<Object> list = TaskUtil.parseObjectArrayEntryType(dataMap, mappingEntry);
            entryObject.set("value", (Object)TaskUtil.truncateList(list));
            entryObject.set("value_tag", (Object)list.toString());
        } else {
            Object value = TaskUtil.parseBasicType(dataMap, mappingEntry);
            if (dataTypeType.equalsIgnoreCase("string") && mappingEntry.getBizName().contains(",")) {
                entryObject.set("value", TaskUtil.truncateLongValue(value));
                entryObject.set("value_tag", (Object)String.valueOf(value));
            } else {
                entryObject.set("value", value);
                entryObject.set("value_tag", value);
            }
        }
    }

    private static Object truncateLongValue(Object value) {
        String str = (String)value;
        if (str.length() > 250) {
            return str.substring(0, 250) + "...";
        }
        return str;
    }

    private static String truncateList(List<Object> list) {
        String resultStr = list.toString();
        if (resultStr.length() > 250) {
            return resultStr.substring(0, 250) + "...";
        }
        return resultStr;
    }

    private static List<Object> parseObjectArrayEntryType(Map<String, Object> dataMap, MappingEntry mappingEntry) {
        String[] names = mappingEntry.getDataTypeName().split("\\[ \\]\\.");
        String objectKeyName = names[names.length - 1];
        String listKey = names[names.length - 2];
        List list = (List)dataMap.get(listKey);
        LinkedList<Object> result = new LinkedList<Object>();
        for (Map map : list) {
            Object object = map.get(objectKeyName);
            if (!ObjectUtils.isEmpty(object)) {
                result.add(object);
                continue;
            }
            result.add("-");
        }
        return result;
    }

    private static List<Object> parseBasicEntryType(Map<String, Object> dataMap, MappingEntry mappingEntry) {
        String dataTypeName = mappingEntry.getDataTypeName();
        List<Object> list = null;
        if (dataTypeName.contains(".")) {
            String[] names = dataTypeName.split("\\.");
            String mapKey = names[names.length - 2];
            Map map = (Map)dataMap.get(mapKey);
            String listKey = names[names.length - 1];
            list = mappingEntry.getDataTypeType().contains("string") ? TaskUtil.handleStringList((List)map.get(listKey)) : (List<Object>)map.get(listKey);
        } else {
            list = mappingEntry.getDataTypeType().contains("string") ? TaskUtil.handleStringList((List)dataMap.get(dataTypeName)) : (List<Object>)dataMap.get(dataTypeName);
        }
        return list;
    }

    private static List<Object> handleStringList(List<Object> list) {
        LinkedList<Object> objects = new LinkedList<Object>();
        for (Object object : list) {
            if (ObjectUtils.isEmpty((Object)object)) {
                objects.add("\"\"");
                continue;
            }
            objects.add(object);
        }
        return objects;
    }

    private static Object parseBasicType(Map<String, Object> dataMap, MappingEntry mappingEntry) {
        String dataTypeName = mappingEntry.getDataTypeName();
        if (dataTypeName.contains(".")) {
            String[] names = dataTypeName.split("\\.");
            dataTypeName = names[names.length - 1];
            Map map = null;
            String mapKey = names[names.length - 2];
            if (names.length == 3) {
                String outerLayerMapKey = names[names.length - 3];
                Map outerLayerMap = (Map)dataMap.get(outerLayerMapKey);
                map = (Map)outerLayerMap.get(mapKey);
            } else {
                map = (Map)dataMap.get(mapKey);
            }
            return map.get(dataTypeName);
        }
        return dataMap.get(dataTypeName);
    }
}

