/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.util;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bsc.bea.common.model.AggFunParam;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.DataTransformDepend;
import kd.bsc.bea.common.model.Mapping;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.model.MappingMain;
import kd.bsc.bea.common.util.FunctionUtil;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.converter.DataConverter;
import kd.bsc.bea.exception.BeaErrorCode;
import kd.bsc.bea.helper.AttachmentHelper;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.helper.ConvRuleHelper;

public class MappingUtil {
    public static final String BIZMODEL_TYPE_DATE = "date";
    public static final String SCHEMA_TYPE_INTEGER = "integer";
    public static final String SCHEMA_TYPE_NUMBER = "number";
    public static final String SCHEMA_TYPE_STRING = "string";
    public static final String SYMBOL_ENTRY = "\\[ \\]\\.";

    public static Map<String, Object> parseMappingEntry(Map<String, MappingEntry> mappingEntryMap, DynamicObject bizObject, Mapping mapping) {
        Map<String, Object> resultMap = MappingUtil.initLayerMap(mappingEntryMap, bizObject);
        for (Map.Entry<String, MappingEntry> entry : mappingEntryMap.entrySet()) {
            String dataTypeName = entry.getKey();
            MappingEntry mappingEntry = entry.getValue();
            String dataTypeType = mappingEntry.getDataTypeType();
            if (MappingUtil.isObjectArrayType(dataTypeType) || MappingUtil.isObjectType(dataTypeType)) continue;
            if (MappingUtil.isArrayType(dataTypeType)) {
                MappingUtil.handleBasicArrayType(resultMap, mappingEntry, bizObject, mapping);
                continue;
            }
            if (MappingUtil.isArrayTypeObjectsInside(dataTypeName)) {
                MappingUtil.handleArrayTypeObjectsInside(resultMap, mappingEntry, bizObject);
                continue;
            }
            MappingUtil.handleBasicType(resultMap, mappingEntry, bizObject, mapping);
        }
        return resultMap;
    }

    public static void handleBasicArrayType(Map<String, Object> resultMap, MappingEntry mappingEntry, DynamicObject bizObject, Mapping mapping) {
        List<Object> list = MappingUtil.parseBasicEntryList(resultMap, mappingEntry);
        String aggFunc = mappingEntry.getAggFunc();
        if (StringUtils.isNotBlank((CharSequence)aggFunc)) {
            if ("stringify".equals(aggFunc) || "hash".equals(aggFunc)) {
                String entryIdentify = MappingUtil.parseEntryIdentify(mappingEntry.getBizName());
                DynamicObjectCollection entries = bizObject.getDynamicObjectCollection(entryIdentify);
                for (DynamicObject dynamicObject : entries) {
                    String entryResult = MappingUtil.aggCalculateStringifyOrHash(mappingEntry, bizObject, dynamicObject);
                    list.add(entryResult);
                }
            } else if ("fileHash".equals(aggFunc)) {
                List<String> hashList = MappingUtil.aggCalculateFileHash(mappingEntry, bizObject, mapping.getBizModel());
                list.addAll(hashList);
            }
            return;
        }
        String bizNameValue = mappingEntry.getBizName();
        if (!ObjectUtils.isEmpty((Object)bizNameValue)) {
            String[] bizNames = bizNameValue.split(SYMBOL_ENTRY);
            String bizName = bizNames[bizNames.length - 1];
            String entryIdentify = bizNames[bizNames.length - 2];
            DynamicObjectCollection entries = bizObject.getDynamicObjectCollection(entryIdentify);
            String dataTypeType = mappingEntry.getDataTypeType();
            entries.stream().map(entry -> entry.get(bizName)).map(value -> {
                if (StringUtils.isNotEmpty((CharSequence)mappingEntry.getConvRule())) {
                    return MappingUtil.getConvRuleOutput(mappingEntry, value, (MappingMain)mapping);
                }
                if (!ObjectUtils.isEmpty((Object)value)) {
                    if (mappingEntry.getBizType().contains(BIZMODEL_TYPE_DATE)) {
                        value = ((Date)value).getTime();
                        value = String.valueOf(value);
                        if (dataTypeType.contains(SCHEMA_TYPE_NUMBER) || dataTypeType.contains(SCHEMA_TYPE_INTEGER)) {
                            value = new BigInteger(String.valueOf(value));
                        }
                    } else if (dataTypeType.contains(SCHEMA_TYPE_STRING)) {
                        value = String.valueOf(value);
                    }
                } else {
                    value = dataTypeType.contains(SCHEMA_TYPE_STRING) ? "" : (dataTypeType.contains(SCHEMA_TYPE_NUMBER) || dataTypeType.contains(SCHEMA_TYPE_INTEGER) ? (Constable)Integer.valueOf(0) : (Constable)Boolean.FALSE);
                }
                return value;
            }).forEach(list::add);
        }
    }

    public static void handleArrayTypeObjectsInside(Map<String, Object> resultMap, MappingEntry mappingEntry, DynamicObject bizObject) {
        String aggFunc = mappingEntry.getAggFunc();
        if (StringUtils.isNotBlank((CharSequence)aggFunc)) {
            if ("stringify".equals(aggFunc) || "hash".equals(aggFunc)) {
                String[] dataTypeNames = mappingEntry.getDataTypeName().split(SYMBOL_ENTRY);
                String objectKeyName = dataTypeNames[dataTypeNames.length - 1];
                String listKey = dataTypeNames[dataTypeNames.length - 2];
                List list = (List)resultMap.get(listKey);
                String entryIdentify = MappingUtil.parseEntryIdentify(mappingEntry.getBizName());
                DynamicObjectCollection entries = bizObject.getDynamicObjectCollection(entryIdentify);
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)entries.get(i);
                    Map map = (Map)list.get(i);
                    String entryResult = MappingUtil.aggCalculateStringifyOrHash(mappingEntry, bizObject, dynamicObject);
                    map.put(objectKeyName, entryResult);
                }
            }
            return;
        }
        String bizNameValue = mappingEntry.getBizName();
        if (!ObjectUtils.isEmpty((Object)bizNameValue)) {
            String[] names = mappingEntry.getDataTypeName().split(SYMBOL_ENTRY);
            String objectKeyName = names[names.length - 1];
            String listKey = names[names.length - 2];
            List list = (List)resultMap.get(listKey);
            String[] bizNames = bizNameValue.split(SYMBOL_ENTRY);
            String bizName = bizNames[bizNames.length - 1];
            String entryIdentify = bizNames[bizNames.length - 2];
            DynamicObjectCollection entries = bizObject.getDynamicObjectCollection(entryIdentify);
            for (int i = 0; i < entries.size(); ++i) {
                Map map = (Map)list.get(i);
                DynamicObject entryObject = (DynamicObject)entries.get(i);
                Object bizValue = entryObject.get(bizName);
                String dataTypeType = mappingEntry.getDataTypeType();
                if (!ObjectUtils.isEmpty((Object)bizValue)) {
                    MappingUtil.handleData(map, mappingEntry, bizValue, objectKeyName);
                    continue;
                }
                if (!mappingEntry.getRequired().booleanValue()) continue;
                if (dataTypeType.contains(SCHEMA_TYPE_STRING)) {
                    map.put(objectKeyName, "");
                    continue;
                }
                if (dataTypeType.contains("boolean")) {
                    map.put(objectKeyName, Boolean.FALSE);
                    continue;
                }
                map.put(objectKeyName, 0);
            }
        }
    }

    public static String parseEntryIdentify(String bizName) {
        String[] names;
        for (String name : names = bizName.split(",")) {
            if (!MappingUtil.isArrayType(name)) continue;
            String[] bizNames = name.split(SYMBOL_ENTRY);
            return bizNames[bizNames.length - 2];
        }
        return null;
    }

    public static List<Object> parseBasicEntryList(Map<String, Object> resultMap, MappingEntry mappingEntry) {
        String dataTypeName = mappingEntry.getDataTypeName();
        List list = null;
        if (dataTypeName.contains(".")) {
            String[] names = dataTypeName.split("\\.");
            String mapKey = names[names.length - 2];
            Map map = (Map)resultMap.get(mapKey);
            String listKey = names[names.length - 1];
            list = (List)map.get(listKey);
        } else {
            list = (List)resultMap.get(dataTypeName);
        }
        return list;
    }

    public static void handleBasicType(Map<String, Object> resultMap, MappingEntry mappingEntry, DynamicObject bizObject, Mapping mapping) {
        String dataTypeName = mappingEntry.getDataTypeName();
        if (dataTypeName.contains(".")) {
            String[] names = dataTypeName.split("\\.");
            dataTypeName = names[names.length - 1];
            Map map = null;
            String mapKey = names[names.length - 2];
            if (names.length == 3) {
                String outerLayerMapKey = names[names.length - 3];
                Map outerLayerMap = (Map)resultMap.get(outerLayerMapKey);
                map = (Map)outerLayerMap.get(mapKey);
            } else {
                map = (Map)resultMap.get(mapKey);
            }
            MappingUtil.handleBasicMapping(map, mappingEntry, dataTypeName, bizObject, mapping);
        } else {
            MappingUtil.handleBasicMapping(resultMap, mappingEntry, dataTypeName, bizObject, mapping);
        }
    }

    public static void handleBasicMapping(Map<String, Object> map, MappingEntry mappingEntry, String dataTypeName, DynamicObject bizObject, Mapping mapping) {
        Object bizValue;
        String dataTypeType = mappingEntry.getDataTypeType();
        String fixedValue = mappingEntry.getFixedValue();
        String aggFunc = mappingEntry.getAggFunc();
        String bizName = mappingEntry.getBizName();
        String convRule = mappingEntry.getConvRule();
        if (StringUtils.isNotBlank((CharSequence)fixedValue)) {
            MappingUtil.handleFixed(map, dataTypeName, dataTypeType, fixedValue);
        } else if (StringUtils.isNotBlank((CharSequence)aggFunc)) {
            MappingUtil.aggCalculate(map, dataTypeName, mappingEntry, bizObject, mapping.getBizModel());
        } else if (StringUtils.isNotEmpty((CharSequence)convRule)) {
            MappingUtil.handleConvRule(map, dataTypeName, mappingEntry, bizObject, (MappingMain)mapping);
        } else if (mappingEntry.getRequired().booleanValue()) {
            Object bizValue2 = bizObject.get(bizName);
            if (ObjectUtils.isEmpty((Object)bizValue2)) {
                throw new KDBizException(BeaErrorCode.NULL_VALUE_EXCEPTION, new Object[]{bizName});
            }
            MappingUtil.handleData(map, mappingEntry, bizValue2, dataTypeName);
        } else if (StringUtils.isNotEmpty((CharSequence)bizName) && !ObjectUtils.isEmpty((Object)(bizValue = bizObject.get(bizName)))) {
            MappingUtil.handleData(map, mappingEntry, bizValue, dataTypeName);
        }
    }

    private static Object getConvRuleOutput(MappingEntry mappingEntry, Object input, MappingMain mappingMain) {
        DataConverter<Object, Object> converter = ConvRuleHelper.getConverterDict().get(mappingEntry.getConvRule());
        if (null == converter) {
            throw new KDException(BeaErrorCode.UNKNOWN_EXCEPTION, new Object[]{String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u8f6c\u6362\u89c4\u5219\uff1a%s", (String)"MappingUtil_0", (String)"bsc-bea-plugin", (Object[])new Object[0]), mappingEntry.getConvRule())});
        }
        DataTransformDepend depend = new DataTransformDepend();
        depend.setMain(mappingMain);
        depend.setEntry(mappingEntry);
        return converter.transform(input, depend);
    }

    private static void handleConvRule(Map<String, Object> map, String dataTypeName, MappingEntry mappingEntry, DynamicObject bizObject, MappingMain mappingMain) {
        Object output = MappingUtil.getConvRuleOutput(mappingEntry, bizObject.get(mappingEntry.getBizName()), mappingMain);
        map.put(dataTypeName, output);
    }

    public static void handleData(Map<String, Object> map, MappingEntry mappingEntry, Object bizValue, String key) {
        String dataTypeType = mappingEntry.getDataTypeType();
        if (mappingEntry.getBizType().contains(BIZMODEL_TYPE_DATE)) {
            Date date = (Date)bizValue;
            if (dataTypeType.contains(SCHEMA_TYPE_STRING)) {
                MappingUtil.putValue(dataTypeType, key, String.valueOf(date.getTime()), map);
            } else if (dataTypeType.contains(SCHEMA_TYPE_NUMBER) || dataTypeType.contains(SCHEMA_TYPE_INTEGER)) {
                MappingUtil.putValue(dataTypeType, key, new BigInteger(String.valueOf(date.getTime())), map);
            }
        } else {
            MappingUtil.putValue(dataTypeType, key, bizValue, map);
        }
    }

    public static void putValue(String type, String key, Object value, Map<String, Object> map) {
        if (type.equalsIgnoreCase(SCHEMA_TYPE_STRING)) {
            map.put(key, String.valueOf(value));
        } else {
            map.put(key, value);
        }
    }

    public static Map<String, Object> initLayerMap(Map<String, MappingEntry> mappingEntryMap, DynamicObject bizObject) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        for (Map.Entry<String, MappingEntry> entry : mappingEntryMap.entrySet()) {
            LinkedList list;
            Map superiorMap;
            String[] names;
            String dataTypeName = entry.getKey();
            MappingEntry mappingEntry = entry.getValue();
            String dataTypeType = mappingEntry.getDataTypeType();
            if (MappingUtil.isObjectType(dataTypeType)) {
                LinkedHashMap objectMap = new LinkedHashMap(16);
                if (dataTypeName.contains(".")) {
                    names = dataTypeName.split("\\.");
                    superiorMap = (Map)map.get(names[names.length - 2]);
                    superiorMap.put(names[names.length - 1], objectMap);
                } else {
                    map.put(dataTypeName, objectMap);
                }
            } else if (MappingUtil.isObjectArrayType(dataTypeType)) {
                list = new LinkedList();
                map.put(dataTypeName, list);
            } else if (MappingUtil.isArrayType(dataTypeType)) {
                list = new LinkedList();
                if (dataTypeName.contains(".")) {
                    names = dataTypeName.split("\\.");
                    superiorMap = (Map)map.get(names[names.length - 2]);
                    superiorMap.put(names[names.length - 1], list);
                } else {
                    map.put(dataTypeName, list);
                }
            }
            if (!MappingUtil.isArrayTypeObjectsInside(dataTypeName)) continue;
            String[] names2 = dataTypeName.split(SYMBOL_ENTRY);
            String listKey = names2[names2.length - 2];
            String bizName = mappingEntry.getBizName();
            if (!StringUtils.isNotBlank((CharSequence)bizName)) continue;
            String entryKey = null;
            if (bizName.contains(",")) {
                entryKey = MappingUtil.parseEntryIdentify(bizName);
            } else {
                String[] bizNames = mappingEntry.getBizName().split(SYMBOL_ENTRY);
                entryKey = bizNames[bizNames.length - 2];
            }
            int entrySize = bizObject.getDynamicObjectCollection(entryKey).size();
            List list2 = (List)map.get(listKey);
            if (list2.size() == 0) {
                for (int i = 0; i < entrySize; ++i) {
                    LinkedHashMap newMap = new LinkedHashMap(16);
                    list2.add(newMap);
                }
            }
            map.put(listKey, list2);
        }
        return map;
    }

    public static boolean isArrayTypeObjectsInside(String content) {
        return MappingUtil.isArrayType(content) && content.contains(".");
    }

    public static boolean isArrayType(String content) {
        return content.contains("[") && content.contains("]");
    }

    public static boolean isObjectArrayType(String content) {
        return content.contains("object") && content.contains("[") && content.contains("]");
    }

    public static boolean isObjectType(String content) {
        return content.equalsIgnoreCase("object");
    }

    private static void handleFixed(Map<String, Object> map, String dataTypeName, String dataTypeType, String fixedValue) {
        if (SCHEMA_TYPE_NUMBER.equalsIgnoreCase(dataTypeType)) {
            map.put(dataTypeName, new BigDecimal(fixedValue));
        } else if (SCHEMA_TYPE_INTEGER.equalsIgnoreCase(dataTypeType)) {
            map.put(dataTypeName, new BigInteger(fixedValue));
        } else {
            map.put(dataTypeName, fixedValue);
        }
    }

    private static void aggCalculate(Map<String, Object> map, String dataTypeName, MappingEntry mappingEntry, DynamicObject bizObject, String bizModelNumber) {
        String aggFunc = mappingEntry.getAggFunc();
        String aggFuncParam = mappingEntry.getAggFuncParam();
        if ("stringify".equals(aggFunc)) {
            String json = MappingUtil.basicStringify(mappingEntry, bizObject);
            map.put(dataTypeName, json);
        } else if ("hash".equals(aggFunc)) {
            String jsonStr = MappingUtil.basicStringify(mappingEntry, bizObject);
            AggFunParam aggFunParamObj = (AggFunParam)JsonUtil.parse((String)aggFuncParam, AggFunParam.class);
            String hashEncode = aggFunParamObj.getHashEncode();
            if ("Base16".equals(hashEncode)) {
                String hashBase16 = FunctionUtil.sha256Base16((String)jsonStr);
                map.put(dataTypeName, hashBase16);
            } else if ("Base64".equals(hashEncode)) {
                String hashBase64 = FunctionUtil.sha256Base64((String)jsonStr);
                map.put(dataTypeName, hashBase64);
            }
        } else if ("fileHash".equals(aggFunc)) {
            List<String> attachmentsHashList = MappingUtil.aggCalculateFileHash(mappingEntry, bizObject, bizModelNumber);
            String merkleTreeHash = AttachmentHelper.getMerkleTreeHash(attachmentsHashList);
            map.put(dataTypeName, merkleTreeHash);
        }
    }

    private static List<String> aggCalculateFileHash(MappingEntry mappingEntry, DynamicObject bizObject, String bizModelNumber) {
        String aggFuncParam = mappingEntry.getAggFuncParam();
        AggFunParam aggFunParamObj = (AggFunParam)JsonUtil.parse((String)aggFuncParam, AggFunParam.class);
        String fileHashEncode = aggFunParamObj.getFileHashEncode();
        String bizName = mappingEntry.getBizName();
        List<String> panels = null != aggFunParamObj.getFileType() ? BizMappingHelper.getBizModelAttachmentPanels(bizModelNumber).stream().map(BizModelField::getFieldName).collect(Collectors.toList()) : Arrays.asList(bizName.split(","));
        return AttachmentHelper.getAttachmentsHashList(fileHashEncode, bizObject.getPkValue(), panels);
    }

    private static String aggCalculateStringifyOrHash(MappingEntry mappingEntry, DynamicObject bizObject, DynamicObject entryObject) {
        String aggFunc = mappingEntry.getAggFunc();
        String aggFuncParam = mappingEntry.getAggFuncParam();
        if ("stringify".equals(aggFunc)) {
            return MappingUtil.entryStringify(mappingEntry, bizObject, entryObject);
        }
        if ("hash".equals(aggFunc)) {
            String jsonStr = MappingUtil.entryStringify(mappingEntry, bizObject, entryObject);
            AggFunParam aggFunParamObj = (AggFunParam)JsonUtil.parse((String)aggFuncParam, AggFunParam.class);
            String hashEncode = aggFunParamObj.getHashEncode();
            if ("Base64".equals(hashEncode)) {
                return FunctionUtil.sha256Base64((String)jsonStr);
            }
            return FunctionUtil.sha256Base16((String)jsonStr);
        }
        return "";
    }

    public static String basicStringify(MappingEntry mappingEntry, DynamicObject bizObject) {
        String[] names;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (String name : names = mappingEntry.getBizName().split(",")) {
            map.put(name, bizObject.get(name));
        }
        return FunctionUtil.stringify(map);
    }

    public static String entryStringify(MappingEntry mappingEntry, DynamicObject bizObject, DynamicObject entryObject) {
        String[] names;
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String bizNameValue = mappingEntry.getBizName();
        for (String name : names = bizNameValue.split(",")) {
            if (MappingUtil.isArrayType(name)) {
                String[] bizNames = name.split(SYMBOL_ENTRY);
                String bizName = bizNames[bizNames.length - 1];
                map.put(name, entryObject.get(bizName));
                continue;
            }
            map.put(name, bizObject.get(name));
        }
        return FunctionUtil.stringify(map);
    }

    public static Map<String, MappingEntry> getMappingEntryMap(DynamicObjectCollection entitys) {
        return BizMappingHelper.objColToMappingEntry(entitys).stream().collect(Collectors.toMap(MappingEntry::getDataTypeName, m -> m, (x, y) -> y, LinkedHashMap::new));
    }
}

