/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.config.client.util.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bsc.bea.common.exception.ExceptionMessageProviderFactory;
import kd.bsc.bea.common.model.Entry;
import kd.bsc.bea.exception.BeaErrorCode;

public class ParseSchemaUtil {
    private static final int LAYER_LIMIT = 3;

    public static List<Entry> parseJsonSchema(String schema) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = null;
        try {
            rootNode = mapper.readTree(schema);
        }
        catch (JsonProcessingException e) {
            throw new KDException(BeaErrorCode.UNKNOWN_EXCEPTION, new Object[]{ExceptionMessageProviderFactory.getProvider().getMessage((Exception)((Object)e))});
        }
        String jsonType = rootNode.path("type").asText();
        if (!jsonType.equalsIgnoreCase("object")) {
            throw new KDBizException(BeaErrorCode.SCHEMA_MUST_OBJECT_START_EXCEPTION, new Object[0]);
        }
        HashMap<String, Object> requiredMap = new HashMap<String, Object>(16);
        ArrayList<Entry> entryList = new ArrayList<Entry>(16);
        int layer = 1;
        ParseSchemaUtil.handleRequired(requiredMap, rootNode);
        ParseSchemaUtil.recurseObjectJsonNode("", requiredMap, entryList, rootNode, layer);
        return entryList;
    }

    public static void handleRequired(Map<String, Object> map, JsonNode jsonNode) {
        JsonNode requiredNode = jsonNode.path("required");
        if (!requiredNode.isMissingNode()) {
            for (JsonNode node : requiredNode) {
                map.put(node.asText(), Boolean.TRUE);
            }
        }
    }

    public static void recurseObjectJsonNode(String parentKey, Map<String, Object> requiredMap, List<Entry> entryList, JsonNode jsonNode, int layer) {
        if (layer > 3) {
            throw new KDBizException(BeaErrorCode.SCHEMA_EXCEED_LAYER_LIMIT, new Object[0]);
        }
        JsonNode objectNode = jsonNode.path("properties");
        if (objectNode.isMissingNode()) {
            throw new KDBizException(BeaErrorCode.SCHEMA_OBJECT_LOST_PROPERTIES, new Object[]{objectNode.path("title")});
        }
        Iterator fields = objectNode.fields();
        while (fields.hasNext()) {
            Map.Entry nextNode = (Map.Entry)fields.next();
            JsonNode typeNode = ((JsonNode)nextNode.getValue()).path("type");
            if (typeNode.isMissingNode()) {
                throw new KDBizException(BeaErrorCode.SCHEMA_LOSE_TYPE_EXCEPTION, new Object[]{nextNode.getKey()});
            }
            if (typeNode.asText().equalsIgnoreCase("array")) {
                ParseSchemaUtil.recurseArrayJsonNode(parentKey, requiredMap, entryList, nextNode, ++layer);
                --layer;
                continue;
            }
            if (typeNode.asText().equalsIgnoreCase("object")) {
                ParseSchemaUtil.handleRequired(requiredMap, (JsonNode)nextNode.getValue());
                String key = ParseSchemaUtil.prepareEntry(parentKey, requiredMap, entryList, nextNode);
                ParseSchemaUtil.recurseObjectJsonNode(key, requiredMap, entryList, (JsonNode)nextNode.getValue(), ++layer);
                --layer;
                continue;
            }
            ParseSchemaUtil.prepareEntry(parentKey, requiredMap, entryList, nextNode);
        }
    }

    public static void recurseArrayJsonNode(String parentKey, Map<String, Object> requiredMap, List<Entry> entryList, Map.Entry<String, JsonNode> nextNode, int layer) {
        if (layer > 3) {
            throw new KDBizException(BeaErrorCode.SCHEMA_EXCEED_LAYER_LIMIT, new Object[0]);
        }
        JsonNode itemsTypeNode = nextNode.getValue().path("items").path("type");
        String nodeKey = nextNode.getKey();
        if (itemsTypeNode.isMissingNode()) {
            throw new KDBizException(BeaErrorCode.SCHEMA_LOSE_TYPE_EXCEPTION, new Object[]{nodeKey});
        }
        String itemsType = itemsTypeNode.asText();
        if (itemsType.equalsIgnoreCase("array")) {
            throw new KDBizException(BeaErrorCode.SCHEMA_DUPLICATED_ARRAY_EXCEPTION, new Object[]{nodeKey});
        }
        Entry entry = new Entry();
        String entryKey = "";
        if (StringUtils.isNotEmpty((String)parentKey)) {
            entryKey = parentKey + "." + nodeKey;
            entry.setName(entryKey);
        } else {
            entryKey = nodeKey;
            entry.setName(entryKey);
        }
        entry.setType(itemsType + "[ ]");
        entry.setRequired(Boolean.valueOf(requiredMap.get(nodeKey) != null));
        entry.setDescription(nextNode.getValue().path("description").asText());
        entryList.add(entry);
        if (itemsType.equalsIgnoreCase("object")) {
            ParseSchemaUtil.handleRequired(requiredMap, nextNode.getValue().path("items"));
            ParseSchemaUtil.recurseObjectJsonNode(entryKey + "[ ]", requiredMap, entryList, nextNode.getValue().path("items"), ++layer);
        }
    }

    public static String prepareEntry(String parentKey, Map<String, Object> requiredMap, List<Entry> entryList, Map.Entry<String, JsonNode> nextNode) {
        Entry entry = new Entry();
        entry.setRequired(Boolean.valueOf(requiredMap.get(nextNode.getKey()) != null));
        entry.setDescription(nextNode.getValue().path("description").asText());
        String entryKey = "";
        if (StringUtils.isNotEmpty((String)parentKey)) {
            entryKey = parentKey + "." + nextNode.getKey();
            entry.setName(entryKey);
        } else {
            entryKey = nextNode.getKey();
            entry.setName(entryKey);
        }
        String type = nextNode.getValue().path("type").asText();
        if (type.equalsIgnoreCase("string")) {
            JsonNode formatNode = nextNode.getValue().path("format");
            JsonNode patternNode = nextNode.getValue().path("pattern");
            if (!formatNode.isMissingNode()) {
                String format = formatNode.asText();
                if (format.equalsIgnoreCase("date")) {
                    entry.setType("date string");
                } else if (format.equalsIgnoreCase("time")) {
                    entry.setType("time string");
                } else if (format.equalsIgnoreCase("date-time")) {
                    entry.setType("date-time string");
                } else if (format.equalsIgnoreCase("email")) {
                    entry.setType("email string");
                } else if (format.equalsIgnoreCase("regex")) {
                    entry.setType("regex string");
                } else {
                    entry.setType(type);
                }
            } else if (!patternNode.isMissingNode()) {
                entry.setType("pattern string");
            } else {
                entry.setType(type);
            }
        } else {
            entry.setType(type);
        }
        entryList.add(entry);
        return entryKey;
    }
}

