/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.verifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.FilterEntry;
import kd.bsc.bea.common.model.FilterEntryVerifyDepend;
import kd.bsc.bea.common.util.FieldTypeUtil;
import kd.bsc.bea.util.ResUtils;
import kd.bsc.bea.verifier.BizMappingFieldVerifyUtil;
import kd.bsc.bea.verifier.ListVerifierExecutor;
import kd.bsc.bea.verifier.ParamVerifier;
import kd.bsc.bea.verifier.Prompt;
import kd.bsc.bea.verifier.VerifierExecutor;

public class FilterEntryVerifierExecutors {
    private static final VerifierExecutor<FilterEntry, FilterEntryVerifyDepend> FILTER_ENTRY_VERIFIER_EXECUTOR = FilterEntryVerifierExecutors.filterEntryVerifyExecutor();
    private static final ListVerifierExecutor<FilterEntry, FilterEntryVerifyDepend> FILTER_ENTRIES_VERIFIER_EXECUTOR = FilterEntryVerifierExecutors.filterEntriesVerifyExecutor();

    public static List<Prompt> execute(List<FilterEntry> entries, FilterEntryVerifyDepend depend) {
        List<Prompt> filterEntryVerifyResult = FILTER_ENTRY_VERIFIER_EXECUTOR.execute(entries, depend);
        List<Prompt> filterEntriesVerifyResult = FILTER_ENTRIES_VERIFIER_EXECUTOR.execute(entries, depend);
        filterEntryVerifyResult.addAll(filterEntriesVerifyResult);
        return filterEntryVerifyResult;
    }

    private static VerifierExecutor<FilterEntry, FilterEntryVerifyDepend> filterEntryVerifyExecutor() {
        ArrayList paramVerifiers = new ArrayList(10);
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                if (input.getSeqNum() == depend.getTotalEntryNum() - 1 && StringUtils.isNotEmpty((CharSequence)input.getLogicalSymbol())) {
                    String description = ResUtils.loadKDString("\u6700\u540e\u4e00\u4e2a\u4e0a\u94fe\u6761\u4ef6\u7684\u201c\u903b\u8f91\u8fde\u63a5\u7b26\u201d\u5fc5\u987b\u4e3a\u7a7a", "FilterEntryVerifierExecutors_0");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                if (input.getSeqNum() != depend.getTotalEntryNum() - 1 && StringUtils.isEmpty((CharSequence)input.getLogicalSymbol())) {
                    String description = ResUtils.loadKDString("\u4e0a\u94fe\u6761\u4ef6\u95f4\u7684\u201c\u903b\u8f91\u8fde\u63a5\u7b26\u201d\u4e0d\u80fd\u4e3a\u7a7a", "FilterEntryVerifierExecutors_1");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                if (StringUtils.isEmpty((CharSequence)input.getFilterName())) {
                    String description = ResUtils.loadKDString("\u201c\u4e1a\u52a1\u5bf9\u8c61\u6761\u4ef6\u5b57\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u53cc\u51fb\u5355\u5143\u683c\u9009\u62e9\u5b57\u6bb5", "FilterEntryVerifierExecutors_2");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                if (StringUtils.isEmpty((CharSequence)input.getOption())) {
                    String description = ResUtils.loadKDString("\u201c\u6bd4\u8f83\u65b9\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a", "FilterEntryVerifierExecutors_3");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                if (StringUtils.isEmpty((CharSequence)input.getRefVar()) && StringUtils.isEmpty((CharSequence)input.getConstVar())) {
                    String description = ResUtils.loadKDString("\u201c\u6bd4\u8f83\u503c\u53d8\u91cf\u201d\u4e0e\u201c\u56fa\u5b9a\u6bd4\u8f83\u503c\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", "FilterEntryVerifierExecutors_4");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                Map bizModelFieldsMap = depend.getBizModelFields();
                if (StringUtils.isNotBlank((CharSequence)input.getFilterName()) && null == bizModelFieldsMap.get(input.getFilterName()) || StringUtils.isNotBlank((CharSequence)input.getRefVar()) && null == bizModelFieldsMap.get(input.getRefVar())) {
                    String description = ResUtils.loadKDString("\u201c\u4e1a\u52a1\u5bf9\u8c61\u6761\u4ef6\u5b57\u6bb5\u201d\u6216\u201c\u6bd4\u8f83\u503c\u53d8\u91cf\u201d\u6307\u5b9a\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664", "FilterEntryVerifierExecutors_5");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                Map bizModelFieldsMap = depend.getBizModelFields();
                BizModelField filterName = (BizModelField)bizModelFieldsMap.get(input.getFilterName());
                BizModelField refVar = (BizModelField)bizModelFieldsMap.get(input.getRefVar());
                if (null != filterName && null != refVar && !FieldTypeUtil.isSameType((int)filterName.getFieldType(), (String)filterName.getFilterType(), (int)refVar.getFieldType(), (String)refVar.getFilterType())) {
                    String description = ResUtils.loadKDString("\u201c\u4e1a\u52a1\u5bf9\u8c61\u6761\u4ef6\u5b57\u6bb5\u201d\u4e0e\u201c\u6bd4\u8f83\u503c\u53d8\u91cf\u201d\u7c7b\u578b\u5fc5\u987b\u76f8\u540c", "FilterEntryVerifierExecutors_6");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<FilterEntry, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(FilterEntry input, FilterEntryVerifyDepend depend) {
                Map bizModelFieldsMap = depend.getBizModelFields();
                BizModelField filterName = (BizModelField)bizModelFieldsMap.get(input.getFilterName());
                boolean notMatchType = false;
                if (null != filterName && null != input.getConstVar() && FieldTypeUtil.isInteger((int)filterName.getFieldType())) {
                    try {
                        Long.valueOf(input.getConstVar());
                    }
                    catch (NumberFormatException e) {
                        notMatchType = true;
                    }
                }
                if (notMatchType) {
                    String description = ResUtils.loadKDString("\u201c\u4e1a\u52a1\u5bf9\u8c61\u6761\u4ef6\u5b57\u6bb5\u201d\u4e0e\u201c\u56fa\u5b9a\u6bd4\u8f83\u503c\u201d\u7c7b\u578b\u5fc5\u987b\u76f8\u540c", "FilterEntryVerifierExecutors_7");
                    return BizMappingFieldVerifyUtil.formatFilterEntryPrompt(description, input);
                }
                return null;
            }
        });
        return new VerifierExecutor<FilterEntry, FilterEntryVerifyDepend>(paramVerifiers);
    }

    private static ListVerifierExecutor<FilterEntry, FilterEntryVerifyDepend> filterEntriesVerifyExecutor() {
        List paramVerifiers = Collections.singletonList(new ParamVerifier<List<FilterEntry>, FilterEntryVerifyDepend>(){

            @Override
            public Prompt check(List<FilterEntry> input, FilterEntryVerifyDepend depend) {
                if (0 != input.stream().mapToInt(f -> StringUtils.length((CharSequence)f.getLeftBracketValue()) - StringUtils.length((CharSequence)f.getRightBracketValue())).sum()) {
                    String description = ResUtils.loadKDString("\u4e0a\u94fe\u6761\u4ef6\u7684\u5de6\u62ec\u53f7\u548c\u53f3\u62ec\u53f7\u6570\u91cf\u5fc5\u987b\u76f8\u7b49", "FilterEntryVerifierExecutors_8");
                    return Prompt.interruptError(description);
                }
                return null;
            }
        });
        return new ListVerifierExecutor<FilterEntry, FilterEntryVerifyDepend>(paramVerifiers);
    }
}

