/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.verifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bsc.bea.common.model.AggregationFunRow;
import kd.bsc.bea.common.model.BizModelField;
import kd.bsc.bea.common.model.ConvRuleRow;
import kd.bsc.bea.common.model.MappingEntry;
import kd.bsc.bea.common.model.MappingEntryVerifyDepend;
import kd.bsc.bea.common.util.FieldTypeUtil;
import kd.bsc.bea.common.util.JsonSchemaUtil;
import kd.bsc.bea.helper.AggregationFunHelper;
import kd.bsc.bea.helper.BizMappingHelper;
import kd.bsc.bea.helper.ConvRuleHelper;
import kd.bsc.bea.util.ResUtils;
import kd.bsc.bea.verifier.BizMappingFieldVerifyUtil;
import kd.bsc.bea.verifier.ListVerifierExecutor;
import kd.bsc.bea.verifier.ParamVerifier;
import kd.bsc.bea.verifier.Prompt;
import kd.bsc.bea.verifier.VerifierExecutor;

public class MappingEntryVerifierExecutors {
    private static final VerifierExecutor<MappingEntry, MappingEntryVerifyDepend> MAPPING_ENTRY_VERIFIER_EXECUTOR = MappingEntryVerifierExecutors.mappingEntryVerifyExecutor();
    private static final ListVerifierExecutor<MappingEntry, MappingEntryVerifyDepend> MAPPING_ENTRIES_VERIFIER_EXECUTOR = MappingEntryVerifierExecutors.mappingEntriesVerifyExecutor();

    public static List<Prompt> execute(List<MappingEntry> mappingEntries, MappingEntryVerifyDepend depend) {
        List<Prompt> mappingEntryCheckResult = MAPPING_ENTRY_VERIFIER_EXECUTOR.execute(mappingEntries, depend);
        List<Prompt> mappingEntriesCheckResult = MAPPING_ENTRIES_VERIFIER_EXECUTOR.execute(mappingEntries, depend);
        mappingEntryCheckResult.addAll(mappingEntriesCheckResult);
        return mappingEntryCheckResult;
    }

    private static VerifierExecutor<MappingEntry, MappingEntryVerifyDepend> mappingEntryVerifyExecutor() {
        ArrayList paramVerifiers = new ArrayList(10);
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (BizMappingHelper.isCreateMappingEnable(input.getDataTypeType()) && Boolean.TRUE.equals(input.getRequired()) && StringUtils.isEmpty((CharSequence)input.getBizName()) && StringUtils.isEmpty((CharSequence)input.getFixedValue())) {
                    String description = ResUtils.loadKDString("\u5fc5\u9009\u5b57\u6bb5\u7684\u201c\u76f4\u63a5\u8d4b\u503c\u201d\u548c\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", "MappingEntryVerifierExecutors_0");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getBizName()) && StringUtils.isNotEmpty((CharSequence)input.getFixedValue())) {
                    String description = ResUtils.loadKDString("\u201c\u76f4\u63a5\u8d4b\u503c\u201d\u548c\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u4e0d\u80fd\u540c\u65f6\u586b\u5199", "MappingEntryVerifierExecutors_1");
                    BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getBizName()) && input.getBizName().contains(",") && StringUtils.isEmpty((CharSequence)input.getAggFunc())) {
                    String description = ResUtils.loadKDString("\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u591a\u9009\u65f6\uff0c\u201c\u805a\u5408\u51fd\u6570\u201d\u4e0d\u80fd\u4e3a\u7a7a", "MappingEntryVerifierExecutors_2");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getAggFunc()) && StringUtils.isEmpty((CharSequence)input.getBizName())) {
                    String description = ResUtils.loadKDString("\u201c\u805a\u5408\u51fd\u6570\u201d\u9009\u62e9\u65f6\uff0c\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a", "MappingEntryVerifierExecutors_3");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getAggFunc())) {
                    if ("fileHash".equals(input.getAggFunc())) {
                        if (!"string".equalsIgnoreCase(BizMappingFieldVerifyUtil.getDataTypeFieldBaseType(input.getDataTypeType()))) {
                            String description = ResUtils.loadKDString("\u201c\u5b58\u8bc1\u5b9e\u4f53\u5b57\u6bb5\u7c7b\u578b\u201d\u4e0e\u201c\u805a\u5408\u8fd0\u7b97\u201d\u8f93\u51fa\u7c7b\u578b\u4e0d\u5339\u914d", "MappingEntryVerifierExecutors_4");
                            return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                        }
                    } else if (!"string".equalsIgnoreCase(BizMappingFieldVerifyUtil.getDataTypeFieldBaseType(input.getDataTypeType()))) {
                        String description = ResUtils.loadKDString("\u201c\u5b58\u8bc1\u5b9e\u4f53\u5b57\u6bb5\u7c7b\u578b\u201d\u4e0e\u201c\u805a\u5408\u8fd0\u7b97\u201d\u8f93\u51fa\u7c7b\u578b\u4e0d\u5339\u914d", "MappingEntryVerifierExecutors_4");
                        return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                    }
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                AggregationFunRow funRow = AggregationFunHelper.getFunRowMap().get(input.getAggFunc());
                if (StringUtils.isNotEmpty((CharSequence)input.getAggFunc()) && null == funRow) {
                    String description = ResUtils.loadKDString("\u672a\u5b9a\u4e49\u7684\u201c\u805a\u5408\u51fd\u6570\u201d", "MappingEntryVerifierExecutors_5");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getAggFunc()) && StringUtils.isNotEmpty((CharSequence)input.getConvRule())) {
                    String description = ResUtils.loadKDString("\u201c\u805a\u5408\u8fd0\u7b97\u201d\u548c\u201c\u683c\u5f0f\u8f6c\u6362\u201d\u4e0d\u80fd\u540c\u65f6\u586b\u5199", "MappingEntryVerifierExecutors_6");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                AggregationFunRow funRow = AggregationFunHelper.getFunRowMap().get(input.getAggFunc());
                if (null != funRow && StringUtils.isEmpty((CharSequence)funRow.getParamJsonSchema()) && StringUtils.isNotEmpty((CharSequence)input.getAggFuncParam())) {
                    String description = ResUtils.loadKDString("\u65e0\u5165\u53c2\u201c\u805a\u5408\u8fd0\u7b97\u201d\u5bf9\u5e94\u7684\u201c\u805a\u5408\u8fd0\u7b97\u53c2\u6570\u201d\u5fc5\u987b\u4e3a\u7a7a", "MappingEntryVerifierExecutors_7");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                AggregationFunRow funRow = AggregationFunHelper.getFunRowMap().get(input.getAggFunc());
                if (null != funRow && StringUtils.isNotEmpty((CharSequence)funRow.getParamJsonSchema()) && !JsonSchemaUtil.validate((String)funRow.getParamJsonSchema(), (String)input.getAggFuncParam()).isEmpty()) {
                    String description = ResUtils.loadKDString("\u201c\u805a\u5408\u8fd0\u7b97\u201d\u5bf9\u5e94\u7684\u201c\u805a\u5408\u8fd0\u7b97\u53c2\u6570\u201d\u4e0d\u7b26\u5408\u89c4\u8303", "MappingEntryVerifierExecutors_10");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                AggregationFunRow funRow = AggregationFunHelper.getFunRowMap().get(input.getAggFunc());
                if (null == funRow && StringUtils.isEmpty((CharSequence)input.getAggFunc()) && StringUtils.isNotEmpty((CharSequence)input.getAggFuncParam())) {
                    String description = ResUtils.loadKDString("\u201c\u805a\u5408\u8fd0\u7b97\u201d\u4e3a\u7a7a\u65f6\uff0c\u5bf9\u5e94\u7684\u201c\u805a\u5408\u8fd0\u7b97\u53c2\u6570\u201d\u5fc5\u987b\u4e3a\u7a7a", "MappingEntryVerifierExecutors_11");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                return MappingEntryVerifierExecutors.checkFieldTypeMatch(input, depend.getBizModelFieldMap());
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotBlank((CharSequence)input.getBizName()) && !"fileHash".equals(input.getAggFunc())) {
                    boolean bizFieldMultiValue;
                    boolean dataTypeMultiValue = MappingEntryVerifierExecutors.isMultiValueField(input);
                    boolean bl = bizFieldMultiValue = input.getBizName().contains("[") && input.getBizName().contains("]");
                    if (dataTypeMultiValue != bizFieldMultiValue) {
                        String description = ResUtils.loadKDString("\u5b58\u8bc1\u5b9e\u4f53\u5b57\u6bb5\u4e0e\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u4e0d\u5339\u914d\uff0c\u6570\u7ec4\u5b57\u6bb5\u81f3\u5c11\u5173\u8054\u4e00\u4e2a\u5206\u5f55\u5b57\u6bb5\uff0c\u975e\u6570\u7ec4\u5b57\u6bb5\u4e0d\u80fd\u5173\u8054\u5206\u5f55\u5b57\u6bb5", "MappingEntryVerifierExecutors_12");
                        return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                    }
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if ("fileHash".equals(input.getAggFunc()) && MappingEntryVerifierExecutors.isObjectInArraySubField(input.getDataTypeName())) {
                    String description = ResUtils.loadKDString("\u5bf9\u8c61\u6570\u7ec4\u5185\u5b9e\u4f53\u5b57\u6bb5\u65e0\u6cd5\u5173\u8054\u6587\u4ef6\u4e0a\u94fe\u805a\u5408\u51fd\u6570", "MappingEntryVerifierExecutors_13");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotBlank((CharSequence)input.getFixedValue()) && MappingEntryVerifierExecutors.isMultiValueField(input)) {
                    String description = ResUtils.loadKDString("\u57fa\u672c\u7c7b\u578b\u6570\u7ec4\u53ca\u5bf9\u8c61\u6570\u7ec4\u5185\u5b9e\u4f53\u5b57\u6bb5\u65e0\u6cd5\u5173\u8054\u56fa\u5b9a\u503c", "MappingEntryVerifierExecutors_14");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                Set slices;
                if (StringUtils.isNotBlank((CharSequence)input.getBizName()) && (slices = Stream.of(input.getBizName().split(",")).map(s -> s.split("\\.")).flatMap(Arrays::stream).filter(s -> s.contains("[") && s.contains("]")).collect(Collectors.toSet())).size() > 1) {
                    String description = ResUtils.loadKDString("\u4e0d\u652f\u6301\u5173\u8054\u591a\u4e2a\u4e0d\u540c\u7684\u5206\u5f55\u4e0b\u7684\u5b57\u6bb5", "MappingEntryVerifierExecutors_15");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotBlank((CharSequence)input.getBizType()) && (input.getBizType().contains("attachmentPanel") || "attachments".equals(input.getBizType())) && !"fileHash".equals(input.getAggFunc())) {
                    String description = ResUtils.loadKDString("\u9644\u4ef6\u9762\u677f\u6216\u9644\u4ef6\u5b57\u6bb5\u5fc5\u987b\u9009\u62e9\u201c\u6587\u4ef6\u54c8\u5e0c\u201d\u805a\u5408\u51fd\u6570\u5173\u8054", "MappingEntryVerifierExecutors_16");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if ("fileHash".equals(input.getAggFunc()) && !input.getBizType().contains("attachmentPanel") && !"attachments".equals(input.getBizType())) {
                    String description = ResUtils.loadKDString("\u201c\u6587\u4ef6\u54c8\u5e0c\u201d\u805a\u5408\u51fd\u6570\u5fc5\u987b\u9009\u62e9\u9644\u4ef6\u9762\u677f\u6216\u9644\u4ef6\u5b57\u6bb5\u5173\u8054", "MappingEntryVerifierExecutors_17");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                if (StringUtils.isNotEmpty((CharSequence)input.getConvRule()) && StringUtils.isEmpty((CharSequence)input.getBizName()) && !MappingEntryVerifierExecutors.bizFieldSingleSelect(input)) {
                    String description = ResUtils.loadKDString("\u201c\u683c\u5f0f\u8f6c\u6362\u201d\u9009\u62e9\u65f6\uff0c\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3a\u5355\u9009", "MappingEntryVerifierExecutors_18");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, input);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<MappingEntry, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(MappingEntry input, MappingEntryVerifyDepend depend) {
                ConvRuleRow row = ConvRuleHelper.getRowDict().get(input.getConvRule());
                if (null != row && null != row.getInType() && !row.getInType().contains(input.getBizType())) {
                    String description = ResUtils.loadKDString("\u201c\u683c\u5f0f\u8f6c\u6362\u201d\u8f93\u5165\u7c7b\u578b\u53ea\u652f\u6301\u201c%s\u201d\u7684\u201c\u4e1a\u52a1\u5b57\u6bb5\u7c7b\u578b\u201d", "MappingEntryVerifierExecutors_19");
                    return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(String.format(description, row.getInType()), input);
                }
                return null;
            }
        });
        return new VerifierExecutor<MappingEntry, MappingEntryVerifyDepend>(paramVerifiers);
    }

    private static ListVerifierExecutor<MappingEntry, MappingEntryVerifyDepend> mappingEntriesVerifyExecutor() {
        ArrayList paramVerifiers = new ArrayList(2);
        paramVerifiers.add(new ParamVerifier<List<MappingEntry>, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(List<MappingEntry> input, MappingEntryVerifyDepend depend) {
                if (input.stream().map(MappingEntry::getBizName).allMatch(StringUtils::isBlank)) {
                    String description = ResUtils.loadKDString("\u201c\u5b57\u6bb5\u6620\u5c04\u201d\u5206\u5f55\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u5173\u8054", "MappingEntryVerifierExecutors_20");
                    return Prompt.interruptError(description);
                }
                return null;
            }
        });
        paramVerifiers.add(new ParamVerifier<List<MappingEntry>, MappingEntryVerifyDepend>(){

            @Override
            public Prompt check(List<MappingEntry> input, MappingEntryVerifyDepend depend) {
                List objectArrayFieldNames = input.stream().filter(e -> "object[]".equals(e.getDataTypeType().replace(" ", ""))).map(MappingEntry::getDataTypeName).collect(Collectors.toList());
                List objectArrayFieldsMappingEntries = objectArrayFieldNames.stream().map(n -> input.stream().filter(e -> e.getDataTypeName().startsWith(n + "[ ]")).collect(Collectors.toList())).collect(Collectors.toList());
                List entryNameSets = objectArrayFieldsMappingEntries.stream().map(l -> l.stream().map(BizMappingHelper::getBizFieldEntryNames).flatMap(Collection::stream).collect(Collectors.toSet())).collect(Collectors.toList());
                if (entryNameSets.stream().anyMatch(s -> s.size() > 1)) {
                    String description = ResUtils.loadKDString("\u540c\u4e00\u5bf9\u8c61\u6570\u7ec4\u4e0b\u5b57\u6bb5\u4e0d\u652f\u6301\u5173\u8054\u591a\u4e2a\u4e0d\u540c\u7684\u5206\u5f55", "MappingEntryVerifierExecutors_21");
                    return Prompt.interruptError(description);
                }
                return null;
            }
        });
        return new ListVerifierExecutor<MappingEntry, MappingEntryVerifyDepend>(paramVerifiers);
    }

    private static Prompt checkFieldTypeMatch(MappingEntry entry, Map<String, BizModelField> bizModelFields) {
        if (MappingEntryVerifierExecutors.bizFieldSingleSelect(entry) && StringUtils.isBlank((CharSequence)entry.getAggFunc()) && !entry.getBizType().contains("attachment")) {
            BizModelField bizModelField = bizModelFields.get(entry.getBizName());
            if (null == bizModelField) {
                String description = ResUtils.loadKDString("\u540d\u79f0\u4e3a\u201c%s\u201d\u7684\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u5b58\u5728", "MappingEntryVerifierExecutors_8");
                return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(String.format(description, entry.getBizName()), entry);
            }
            if (!MappingEntryVerifierExecutors.isMatchFieldType(entry, bizModelField)) {
                String description = ResUtils.loadKDString("\u201c\u5b58\u8bc1\u5b9e\u4f53\u5b57\u6bb5\u201d\u4e0e\u201c\u4e1a\u52a1\u5b57\u6bb5\u540d\u79f0\u201d\u7c7b\u578b\u6216\u201c\u683c\u5f0f\u8f6c\u6362\u201d\u7684\u8f93\u51fa\u7c7b\u578b\u4e0d\u5339\u914d", "MappingEntryVerifierExecutors_9");
                return BizMappingFieldVerifyUtil.formatMappingEntryPrompt(description, entry);
            }
        }
        return null;
    }

    private static boolean bizFieldSingleSelect(MappingEntry entry) {
        return StringUtils.isNotBlank((CharSequence)entry.getBizName()) && !entry.getBizName().contains(",");
    }

    private static boolean isMatchFieldType(MappingEntry entry, BizModelField field) {
        String fieldBaseType = MappingEntryVerifierExecutors.getDataTypeFieldBaseType(entry.getDataTypeType());
        if (null != fieldBaseType) {
            if (StringUtils.isEmpty((CharSequence)entry.getConvRule())) {
                switch (fieldBaseType) {
                    case "integer": {
                        return FieldTypeUtil.isInteger((int)field.getFieldType()) || FieldTypeUtil.isDate((int)field.getFieldType());
                    }
                    case "number": {
                        return FieldTypeUtil.isNumber((int)field.getFieldType()) || FieldTypeUtil.isDate((int)field.getFieldType());
                    }
                    case "string": {
                        return FieldTypeUtil.isString((int)field.getFieldType(), (String)field.getFilterType()) || FieldTypeUtil.isDate((int)field.getFieldType());
                    }
                    case "boolean": {
                        return FieldTypeUtil.isBoolean((int)field.getFieldType());
                    }
                }
                return false;
            }
            ConvRuleRow row = ConvRuleHelper.getRowDict().getOrDefault(entry.getConvRule(), ConvRuleRow.EMPTY);
            return fieldBaseType.equals(row.getOutType());
        }
        return false;
    }

    private static String getDataTypeFieldBaseType(String fieldType) {
        if (null != fieldType) {
            return fieldType.replaceAll("[\\[\\] ]", "");
        }
        return null;
    }

    private static boolean isMultiValueField(MappingEntry entry) {
        return MappingEntryVerifierExecutors.isBaseTypeArrayField(entry) || MappingEntryVerifierExecutors.isObjectInArraySubField(entry.getDataTypeName());
    }

    private static boolean isBaseTypeArrayField(MappingEntry entry) {
        return entry.getDataTypeType().contains("[") && entry.getDataTypeType().contains("]");
    }

    private static boolean isObjectInArraySubField(String dataTypeFieldName) {
        return dataTypeFieldName.contains("[") && dataTypeFieldName.contains("]");
    }
}

