/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.api;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.bsc.bea.common.constant.CommonErrorCode;
import kd.bsc.bea.common.model.ChainData;
import kd.bsc.bea.common.model.ChainDataType;
import kd.bsc.bea.common.model.ChainDataTypeList;
import kd.bsc.bea.common.model.blockchain.BlockchainResponse;
import kd.bsc.bea.common.util.HttpUtils;
import kd.bsc.bea.common.util.JsonUtil;
import kd.bsc.bea.common.util.PropUtils;

public class KedasClient {
    private static Log log = LogFactory.getLog(KedasClient.class);
    private static final int CAPACITY_SIZE = 16;

    public static ChainDataType createSchema(String channel, String accessToken, String proxy, String bduid, String schemaName, String structure) {
        String url = KedasClient.getBaseUrl() + "/schemas";
        HashMap<String, Object> body = new HashMap<String, Object>(16);
        body.put("access_token", accessToken);
        body.put("bduid", bduid);
        body.put("proxy", proxy);
        body.put("name", schemaName);
        body.put("channel", channel);
        body.put("structure", structure);
        String result = HttpUtils.postOfJson(url, null, body);
        ChainDataType.Response response = JsonUtil.parse(result, ChainDataType.Response.class);
        return KedasClient.checkResponseAndGetData(response);
    }

    public static ChainData toChain(String channel, String accessToken, String proxy, String bduid, String owner, String schemaId, String indexId, Object data) {
        String url = KedasClient.getBaseUrl() + "/records";
        HashMap<String, Object> body = new HashMap<String, Object>(16);
        body.put("access_token", accessToken);
        body.put("bduid", bduid);
        body.put("proxy", proxy);
        body.put("owner", owner);
        body.put("schema_id", schemaId);
        body.put("index_id", indexId);
        body.put("channel", channel);
        body.put("data", data);
        String result = HttpUtils.postOfJson(url, null, body);
        ChainData.Response response = JsonUtil.parse(result, ChainData.Response.class);
        return KedasClient.checkResponseAndGetData(response);
    }

    public static ChainDataTypeList querySchemas(String channel, String accessToken, String bduid, Integer offset, Integer limit) {
        String urlTemplate = KedasClient.getBaseUrl() + "/schemas?access_token=%s&channel=%s&bduid=%s&offset=%d&limit=%d";
        String url = String.format(urlTemplate, accessToken, channel, bduid, offset, limit);
        String result = HttpUtils.get(url);
        ChainDataTypeList.Response response = JsonUtil.parse(result, ChainDataTypeList.Response.class);
        return KedasClient.checkResponseAndGetData(response);
    }

    public static ChainDataType querySchemaByName(String channel, String accessToken, String bduid, String name) {
        String urlTemplate = KedasClient.getBaseUrl() + "/schemas/findByName?access_token=%s&channel=%s&bduid=%s&name=%s";
        String url = String.format(urlTemplate, accessToken, channel, bduid, name);
        String result = HttpUtils.get(url);
        ChainDataType.Response response = JsonUtil.parse(result, ChainDataType.Response.class);
        return KedasClient.checkResponseAndGetData(response);
    }

    public static ChainData queryChainDataByIndexId(String accessToken, String channel, String bduid, String proxy, String schemaId, String indexId) {
        String urlTemplate = KedasClient.getBaseUrl() + "/records/findByIndexId?access_token=%s&channel=%s&bduid=%s&proxy=%s&schema_id=%s&index_id=%s";
        String url = null;
        try {
            url = String.format(urlTemplate, accessToken, channel, bduid, proxy, schemaId, URLEncoder.encode(indexId, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u5b58\u8bc1\u7f16\u53f7\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
        }
        String result = HttpUtils.get(url);
        ChainData.Response response = JsonUtil.parse(result, ChainData.Response.class);
        return KedasClient.checkResponseAndGetData(response);
    }

    public static <T> T checkResponseAndGetData(BlockchainResponse<T> response) {
        Integer errcode = response.getErrcode();
        String description = response.getDescription();
        if (errcode != 0) {
            if (StringUtils.isNotNull((String)description)) {
                ErrorCode thirdErrorCode = CommonErrorCode.create(String.valueOf(errcode), description);
                throw new KDException(thirdErrorCode, new Object[0]);
            }
            throw new KDException(CommonErrorCode.INTERFACE_CALL_FAILED, new Object[]{response});
        }
        return response.getData();
    }

    public static String getBaseUrl() {
        return PropUtils.getOpenApi() + "/edas/api/v2";
    }
}

