/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import java.util.Arrays;
import java.util.List;

public class FieldTypeUtil {
    public static boolean isDate(int fieldType) {
        return 93 == fieldType || 4 == fieldType || 91 == fieldType;
    }

    public static boolean isNumber(int fieldType) {
        return FieldTypeMapping.NUMBER_FIELD_TYPE.contains(fieldType);
    }

    public static boolean isInteger(int fieldType) {
        return 4 == fieldType || -5 == fieldType;
    }

    public static boolean isString(int fieldType, String filterType) {
        return -9 == fieldType || 12 == fieldType || "text".equals(filterType);
    }

    public static boolean isBoolean(int fieldType) {
        return 1 == fieldType;
    }

    public static boolean isSameType(int t1, String f1, int t2, String f2) {
        return FieldTypeUtil.isNumber(t1) && FieldTypeUtil.isNumber(t2) || FieldTypeUtil.isString(t1, f1) && FieldTypeUtil.isString(t2, f2) || FieldTypeUtil.isBoolean(t1) && FieldTypeUtil.isBoolean(t2);
    }

    private static class FieldTypeMapping {
        private static final int INTEGER = 4;
        private static final int BIG_INTEGER = -5;
        private static final int DECIMAL = 3;
        private static final int TEXT = -9;
        private static final int ENUM = 12;
        private static final int BOOLEAN = 1;
        private static final int DATE_TIME = 93;
        private static final int TIME = 4;
        private static final int DATE = 91;
        private static final List<Integer> NUMBER_FIELD_TYPE = Arrays.asList(4, -5, 3);

        private FieldTypeMapping() {
        }
    }
}

