/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bsc.bea.common.util.JsonUtil;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonSchemaUtil {
    public static List<String> validate(String schema, String source) {
        try {
            Schema schemaValidation = SchemaLoader.load((JSONObject)new JSONObject(schema));
            schemaValidation.validate((Object)new JSONObject(source));
            return Collections.emptyList();
        }
        catch (ValidationException e) {
            return e.getAllMessages();
        }
        catch (JSONException e) {
            return Collections.singletonList("data\u53c2\u6570\u4e0d\u7b26\u5408json\u89c4\u8303");
        }
    }

    public static boolean isSchemaValid(String schemaSource) {
        return JsonSchemaUtil.getSchemaValidateMessage(schemaSource) == null;
    }

    public static String getSchemaValidateMessage(String schemaSource) {
        try {
            SchemaLoader.load((JSONObject)new JSONObject(schemaSource));
            JsonUtil.prettyToString(schemaSource);
            return null;
        }
        catch (SchemaException e) {
            return e.getMessage();
        }
        catch (JSONException e) {
            return ResManager.loadKDString((String)"\u975e\u6cd5\u7684json", (String)"JsonSchemaUtil_0", (String)"bsc-bea-common", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public static int jsonMaxLevel(JsonNode node) {
        JsonNode items;
        String itemType;
        ArrayList<Integer> childLevels = new ArrayList<Integer>(8);
        String type = node.get("type").asText();
        if ("object".equals(type)) {
            JsonSchemaUtil.addObjectNodeChildLevel(node, childLevels);
        } else if ("array".equals(type) && "object".equals(itemType = (items = node.get("items")).get("type").asText())) {
            JsonSchemaUtil.addObjectNodeChildLevel(items, childLevels);
        }
        return childLevels.stream().mapToInt(Integer::intValue).max().orElse(0);
    }

    private static void addObjectNodeChildLevel(JsonNode root, List<Integer> childLevels) {
        JsonNode properties = root.get("properties");
        Iterator childIterator = properties.elements();
        while (childIterator.hasNext()) {
            JsonNode child = (JsonNode)childIterator.next();
            childLevels.add(JsonSchemaUtil.jsonMaxLevel(child) + 1);
        }
    }
}

