/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonUtil {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
        throw new IllegalStateException("JsonUtil class");
    }

    public static String stringify(Object o) {
        try {
            return objectMapper.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new JsonSerializeException(e);
        }
    }

    public static String toPretty(String json) {
        try {
            Object o = JsonUtil.parse(json, Object.class);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializeException(e);
        }
    }

    public static String prettyToString(String pretty) {
        Object o = JsonUtil.parse(pretty, Object.class);
        return JsonUtil.stringify(o);
    }

    public static Map<String, Object> parseToMap(Object object) {
        String json = JsonUtil.stringify(object);
        return JsonUtil.parse(json, new TypeReference<Map<String, Object>>(){});
    }

    public static <T> T parse(String json, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> List<T> parseToList(String json, Class<T> clazz) {
        try {
            JavaType javaType = JsonUtil.getCollectionType(ArrayList.class, clazz);
            return (List)objectMapper.readValue(json, javaType);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T parse(String json, TypeReference<T> type) {
        try {
            return (T)objectMapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static JsonNode readTree(String json) {
        try {
            return objectMapper.readTree(json);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T treeToValue(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)objectMapper.treeToValue((TreeNode)jsonNode, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T deserialize(InputStream stream, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(stream, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T deserialize(InputStream stream, TypeReference<T> type) {
        try {
            return (T)objectMapper.readValue(stream, type);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static byte[] serialize(Object o) {
        try {
            return objectMapper.writeValueAsBytes(o);
        }
        catch (JsonProcessingException e) {
            throw new JsonSerializeException(e);
        }
    }

    public static <T> T deserialize(byte[] bytes, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T deserialize(byte[] bytes, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.readValue(bytes, typeReference);
        }
        catch (IOException e) {
            throw new JsonDeserializeException(e);
        }
    }

    public static <T> T convertValue(Object object, TypeReference<T> typeReference) {
        try {
            return (T)objectMapper.convertValue(object, typeReference);
        }
        catch (Exception e) {
            throw new JsonDeserializeException(e);
        }
    }

    private static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return objectMapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    static {
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        objectMapper.enable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.disable(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS);
    }

    private static final class JsonDeserializeException
    extends RuntimeException {
        JsonDeserializeException(Throwable cause) {
            super("json deserialize failure", cause);
        }
    }

    private static final class JsonSerializeException
    extends RuntimeException {
        JsonSerializeException(Throwable cause) {
            super("json serialize failure", cause);
        }
    }
}

