/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import java.util.ArrayList;
import java.util.List;
import kd.bsc.bea.common.util.FunctionUtil;

public class MerkleTrees {
    private List<String> txList;
    private String root;

    public MerkleTrees(List<String> txList) {
        this.txList = txList;
        this.root = "";
    }

    public String getRoot() {
        return this.root;
    }

    public void merkleTree() {
        ArrayList<String> tempTxList = new ArrayList<String>(12);
        for (int i = 0; i < this.txList.size(); ++i) {
            tempTxList.add(this.txList.get(i));
        }
        if (tempTxList.size() == 1) {
            this.root = (String)tempTxList.get(0);
            return;
        }
        List<String> newTxList = this.getNewTxList(tempTxList);
        while (newTxList.size() != 1) {
            newTxList = this.getNewTxList(newTxList);
        }
        this.root = newTxList.get(0);
    }

    private List<String> getNewTxList(List<String> tempTxList) {
        ArrayList<String> newTxList = new ArrayList<String>(12);
        for (int index = 0; index < tempTxList.size(); ++index) {
            String left = tempTxList.get(index);
            String right = "";
            if (++index != tempTxList.size()) {
                right = tempTxList.get(index);
            }
            String sha256Hash = FunctionUtil.sha256Base16(left + right);
            newTxList.add(sha256Hash);
        }
        return newTxList;
    }
}

