/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class MetaDataUtils {
    public static String getBaseDataNumber(IDataModel model, String fieldKey) {
        MainEntityType mainType = model.getDataEntityType();
        BasedataProp basedataProp = (BasedataProp)mainType.findProperty(fieldKey);
        DynamicObject billObj = model.getDataEntity();
        return (String)basedataProp.getRefIdProp().getValue((Object)billObj);
    }

    public static String getBaseDataName(IDataModel model, String fieldKey) {
        MainEntityType mainType = model.getDataEntityType();
        BasedataProp basedataProp = (BasedataProp)mainType.findProperty(fieldKey);
        DynamicObject billObj = model.getDataEntity();
        DynamicObject baseDataObj = (DynamicObject)basedataProp.getValue((Object)billObj);
        return baseDataObj.getString("name");
    }

    public static void openPopForm(String title, String formId, String callbackFlag, AbstractFormPlugin plugin, Map<String, Object> param) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCaption(title);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, callbackFlag));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(param);
        plugin.getView().showForm(showParameter);
    }

    public static List<FilterField> getFilterFields(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityTypeUtil entityTypeUtil = EntityTypeUtil.getInstance();
        return entityTypeUtil.getFilterFields((IDataEntityType)entityType, false);
    }

    public static Map<String, FilterField> getFilterFieldMap(String entityNumber) {
        return MetaDataUtils.getFilterFields(entityNumber).stream().collect(Collectors.toMap(FilterField::getFullFieldName, f -> f));
    }
}

