/*
 * Decompiled with CFR 0.152.
 */
package kd.bsc.bea.common.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PropUtils {
    private static final Log log = LogFactory.getLog(PropUtils.class);
    private static final String OPENAPI = "https://openapi.kingdeeabc.com";

    public static String getParamByKey(String key) {
        Long orgId = RequestContext.get().getOrgId();
        String appId = AppMetadataCache.getAppInfo((String)"bcc").getId();
        AppParam appParam = new AppParam(appId, orgId);
        return String.valueOf(SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)key));
    }

    public static String getOpenApi() {
        String openApi = "";
        try {
            openApi = PropUtils.getParamByKey("openapi");
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5e94\u7528\u53c2\u6570\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return OPENAPI;
        }
        if (StringUtils.isBlank((CharSequence)openApi)) {
            return OPENAPI;
        }
        if (!PropUtils.isValidUrl(openApi)) {
            return OPENAPI;
        }
        if (openApi.endsWith("/")) {
            openApi = openApi.substring(0, openApi.length() - 1);
        }
        return openApi;
    }

    private static boolean isValidUrl(String url) {
        return url.matches("^http(s?)://.+");
    }
}

